/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class GpxImporter
extends FileImporter {
    public GpxImporter() {
        super(new ExtensionFileFilter("gpx,gpx.gz", "gpx", I18n.tr("GPX Files", new Object[0]) + " (*.gpx *.gpx.gz)"));
    }

    public void importData(final File file, ProgressMonitor progressMonitor) throws IOException {
        final String string = file.getName();
        try {
            InputStream inputStream = file.getName().endsWith(".gpx.gz") ? new GZIPInputStream(new FileInputStream(file)) : new FileInputStream(file);
            final GpxReader gpxReader = new GpxReader(inputStream);
            final boolean bl = gpxReader.parse(true);
            gpxReader.data.storageFile = file;
            final GpxLayer gpxLayer = new GpxLayer(gpxReader.data, string, true);
            Runnable runnable = new Runnable(){

                public void run() {
                    if (gpxReader.data.hasRoutePoints() || gpxReader.data.hasTrackPoints()) {
                        Main.main.addLayer(gpxLayer);
                    }
                    if (Main.pref.getBoolean("marker.makeautomarkers", true) && !gpxReader.data.waypoints.isEmpty()) {
                        MarkerLayer markerLayer = new MarkerLayer(gpxReader.data, I18n.tr("Markers from {0}", string), file, gpxLayer);
                        if (markerLayer.data.size() > 0) {
                            Main.main.addLayer(markerLayer);
                        }
                    }
                    if (!bl) {
                        JOptionPane.showMessageDialog(null, I18n.tr("Error occurred while parsing gpx file {0}. Only a part of the file will be available.", file.getName()));
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            throw new IOException(I18n.tr("File \"{0}\" does not exist", file.getName()));
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            throw new IOException(I18n.tr("Parsing file \"{0}\" failed", file.getName()));
        }
    }
}

