/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.Gradient;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.batik.LinearGradientPaint;
import com.kitfox.svg.batik.MultipleGradientPaint;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class LinearGradient
extends Gradient {
    float x1 = 0.0f;
    float y1 = 0.0f;
    float x2 = 1.0f;
    float y2 = 0.0f;

    protected void build() throws SVGException {
        super.build();
        StyleAttribute styleAttribute = new StyleAttribute();
        if (this.getPres(styleAttribute.setName("x1"))) {
            this.x1 = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("y1"))) {
            this.y1 = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("x2"))) {
            this.x2 = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("y2"))) {
            this.y2 = styleAttribute.getFloatValueWithUnits();
        }
    }

    public Paint getPaint(Rectangle2D rectangle2D, AffineTransform affineTransform) {
        LinearGradientPaint linearGradientPaint;
        MultipleGradientPaint.CycleMethodEnum cycleMethodEnum;
        switch (this.spreadMethod) {
            default: {
                cycleMethodEnum = MultipleGradientPaint.NO_CYCLE;
                break;
            }
            case 1: {
                cycleMethodEnum = MultipleGradientPaint.REPEAT;
                break;
            }
            case 2: {
                cycleMethodEnum = MultipleGradientPaint.REFLECT;
            }
        }
        if (this.gradientUnits == 1) {
            linearGradientPaint = new LinearGradientPaint(new Point2D.Float(this.x1, this.y1), new Point2D.Float(this.x2, this.y2), this.getStopFractions(), this.getStopColors(), cycleMethodEnum, MultipleGradientPaint.SRGB, this.gradientTransform);
        } else {
            AffineTransform affineTransform2 = new AffineTransform();
            affineTransform2.translate(rectangle2D.getX(), rectangle2D.getY());
            double d = rectangle2D.getWidth();
            double d2 = rectangle2D.getHeight();
            if (d == 0.0) {
                d = 1.0;
            }
            if (d2 == 0.0) {
                d2 = 1.0;
            }
            affineTransform2.scale(d, d2);
            affineTransform2.concatenate(this.gradientTransform);
            linearGradientPaint = new LinearGradientPaint(new Point2D.Float(this.x1, this.y1), new Point2D.Float(this.x2, this.y2), this.getStopFractions(), this.getStopColors(), cycleMethodEnum, MultipleGradientPaint.SRGB, affineTransform2);
        }
        return linearGradientPaint;
    }

    public boolean updateTime(double d) throws SVGException {
        float f;
        boolean bl = super.updateTime(d);
        StyleAttribute styleAttribute = new StyleAttribute();
        boolean bl2 = false;
        if (this.getPres(styleAttribute.setName("x1")) && (f = styleAttribute.getFloatValueWithUnits()) != this.x1) {
            this.x1 = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("y1")) && (f = styleAttribute.getFloatValueWithUnits()) != this.y1) {
            this.y1 = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("x2")) && (f = styleAttribute.getFloatValueWithUnits()) != this.x2) {
            this.x2 = f;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("y2")) && (f = styleAttribute.getFloatValueWithUnits()) != this.y2) {
            this.y2 = f;
            bl2 = true;
        }
        return bl || bl2;
    }
}

