/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.batik;

import com.kitfox.svg.batik.GraphicsUtil;
import com.kitfox.svg.batik.LinearGradientPaint;
import com.kitfox.svg.batik.MultipleGradientPaint;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.lang.ref.WeakReference;

abstract class MultipleGradientPaintContext
implements PaintContext {
    protected static final boolean DEBUG = false;
    protected ColorModel dataModel;
    protected ColorModel model;
    private static ColorModel lrgbmodel_NA = new DirectColorModel(ColorSpace.getInstance(1004), 24, 0xFF0000, 65280, 255, 0, false, 3);
    private static ColorModel srgbmodel_NA = new DirectColorModel(ColorSpace.getInstance(1000), 24, 0xFF0000, 65280, 255, 0, false, 3);
    private static ColorModel lrgbmodel_A = new DirectColorModel(ColorSpace.getInstance(1004), 32, 0xFF0000, 65280, 255, -16777216, false, 3);
    private static ColorModel srgbmodel_A = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, false, 3);
    protected static ColorModel cachedModel;
    protected static WeakReference cached;
    protected WritableRaster saved;
    protected MultipleGradientPaint.CycleMethodEnum cycleMethod;
    protected MultipleGradientPaint.ColorSpaceEnum colorSpace;
    protected float a00;
    protected float a01;
    protected float a10;
    protected float a11;
    protected float a02;
    protected float a12;
    protected boolean isSimpleLookup = true;
    protected boolean hasDiscontinuity = false;
    protected int fastGradientArraySize;
    protected int[] gradient;
    protected int[][] gradients;
    protected int gradientAverage;
    protected int gradientUnderflow;
    protected int gradientOverflow;
    protected int gradientsLength;
    protected float[] normalizedIntervals;
    protected float[] fractions;
    private int transparencyTest;
    private static final int[] SRGBtoLinearRGB;
    private static final int[] LinearRGBtoSRGB;
    protected static final int GRADIENT_SIZE = 256;
    protected static final int GRADIENT_SIZE_INDEX = 255;
    private static final int MAX_GRADIENT_ARRAY_SIZE = 5000;

    public MultipleGradientPaintContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints, float[] fArray, Color[] colorArray, MultipleGradientPaint.CycleMethodEnum cycleMethodEnum, MultipleGradientPaint.ColorSpaceEnum colorSpaceEnum) throws NoninvertibleTransformException {
        boolean bl = false;
        boolean bl2 = false;
        int n = fArray.length;
        if (fArray[0] != 0.0f) {
            bl = true;
            ++n;
        }
        if (fArray[fArray.length - 1] != 1.0f) {
            bl2 = true;
            ++n;
        }
        for (int i = 0; i < fArray.length - 1; ++i) {
            if (fArray[i] != fArray[i + 1]) continue;
            --n;
        }
        this.fractions = new float[n];
        Color[] colorArray2 = new Color[n - 1];
        Color[] colorArray3 = new Color[n - 1];
        this.normalizedIntervals = new float[n - 1];
        this.gradientUnderflow = colorArray[0].getRGB();
        this.gradientOverflow = colorArray[colorArray.length - 1].getRGB();
        int n2 = 0;
        if (bl) {
            this.fractions[0] = 0.0f;
            colorArray2[0] = colorArray[0];
            colorArray3[0] = colorArray[0];
            this.normalizedIntervals[0] = fArray[0];
            ++n2;
        }
        for (int i = 0; i < fArray.length - 1; ++i) {
            if (fArray[i] == fArray[i + 1]) {
                if (colorArray[i].equals(colorArray[i + 1])) continue;
                this.hasDiscontinuity = true;
                continue;
            }
            this.fractions[n2] = fArray[i];
            colorArray2[n2] = colorArray[i];
            colorArray3[n2] = colorArray[i + 1];
            this.normalizedIntervals[n2] = fArray[i + 1] - fArray[i];
            ++n2;
        }
        this.fractions[n2] = fArray[fArray.length - 1];
        if (bl2) {
            colorArray2[n2] = colorArray3[n2] = colorArray[colorArray.length - 1];
            this.normalizedIntervals[n2] = 1.0f - fArray[fArray.length - 1];
            this.fractions[++n2] = 1.0f;
        }
        AffineTransform affineTransform2 = affineTransform.createInverse();
        double[] dArray = new double[6];
        affineTransform2.getMatrix(dArray);
        this.a00 = (float)dArray[0];
        this.a10 = (float)dArray[1];
        this.a01 = (float)dArray[2];
        this.a11 = (float)dArray[3];
        this.a02 = (float)dArray[4];
        this.a12 = (float)dArray[5];
        this.cycleMethod = cycleMethodEnum;
        this.colorSpace = colorSpaceEnum;
        if (colorModel.getColorSpace() == lrgbmodel_A.getColorSpace()) {
            this.dataModel = lrgbmodel_A;
        } else if (colorModel.getColorSpace() == srgbmodel_A.getColorSpace()) {
            this.dataModel = srgbmodel_A;
        } else {
            throw new IllegalArgumentException("Unsupported ColorSpace for interpolation");
        }
        this.calculateGradientFractions(colorArray2, colorArray3);
        this.model = GraphicsUtil.coerceColorModel(this.dataModel, colorModel.isAlphaPremultiplied());
    }

    protected final void calculateGradientFractions(Color[] colorArray, Color[] colorArray2) {
        int n;
        int n2;
        if (this.colorSpace == LinearGradientPaint.LINEAR_RGB) {
            for (n2 = 0; n2 < colorArray.length; ++n2) {
                colorArray[n2] = new Color(SRGBtoLinearRGB[colorArray[n2].getRed()], SRGBtoLinearRGB[colorArray[n2].getGreen()], SRGBtoLinearRGB[colorArray[n2].getBlue()], colorArray[n2].getAlpha());
                colorArray2[n2] = new Color(SRGBtoLinearRGB[colorArray2[n2].getRed()], SRGBtoLinearRGB[colorArray2[n2].getGreen()], SRGBtoLinearRGB[colorArray2[n2].getBlue()], colorArray2[n2].getAlpha());
            }
        }
        this.transparencyTest = -16777216;
        this.gradients = new int[this.fractions.length - 1][];
        this.gradientsLength = this.gradients.length;
        n2 = this.normalizedIntervals.length;
        float f = 1.0f;
        for (n = 0; n < n2; ++n) {
            f = f > this.normalizedIntervals[n] ? this.normalizedIntervals[n] : f;
        }
        n = 0;
        if (f == 0.0f) {
            n = Integer.MAX_VALUE;
            this.hasDiscontinuity = true;
        } else {
            for (int i = 0; i < this.normalizedIntervals.length; ++i) {
                n = (int)((float)n + this.normalizedIntervals[i] / f * 256.0f);
            }
        }
        if (n > 5000) {
            this.calculateMultipleArrayGradient(colorArray, colorArray2);
            if (this.cycleMethod == MultipleGradientPaint.REPEAT && this.gradients[0][0] != this.gradients[this.gradients.length - 1][255]) {
                this.hasDiscontinuity = true;
            }
        } else {
            this.calculateSingleArrayGradient(colorArray, colorArray2, f);
            if (this.cycleMethod == MultipleGradientPaint.REPEAT && this.gradient[0] != this.gradient[this.fastGradientArraySize]) {
                this.hasDiscontinuity = true;
            }
        }
        if (this.transparencyTest >>> 24 == 255) {
            if (this.dataModel.getColorSpace() == lrgbmodel_NA.getColorSpace()) {
                this.dataModel = lrgbmodel_NA;
            } else if (this.dataModel.getColorSpace() == srgbmodel_NA.getColorSpace()) {
                this.dataModel = srgbmodel_NA;
            }
            this.model = this.dataModel;
        }
    }

    private void calculateSingleArrayGradient(Color[] colorArray, Color[] colorArray2, float f) {
        int n;
        int n2;
        this.isSimpleLookup = true;
        int n3 = 1;
        int n4 = 32768;
        int n5 = 32768;
        int n6 = 32768;
        int n7 = 32768;
        for (n2 = 0; n2 < this.gradients.length; ++n2) {
            n = (int)(this.normalizedIntervals[n2] / f * 255.0f);
            n3 += n;
            this.gradients[n2] = new int[n];
            int n8 = colorArray[n2].getRGB();
            int n9 = colorArray2[n2].getRGB();
            this.interpolate(n8, n9, this.gradients[n2]);
            int n10 = this.gradients[n2][128];
            float f2 = this.normalizedIntervals[n2];
            n4 += (int)((float)(n10 >> 8 & 0xFF0000) * f2);
            n5 += (int)((float)(n10 & 0xFF0000) * f2);
            n6 += (int)((float)(n10 << 8 & 0xFF0000) * f2);
            n7 += (int)((float)(n10 << 16 & 0xFF0000) * f2);
            this.transparencyTest &= n8;
            this.transparencyTest &= n9;
        }
        this.gradientAverage = (n4 & 0xFF0000) << 8 | n5 & 0xFF0000 | (n6 & 0xFF0000) >> 8 | (n7 & 0xFF0000) >> 16;
        this.gradient = new int[n3];
        n2 = 0;
        for (n = 0; n < this.gradients.length; ++n) {
            System.arraycopy(this.gradients[n], 0, this.gradient, n2, this.gradients[n].length);
            n2 += this.gradients[n].length;
        }
        this.gradient[this.gradient.length - 1] = colorArray2[colorArray2.length - 1].getRGB();
        if (this.colorSpace == LinearGradientPaint.LINEAR_RGB) {
            if (this.dataModel.getColorSpace() == ColorSpace.getInstance(1000)) {
                for (n = 0; n < this.gradient.length; ++n) {
                    this.gradient[n] = this.convertEntireColorLinearRGBtoSRGB(this.gradient[n]);
                }
                this.gradientAverage = this.convertEntireColorLinearRGBtoSRGB(this.gradientAverage);
            }
        } else if (this.dataModel.getColorSpace() == ColorSpace.getInstance(1004)) {
            for (n = 0; n < this.gradient.length; ++n) {
                this.gradient[n] = this.convertEntireColorSRGBtoLinearRGB(this.gradient[n]);
            }
            this.gradientAverage = this.convertEntireColorSRGBtoLinearRGB(this.gradientAverage);
        }
        this.fastGradientArraySize = this.gradient.length - 1;
    }

    private void calculateMultipleArrayGradient(Color[] colorArray, Color[] colorArray2) {
        int n;
        int n2;
        this.isSimpleLookup = false;
        int n3 = 32768;
        int n4 = 32768;
        int n5 = 32768;
        int n6 = 32768;
        for (n2 = 0; n2 < this.gradients.length; ++n2) {
            if (this.normalizedIntervals[n2] == 0.0f) continue;
            this.gradients[n2] = new int[256];
            int n7 = colorArray[n2].getRGB();
            int n8 = colorArray2[n2].getRGB();
            this.interpolate(n7, n8, this.gradients[n2]);
            n = this.gradients[n2][128];
            float f = this.normalizedIntervals[n2];
            n3 += (int)((float)(n >> 8 & 0xFF0000) * f);
            n4 += (int)((float)(n & 0xFF0000) * f);
            n5 += (int)((float)(n << 8 & 0xFF0000) * f);
            n6 += (int)((float)(n << 16 & 0xFF0000) * f);
            this.transparencyTest &= n7;
            this.transparencyTest &= n8;
        }
        this.gradientAverage = (n3 & 0xFF0000) << 8 | n4 & 0xFF0000 | (n5 & 0xFF0000) >> 8 | (n6 & 0xFF0000) >> 16;
        if (this.colorSpace == LinearGradientPaint.LINEAR_RGB) {
            if (this.dataModel.getColorSpace() == ColorSpace.getInstance(1000)) {
                for (n2 = 0; n2 < this.gradients.length; ++n2) {
                    for (n = 0; n < this.gradients[n2].length; ++n) {
                        this.gradients[n2][n] = this.convertEntireColorLinearRGBtoSRGB(this.gradients[n2][n]);
                    }
                }
                this.gradientAverage = this.convertEntireColorLinearRGBtoSRGB(this.gradientAverage);
            }
        } else if (this.dataModel.getColorSpace() == ColorSpace.getInstance(1004)) {
            for (n2 = 0; n2 < this.gradients.length; ++n2) {
                for (n = 0; n < this.gradients[n2].length; ++n) {
                    this.gradients[n2][n] = this.convertEntireColorSRGBtoLinearRGB(this.gradients[n2][n]);
                }
            }
            this.gradientAverage = this.convertEntireColorSRGBtoLinearRGB(this.gradientAverage);
        }
    }

    private void interpolate(int n, int n2, int[] nArray) {
        float f = 1.0f / (float)nArray.length;
        int n3 = n >> 24 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 8 & 0xFF;
        int n6 = n & 0xFF;
        int n7 = (n2 >> 24 & 0xFF) - n3;
        int n8 = (n2 >> 16 & 0xFF) - n4;
        int n9 = (n2 >> 8 & 0xFF) - n5;
        int n10 = (n2 & 0xFF) - n6;
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (int)((double)((float)n3 + (float)(i * n7) * f) + 0.5) << 24 | (int)((double)((float)n4 + (float)(i * n8) * f) + 0.5) << 16 | (int)((double)((float)n5 + (float)(i * n9) * f) + 0.5) << 8 | (int)((double)((float)n6 + (float)(i * n10) * f) + 0.5);
        }
    }

    private int convertEntireColorLinearRGBtoSRGB(int n) {
        int n2 = n >> 24 & 0xFF;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        n3 = LinearRGBtoSRGB[n3];
        n4 = LinearRGBtoSRGB[n4];
        n5 = LinearRGBtoSRGB[n5];
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    private int convertEntireColorSRGBtoLinearRGB(int n) {
        int n2 = n >> 24 & 0xFF;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        n3 = SRGBtoLinearRGB[n3];
        n4 = SRGBtoLinearRGB[n4];
        n5 = SRGBtoLinearRGB[n5];
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    protected final int indexIntoGradientsArrays(float f) {
        int n;
        if (this.cycleMethod == MultipleGradientPaint.NO_CYCLE) {
            if (f >= 1.0f) {
                return this.gradientOverflow;
            }
            if (f <= 0.0f) {
                return this.gradientUnderflow;
            }
        } else {
            if (this.cycleMethod == MultipleGradientPaint.REPEAT) {
                if ((f -= (float)((int)f)) < 0.0f) {
                    f += 1.0f;
                }
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                if (this.isSimpleLookup) {
                    int n5 = (int)(f *= (float)this.gradient.length);
                    if (n5 + 1 < this.gradient.length) {
                        return this.gradient[n5];
                    }
                    n2 = (int)((f - (float)n5) * 65536.0f);
                    n3 = this.gradient[n5];
                    n4 = this.gradient[0];
                } else {
                    for (int i = 0; i < this.gradientsLength; ++i) {
                        if (!(f < this.fractions[i + 1])) continue;
                        float f2 = f - this.fractions[i];
                        int n6 = (int)(f2 = f2 / this.normalizedIntervals[i] * 256.0f);
                        if (n6 + 1 < this.gradients[i].length || i + 1 < this.gradientsLength) {
                            return this.gradients[i][n6];
                        }
                        n2 = (int)((f2 - (float)n6) * 65536.0f);
                        n3 = this.gradients[i][n6];
                        n4 = this.gradients[0][0];
                        break;
                    }
                }
                return ((n3 >> 8 & 0xFF0000) + ((n4 >>> 24) - (n3 >>> 24)) * n2 & 0xFF0000) << 8 | (n3 & 0xFF0000) + ((n4 >> 16 & 0xFF) - (n3 >> 16 & 0xFF)) * n2 & 0xFF0000 | ((n3 << 8 & 0xFF0000) + ((n4 >> 8 & 0xFF) - (n3 >> 8 & 0xFF)) * n2 & 0xFF0000) >> 8 | ((n3 << 16 & 0xFF0000) + ((n4 & 0xFF) - (n3 & 0xFF)) * n2 & 0xFF0000) >> 16;
            }
            if (f < 0.0f) {
                f = -f;
            }
            n = (int)f;
            f -= (float)n;
            if ((n & 1) == 1) {
                f = 1.0f - f;
            }
        }
        if (this.isSimpleLookup) {
            return this.gradient[(int)(f * (float)this.fastGradientArraySize)];
        }
        for (n = 0; n < this.gradientsLength; ++n) {
            if (!(f < this.fractions[n + 1])) continue;
            float f3 = f - this.fractions[n];
            int n7 = (int)(f3 / this.normalizedIntervals[n] * 255.0f);
            return this.gradients[n][n7];
        }
        return this.gradientOverflow;
    }

    protected final int indexGradientAntiAlias(float f, float f2) {
        if (this.cycleMethod == MultipleGradientPaint.NO_CYCLE) {
            int n;
            int n2;
            float f3;
            float f4 = f - f2 / 2.0f;
            float f5 = f + f2 / 2.0f;
            if (f4 >= 1.0f) {
                return this.gradientOverflow;
            }
            if (f5 <= 0.0f) {
                return this.gradientUnderflow;
            }
            float f6 = 0.0f;
            float f7 = 0.0f;
            if (f5 >= 1.0f) {
                f6 = (f5 - 1.0f) / f2;
                if (f4 <= 0.0f) {
                    f7 = -f4 / f2;
                    f3 = 1.0f;
                    n2 = this.gradientAverage;
                } else {
                    f3 = 1.0f - f4;
                    n2 = this.getAntiAlias(f4, true, 1.0f, false, 1.0f - f4, 1.0f);
                }
            } else if (f4 <= 0.0f) {
                f7 = -f4 / f2;
                f3 = f5;
                n2 = this.getAntiAlias(0.0f, true, f5, false, f5, 1.0f);
            } else {
                return this.getAntiAlias(f4, true, f5, false, f2, 1.0f);
            }
            int n3 = (int)(65536.0f * f3 / f2);
            int n4 = (n2 >>> 20 & 0xFF0) * n3 >> 16;
            int n5 = (n2 >> 12 & 0xFF0) * n3 >> 16;
            int n6 = (n2 >> 4 & 0xFF0) * n3 >> 16;
            int n7 = (n2 << 4 & 0xFF0) * n3 >> 16;
            if (f7 != 0.0f) {
                n = this.gradientUnderflow;
                n3 = (int)(65536.0f * f7);
                n4 += (n >>> 20 & 0xFF0) * n3 >> 16;
                n5 += (n >> 12 & 0xFF0) * n3 >> 16;
                n6 += (n >> 4 & 0xFF0) * n3 >> 16;
                n7 += (n << 4 & 0xFF0) * n3 >> 16;
            }
            if (f6 != 0.0f) {
                n = this.gradientOverflow;
                n3 = (int)(65536.0f * f6);
                n4 += (n >>> 20 & 0xFF0) * n3 >> 16;
                n5 += (n >> 12 & 0xFF0) * n3 >> 16;
                n6 += (n >> 4 & 0xFF0) * n3 >> 16;
                n7 += (n << 4 & 0xFF0) * n3 >> 16;
            }
            return (n4 & 0xFF0) << 20 | (n5 & 0xFF0) << 12 | (n6 & 0xFF0) << 4 | (n7 & 0xFF0) >> 4;
        }
        int n = (int)f2;
        float f8 = 1.0f;
        if (n != 0 && (double)(f8 = (f2 -= (float)n) / ((float)n + f2)) < 0.1) {
            return this.gradientAverage;
        }
        if ((double)f2 > 0.99) {
            return this.gradientAverage;
        }
        float f9 = f - f2 / 2.0f;
        float f10 = f + f2 / 2.0f;
        boolean bl = true;
        boolean bl2 = false;
        if (this.cycleMethod == MultipleGradientPaint.REPEAT) {
            f9 -= (float)((int)f9);
            f10 -= (float)((int)f10);
            if (f9 < 0.0f) {
                f9 += 1.0f;
            }
            if (f10 < 0.0f) {
                f10 += 1.0f;
            }
        } else {
            if (f10 < 0.0f) {
                f9 = -f9;
                bl = !bl;
                f10 = -f10;
                bl2 = !bl2;
            } else if (f9 < 0.0f) {
                f9 = -f9;
                bl = !bl;
            }
            int n8 = (int)f9;
            f9 -= (float)n8;
            int n9 = (int)f10;
            f10 -= (float)n9;
            if ((n8 & 1) == 1) {
                f9 = 1.0f - f9;
                boolean bl3 = bl = !bl;
            }
            if ((n9 & 1) == 1) {
                f10 = 1.0f - f10;
                boolean bl4 = bl2 = !bl2;
            }
            if (f9 > f10 && !bl && bl2) {
                float f11 = f9;
                f9 = f10;
                f10 = f11;
                bl = true;
                bl2 = false;
            }
        }
        return this.getAntiAlias(f9, bl, f10, bl2, f2, f8);
    }

    private final int getAntiAlias(float f, boolean bl, float f2, boolean bl2, float f3, float f4) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (this.isSimpleLookup) {
            n5 = (int)(f *= (float)this.fastGradientArraySize);
            n4 = (int)(f2 *= (float)this.fastGradientArraySize);
            if (bl && !bl2 && n5 <= n4) {
                if (n5 == n4) {
                    return this.gradient[n5];
                }
                for (n3 = n5 + 1; n3 < n4; ++n3) {
                    n2 = this.gradient[n3];
                    n6 += n2 >>> 20 & 0xFF0;
                    n7 += n2 >>> 12 & 0xFF0;
                    n8 += n2 >>> 4 & 0xFF0;
                    n9 += n2 << 4 & 0xFF0;
                }
            } else {
                if (bl) {
                    for (n3 = n5 + 1; n3 < this.fastGradientArraySize; ++n3) {
                        n2 = this.gradient[n3];
                        n6 += n2 >>> 20 & 0xFF0;
                        n7 += n2 >>> 12 & 0xFF0;
                        n8 += n2 >>> 4 & 0xFF0;
                        n9 += n2 << 4 & 0xFF0;
                    }
                } else {
                    for (n3 = 0; n3 < n5; ++n3) {
                        n2 = this.gradient[n3];
                        n6 += n2 >>> 20 & 0xFF0;
                        n7 += n2 >>> 12 & 0xFF0;
                        n8 += n2 >>> 4 & 0xFF0;
                        n9 += n2 << 4 & 0xFF0;
                    }
                }
                if (bl2) {
                    for (n3 = n4 + 1; n3 < this.fastGradientArraySize; ++n3) {
                        n2 = this.gradient[n3];
                        n6 += n2 >>> 20 & 0xFF0;
                        n7 += n2 >>> 12 & 0xFF0;
                        n8 += n2 >>> 4 & 0xFF0;
                        n9 += n2 << 4 & 0xFF0;
                    }
                } else {
                    for (n3 = 0; n3 < n4; ++n3) {
                        n2 = this.gradient[n3];
                        n6 += n2 >>> 20 & 0xFF0;
                        n7 += n2 >>> 12 & 0xFF0;
                        n8 += n2 >>> 4 & 0xFF0;
                        n9 += n2 << 4 & 0xFF0;
                    }
                }
            }
            n = (int)(65536.0f / (f3 * (float)this.fastGradientArraySize));
            n6 = n6 * n >> 16;
            n7 = n7 * n >> 16;
            n8 = n8 * n >> 16;
            n9 = n9 * n >> 16;
            int n10 = bl ? (int)((1.0f - (f - (float)n5)) * (float)n) : (int)((f - (float)n5) * (float)n);
            n2 = this.gradient[n5];
            n6 += (n2 >>> 20 & 0xFF0) * n10 >> 16;
            n7 += (n2 >>> 12 & 0xFF0) * n10 >> 16;
            n8 += (n2 >>> 4 & 0xFF0) * n10 >> 16;
            n9 += (n2 << 4 & 0xFF0) * n10 >> 16;
            n10 = bl2 ? (int)((1.0f - (f2 - (float)n4)) * (float)n) : (int)((f2 - (float)n4) * (float)n);
            n2 = this.gradient[n4];
            n6 += (n2 >>> 20 & 0xFF0) * n10 >> 16;
            n7 += (n2 >>> 12 & 0xFF0) * n10 >> 16;
            n8 += (n2 >>> 4 & 0xFF0) * n10 >> 16;
            n9 += (n2 << 4 & 0xFF0) * n10 >> 16;
            n6 = n6 + 8 >> 4;
            n7 = n7 + 8 >> 4;
            n8 = n8 + 8 >> 4;
            n9 = n9 + 8 >> 4;
        } else {
            int n11;
            n5 = 0;
            n4 = 0;
            n3 = -1;
            n2 = -1;
            float f5 = 0.0f;
            float f6 = 0.0f;
            for (n11 = 0; n11 < this.gradientsLength; ++n11) {
                if (f < this.fractions[n11 + 1] && n3 == -1) {
                    n3 = n11;
                    f5 = f - this.fractions[n11];
                    f5 = f5 / this.normalizedIntervals[n11] * 255.0f;
                    n5 = (int)f5;
                    if (n2 != -1) break;
                }
                if (!(f2 < this.fractions[n11 + 1]) || n2 != -1) continue;
                n2 = n11;
                f6 = f2 - this.fractions[n11];
                f6 = f6 / this.normalizedIntervals[n11] * 255.0f;
                n4 = (int)f6;
                if (n3 != -1) break;
            }
            if (n3 == -1) {
                n3 = this.gradients.length - 1;
                n5 = 255;
                f5 = 255;
            }
            if (n2 == -1) {
                n2 = this.gradients.length - 1;
                n4 = 255;
                f6 = 255;
            }
            if (n3 == n2 && n5 <= n4 && bl && !bl2) {
                return this.gradients[n3][n5 + n4 + 1 >> 1];
            }
            int n12 = (int)(65536.0f / f3);
            if (n3 < n2 && bl && !bl2) {
                int n13 = (int)((float)n12 * this.normalizedIntervals[n3] * (255.0f - f5) / 255.0f);
                n11 = this.gradients[n3][n5 + 256 >> 1];
                n6 += (n11 >>> 20 & 0xFF0) * n13 >> 16;
                n7 += (n11 >>> 12 & 0xFF0) * n13 >> 16;
                n8 += (n11 >>> 4 & 0xFF0) * n13 >> 16;
                n9 += (n11 << 4 & 0xFF0) * n13 >> 16;
                for (int i = n3 + 1; i < n2; ++i) {
                    n13 = (int)((float)n12 * this.normalizedIntervals[i]);
                    n11 = this.gradients[i][128];
                    n6 += (n11 >>> 20 & 0xFF0) * n13 >> 16;
                    n7 += (n11 >>> 12 & 0xFF0) * n13 >> 16;
                    n8 += (n11 >>> 4 & 0xFF0) * n13 >> 16;
                    n9 += (n11 << 4 & 0xFF0) * n13 >> 16;
                }
                n13 = (int)((float)n12 * this.normalizedIntervals[n2] * f6 / 255.0f);
                n11 = this.gradients[n2][n4 + 1 >> 1];
                n6 += (n11 >>> 20 & 0xFF0) * n13 >> 16;
                n7 += (n11 >>> 12 & 0xFF0) * n13 >> 16;
                n8 += (n11 >>> 4 & 0xFF0) * n13 >> 16;
                n9 += (n11 << 4 & 0xFF0) * n13 >> 16;
            } else {
                int n14;
                int n15;
                if (bl) {
                    n15 = (int)((float)n12 * this.normalizedIntervals[n3] * (255.0f - f5) / 255.0f);
                    n11 = this.gradients[n3][n5 + 256 >> 1];
                } else {
                    n15 = (int)((float)n12 * this.normalizedIntervals[n3] * f5 / 255.0f);
                    n11 = this.gradients[n3][n5 + 1 >> 1];
                }
                n6 += (n11 >>> 20 & 0xFF0) * n15 >> 16;
                n7 += (n11 >>> 12 & 0xFF0) * n15 >> 16;
                n8 += (n11 >>> 4 & 0xFF0) * n15 >> 16;
                n9 += (n11 << 4 & 0xFF0) * n15 >> 16;
                if (bl2) {
                    n15 = (int)((float)n12 * this.normalizedIntervals[n2] * (255.0f - f6) / 255.0f);
                    n11 = this.gradients[n2][n4 + 256 >> 1];
                } else {
                    n15 = (int)((float)n12 * this.normalizedIntervals[n2] * f6 / 255.0f);
                    n11 = this.gradients[n2][n4 + 1 >> 1];
                }
                n6 += (n11 >>> 20 & 0xFF0) * n15 >> 16;
                n7 += (n11 >>> 12 & 0xFF0) * n15 >> 16;
                n8 += (n11 >>> 4 & 0xFF0) * n15 >> 16;
                n9 += (n11 << 4 & 0xFF0) * n15 >> 16;
                if (bl) {
                    for (n14 = n3 + 1; n14 < this.gradientsLength; ++n14) {
                        n15 = (int)((float)n12 * this.normalizedIntervals[n14]);
                        n11 = this.gradients[n14][128];
                        n6 += (n11 >>> 20 & 0xFF0) * n15 >> 16;
                        n7 += (n11 >>> 12 & 0xFF0) * n15 >> 16;
                        n8 += (n11 >>> 4 & 0xFF0) * n15 >> 16;
                        n9 += (n11 << 4 & 0xFF0) * n15 >> 16;
                    }
                } else {
                    for (n14 = 0; n14 < n3; ++n14) {
                        n15 = (int)((float)n12 * this.normalizedIntervals[n14]);
                        n11 = this.gradients[n14][128];
                        n6 += (n11 >>> 20 & 0xFF0) * n15 >> 16;
                        n7 += (n11 >>> 12 & 0xFF0) * n15 >> 16;
                        n8 += (n11 >>> 4 & 0xFF0) * n15 >> 16;
                        n9 += (n11 << 4 & 0xFF0) * n15 >> 16;
                    }
                }
                if (bl2) {
                    for (n14 = n2 + 1; n14 < this.gradientsLength; ++n14) {
                        n15 = (int)((float)n12 * this.normalizedIntervals[n14]);
                        n11 = this.gradients[n14][128];
                        n6 += (n11 >>> 20 & 0xFF0) * n15 >> 16;
                        n7 += (n11 >>> 12 & 0xFF0) * n15 >> 16;
                        n8 += (n11 >>> 4 & 0xFF0) * n15 >> 16;
                        n9 += (n11 << 4 & 0xFF0) * n15 >> 16;
                    }
                } else {
                    for (n14 = 0; n14 < n2; ++n14) {
                        n15 = (int)((float)n12 * this.normalizedIntervals[n14]);
                        n11 = this.gradients[n14][128];
                        n6 += (n11 >>> 20 & 0xFF0) * n15 >> 16;
                        n7 += (n11 >>> 12 & 0xFF0) * n15 >> 16;
                        n8 += (n11 >>> 4 & 0xFF0) * n15 >> 16;
                        n9 += (n11 << 4 & 0xFF0) * n15 >> 16;
                    }
                }
            }
            n6 = n6 + 8 >> 4;
            n7 = n7 + 8 >> 4;
            n8 = n8 + 8 >> 4;
            n9 = n9 + 8 >> 4;
        }
        if (f4 != 1.0f) {
            n5 = (int)(65536.0f * (1.0f - f4));
            n4 = (this.gradientAverage >>> 24 & 0xFF) * n5;
            n3 = (this.gradientAverage >> 16 & 0xFF) * n5;
            n2 = (this.gradientAverage >> 8 & 0xFF) * n5;
            int n16 = (this.gradientAverage & 0xFF) * n5;
            n = (int)(f4 * 65536.0f);
            n6 = n6 * n + n4 >> 16;
            n7 = n7 * n + n3 >> 16;
            n8 = n8 * n + n2 >> 16;
            n9 = n9 * n + n16 >> 16;
        }
        return n6 << 24 | n7 << 16 | n8 << 8 | n9;
    }

    private static int convertSRGBtoLinearRGB(int n) {
        float f = (float)n / 255.0f;
        float f2 = f <= 0.04045f ? f / 12.92f : (float)Math.pow(((double)f + 0.055) / 1.055, 2.4);
        int n2 = Math.round(f2 * 255.0f);
        return n2;
    }

    private static int convertLinearRGBtoSRGB(int n) {
        float f = (float)n / 255.0f;
        float f2 = (double)f <= 0.0031308 ? f * 12.92f : 1.055f * (float)Math.pow(f, 0.4166666666666667) - 0.055f;
        int n2 = Math.round(f2 * 255.0f);
        return n2;
    }

    public final Raster getRaster(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return null;
        }
        WritableRaster writableRaster = this.saved;
        if (writableRaster == null || writableRaster.getWidth() < n3 || writableRaster.getHeight() < n4) {
            this.saved = writableRaster = MultipleGradientPaintContext.getCachedRaster(this.dataModel, n3, n4);
        }
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getBankData()[0];
        int n5 = dataBufferInt.getOffset();
        int n6 = ((SinglePixelPackedSampleModel)writableRaster.getSampleModel()).getScanlineStride();
        int n7 = n6 - n3;
        this.fillRaster(nArray, n5, n7, n, n2, n3, n4);
        GraphicsUtil.coerceData(writableRaster, this.dataModel, this.model.isAlphaPremultiplied());
        return writableRaster;
    }

    protected abstract void fillRaster(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    protected static final synchronized WritableRaster getCachedRaster(ColorModel colorModel, int n, int n2) {
        WritableRaster writableRaster;
        if (colorModel == cachedModel && cached != null && (writableRaster = (WritableRaster)cached.get()) != null && writableRaster.getWidth() >= n && writableRaster.getHeight() >= n2) {
            cached = null;
            return writableRaster;
        }
        if (n < 32) {
            n = 32;
        }
        if (n2 < 32) {
            n2 = 32;
        }
        return colorModel.createCompatibleWritableRaster(n, n2);
    }

    protected static final synchronized void putCachedRaster(ColorModel colorModel, WritableRaster writableRaster) {
        WritableRaster writableRaster2;
        if (cached != null && (writableRaster2 = (WritableRaster)cached.get()) != null) {
            int n = writableRaster2.getWidth();
            int n2 = writableRaster2.getHeight();
            int n3 = writableRaster.getWidth();
            int n4 = writableRaster.getHeight();
            if (n >= n3 && n2 >= n4) {
                return;
            }
            if (n * n2 >= n3 * n4) {
                return;
            }
        }
        cachedModel = colorModel;
        cached = new WeakReference<WritableRaster>(writableRaster);
    }

    public final void dispose() {
        if (this.saved != null) {
            MultipleGradientPaintContext.putCachedRaster(this.model, this.saved);
            this.saved = null;
        }
    }

    public final ColorModel getColorModel() {
        return this.model;
    }

    static {
        SRGBtoLinearRGB = new int[256];
        LinearRGBtoSRGB = new int[256];
        for (int i = 0; i < 256; ++i) {
            MultipleGradientPaintContext.SRGBtoLinearRGB[i] = MultipleGradientPaintContext.convertSRGBtoLinearRGB(i);
            MultipleGradientPaintContext.LinearRGBtoSRGB[i] = MultipleGradientPaintContext.convertLinearRGBtoSRGB(i);
        }
    }
}

