/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.util.concurrent.Future;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.io.UpdatePrimitivesTask;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadOsmChangeTask
extends DownloadOsmTask {
    @Override
    public boolean acceptsUrl(String string) {
        return string != null && string.matches("http://.*/api/0.6/changeset/\\p{Digit}+/download");
    }

    @Override
    public Future<?> download(boolean bl, Bounds bounds, ProgressMonitor progressMonitor) {
        return null;
    }

    @Override
    public Future<?> loadUrl(boolean bl, String string, ProgressMonitor progressMonitor) {
        this.downloadTask = new DownloadTask(bl, (OsmServerReader)new OsmServerLocationReader(string), progressMonitor);
        return Main.worker.submit(this.downloadTask);
    }

    protected class DownloadTask
    extends DownloadOsmTask.DownloadTask {
        public DownloadTask(boolean bl, OsmServerReader osmServerReader, ProgressMonitor progressMonitor) {
            super(bl, osmServerReader, progressMonitor);
        }

        protected DataSet parseDataSet() throws OsmTransferException {
            return this.reader.parseOsmChange(this.progressMonitor.createSubTaskMonitor(-1, false));
        }

        protected void finish() {
            super.finish();
            if (DownloadOsmChangeTask.this.isFailed() || DownloadOsmChangeTask.this.isCanceled() || DownloadOsmChangeTask.this.downloadedData == null) {
                return;
            }
            this.progressMonitor.subTask(I18n.tr("Updating data", new Object[0]));
            UpdatePrimitivesTask updatePrimitivesTask = new UpdatePrimitivesTask(DownloadOsmChangeTask.this.targetLayer, DownloadOsmChangeTask.this.downloadedData.allPrimitives());
            Main.worker.submit(updatePrimitivesTask);
        }
    }
}

