/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Hash;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.Storage;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PurgeCommand
extends Command {
    protected List<OsmPrimitive> toPurge;
    protected Storage<PrimitiveData> makeIncompleteData;
    protected Map<PrimitiveId, PrimitiveData> makeIncompleteData_byPrimId;
    protected final DataSet ds;

    public PurgeCommand(OsmDataLayer osmDataLayer, Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2) {
        super(osmDataLayer);
        this.ds = osmDataLayer.data;
        this.toPurge = PurgeCommand.topoSort(collection);
        this.saveIncomplete(collection2);
    }

    protected void saveIncomplete(Collection<OsmPrimitive> collection) {
        this.makeIncompleteData = new Storage<PrimitiveData>(new Hash<PrimitiveData, PrimitiveData>(){

            @Override
            public int getHashCode(PrimitiveData primitiveData) {
                return (int)primitiveData.getUniqueId();
            }

            @Override
            public boolean equals(PrimitiveData primitiveData, PrimitiveData primitiveData2) {
                return primitiveData.getUniqueId() == primitiveData2.getUniqueId() && primitiveData.getType() == primitiveData2.getType();
            }
        });
        this.makeIncompleteData_byPrimId = this.makeIncompleteData.foreignKey(new Hash<PrimitiveId, PrimitiveData>(){

            @Override
            public int getHashCode(PrimitiveId primitiveId) {
                return (int)primitiveId.getUniqueId();
            }

            @Override
            public boolean equals(PrimitiveId primitiveId, PrimitiveData primitiveData) {
                return primitiveId.getUniqueId() == primitiveData.getUniqueId() && primitiveId.getType() == primitiveData.getType();
            }
        });
        for (OsmPrimitive osmPrimitive : collection) {
            this.makeIncompleteData.add(osmPrimitive.save());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeCommand() {
        this.ds.beginUpdate();
        try {
            for (int i = this.toPurge.size() - 1; i >= 0; --i) {
                OsmPrimitive osmPrimitive = this.toPurge.get(i);
                if (this.makeIncompleteData_byPrimId.containsKey(osmPrimitive)) {
                    PrimitiveData primitiveData;
                    switch (osmPrimitive.getType()) {
                        case NODE: {
                            primitiveData = new NodeData();
                            break;
                        }
                        case WAY: {
                            primitiveData = new WayData();
                            break;
                        }
                        case RELATION: {
                            primitiveData = new RelationData();
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    primitiveData.setId(osmPrimitive.getUniqueId());
                    primitiveData.setIncomplete(true);
                    osmPrimitive.load(primitiveData);
                    continue;
                }
                this.ds.removePrimitive(osmPrimitive);
            }
        }
        finally {
            this.ds.endUpdate();
        }
        return true;
    }

    @Override
    public void undoCommand() {
        if (this.ds == null) {
            return;
        }
        for (OsmPrimitive osmPrimitive : this.toPurge) {
            PrimitiveData primitiveData = this.makeIncompleteData_byPrimId.get(osmPrimitive);
            if (primitiveData != null) {
                if (this.ds.getPrimitiveById(osmPrimitive) != osmPrimitive) {
                    throw new AssertionError((Object)String.format("Primitive %s has been made incomplete when purging, but it cannot be found on undo.", osmPrimitive));
                }
                osmPrimitive.load(primitiveData);
                continue;
            }
            if (this.ds.getPrimitiveById(osmPrimitive) != null) {
                throw new AssertionError((Object)String.format("Primitive %s was removed when purging, but is still there on undo", osmPrimitive));
            }
            this.ds.addPrimitive(osmPrimitive);
        }
    }

    public static List<OsmPrimitive> topoSort(Collection<OsmPrimitive> collection) {
        Comparable<Integer> comparable;
        Relation relation;
        Object object2;
        Object object3;
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>(collection);
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(hashSet.size());
        Iterator iterator = hashSet.iterator();
        block0: while (iterator.hasNext()) {
            object3 = (OsmPrimitive)iterator.next();
            if (!(object3 instanceof Node)) continue;
            object2 = (Node)object3;
            for (OsmPrimitive object4 : ((OsmPrimitive)object2).getReferrers()) {
                if (!(object4 instanceof Way) || !hashSet.contains(object4)) continue;
                continue block0;
            }
            iterator.remove();
            arrayList.add((OsmPrimitive)object2);
        }
        block2: while (!hashSet.isEmpty()) {
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                object3 = (OsmPrimitive)iterator.next();
                if (!(object3 instanceof Way)) continue;
                object2 = (Way)object3;
                iterator.remove();
                for (Node node : ((Way)object2).getNodes()) {
                    if (!hashSet.contains(node)) continue;
                    hashSet.remove(node);
                    arrayList.add(node);
                }
                arrayList.add((OsmPrimitive)object2);
                continue block2;
            }
            break block2;
        }
        iterator = hashSet;
        object3 = new HashSet();
        object2 = new ArrayList(iterator.size());
        Iterator<Node> iterator2 = new HashMap();
        Iterator iterator3 = iterator.iterator();
        while (iterator3.hasNext()) {
            relation = (Relation)iterator3.next();
            ((HashMap)((Object)iterator2)).put(relation, 0);
        }
        Iterator iterator4 = iterator.iterator();
        while (iterator4.hasNext()) {
            relation = (Relation)iterator4.next();
            for (OsmPrimitive osmPrimitive : relation.getReferrers()) {
                if (!(osmPrimitive instanceof Relation)) {
                    throw new AssertionError();
                }
                comparable = (Integer)((HashMap)((Object)iterator2)).get(osmPrimitive);
                if (comparable == null) continue;
                ((HashMap)((Object)iterator2)).put((Relation)osmPrimitive, comparable + 1);
            }
        }
        Iterator iterator5 = iterator.iterator();
        while (iterator5.hasNext()) {
            relation = (Relation)iterator5.next();
            if (!((Integer)((HashMap)((Object)iterator2)).get(relation)).equals(0)) continue;
            object3.add(relation);
        }
        while (!object3.isEmpty()) {
            Iterator iterator6 = object3.iterator();
            relation = (Relation)iterator6.next();
            iterator6.remove();
            object2.add(relation);
            for (OsmPrimitive osmPrimitive : relation.getReferrers()) {
                comparable = (Relation)osmPrimitive;
                Integer n = (Integer)((HashMap)((Object)iterator2)).get(comparable);
                if (n == null) continue;
                ((HashMap)((Object)iterator2)).put(comparable, n - 1);
                if (n - 1 != 0) continue;
                object3.add(comparable);
            }
        }
        if (object2.size() != iterator.size()) {
            throw new AssertionError((Object)"topo sort algorithm failed");
        }
        arrayList.addAll((Collection<OsmPrimitive>)object2);
        return arrayList;
    }

    @Override
    public Object getDescription() {
        return new JLabel(I18n.trn("Purged {0} object", "Purged {0} objects", this.toPurge.size(), this.toPurge.size()), ImageProvider.get("data", "purge"), 0);
    }

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        return this.toPurge;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
    }
}

