/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.properties;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.conflict.ConflictColors;
import org.openstreetmap.josm.gui.conflict.pair.IConflictResolver;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.conflict.pair.properties.PropertiesMergeModel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesMerger
extends JPanel
implements Observer,
IConflictResolver {
    private static DecimalFormat COORD_FORMATTER = new DecimalFormat("###0.0000000");
    private JLabel lblMyVersion;
    private JLabel lblMergedVersion;
    private JLabel lblTheirVersion;
    private JLabel lblMyCoordinates;
    private JLabel lblMergedCoordinates;
    private JLabel lblTheirCoordinates;
    private JLabel lblMyDeletedState;
    private JLabel lblMergedDeletedState;
    private JLabel lblTheirDeletedState;
    private JLabel lblMyReferrers;
    private JLabel lblTheirReferrers;
    private final PropertiesMergeModel model = new PropertiesMergeModel();

    protected JLabel buildValueLabel(String string) {
        JLabel jLabel = new JLabel();
        jLabel.setName(string);
        jLabel.setHorizontalAlignment(0);
        jLabel.setOpaque(true);
        jLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        return jLabel;
    }

    protected void buildHeaderRow() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.lblMyVersion = new JLabel(I18n.tr("My version", new Object[0]));
        this.lblMyVersion.setToolTipText(I18n.tr("Properties in my dataset, i.e. the local dataset", new Object[0]));
        this.add((Component)this.lblMyVersion, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.lblMergedVersion = new JLabel(I18n.tr("Merged version", new Object[0]));
        this.lblMergedVersion.setToolTipText(I18n.tr("Properties in the merged element. They will replace properties in my elements when merge decisions are applied.", new Object[0]));
        this.add((Component)this.lblMergedVersion, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        this.lblTheirVersion = new JLabel(I18n.tr("Their version", new Object[0]));
        this.lblTheirVersion.setToolTipText(I18n.tr("Properties in their dataset, i.e. the server dataset", new Object[0]));
        this.add((Component)this.lblTheirVersion, gridBagConstraints);
    }

    protected void buildCoordinateConflictRows() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)new JLabel(I18n.tr("Coordinates:", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.0;
        this.lblMyCoordinates = this.buildValueLabel("label.mycoordinates");
        this.add((Component)this.lblMyCoordinates, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        KeepMyCoordinatesAction keepMyCoordinatesAction = new KeepMyCoordinatesAction();
        this.model.addObserver(keepMyCoordinatesAction);
        JButton jButton = new JButton(keepMyCoordinatesAction);
        jButton.setName("button.keepmycoordinates");
        this.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.0;
        this.lblMergedCoordinates = this.buildValueLabel("label.mergedcoordinates");
        this.add((Component)this.lblMergedCoordinates, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        KeepTheirCoordinatesAction keepTheirCoordinatesAction = new KeepTheirCoordinatesAction();
        this.model.addObserver(keepTheirCoordinatesAction);
        JButton jButton2 = new JButton(keepTheirCoordinatesAction);
        this.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.0;
        this.lblTheirCoordinates = this.buildValueLabel("label.theircoordinates");
        this.add((Component)this.lblTheirCoordinates, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        UndecideCoordinateConflictAction undecideCoordinateConflictAction = new UndecideCoordinateConflictAction();
        this.model.addObserver(undecideCoordinateConflictAction);
        JButton jButton3 = new JButton(undecideCoordinateConflictAction);
        this.add((Component)jButton3, gridBagConstraints);
    }

    protected void buildDeletedStateConflictRows() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)new JLabel(I18n.tr("Deleted State:", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.0;
        this.lblMyDeletedState = this.buildValueLabel("label.mydeletedstate");
        this.add((Component)this.lblMyDeletedState, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        KeepMyDeletedStateAction keepMyDeletedStateAction = new KeepMyDeletedStateAction();
        this.model.addObserver(keepMyDeletedStateAction);
        JButton jButton = new JButton(keepMyDeletedStateAction);
        jButton.setName("button.keepmydeletedstate");
        this.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.0;
        this.lblMergedDeletedState = this.buildValueLabel("label.mergeddeletedstate");
        this.add((Component)this.lblMergedDeletedState, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        KeepTheirDeletedStateAction keepTheirDeletedStateAction = new KeepTheirDeletedStateAction();
        this.model.addObserver(keepTheirDeletedStateAction);
        JButton jButton2 = new JButton(keepTheirDeletedStateAction);
        jButton2.setName("button.keeptheirdeletedstate");
        this.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.0;
        this.lblTheirDeletedState = this.buildValueLabel("label.theirdeletedstate");
        this.add((Component)this.lblTheirDeletedState, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        UndecideDeletedStateConflictAction undecideDeletedStateConflictAction = new UndecideDeletedStateConflictAction();
        this.model.addObserver(undecideDeletedStateConflictAction);
        JButton jButton3 = new JButton(undecideDeletedStateConflictAction);
        jButton3.setName("button.undecidedeletedstate");
        this.add((Component)jButton3, gridBagConstraints);
    }

    protected void buildReferrersRow() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)new JLabel(I18n.tr("Referenced by:", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.0;
        this.lblMyReferrers = this.buildValueLabel("label.myreferrers");
        this.add((Component)this.lblMyReferrers, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.0;
        this.lblTheirReferrers = this.buildValueLabel("label.theirreferrers");
        this.add((Component)this.lblTheirReferrers, gridBagConstraints);
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        this.buildHeaderRow();
        this.buildCoordinateConflictRows();
        this.buildDeletedStateConflictRows();
        this.buildReferrersRow();
    }

    public PropertiesMerger() {
        this.model.addObserver(this);
        this.build();
    }

    public String coordToString(LatLon latLon) {
        if (latLon == null) {
            return I18n.tr("(none)", new Object[0]);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(").append(COORD_FORMATTER.format(latLon.lat())).append(",").append(COORD_FORMATTER.format(latLon.lon())).append(")");
        return stringBuilder.toString();
    }

    public String deletedStateToString(Boolean bl) {
        if (bl == null) {
            return I18n.tr("(none)", new Object[0]);
        }
        if (bl.booleanValue()) {
            return I18n.tr("deleted", new Object[0]);
        }
        return I18n.tr("not deleted", new Object[0]);
    }

    public String referrersToString(List<OsmPrimitive> list) {
        if (list.isEmpty()) {
            return I18n.tr("(none)", new Object[0]);
        }
        String string = "<html>";
        for (OsmPrimitive osmPrimitive : list) {
            string = string + osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()) + "<br>";
        }
        string = string + "</html>";
        return string;
    }

    protected void updateCoordinates() {
        this.lblMyCoordinates.setText(this.coordToString(this.model.getMyCoords()));
        this.lblMergedCoordinates.setText(this.coordToString(this.model.getMergedCoords()));
        this.lblTheirCoordinates.setText(this.coordToString(this.model.getTheirCoords()));
        if (!this.model.hasCoordConflict()) {
            this.lblMyCoordinates.setBackground(ConflictColors.BGCOLOR_NO_CONFLICT.get());
            this.lblMergedCoordinates.setBackground(ConflictColors.BGCOLOR_NO_CONFLICT.get());
            this.lblTheirCoordinates.setBackground(ConflictColors.BGCOLOR_NO_CONFLICT.get());
        } else if (!this.model.isDecidedCoord()) {
            this.lblMyCoordinates.setBackground(ConflictColors.BGCOLOR_UNDECIDED.get());
            this.lblMergedCoordinates.setBackground(ConflictColors.BGCOLOR_NO_CONFLICT.get());
            this.lblTheirCoordinates.setBackground(ConflictColors.BGCOLOR_UNDECIDED.get());
        } else {
            this.lblMyCoordinates.setBackground(this.model.isCoordMergeDecision(MergeDecisionType.KEEP_MINE) ? ConflictColors.BGCOLOR_DECIDED.get() : ConflictColors.BGCOLOR_NO_CONFLICT.get());
            this.lblMergedCoordinates.setBackground(ConflictColors.BGCOLOR_DECIDED.get());
            this.lblTheirCoordinates.setBackground(this.model.isCoordMergeDecision(MergeDecisionType.KEEP_THEIR) ? ConflictColors.BGCOLOR_DECIDED.get() : ConflictColors.BGCOLOR_NO_CONFLICT.get());
        }
    }

    protected void updateDeletedState() {
        this.lblMyDeletedState.setText(this.deletedStateToString(this.model.getMyDeletedState()));
        this.lblMergedDeletedState.setText(this.deletedStateToString(this.model.getMergedDeletedState()));
        this.lblTheirDeletedState.setText(this.deletedStateToString(this.model.getTheirDeletedState()));
        if (!this.model.hasDeletedStateConflict()) {
            this.lblMyDeletedState.setBackground(ConflictColors.BGCOLOR_NO_CONFLICT.get());
            this.lblMergedDeletedState.setBackground(ConflictColors.BGCOLOR_NO_CONFLICT.get());
            this.lblTheirDeletedState.setBackground(ConflictColors.BGCOLOR_NO_CONFLICT.get());
        } else if (!this.model.isDecidedDeletedState()) {
            this.lblMyDeletedState.setBackground(ConflictColors.BGCOLOR_UNDECIDED.get());
            this.lblMergedDeletedState.setBackground(ConflictColors.BGCOLOR_NO_CONFLICT.get());
            this.lblTheirDeletedState.setBackground(ConflictColors.BGCOLOR_UNDECIDED.get());
        } else {
            this.lblMyDeletedState.setBackground(this.model.isDeletedStateDecision(MergeDecisionType.KEEP_MINE) ? ConflictColors.BGCOLOR_DECIDED.get() : ConflictColors.BGCOLOR_NO_CONFLICT.get());
            this.lblMergedDeletedState.setBackground(ConflictColors.BGCOLOR_DECIDED.get());
            this.lblTheirDeletedState.setBackground(this.model.isDeletedStateDecision(MergeDecisionType.KEEP_THEIR) ? ConflictColors.BGCOLOR_DECIDED.get() : ConflictColors.BGCOLOR_NO_CONFLICT.get());
        }
    }

    protected void updateReferrers() {
        this.lblMyReferrers.setText(this.referrersToString(this.model.getMyReferrers()));
        this.lblMyReferrers.setBackground(ConflictColors.BGCOLOR_NO_CONFLICT.get());
        this.lblTheirReferrers.setText(this.referrersToString(this.model.getTheirReferrers()));
        this.lblTheirReferrers.setBackground(ConflictColors.BGCOLOR_NO_CONFLICT.get());
    }

    @Override
    public void update(Observable observable, Object object) {
        this.updateCoordinates();
        this.updateDeletedState();
        this.updateReferrers();
    }

    public PropertiesMergeModel getModel() {
        return this.model;
    }

    @Override
    public void deletePrimitive(boolean bl) {
        if (bl) {
            if (this.model.getMergedCoords() == null) {
                this.model.decideCoordsConflict(MergeDecisionType.KEEP_MINE);
            }
        } else {
            this.model.decideCoordsConflict(MergeDecisionType.UNDECIDED);
        }
    }

    @Override
    public void populate(Conflict<? extends OsmPrimitive> conflict) {
        this.model.populate(conflict);
    }

    class UndecideDeletedStateConflictAction
    extends AbstractAction
    implements Observer {
        public UndecideDeletedStateConflictAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagundecide"));
            this.putValue("ShortDescription", I18n.tr("Undecide conflict between deleted state", new Object[0]));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropertiesMerger.this.model.decideDeletedStateConflict(MergeDecisionType.UNDECIDED);
        }

        public void update(Observable observable, Object object) {
            this.setEnabled(PropertiesMerger.this.model.hasDeletedStateConflict() && PropertiesMerger.this.model.isDecidedDeletedState());
        }
    }

    class KeepTheirDeletedStateAction
    extends AbstractAction
    implements Observer {
        public KeepTheirDeletedStateAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagkeeptheir"));
            this.putValue("ShortDescription", I18n.tr("Keep their deleted state", new Object[0]));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropertiesMerger.this.model.decideDeletedStateConflict(MergeDecisionType.KEEP_THEIR);
        }

        public void update(Observable observable, Object object) {
            this.setEnabled(PropertiesMerger.this.model.hasDeletedStateConflict() && !PropertiesMerger.this.model.isDecidedDeletedState());
        }
    }

    class KeepMyDeletedStateAction
    extends AbstractAction
    implements Observer {
        public KeepMyDeletedStateAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagkeepmine"));
            this.putValue("ShortDescription", I18n.tr("Keep my deleted state", new Object[0]));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropertiesMerger.this.model.decideDeletedStateConflict(MergeDecisionType.KEEP_MINE);
        }

        public void update(Observable observable, Object object) {
            this.setEnabled(PropertiesMerger.this.model.hasDeletedStateConflict() && !PropertiesMerger.this.model.isDecidedDeletedState());
        }
    }

    class UndecideCoordinateConflictAction
    extends AbstractAction
    implements Observer {
        public UndecideCoordinateConflictAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagundecide"));
            this.putValue("ShortDescription", I18n.tr("Undecide conflict between different coordinates", new Object[0]));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropertiesMerger.this.model.decideCoordsConflict(MergeDecisionType.UNDECIDED);
        }

        public void update(Observable observable, Object object) {
            this.setEnabled(PropertiesMerger.this.model.hasCoordConflict() && PropertiesMerger.this.model.isDecidedCoord());
        }
    }

    class KeepTheirCoordinatesAction
    extends AbstractAction
    implements Observer {
        public KeepTheirCoordinatesAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagkeeptheir"));
            this.putValue("ShortDescription", I18n.tr("Keep their coordinates", new Object[0]));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropertiesMerger.this.model.decideCoordsConflict(MergeDecisionType.KEEP_THEIR);
        }

        public void update(Observable observable, Object object) {
            this.setEnabled(PropertiesMerger.this.model.hasCoordConflict() && !PropertiesMerger.this.model.isDecidedCoord());
        }
    }

    class KeepMyCoordinatesAction
    extends AbstractAction
    implements Observer {
        public KeepMyCoordinatesAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs/conflict", "tagkeepmine"));
            this.putValue("ShortDescription", I18n.tr("Keep my coordinates", new Object[0]));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropertiesMerger.this.model.decideCoordsConflict(MergeDecisionType.KEEP_MINE);
        }

        public void update(Observable observable, Object object) {
            this.setEnabled(PropertiesMerger.this.model.hasCoordConflict() && !PropertiesMerger.this.model.isDecidedCoord());
        }
    }
}

