/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.ChangesetCacheEvent;
import org.openstreetmap.josm.data.osm.ChangesetCacheListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Storage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangesetListModel
extends DefaultListModel
implements ChangesetCacheListener {
    private final List<Changeset> data = new ArrayList<Changeset>();
    private final Storage<Changeset> shownChangesets = new Storage(true);
    private DefaultListSelectionModel selectionModel;

    public ChangesetListModel(DefaultListSelectionModel defaultListSelectionModel) {
        this.selectionModel = defaultListSelectionModel;
    }

    public Set<Changeset> getSelectedChangesets() {
        HashSet<Changeset> hashSet = new HashSet<Changeset>();
        for (int i = 0; i < this.getSize(); ++i) {
            if (!this.selectionModel.isSelectedIndex(i)) continue;
            hashSet.add(this.data.get(i));
        }
        return hashSet;
    }

    public Set<Integer> getSelectedChangesetIds() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < this.getSize(); ++i) {
            if (!this.selectionModel.isSelectedIndex(i)) continue;
            hashSet.add(this.data.get(i).getId());
        }
        return hashSet;
    }

    public void setSelectedChangesets(Collection<Changeset> collection) {
        this.selectionModel.clearSelection();
        if (collection == null) {
            return;
        }
        for (Changeset changeset : collection) {
            int n = this.data.indexOf(changeset);
            if (n < 0) continue;
            this.selectionModel.addSelectionInterval(n, n);
        }
    }

    protected void setChangesets(Collection<Changeset> collection) {
        this.shownChangesets.clear();
        if (collection != null) {
            this.shownChangesets.addAll(collection);
        }
        this.updateModel();
    }

    private void updateModel() {
        Set<Changeset> set = this.getSelectedChangesets();
        this.data.clear();
        this.data.addAll(this.shownChangesets);
        ChangesetCache changesetCache = ChangesetCache.getInstance();
        for (Changeset changeset : this.data) {
            if (!changesetCache.contains(changeset) || changesetCache.get(changeset.getId()) == changeset) continue;
            changeset.mergeFrom(changesetCache.get(changeset.getId()));
        }
        this.sort();
        this.fireIntervalAdded(this, 0, this.getSize());
        this.setSelectedChangesets(set);
    }

    public void initFromChangesetIds(Collection<Integer> collection) {
        if (collection == null || collection.isEmpty()) {
            this.setChangesets(null);
            return;
        }
        HashSet<Changeset> hashSet = new HashSet<Changeset>(collection.size());
        for (int n : collection) {
            if (n <= 0) continue;
            hashSet.add(new Changeset(n));
        }
        this.setChangesets(hashSet);
    }

    public void initFromPrimitives(Collection<? extends OsmPrimitive> collection) {
        if (collection == null) {
            this.setChangesets(null);
            return;
        }
        HashSet<Changeset> hashSet = new HashSet<Changeset>();
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive.getChangesetId() <= 0) continue;
            hashSet.add(new Changeset(osmPrimitive.getChangesetId()));
        }
        this.setChangesets(hashSet);
    }

    public void initFromDataSet(DataSet dataSet) {
        if (dataSet == null) {
            this.setChangesets(null);
            return;
        }
        HashSet<Changeset> hashSet = new HashSet<Changeset>();
        for (OsmPrimitive osmPrimitive : dataSet.allPrimitives()) {
            if (osmPrimitive.getChangesetId() <= 0) continue;
            hashSet.add(new Changeset(osmPrimitive.getChangesetId()));
        }
        this.setChangesets(hashSet);
    }

    @Override
    public Object getElementAt(int n) {
        return this.data.get(n);
    }

    @Override
    public int getSize() {
        return this.data.size();
    }

    protected void sort() {
        Collections.sort(this.data, new Comparator<Changeset>(){

            @Override
            public int compare(Changeset changeset, Changeset changeset2) {
                if (changeset.getId() > changeset2.getId()) {
                    return -1;
                }
                if (changeset.getId() == changeset2.getId()) {
                    return 0;
                }
                return 1;
            }
        });
    }

    public boolean hasSelectedOpenChangesets() {
        return !this.getSelectedOpenChangesets().isEmpty();
    }

    public List<Changeset> getSelectedOpenChangesets() {
        ArrayList<Changeset> arrayList = new ArrayList<Changeset>();
        for (int i = 0; i < this.getSize(); ++i) {
            Changeset changeset;
            if (!this.selectionModel.isSelectedIndex(i) || !(changeset = this.data.get(i)).isOpen()) continue;
            arrayList.add(changeset);
        }
        return arrayList;
    }

    @Override
    public void changesetCacheUpdated(ChangesetCacheEvent changesetCacheEvent) {
        int n;
        Set<Changeset> set = this.getSelectedChangesets();
        for (Changeset changeset : changesetCacheEvent.getAddedChangesets()) {
            n = this.data.indexOf(changeset);
            if (n < 0 || this.data.get(n) == changeset) continue;
            this.data.get(n).mergeFrom(changeset);
        }
        for (Changeset changeset : changesetCacheEvent.getUpdatedChangesets()) {
            n = this.data.indexOf(changeset);
            if (n < 0 || this.data.get(n) == changeset) continue;
            this.data.get(n).mergeFrom(changeset);
        }
        for (Changeset changeset : changesetCacheEvent.getRemovedChangesets()) {
            n = this.data.indexOf(changeset);
            if (n < 0) continue;
            this.data.set(n, new Changeset(changeset.getId()));
        }
        this.fireContentsChanged(this, 0, this.getSize());
        this.setSelectedChangesets(set);
    }
}

