/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class PreferenceDialog
extends JDialog {
    private PreferenceTabbedPane tpPreferences;
    private boolean canceled;

    protected JPanel buildActionPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add(new SideButton(new OKAction()));
        jPanel.add(new SideButton(new CancelAction()));
        jPanel.add(new SideButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Action/Preferences"))));
        return jPanel;
    }

    protected void build() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.tpPreferences = new PreferenceTabbedPane();
        container.add((Component)this.tpPreferences, "Center");
        this.tpPreferences.buildGui();
        this.tpPreferences.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        container.add((Component)this.buildActionPanel(), "South");
        this.addWindowListener(new WindowEventHandler());
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getRootPane().getActionMap().put("cancel", new CancelAction());
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Action/Preferences"));
    }

    public PreferenceDialog(Component component) {
        super((Window)JOptionPane.getFrameForComponent(component), I18n.tr("Preferences", new Object[0]), Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
        this.setMinimumSize(new Dimension(600, 350));
        this.setMaximumSize(Toolkit.getDefaultToolkit().getScreenSize());
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            Insets insets = this.getParent().getInsets();
            Dimension dimension = this.getParent().getSize();
            dimension = new Dimension(Math.min(dimension.width - insets.left - insets.right, 700), Math.min(dimension.height - insets.top - insets.bottom, 800));
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(this.getParent(), dimension)).applySafe(this);
        } else if (!bl && this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(bl);
    }

    void selectPreferencesTabByName(String string) {
        this.tpPreferences.selectTabByName(string);
    }

    public void selectMapPaintPreferenceTab() {
        this.tpPreferences.setSelectedComponent(this.tpPreferences.map);
        this.tpPreferences.mapcontent.setSelectedIndex(1);
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            new CancelAction().cancel();
        }
    }

    class OKAction
    extends AbstractAction {
        public OKAction() {
            this.putValue("Name", I18n.tr("OK", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
            this.putValue("ShortDescription", I18n.tr("Save the preferences and close the dialog", new Object[0]));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            for (PreferenceTabbedPane.ValidationListener validationListener : ((PreferenceDialog)PreferenceDialog.this).tpPreferences.validationListeners) {
                if (validationListener.validatePreferences()) continue;
                return;
            }
            PreferenceDialog.this.tpPreferences.savePreferences();
            ((PreferenceDialog)PreferenceDialog.this).tpPreferences.validationListeners.clear();
            PreferenceDialog.this.setCanceled(false);
            PreferenceDialog.this.setVisible(false);
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
            this.putValue("ShortDescription", I18n.tr("Close the preferences dialog and discard preference updates", new Object[0]));
        }

        public void cancel() {
            PreferenceDialog.this.setCanceled(true);
            PreferenceDialog.this.setVisible(false);
            ((PreferenceDialog)PreferenceDialog.this).tpPreferences.validationListeners.clear();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.cancel();
        }
    }
}

