/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.ChangesetDataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.data.osm.history.RelationMember;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmDataParsingException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class OsmChangesetContentParser {
    private InputSource source;
    private ChangesetDataSet data;

    public OsmChangesetContentParser(InputStream inputStream) throws UnsupportedEncodingException {
        CheckParameterUtil.ensureParameterNotNull(inputStream, "source");
        this.source = new InputSource(new InputStreamReader(inputStream, "UTF-8"));
        this.data = new ChangesetDataSet();
    }

    public OsmChangesetContentParser(String string) {
        CheckParameterUtil.ensureParameterNotNull(string, "source");
        this.source = new InputSource(new StringReader(string));
        this.data = new ChangesetDataSet();
    }

    public ChangesetDataSet parse(ProgressMonitor progressMonitor) throws OsmDataParsingException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            progressMonitor.beginTask("");
            progressMonitor.indeterminateSubTask(I18n.tr("Parsing changeset content ...", new Object[0]));
            SAXParserFactory.newInstance().newSAXParser().parse(this.source, (DefaultHandler)new Parser());
        }
        catch (OsmDataParsingException osmDataParsingException) {
            throw osmDataParsingException;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new OsmDataParsingException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new OsmDataParsingException(sAXException);
        }
        catch (IOException iOException) {
            throw new OsmDataParsingException(iOException);
        }
        finally {
            progressMonitor.finishTask();
        }
        return this.data;
    }

    public ChangesetDataSet parse() throws OsmDataParsingException {
        return this.parse(null);
    }

    private class Parser
    extends DefaultHandler {
        private HistoryOsmPrimitive currentPrimitive;
        private ChangesetDataSet.ChangesetModificationType currentModificationType;
        private Locator locator;

        private Parser() {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        protected void throwException(String string) throws OsmDataParsingException {
            throw new OsmDataParsingException(string).rememberLocation(this.locator);
        }

        protected void throwException(Exception exception) throws OsmDataParsingException {
            throw new OsmDataParsingException(exception).rememberLocation(this.locator);
        }

        protected long getMandatoryAttributeLong(Attributes attributes, String string) throws SAXException {
            String string2 = attributes.getValue(string);
            if (string2 == null) {
                this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", string));
            }
            Long l = 0L;
            try {
                l = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type long. Got ''{1}''.", string, string2));
            }
            if (l < 0L) {
                this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type long (>=0). Got ''{1}''.", string, string2));
            }
            return l;
        }

        protected Long getAttributeLong(Attributes attributes, String string) throws SAXException {
            String string2 = attributes.getValue(string);
            if (string2 == null) {
                return null;
            }
            Long l = null;
            try {
                l = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type long. Got ''{1}''.", string, string2));
            }
            if (l < 0L) {
                this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type long (>=0). Got ''{1}''.", string, string2));
            }
            return l;
        }

        protected Double getMandatoryAttributeDouble(Attributes attributes, String string) throws SAXException {
            String string2 = attributes.getValue(string);
            if (string2 == null) {
                this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", string));
            }
            double d = 0.0;
            try {
                d = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type double. Got ''{1}''.", string, string2));
            }
            return d;
        }

        protected String getMandatoryAttributeString(Attributes attributes, String string) throws SAXException {
            String string2 = attributes.getValue(string);
            if (string2 == null) {
                this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", string));
            }
            return string2;
        }

        protected boolean getMandatoryAttributeBoolean(Attributes attributes, String string) throws SAXException {
            String string2 = attributes.getValue(string);
            if (string2 == null) {
                this.throwException(I18n.tr("Missing mandatory attribute ''{0}''.", string));
            }
            if ("true".equals(string2)) {
                return true;
            }
            if ("false".equals(string2)) {
                return false;
            }
            this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type boolean. Got ''{1}''.", string, string2));
            return false;
        }

        protected HistoryOsmPrimitive createPrimitive(Attributes attributes, OsmPrimitiveType osmPrimitiveType) throws SAXException {
            long l = this.getMandatoryAttributeLong(attributes, "id");
            long l2 = this.getMandatoryAttributeLong(attributes, "version");
            long l3 = this.getMandatoryAttributeLong(attributes, "changeset");
            boolean bl = this.getMandatoryAttributeBoolean(attributes, "visible");
            Long l4 = this.getAttributeLong(attributes, "uid");
            String string = attributes.getValue("user");
            User user = string != null ? (l4 != null ? User.createOsmUser(l4, string) : User.createLocalUser(string)) : User.getAnonymous();
            String string2 = this.getMandatoryAttributeString(attributes, "timestamp");
            Date date = DateUtils.fromString(string2);
            HistoryOsmPrimitive historyOsmPrimitive = null;
            if (osmPrimitiveType.equals((Object)OsmPrimitiveType.NODE)) {
                double d = this.getMandatoryAttributeDouble(attributes, "lat");
                double d2 = this.getMandatoryAttributeDouble(attributes, "lon");
                historyOsmPrimitive = new HistoryNode(l, l2, bl, user, l3, date, new LatLon(d, d2));
            } else if (osmPrimitiveType.equals((Object)OsmPrimitiveType.WAY)) {
                historyOsmPrimitive = new HistoryWay(l, l2, bl, user, l3, date);
            }
            if (osmPrimitiveType.equals((Object)OsmPrimitiveType.RELATION)) {
                historyOsmPrimitive = new HistoryRelation(l, l2, bl, user, l3, date);
            }
            return historyOsmPrimitive;
        }

        protected void startNode(Attributes attributes) throws SAXException {
            this.currentPrimitive = this.createPrimitive(attributes, OsmPrimitiveType.NODE);
        }

        protected void startWay(Attributes attributes) throws SAXException {
            this.currentPrimitive = this.createPrimitive(attributes, OsmPrimitiveType.WAY);
        }

        protected void startRelation(Attributes attributes) throws SAXException {
            this.currentPrimitive = this.createPrimitive(attributes, OsmPrimitiveType.RELATION);
        }

        protected void handleTag(Attributes attributes) throws SAXException {
            String string = this.getMandatoryAttributeString(attributes, "k");
            String string2 = this.getMandatoryAttributeString(attributes, "v");
            this.currentPrimitive.put(string, string2);
        }

        protected void handleNodeReference(Attributes attributes) throws SAXException {
            long l = this.getMandatoryAttributeLong(attributes, "ref");
            ((HistoryWay)this.currentPrimitive).addNode(l);
        }

        protected void handleMember(Attributes attributes) throws SAXException {
            long l = this.getMandatoryAttributeLong(attributes, "ref");
            String string = this.getMandatoryAttributeString(attributes, "type");
            OsmPrimitiveType osmPrimitiveType = null;
            try {
                osmPrimitiveType = OsmPrimitiveType.fromApiTypeName(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.throwException(I18n.tr("Illegal value for mandatory attribute ''{0}'' of type OsmPrimitiveType. Got ''{1}''.", "type", string));
            }
            String string2 = this.getMandatoryAttributeString(attributes, "role");
            RelationMember relationMember = new RelationMember(string2, osmPrimitiveType, l);
            ((HistoryRelation)this.currentPrimitive).addMember(relationMember);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string3.equals("node")) {
                this.startNode(attributes);
            } else if (string3.equals("way")) {
                this.startWay(attributes);
            } else if (string3.equals("relation")) {
                this.startRelation(attributes);
            } else if (string3.equals("tag")) {
                this.handleTag(attributes);
            } else if (string3.equals("nd")) {
                this.handleNodeReference(attributes);
            } else if (string3.equals("member")) {
                this.handleMember(attributes);
            } else if (!string3.equals("osmChange")) {
                if (string3.equals("create")) {
                    this.currentModificationType = ChangesetDataSet.ChangesetModificationType.CREATED;
                } else if (string3.equals("modify")) {
                    this.currentModificationType = ChangesetDataSet.ChangesetModificationType.UPDATED;
                } else if (string3.equals("delete")) {
                    this.currentModificationType = ChangesetDataSet.ChangesetModificationType.DELETED;
                } else {
                    System.err.println(I18n.tr("Warning: unsupported start element ''{0}'' in changeset content at position ({1},{2}). Skipping.", string3, this.locator.getLineNumber(), this.locator.getColumnNumber()));
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string3.equals("node") || string3.equals("way") || string3.equals("relation")) {
                if (this.currentModificationType == null) {
                    this.throwException(I18n.tr("Illegal document structure. Found node, way, or relation outside of ''create'', ''modify'', or ''delete''.", new Object[0]));
                }
                OsmChangesetContentParser.this.data.put(this.currentPrimitive, this.currentModificationType);
            } else if (!string3.equals("osmChange")) {
                if (string3.equals("create")) {
                    this.currentModificationType = null;
                } else if (string3.equals("modify")) {
                    this.currentModificationType = null;
                } else if (string3.equals("delete")) {
                    this.currentModificationType = null;
                } else if (!(string3.equals("tag") || string3.equals("nd") || string3.equals("member"))) {
                    System.err.println(I18n.tr("Warning: unsupported end element ''{0}'' in changeset content at position ({1},{2}). Skipping.", string3, this.locator.getLineNumber(), this.locator.getColumnNumber()));
                }
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            this.throwException(sAXParseException);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.throwException(sAXParseException);
        }
    }
}

