/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor;

import java.util.Collection;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundingXYVisitor
extends AbstractVisitor {
    private ProjectionBounds bounds = null;

    @Override
    public void visit(Node node) {
        this.visit(node.getEastNorth());
    }

    @Override
    public void visit(Way way) {
        if (way.isIncomplete()) {
            return;
        }
        for (Node node : way.getNodes()) {
            this.visit(node);
        }
    }

    @Override
    public void visit(Relation relation) {
        for (RelationMember relationMember : relation.getMembers()) {
            if (relationMember.isRelation()) continue;
            relationMember.getMember().visit(this);
        }
    }

    public void visit(Bounds bounds) {
        if (bounds != null) {
            this.visit(bounds.getMin());
            this.visit(bounds.getMax());
        }
    }

    public void visit(ProjectionBounds projectionBounds) {
        if (projectionBounds != null) {
            this.visit(projectionBounds.getMin());
            this.visit(projectionBounds.getMax());
        }
    }

    public void visit(LatLon latLon) {
        if (latLon != null) {
            if (latLon instanceof CachedLatLon) {
                this.visit(((CachedLatLon)latLon).getEastNorth());
            } else {
                this.visit(Main.getProjection().latlon2eastNorth(latLon));
            }
        }
    }

    public void visit(EastNorth eastNorth) {
        if (eastNorth != null) {
            if (this.bounds == null) {
                this.bounds = new ProjectionBounds(eastNorth);
            } else {
                this.bounds.extend(eastNorth);
            }
        }
    }

    public boolean hasExtend() {
        return this.bounds != null && !this.bounds.getMin().equals(this.bounds.getMax());
    }

    public ProjectionBounds getBounds() {
        return this.bounds;
    }

    public void enlargeBoundingBox() {
        this.enlargeBoundingBox(Main.pref.getDouble("edit.zoom-enlarge-bbox", 0.002));
    }

    public void enlargeBoundingBox(double d) {
        if (this.bounds == null) {
            return;
        }
        LatLon latLon = Main.getProjection().eastNorth2latlon(this.bounds.getMin());
        LatLon latLon2 = Main.getProjection().eastNorth2latlon(this.bounds.getMax());
        this.bounds = new ProjectionBounds(Main.getProjection().latlon2eastNorth(new LatLon(latLon.lat() - d, latLon.lon() - d)), Main.getProjection().latlon2eastNorth(new LatLon(latLon2.lat() + d, latLon2.lon() + d)));
    }

    public String toString() {
        return "BoundingXYVisitor[" + this.bounds + "]";
    }

    public void computeBoundingBox(Collection<? extends OsmPrimitive> collection) {
        if (collection == null) {
            return;
        }
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive == null) continue;
            osmPrimitive.visit(this);
        }
    }
}

