/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Image;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPainter;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.MapImage;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinePatternElemStyle
extends ElemStyle {
    public MapImage<Image> pattern;

    public LinePatternElemStyle(Cascade cascade, MapImage<Image> mapImage) {
        super(cascade, -1.0f);
        this.pattern = mapImage;
    }

    public static LinePatternElemStyle create(Environment environment) {
        Cascade cascade = environment.mc.getCascade(environment.layer);
        MapPaintStyles.IconReference iconReference = cascade.get("pattern-image", null, MapPaintStyles.IconReference.class);
        if (iconReference == null) {
            return null;
        }
        ImageIcon imageIcon = MapPaintStyles.getIcon(iconReference, -1, -1);
        if (imageIcon == null) {
            return null;
        }
        MapImage<Image> mapImage = new MapImage<Image>(iconReference.iconName, iconReference.source);
        mapImage.img = imageIcon.getImage();
        return new LinePatternElemStyle(cascade, mapImage);
    }

    @Override
    public void paintPrimitive(OsmPrimitive osmPrimitive, MapPaintSettings mapPaintSettings, MapPainter mapPainter, boolean bl, boolean bl2) {
        Way way = (Way)osmPrimitive;
        mapPainter.drawLinePattern(way, (Image)this.pattern.img);
    }

    @Override
    public boolean isProperLineStyle() {
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        LinePatternElemStyle linePatternElemStyle = (LinePatternElemStyle)object;
        return this.pattern.equals(linePatternElemStyle.pattern);
    }

    @Override
    public int hashCode() {
        return this.pattern.hashCode();
    }

    @Override
    public String toString() {
        return "LinePatternElemStyle{" + super.toString() + "pattern=[" + this.pattern + "]}";
    }
}

