/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.gui.preferences.GPXSettingsPanel;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class DrawingPreference
implements PreferenceSetting {
    private GPXSettingsPanel gpxPanel;
    private JCheckBox directionHint = new JCheckBox(I18n.tr("Draw Direction Arrows", new Object[0]));
    private JCheckBox headArrow = new JCheckBox(I18n.tr("Only on the head of a way.", new Object[0]));
    private JCheckBox onewayArrow = new JCheckBox(I18n.tr("Draw oneway arrows.", new Object[0]));
    private JCheckBox segmentOrderNumber = new JCheckBox(I18n.tr("Draw segment order numbers", new Object[0]));
    private JCheckBox sourceBounds = new JCheckBox(I18n.tr("Draw boundaries of downloaded data", new Object[0]));
    private JCheckBox virtualNodes = new JCheckBox(I18n.tr("Draw virtual nodes in select mode", new Object[0]));
    private JCheckBox inactive = new JCheckBox(I18n.tr("Draw inactive layers in other color", new Object[0]));
    private JCheckBox useHighlighting = new JCheckBox(I18n.tr("Highlight target ways and nodes", new Object[0]));
    private JCheckBox drawHelperLine = new JCheckBox(I18n.tr("Draw rubber-band helper line", new Object[0]));
    private JCheckBox useAntialiasing = new JCheckBox(I18n.tr("Smooth map graphics (antialiasing)", new Object[0]));
    private JCheckBox outlineOnly = new JCheckBox(I18n.tr("Draw only outlines of areas", new Object[0]));

    public void addGui(PreferenceTabbedPane preferenceTabbedPane) {
        preferenceTabbedPane.display.setPreferredSize(new Dimension(400, 600));
        this.gpxPanel = new GPXSettingsPanel();
        preferenceTabbedPane.addValidationListener(this.gpxPanel);
        JPanel jPanel = this.gpxPanel;
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        preferenceTabbedPane.displaycontent.addTab(I18n.tr("GPS Points", new Object[0]), jScrollPane);
        jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.directionHint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DrawingPreference.this.directionHint.isSelected()) {
                    DrawingPreference.this.headArrow.setSelected(Main.pref.getBoolean("draw.segment.head_only", false));
                } else {
                    DrawingPreference.this.headArrow.setSelected(false);
                }
                DrawingPreference.this.headArrow.setEnabled(DrawingPreference.this.directionHint.isSelected());
            }
        });
        this.directionHint.setToolTipText(I18n.tr("Draw direction hints for way segments.", new Object[0]));
        this.directionHint.setSelected(Main.pref.getBoolean("draw.segment.direction", false));
        jPanel.add((Component)this.directionHint, GBC.eop().insets(20, 0, 0, 0));
        this.headArrow.setToolTipText(I18n.tr("Only on the head of a way.", new Object[0]));
        this.headArrow.setSelected(Main.pref.getBoolean("draw.segment.head_only", false));
        this.headArrow.setEnabled(this.directionHint.isSelected());
        jPanel.add((Component)this.headArrow, GBC.eop().insets(40, 0, 0, 0));
        this.onewayArrow.setToolTipText(I18n.tr("Draw arrows in the direction of oneways and other directed features.", new Object[0]));
        this.onewayArrow.setSelected(Main.pref.getBoolean("draw.oneway", true));
        jPanel.add((Component)this.onewayArrow, GBC.eop().insets(20, 0, 0, 0));
        this.segmentOrderNumber.setToolTipText(I18n.tr("Draw the order numbers of all segments within their way.", new Object[0]));
        this.segmentOrderNumber.setSelected(Main.pref.getBoolean("draw.segment.order_number", false));
        jPanel.add((Component)this.segmentOrderNumber, GBC.eop().insets(20, 0, 0, 0));
        this.sourceBounds.setToolTipText(I18n.tr("Draw the boundaries of data loaded from the server.", new Object[0]));
        this.sourceBounds.setSelected(Main.pref.getBoolean("draw.data.downloaded_area", true));
        jPanel.add((Component)this.sourceBounds, GBC.eop().insets(20, 0, 0, 0));
        this.virtualNodes.setToolTipText(I18n.tr("Draw virtual nodes in select mode for easy way modification.", new Object[0]));
        this.virtualNodes.setSelected(Main.pref.getInteger("mappaint.node.virtual-size", 8) != 0);
        jPanel.add((Component)this.virtualNodes, GBC.eop().insets(20, 0, 0, 0));
        this.inactive.setToolTipText(I18n.tr("Draw the inactive data layers in a different color.", new Object[0]));
        this.inactive.setSelected(Main.pref.getBoolean("draw.data.inactive_color", true));
        jPanel.add((Component)this.inactive, GBC.eop().insets(20, 0, 0, 0));
        this.useAntialiasing.setToolTipText(I18n.tr("Apply antialiasing to the map view resulting in a smoother appearance.", new Object[0]));
        this.useAntialiasing.setSelected(Main.pref.getBoolean("mappaint.use-antialiasing", true));
        this.useHighlighting.setToolTipText(I18n.tr("Hightlight target nodes and ways while drawing or selecting", new Object[0]));
        this.useHighlighting.setSelected(Main.pref.getBoolean("draw.target-highlight", true));
        this.drawHelperLine.setToolTipText(I18n.tr("Draw rubber-band helper line", new Object[0]));
        this.drawHelperLine.setSelected(Main.pref.getBoolean("draw.helper-line", true));
        jPanel.add((Component)this.drawHelperLine, GBC.eop().insets(20, 0, 0, 0));
        this.outlineOnly.setSelected(Main.pref.getBoolean("draw.data.area_outline_only", false));
        this.outlineOnly.setToolTipText(I18n.tr("This option suppresses the filling of areas, overriding anything specified in the selected style.", new Object[0]));
        JLabel jLabel = new JLabel(I18n.tr("Options that affect drawing performance", new Object[0]));
        jPanel.add((Component)jLabel, GBC.eop().insets(5, 10, 0, 0));
        jPanel.add((Component)this.useAntialiasing, GBC.eop().insets(20, 5, 0, 0));
        jPanel.add((Component)this.useHighlighting, GBC.eop().insets(20, 0, 0, 0));
        jPanel.add((Component)this.outlineOnly, GBC.eol().insets(20, 0, 0, 5));
        ExpertToggleAction.addVisibilitySwitcher(jLabel);
        ExpertToggleAction.addVisibilitySwitcher(this.useAntialiasing);
        ExpertToggleAction.addVisibilitySwitcher(this.useHighlighting);
        ExpertToggleAction.addVisibilitySwitcher(this.outlineOnly);
        jPanel.add(Box.createVerticalGlue(), GBC.eol().fill(1));
        jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        preferenceTabbedPane.displaycontent.addTab(I18n.tr("OSM Data", new Object[0]), jScrollPane);
    }

    public boolean ok() {
        this.gpxPanel.savePreferences();
        Main.pref.put("draw.data.area_outline_only", this.outlineOnly.isSelected());
        Main.pref.put("draw.segment.direction", this.directionHint.isSelected());
        Main.pref.put("draw.segment.head_only", this.headArrow.isSelected());
        Main.pref.put("draw.oneway", this.onewayArrow.isSelected());
        Main.pref.put("draw.segment.order_number", this.segmentOrderNumber.isSelected());
        Main.pref.put("draw.data.downloaded_area", this.sourceBounds.isSelected());
        Main.pref.put("draw.data.inactive_color", this.inactive.isSelected());
        Main.pref.put("mappaint.use-antialiasing", this.useAntialiasing.isSelected());
        Main.pref.put("draw.target-highlight", this.useHighlighting.isSelected());
        Main.pref.put("draw.helper-line", this.drawHelperLine.isSelected());
        int n = Main.pref.getInteger("mappaint.node.virtual-size", 8);
        if (this.virtualNodes.isSelected()) {
            if (n < 1) {
                n = 8;
            }
        } else {
            n = 0;
        }
        Main.pref.putInteger("mappaint.node.virtual-size", n);
        return false;
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new DrawingPreference();
        }
    }
}

