/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.nio.ByteBuffer;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ShowStatusReportAction;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.Base64;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.UrlLabel;
import org.openstreetmap.josm.tools.Utils;

public final class BugReportExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static boolean handlingInProgress = false;
    private static int exceptionCounter = 0;
    private static boolean suppressExceptionDialogs = false;

    public void uncaughtException(Thread thread, Throwable throwable) {
        BugReportExceptionHandler.handleException(throwable);
    }

    public void handle(Throwable throwable) {
        BugReportExceptionHandler.handleException(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleException(final Throwable throwable) {
        if (handlingInProgress) {
            return;
        }
        if (suppressExceptionDialogs) {
            return;
        }
        handlingInProgress = true;
        ++exceptionCounter;
        try {
            throwable.printStackTrace();
            if (Main.parent != null) {
                if (throwable instanceof OutOfMemoryError) {
                    JOptionPane.showMessageDialog(Main.parent, "JOSM is out of memory. Strange things may happen.\nPlease restart JOSM with the -Xmx###M option,\nwhere ### is the number of MB assigned to JOSM (e.g. 256).\nCurrently, " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + " MB are available to JOSM.", "Error", 0);
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PluginHandler.disablePluginAfterException(throwable);
                        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Unexpected Exception", new Object[0]), new String[]{I18n.tr("Do nothing", new Object[0]), I18n.tr("Report Bug", new Object[0])});
                        extendedDialog.setIcon(0);
                        JPanel jPanel = new JPanel(new GridBagLayout());
                        jPanel.add((Component)new JLabel("<html>" + I18n.tr("An unexpected exception occurred.<br>This is always a coding error. If you are running the latest<br>version of JOSM, please consider being kind and file a bug report.", new Object[0]) + "</html>"), GBC.eol());
                        JCheckBox jCheckBox = null;
                        if (exceptionCounter > 1) {
                            jCheckBox = new JCheckBox(I18n.tr("Suppress further error dialogs for this session.", new Object[0]));
                            jPanel.add((Component)jCheckBox, GBC.eol());
                        }
                        extendedDialog.setContent(jPanel);
                        extendedDialog.showDialog();
                        if (jCheckBox != null && jCheckBox.isSelected()) {
                            suppressExceptionDialogs = true;
                        }
                        if (extendedDialog.getValue() != 2) {
                            return;
                        }
                        try {
                            StringWriter stringWriter = new StringWriter();
                            throwable.printStackTrace(new PrintWriter(stringWriter));
                            String string = ShowStatusReportAction.getReportHeader() + stringWriter.getBuffer().toString();
                            String string2 = string.replaceAll("\r", "");
                            if (string2.length() > 6000) {
                                int n = (string2 = string2.substring(0, 6000)).lastIndexOf("\n");
                                if (6000 - n < 200) {
                                    string2 = string2.substring(0, n + 1);
                                }
                                string2 = string2 + "...<snip>...\n";
                            }
                            URL uRL = new URL("http://josm.openstreetmap.de/josmticket?tdata=" + Base64.encode(ByteBuffer.wrap(string2.getBytes("UTF8")), true));
                            JPanel jPanel2 = new JPanel(new GridBagLayout());
                            jPanel2.add((Component)new JMultilineLabel(I18n.tr("You have encountered an error in JOSM. Before you file a bug report make sure you have updated to the latest version of JOSM here:", new Object[0])), GBC.eol());
                            jPanel2.add((Component)new UrlLabel("http://josm.openstreetmap.de/#Download"), GBC.eop().insets(8, 0, 0, 0));
                            jPanel2.add((Component)new JMultilineLabel(I18n.tr("You should also update your plugins. If neither of those help please file a bug report in our bugtracker using this link:", new Object[0])), GBC.eol());
                            jPanel2.add((Component)new UrlLabel(uRL.toString(), "http://josm.openstreetmap.de/josmticket?..."), GBC.eop().insets(8, 0, 0, 0));
                            jPanel2.add((Component)new JMultilineLabel(I18n.tr("There the error information provided below should already be filled in for you. Please include information on how to reproduce the error and try to supply as much detail as possible.", new Object[0])), GBC.eop());
                            jPanel2.add((Component)new JMultilineLabel(I18n.tr("Alternatively, if that does not work you can manually fill in the information below at this URL:", new Object[0])), GBC.eol());
                            jPanel2.add((Component)new UrlLabel("http://josm.openstreetmap.de/newticket"), GBC.eop().insets(8, 0, 0, 0));
                            if (Utils.copyToClipboard(string)) {
                                jPanel2.add((Component)new JLabel(I18n.tr("(The text has already been copied to your clipboard.)", new Object[0])), GBC.eop());
                            }
                            JTextArea jTextArea = new JTextArea(string, 20, 60);
                            jTextArea.setCaretPosition(0);
                            jTextArea.setEditable(false);
                            jPanel2.add((Component)new JScrollPane(jTextArea), GBC.eop());
                            for (Component component : jPanel2.getComponents()) {
                                if (!(component instanceof JMultilineLabel)) continue;
                                ((JMultilineLabel)component).setMaxWidth(400);
                            }
                            JOptionPane.showMessageDialog(Main.parent, jPanel2, I18n.tr("You have encountered a bug in JOSM", new Object[0]), 0);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
            }
        }
        finally {
            handlingInProgress = false;
        }
    }

    public static boolean exceptionHandlingInProgress() {
        return handlingInProgress;
    }
}

