/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import com.kitfox.svg.SVGDiagram;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ImageProvider;

class ImageResource {
    private HashMap<Dimension, ImageWrapper> imgCache = new HashMap();
    private SVGDiagram svg;
    public static final Dimension DEFAULT_DIMENSION = new Dimension(-1, -1);

    public ImageResource(Image image, boolean bl) {
        CheckParameterUtil.ensureParameterNotNull(image);
        this.imgCache.put(DEFAULT_DIMENSION, new ImageWrapper(image, bl));
    }

    public ImageResource(SVGDiagram sVGDiagram) {
        CheckParameterUtil.ensureParameterNotNull(sVGDiagram);
        this.svg = sVGDiagram;
    }

    public ImageIcon getImageIcon() {
        return this.getImageIcon(DEFAULT_DIMENSION, ImageProvider.SanitizeMode.OFF);
    }

    public ImageIcon getImageIcon(Dimension dimension, ImageProvider.SanitizeMode sanitizeMode) {
        if (dimension.width < -1 || dimension.width == 0 || dimension.height < -1 || dimension.height == 0) {
            throw new IllegalArgumentException();
        }
        ImageWrapper imageWrapper = this.imgCache.get(dimension);
        if (imageWrapper != null) {
            if (!imageWrapper.sanitized && (sanitizeMode == ImageProvider.SanitizeMode.ALWAYS || sanitizeMode == ImageProvider.SanitizeMode.MAKE_BUFFEREDIMAGE && !(imageWrapper.img instanceof BufferedImage))) {
                imageWrapper.img = ImageProvider.sanitize(imageWrapper.img);
                imageWrapper.sanitized = true;
            }
            return new ImageIcon(imageWrapper.img);
        }
        if (this.svg != null) {
            Image image = ImageProvider.createImageFromSvg(this.svg, dimension);
            this.imgCache.put(dimension, new ImageWrapper(image, true));
            return new ImageIcon(image);
        }
        ImageWrapper imageWrapper2 = this.imgCache.get(DEFAULT_DIMENSION);
        if (imageWrapper2 == null) {
            throw new AssertionError();
        }
        int n = dimension.width;
        int n2 = dimension.height;
        ImageIcon imageIcon = new ImageIcon(imageWrapper2.img);
        if (n == -1) {
            n = imageIcon.getIconWidth() * n2 / imageIcon.getIconHeight();
        } else if (n2 == -1) {
            n2 = imageIcon.getIconHeight() * n / imageIcon.getIconWidth();
        }
        Image image = imageIcon.getImage().getScaledInstance(n, n2, 4);
        boolean bl = false;
        if (sanitizeMode == ImageProvider.SanitizeMode.ALWAYS || sanitizeMode == ImageProvider.SanitizeMode.MAKE_BUFFEREDIMAGE && !(image instanceof BufferedImage)) {
            image = ImageProvider.sanitize(image);
            bl = true;
        }
        this.imgCache.put(dimension, new ImageWrapper(image, bl));
        return new ImageIcon(image);
    }

    public ImageIcon getImageIconBounded(Dimension dimension, ImageProvider.SanitizeMode sanitizeMode) {
        float f;
        float f2;
        if (dimension.width < -1 || dimension.width == 0 || dimension.height < -1 || dimension.height == 0) {
            throw new IllegalArgumentException();
        }
        if (this.svg != null) {
            f2 = this.svg.getWidth();
            f = this.svg.getHeight();
        } else {
            ImageWrapper imageWrapper = this.imgCache.get(DEFAULT_DIMENSION);
            if (imageWrapper == null) {
                throw new AssertionError();
            }
            ImageIcon imageIcon = new ImageIcon(imageWrapper.img);
            f2 = imageIcon.getIconWidth();
            f = imageIcon.getIconHeight();
        }
        int n = dimension.width;
        int n2 = dimension.height;
        if (f2 <= (float)n) {
            n = -1;
        }
        if (f <= (float)n2) {
            n2 = -1;
        }
        if (n == -1 && n2 == -1) {
            return this.getImageIcon(DEFAULT_DIMENSION, sanitizeMode);
        }
        if (n == -1) {
            return this.getImageIcon(new Dimension(-1, n2), sanitizeMode);
        }
        if (n2 == -1) {
            return this.getImageIcon(new Dimension(n, -1), sanitizeMode);
        }
        if (f2 / (float)n > f / (float)n2) {
            return this.getImageIcon(new Dimension(n, -1), sanitizeMode);
        }
        return this.getImageIcon(new Dimension(-1, n2), sanitizeMode);
    }

    private static class ImageWrapper {
        Image img;
        boolean sanitized;

        public ImageWrapper(Image image, boolean bl) {
            CheckParameterUtil.ensureParameterNotNull(image);
            this.img = image;
            this.sanitized = bl;
        }
    }
}

