/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.preferences.TaggingPresetPreference;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;

public class TaggingPresetNameTemplateList {
    private static TaggingPresetNameTemplateList instance;
    private final List<TaggingPreset> presetsWithPattern = new ArrayList<TaggingPreset>();

    public static TaggingPresetNameTemplateList getInstance() {
        if (instance == null) {
            instance = new TaggingPresetNameTemplateList();
        }
        return instance;
    }

    private TaggingPresetNameTemplateList() {
        if (TaggingPresetPreference.taggingPresets != null) {
            for (TaggingPreset taggingPreset : TaggingPresetPreference.taggingPresets) {
                if (taggingPreset.nameTemplate == null) continue;
                this.presetsWithPattern.add(taggingPreset);
            }
        }
    }

    public TaggingPreset findPresetTemplate(OsmPrimitive osmPrimitive) {
        TaggingPreset.PresetType presetType;
        switch (osmPrimitive.getType()) {
            case NODE: {
                presetType = TaggingPreset.PresetType.NODE;
                break;
            }
            case WAY: {
                if (((Way)osmPrimitive).isClosed()) {
                    presetType = TaggingPreset.PresetType.CLOSEDWAY;
                    break;
                }
                presetType = TaggingPreset.PresetType.WAY;
                break;
            }
            case RELATION: {
                presetType = TaggingPreset.PresetType.RELATION;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        for (TaggingPreset taggingPreset : this.presetsWithPattern) {
            if (taggingPreset.types != null && !taggingPreset.types.contains((Object)presetType) && (presetType != TaggingPreset.PresetType.CLOSEDWAY || !taggingPreset.types.contains((Object)TaggingPreset.PresetType.WAY))) continue;
            int n = 0;
            if (taggingPreset.nameTemplateFilter != null) {
                if (!taggingPreset.nameTemplateFilter.match(osmPrimitive)) continue;
                return taggingPreset;
            }
            for (TaggingPreset.Item item : taggingPreset.data) {
                String string;
                if (item instanceof TaggingPreset.Key) {
                    string = ((TaggingPreset.Key)item).value;
                    String string2 = ((TaggingPreset.Key)item).key;
                    if (string != null && string.equals(osmPrimitive.get(string2))) {
                        ++n;
                        continue;
                    }
                    n -= 100;
                    continue;
                }
                string = null;
                if (item instanceof TaggingPreset.Text && ((TaggingPreset.Text)item).required) {
                    string = ((TaggingPreset.Text)item).key;
                } else if (item instanceof TaggingPreset.Combo && ((TaggingPreset.Combo)item).required) {
                    string = ((TaggingPreset.Combo)item).key;
                } else if (item instanceof TaggingPreset.Check && ((TaggingPreset.Check)item).required) {
                    string = ((TaggingPreset.Check)item).key;
                }
                if (string == null) continue;
                if (osmPrimitive.get(string) != null) {
                    ++n;
                    continue;
                }
                n -= 100;
            }
            if (n <= 0) continue;
            return taggingPreset;
        }
        return null;
    }
}

