/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.dialogs.LatLonDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MoveNodeAction
extends JosmAction {
    public MoveNodeAction() {
        super(I18n.tr("Move Node...", new Object[0]), "movenode", I18n.tr("Edit latitude and longitude of a node.", new Object[0]), null, true);
        this.putValue("help", HelpUtil.ht("/Action/MoveNode"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled() || MoveNodeAction.getCurrentDataSet().getSelectedNodes().size() != 1) {
            return;
        }
        LatLonDialog latLonDialog = new LatLonDialog(Main.parent, I18n.tr("Move Node...", new Object[0]), HelpUtil.ht("/Action/MoveNode"));
        Node node = (Node)MoveNodeAction.getCurrentDataSet().getSelectedNodes().toArray()[0];
        latLonDialog.setCoordinates(node.getCoor());
        latLonDialog.showDialog();
        if (latLonDialog.getValue() != 1) {
            return;
        }
        LatLon latLon = latLonDialog.getCoordinates();
        if (latLon == null) {
            return;
        }
        Main.main.undoRedo.add(new MoveCommand(node, latLon));
        Main.map.mapView.repaint();
    }

    @Override
    protected void updateEnabledState() {
        if (MoveNodeAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(MoveNodeAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        if (collection == null || collection.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        if (collection.size() == 1 && collection.toArray()[0] instanceof Node) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }
}

