/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preferences {
    private File preferencesDirFile = null;
    private File cacheDirFile = null;
    protected final SortedMap<String, String> properties = new TreeMap<String, String>();
    protected final SortedMap<String, String> defaults = new TreeMap<String, String>();
    protected final SortedMap<String, String> colornames = new TreeMap<String, String>();
    protected final SortedMap<String, List<String>> collectionProperties = new TreeMap<String, List<String>>();
    protected final SortedMap<String, List<String>> collectionDefaults = new TreeMap<String, List<String>>();
    protected final SortedMap<String, List<List<String>>> arrayProperties = new TreeMap<String, List<List<String>>>();
    protected final SortedMap<String, List<List<String>>> arrayDefaults = new TreeMap<String, List<List<String>>>();
    protected final SortedMap<String, List<Map<String, String>>> listOfStructsProperties = new TreeMap<String, List<Map<String, String>>>();
    protected final SortedMap<String, List<Map<String, String>>> listOfStructsDefaults = new TreeMap<String, List<Map<String, String>>>();
    private final CopyOnWriteArrayList<PreferenceChangedListener> listeners = new CopyOnWriteArrayList();
    private static final String[] DEFAULT_PLUGIN_SITE = new String[]{"http://josm.openstreetmap.de/plugin%<?plugins=>"};
    protected XMLStreamReader parser;

    public void addPreferenceChangeListener(PreferenceChangedListener preferenceChangedListener) {
        if (preferenceChangedListener != null) {
            this.listeners.addIfAbsent(preferenceChangedListener);
        }
    }

    public void removePreferenceChangeListener(PreferenceChangedListener preferenceChangedListener) {
        this.listeners.remove(preferenceChangedListener);
    }

    protected <T> void firePreferenceChanged(String string, Setting<T> setting, Setting<T> setting2) {
        DefaultPreferenceChangeEvent<T> defaultPreferenceChangeEvent = new DefaultPreferenceChangeEvent<T>(string, setting, setting2);
        for (PreferenceChangedListener preferenceChangedListener : this.listeners) {
            preferenceChangedListener.preferenceChanged(defaultPreferenceChangeEvent);
        }
    }

    public String getPreferencesDir() {
        String string = this.getPreferencesDirFile().getPath();
        if (string.endsWith(File.separator)) {
            return string;
        }
        return string + File.separator;
    }

    public File getPreferencesDirFile() {
        if (this.preferencesDirFile != null) {
            return this.preferencesDirFile;
        }
        String string = System.getProperty("josm.home");
        this.preferencesDirFile = string != null ? new File(string).getAbsoluteFile() : ((string = System.getenv("APPDATA")) != null ? new File(string, "JOSM") : new File(System.getProperty("user.home"), ".josm"));
        return this.preferencesDirFile;
    }

    public File getPreferenceFile() {
        return new File(this.getPreferencesDirFile(), "preferences.xml");
    }

    public File getOldPreferenceFile() {
        return new File(this.getPreferencesDirFile(), "preferences");
    }

    public File getPluginsDirectory() {
        return new File(this.getPreferencesDirFile(), "plugins");
    }

    public File getCacheDirectory() {
        if (this.cacheDirFile != null) {
            return this.cacheDirFile;
        }
        String string = System.getProperty("josm.cache");
        this.cacheDirFile = string != null ? new File(string).getAbsoluteFile() : ((string = Main.pref.get("cache.folder", null)) != null ? new File(string) : new File(this.getPreferencesDirFile(), "cache"));
        if (!this.cacheDirFile.exists() && !this.cacheDirFile.mkdirs()) {
            System.err.println(I18n.tr("Warning: Failed to create missing cache directory: {0}", this.cacheDirFile.getAbsoluteFile()));
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to create missing cache directory: {0}</html>", this.cacheDirFile.getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
        }
        return this.cacheDirFile;
    }

    public Collection<String> getAllPossiblePreferenceDirs() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(Main.pref.getPreferencesDir());
        String string = System.getenv("JOSM_RESOURCES");
        if (string != null) {
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            linkedList.add(string);
        }
        if ((string = System.getProperty("josm.resources")) != null) {
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            linkedList.add(string);
        }
        String string2 = System.getenv("APPDATA");
        if (System.getenv("ALLUSERSPROFILE") != null && string2 != null && string2.lastIndexOf(File.separator) != -1) {
            string2 = string2.substring(string2.lastIndexOf(File.separator));
            linkedList.add(new File(new File(System.getenv("ALLUSERSPROFILE"), string2), "JOSM").getPath());
        }
        linkedList.add("/usr/local/share/josm/");
        linkedList.add("/usr/local/lib/josm/");
        linkedList.add("/usr/share/josm/");
        linkedList.add("/usr/lib/josm/");
        return linkedList;
    }

    public synchronized String get(String string) {
        this.putDefault(string, null);
        if (!this.properties.containsKey(string)) {
            return "";
        }
        return (String)this.properties.get(string);
    }

    public synchronized String get(String string, String string2) {
        this.putDefault(string, string2);
        String string3 = (String)this.properties.get(string);
        if (string3 == null || string3.equals("")) {
            return string2;
        }
        return string3;
    }

    public synchronized Map<String, String> getAllPrefix(String string) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (!entry.getKey().startsWith(string)) continue;
            treeMap.put(entry.getKey(), entry.getValue());
        }
        return treeMap;
    }

    public synchronized List<String> getAllPrefixCollectionKeys(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string2 : this.collectionProperties.keySet()) {
            if (!string2.startsWith(string)) continue;
            linkedList.add(string2);
        }
        return linkedList;
    }

    private synchronized Map<String, String> getAllPrefixDefault(String string) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : this.defaults.entrySet()) {
            if (!entry.getKey().startsWith(string)) continue;
            treeMap.put(entry.getKey(), entry.getValue());
        }
        return treeMap;
    }

    public synchronized TreeMap<String, String> getAllColors() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : this.defaults.entrySet()) {
            if (!entry.getKey().startsWith("color.") || entry.getValue() == null) continue;
            treeMap.put(entry.getKey().substring(6), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (!entry.getKey().startsWith("color.")) continue;
            treeMap.put(entry.getKey().substring(6), entry.getValue());
        }
        return treeMap;
    }

    public synchronized Map<String, String> getDefaults() {
        return this.defaults;
    }

    public synchronized void putDefault(String string, String string2) {
        if (!this.defaults.containsKey(string) || this.defaults.get(string) == null) {
            this.defaults.put(string, string2);
        } else if (string2 != null && !((String)this.defaults.get(string)).equals(string2)) {
            System.out.println("Defaults for " + string + " differ: " + string2 + " != " + (String)this.defaults.get(string));
        }
    }

    public synchronized boolean getBoolean(String string) {
        this.putDefault(string, null);
        return this.properties.containsKey(string) ? Boolean.parseBoolean((String)this.properties.get(string)) : false;
    }

    public synchronized boolean getBoolean(String string, boolean bl) {
        this.putDefault(string, Boolean.toString(bl));
        return this.properties.containsKey(string) ? Boolean.parseBoolean((String)this.properties.get(string)) : bl;
    }

    public synchronized boolean getBoolean(String string, String string2, boolean bl) {
        this.putDefault(string, Boolean.toString(bl));
        String string3 = string + "." + string2;
        if (this.properties.containsKey(string3)) {
            return Boolean.parseBoolean((String)this.properties.get(string3));
        }
        return this.properties.containsKey(string) ? Boolean.parseBoolean((String)this.properties.get(string)) : bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(String string, String string2) {
        boolean bl = false;
        String string3 = null;
        Preferences preferences = this;
        synchronized (preferences) {
            boolean bl2;
            string3 = (String)this.properties.get(string);
            if (string2 != null && string2.length() == 0) {
                string2 = null;
            }
            boolean bl3 = string3 != null && string3.equals(string2);
            boolean bl4 = bl2 = string3 == null && (string2 == null || string2.equals(this.defaults.get(string)));
            if (!bl3 && !bl2) {
                if (string2 == null) {
                    this.properties.remove(string);
                } else {
                    this.properties.put(string, string2);
                }
                try {
                    this.save();
                }
                catch (IOException iOException) {
                    System.out.println(I18n.tr("Warning: failed to persist preferences to ''{0}''", this.getPreferenceFile().getAbsoluteFile()));
                }
                bl = true;
            }
        }
        if (bl) {
            this.firePreferenceChanged(string, new StringSetting(string3), new StringSetting(string2));
        }
        return bl;
    }

    public boolean put(String string, boolean bl) {
        return this.put(string, Boolean.toString(bl));
    }

    public boolean putInteger(String string, Integer n) {
        return this.put(string, Integer.toString(n));
    }

    public boolean putDouble(String string, Double d) {
        return this.put(string, Double.toString(d));
    }

    public boolean putLong(String string, Long l) {
        return this.put(string, Long.toString(l));
    }

    public void save() throws IOException {
        this.putInteger("josm.version", Version.getInstance().getVersion());
        this.updateSystemProperties();
        if (Main.applet) {
            return;
        }
        File file = this.getPreferenceFile();
        File file2 = new File(file + "_backup");
        if (file.exists()) {
            Preferences.copyFile(file, file2);
        }
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file + "_tmp"), "utf-8"), false);
        printWriter.print(this.toXML(false));
        printWriter.close();
        File file3 = new File(file + "_tmp");
        Preferences.copyFile(file3, file);
        file3.delete();
        this.setCorrectPermissions(file);
        this.setCorrectPermissions(file2);
    }

    private void setCorrectPermissions(File file) {
        file.setReadable(false, false);
        file.setWritable(false, false);
        file.setExecutable(false, false);
        file.setReadable(true, true);
        file.setWritable(true, true);
    }

    public static void copyFile(File file, File file2) throws IOException {
        FileChannel fileChannel = new FileInputStream(file).getChannel();
        FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
        try {
            fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (fileChannel != null) {
                fileChannel.close();
            }
            if (fileChannel2 != null) {
                fileChannel2.close();
            }
        }
    }

    public void loadOld() throws Exception {
        this.load(true);
    }

    public void load() throws Exception {
        this.load(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(boolean bl) throws Exception {
        Object object;
        this.properties.clear();
        if (!Main.applet) {
            object = bl ? this.getOldPreferenceFile() : this.getPreferenceFile();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((File)object), "utf-8"));
            try {
                if (bl) {
                    bufferedReader.mark(1);
                    int n = bufferedReader.read();
                    bufferedReader.reset();
                    if (n == 60) {
                        this.validateXML(bufferedReader);
                        Utils.close(bufferedReader);
                        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((File)object), "utf-8"));
                        this.fromXML(bufferedReader);
                    } else {
                        int n2 = 0;
                        ArrayList<Integer> arrayList = new ArrayList<Integer>();
                        String string = bufferedReader.readLine();
                        while (string != null) {
                            int n3 = string.indexOf(61);
                            if (n3 == -1 || n3 == 0) {
                                arrayList.add(n2);
                            } else {
                                String string2 = string.substring(0, n3);
                                String string3 = string.substring(n3 + 1);
                                if (!string3.isEmpty()) {
                                    this.properties.put(string2, string3);
                                }
                            }
                            string = bufferedReader.readLine();
                            ++n2;
                        }
                        if (!arrayList.isEmpty()) {
                            throw new IOException(I18n.tr("Malformed config file at lines {0}", arrayList));
                        }
                    }
                } else {
                    this.validateXML(bufferedReader);
                    Utils.close(bufferedReader);
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((File)object), "utf-8"));
                    this.fromXML(bufferedReader);
                }
            }
            finally {
                bufferedReader.close();
            }
        }
        this.updateSystemProperties();
        if (!this.properties.containsKey("expert")) {
            try {
                object = this.get("josm.version");
                if (((String)object).isEmpty() || Integer.parseInt((String)object) <= 4511) {
                    this.properties.put("expert", "true");
                }
            }
            catch (Exception exception) {
                this.properties.put("expert", "true");
            }
        }
        this.removeObsolete();
    }

    public void init(boolean bl) {
        File file;
        File file2;
        block18: {
            if (Main.applet) {
                return;
            }
            file2 = this.getPreferencesDirFile();
            if (file2.exists()) {
                if (!file2.isDirectory()) {
                    System.err.println(I18n.tr("Warning: Failed to initialize preferences. Preference directory ''{0}'' is not a directory.", file2.getAbsoluteFile()));
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to initialize preferences.<br>Preference directory ''{0}'' is not a directory.</html>", file2.getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
                    return;
                }
            } else if (!file2.mkdirs()) {
                System.err.println(I18n.tr("Warning: Failed to initialize preferences. Failed to create missing preference directory: {0}", file2.getAbsoluteFile()));
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to initialize preferences.<br>Failed to create missing preference directory: {0}</html>", file2.getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
                return;
            }
            file = this.getPreferenceFile();
            try {
                if (!file.exists()) {
                    File file3 = this.getOldPreferenceFile();
                    if (!file3.exists()) {
                        System.out.println(I18n.tr("Info: Missing preference file ''{0}''. Creating a default preference file.", file.getAbsoluteFile()));
                        this.resetToDefault();
                        this.save();
                        break block18;
                    }
                    try {
                        this.loadOld();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        File file4 = new File(file2, "preferences.bak");
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Preferences file had errors.<br> Making backup of old one to <br>{0}<br> and creating a new default preference file.</html>", file4.getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
                        Main.platform.rename(file3, file4);
                        try {
                            this.resetToDefault();
                            this.save();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            System.err.println(I18n.tr("Warning: Failed to initialize preferences. Failed to reset preference file to default: {0}", this.getPreferenceFile()));
                        }
                    }
                    return;
                }
                if (bl) {
                    System.out.println(I18n.tr("Warning: Replacing existing preference file ''{0}'' with default preference file.", file.getAbsoluteFile()));
                    this.resetToDefault();
                    this.save();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to initialize preferences.<br>Failed to reset preference file to default: {0}</html>", this.getPreferenceFile().getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
                return;
            }
        }
        try {
            this.load();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            File file5 = new File(file2, "preferences.xml.bak");
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Preferences file had errors.<br> Making backup of old one to <br>{0}<br> and creating a new default preference file.</html>", file5.getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
            Main.platform.rename(file, file5);
            try {
                this.resetToDefault();
                this.save();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.err.println(I18n.tr("Warning: Failed to initialize preferences. Failed to reset preference file to default: {0}", this.getPreferenceFile()));
            }
        }
    }

    public final void resetToDefault() {
        this.properties.clear();
    }

    public synchronized Color getColor(String string, Color color) {
        return this.getColor(string, null, color);
    }

    public synchronized Color getUIColor(String string) {
        return UIManager.getColor(string);
    }

    public synchronized String getColorName(String string) {
        try {
            Matcher matcher = Pattern.compile("mappaint\\.(.+?)\\.(.+)").matcher(string);
            matcher.matches();
            return I18n.tr("Paint style {0}: {1}", I18n.tr(matcher.group(1), new Object[0]), I18n.tr(matcher.group(2), new Object[0]));
        }
        catch (Exception exception) {
            try {
                Matcher matcher = Pattern.compile("layer (.+)").matcher(string);
                matcher.matches();
                return I18n.tr("Layer: {0}", I18n.tr(matcher.group(1), new Object[0]));
            }
            catch (Exception exception2) {
                return I18n.tr(this.colornames.containsKey(string) ? (String)this.colornames.get(string) : string, new Object[0]);
            }
        }
    }

    public Color getColor(ColorKey colorKey) {
        return this.getColor(colorKey.getColorName(), colorKey.getSpecialName(), colorKey.getDefault());
    }

    public synchronized Color getColor(String string, String string2, Color color) {
        String string3;
        String string4 = string.toLowerCase().replaceAll("[^a-z0-9]+", ".");
        if (!string4.equals(string)) {
            this.colornames.put(string4, string);
        }
        this.putDefault("color." + string4, ColorHelper.color2html(color));
        String string5 = string3 = string2 != null ? this.get("color." + string2) : "";
        if (string3.equals("")) {
            string3 = this.get("color." + string4);
        }
        return string3.equals("") ? color : ColorHelper.html2color(string3);
    }

    public synchronized Color getDefaultColor(String string) {
        String string2 = (String)this.defaults.get("color." + string);
        return string2 == null || "".equals(string2) ? null : ColorHelper.html2color(string2);
    }

    public synchronized boolean putColor(String string, Color color) {
        return this.put("color." + string, color != null ? ColorHelper.color2html(color) : null);
    }

    public synchronized int getInteger(String string, int n) {
        this.putDefault(string, Integer.toString(n));
        String string2 = this.get(string);
        if (string2.isEmpty()) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public synchronized int getInteger(String string, String string2, int n) {
        this.putDefault(string, Integer.toString(n));
        String string3 = this.get(string + "." + string2);
        if (string3.isEmpty()) {
            string3 = this.get(string);
        }
        if (string3.isEmpty()) {
            return n;
        }
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public synchronized long getLong(String string, long l) {
        this.putDefault(string, Long.toString(l));
        String string2 = this.get(string);
        if (null == string2) {
            return l;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    public synchronized double getDouble(String string, double d) {
        this.putDefault(string, Double.toString(d));
        String string2 = this.get(string);
        if (null == string2) {
            return d;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public synchronized double getDouble(String string, String string2) {
        this.putDefault(string, string2);
        String string3 = this.get(string);
        if (string3 != null && string3.length() != 0) {
            try {
                return Double.parseDouble(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    public Collection<String> getCollection(String string, Collection<String> collection) {
        this.putCollectionDefault(string, (List<String>)(collection == null ? null : new ArrayList<String>(collection)));
        List<String> list = this.getCollectionInternal(string);
        if (list != null) {
            return list;
        }
        return collection;
    }

    public Collection<String> getCollection(String string) {
        this.putCollectionDefault(string, null);
        List<String> list = this.getCollectionInternal(string);
        if (list != null) {
            return list;
        }
        return Collections.emptyList();
    }

    private synchronized List<String> getCollectionInternal(String string) {
        List<String> list = (List<String>)this.collectionProperties.get(string);
        if (list != null) {
            return list;
        }
        String string2 = (String)this.properties.get(string);
        if (string2 != null) {
            list = Arrays.asList(string2.split("\u001e", -1));
            this.collectionProperties.put(string, Collections.unmodifiableList(list));
            this.properties.remove(string);
            this.defaults.remove(string);
            return list;
        }
        return null;
    }

    public synchronized void removeFromCollection(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>(this.getCollection(string, Collections.<String>emptyList()));
        arrayList.remove(string2);
        this.putCollection(string, arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putCollection(String string, Collection<String> collection) {
        List list = null;
        ArrayList<String> arrayList = null;
        Preferences preferences = this;
        synchronized (preferences) {
            if (collection == null) {
                list = (List)this.collectionProperties.remove(string);
                boolean bl = list != null;
                if (!(bl |= this.properties.remove(string) != null)) {
                    return false;
                }
            } else {
                list = this.getCollectionInternal(string);
                if (Preferences.equalCollection(collection, list)) {
                    return false;
                }
                Collection collection2 = (Collection)this.collectionDefaults.get(string);
                if (list == null && Preferences.equalCollection(collection, collection2)) {
                    return false;
                }
                arrayList = new ArrayList<String>(collection);
                if (arrayList.contains(null)) {
                    throw new RuntimeException("Error: Null as list element in preference setting (key '" + string + "')");
                }
                this.collectionProperties.put(string, Collections.unmodifiableList(arrayList));
            }
            try {
                this.save();
            }
            catch (IOException iOException) {
                System.out.println(I18n.tr("Warning: failed to persist preferences to ''{0}''", this.getPreferenceFile().getAbsoluteFile()));
            }
        }
        this.firePreferenceChanged(string, new ListSetting(list), new ListSetting((List<String>)arrayList));
        return true;
    }

    public static boolean equalCollection(Collection<String> collection, Collection<String> collection2) {
        if (collection == null) {
            return collection2 == null;
        }
        if (collection2 == null) {
            return false;
        }
        if (collection.size() != collection2.size()) {
            return false;
        }
        Iterator<String> iterator = collection.iterator();
        Iterator<String> iterator2 = collection2.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = iterator.next();
            if (Utils.equal(string2, string = iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public boolean putCollectionBounded(String string, int n, Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(Math.min(n, collection.size()));
        for (String string2 : collection) {
            if (arrayList.size() >= n) break;
            arrayList.add(string2);
        }
        return this.putCollection(string, arrayList);
    }

    private synchronized void putCollectionDefault(String string, List<String> list) {
        this.collectionDefaults.put(string, list);
    }

    public synchronized Collection<Collection<String>> getArray(String string, Collection<Collection<String>> collection) {
        List<Object> list;
        if (collection != null) {
            list = new ArrayList(collection.size());
            for (Collection collection2 : collection) {
                list.add(Collections.unmodifiableList(new ArrayList(collection2)));
            }
            this.putArrayDefault(string, Collections.unmodifiableList(list));
        } else {
            this.putArrayDefault(string, null);
        }
        list = this.getArrayInternal(string);
        if (list != null) {
            List<Object> list2 = list;
            return list2;
        }
        return collection;
    }

    public Collection<Collection<String>> getArray(String string) {
        this.putArrayDefault(string, null);
        List<Collection<String>> list = this.getArrayInternal(string);
        if (list != null) {
            List<Collection<String>> list2 = list;
            return list2;
        }
        return Collections.emptyList();
    }

    private synchronized List<List<String>> getArrayInternal(String string) {
        List<String> list;
        List list2 = (List)this.arrayProperties.get(string);
        if (list2 != null) {
            return list2;
        }
        String string2 = string + ".";
        int n = 0;
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        while ((list = this.getCollectionInternal(string2 + n)) != null) {
            arrayList.add(list);
            this.collectionProperties.remove(string2 + n);
            this.collectionDefaults.remove(string2 + n);
            ++n;
        }
        if (n > 0) {
            this.arrayProperties.put(string, Collections.unmodifiableList(arrayList));
            return arrayList;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putArray(String string, Collection<Collection<String>> collection) {
        boolean bl = false;
        List<List<String>> list = null;
        ArrayList<List<String>> arrayList = null;
        Preferences preferences = this;
        synchronized (preferences) {
            if (collection == null) {
                list = this.getArrayInternal(string);
                if (this.arrayProperties.remove(string) != null) {
                    return false;
                }
            } else {
                list = this.getArrayInternal(string);
                if (Preferences.equalArray(collection, list)) {
                    return false;
                }
                List list2 = (List)this.arrayDefaults.get(string);
                if (list == null && Preferences.equalArray(collection, list2)) {
                    return false;
                }
                arrayList = new ArrayList<List<String>>(collection.size());
                if (arrayList.contains(null)) {
                    throw new RuntimeException("Error: Null as list element in preference setting (key '" + string + "')");
                }
                for (Collection<String> collection2 : collection) {
                    ArrayList<String> arrayList2 = new ArrayList<String>(collection2);
                    if (arrayList2.contains(null)) {
                        throw new RuntimeException("Error: Null as inner list element in preference setting (key '" + string + "')");
                    }
                    arrayList.add(Collections.unmodifiableList(arrayList2));
                }
                this.arrayProperties.put(string, Collections.unmodifiableList(arrayList));
            }
            try {
                this.save();
            }
            catch (IOException iOException) {
                System.out.println(I18n.tr("Warning: failed to persist preferences to ''{0}''", this.getPreferenceFile().getAbsoluteFile()));
            }
        }
        this.firePreferenceChanged(string, new ListListSetting(list), new ListListSetting((List<List<String>>)arrayList));
        return true;
    }

    public static boolean equalArray(Collection<Collection<String>> collection, Collection<List<String>> collection2) {
        if (collection == null) {
            return collection2 == null;
        }
        if (collection2 == null) {
            return false;
        }
        if (collection.size() != collection2.size()) {
            return false;
        }
        Iterator<Collection<String>> iterator = collection.iterator();
        Iterator<List<String>> iterator2 = collection2.iterator();
        while (iterator.hasNext()) {
            if (Preferences.equalCollection(iterator.next(), (Collection<String>)iterator2.next())) continue;
            return false;
        }
        return true;
    }

    private synchronized void putArrayDefault(String string, List<List<String>> list) {
        this.arrayDefaults.put(string, list);
    }

    public Collection<Map<String, String>> getListOfStructs(String string, Collection<Map<String, String>> collection) {
        ArrayList<Map<String, String>> arrayList;
        if (collection != null) {
            arrayList = new ArrayList(collection.size());
            for (Map<String, String> map : collection) {
                arrayList.add(Collections.unmodifiableMap(new LinkedHashMap<String, String>(map)));
            }
            this.putListOfStructsDefault(string, Collections.unmodifiableList(arrayList));
        } else {
            this.putListOfStructsDefault(string, null);
        }
        arrayList = this.getListOfStructsInternal(string);
        if (arrayList != null) {
            return arrayList;
        }
        return collection;
    }

    private synchronized List<Map<String, String>> getListOfStructsInternal(String string) {
        ArrayList<Map<String, String>> arrayList = (ArrayList<Map<String, String>>)this.listOfStructsProperties.get(string);
        if (arrayList != null) {
            return arrayList;
        }
        List<List<String>> list = this.getArrayInternal(string);
        if (list == null) {
            return null;
        }
        arrayList = new ArrayList<Map<String, String>>(list.size());
        for (List<String> list2 : list) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            for (String string2 : list2) {
                int n = string2.indexOf(58);
                if (n == -1 || n == 0) continue;
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                linkedHashMap.put(string3, string4);
            }
            arrayList.add(Collections.unmodifiableMap(linkedHashMap));
        }
        this.arrayProperties.remove(string);
        this.arrayDefaults.remove(string);
        this.listOfStructsProperties.put(string, Collections.unmodifiableList(arrayList));
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putListOfStructs(String string, Collection<Map<String, String>> collection) {
        List<Map<String, String>> list;
        boolean bl = false;
        ArrayList<Map<String, String>> arrayList = null;
        Preferences preferences = this;
        synchronized (preferences) {
            if (collection == null) {
                list = this.getListOfStructsInternal(string);
                if (this.listOfStructsProperties.remove(string) != null) {
                    return false;
                }
            } else {
                list = this.getListOfStructsInternal(string);
                if (Preferences.equalListOfStructs(list, collection)) {
                    return false;
                }
                List list2 = (List)this.listOfStructsDefaults.get(string);
                if (list == null && Preferences.equalListOfStructs(collection, list2)) {
                    return false;
                }
                arrayList = new ArrayList<Map<String, String>>(collection.size());
                if (arrayList.contains(null)) {
                    throw new RuntimeException("Error: Null as list element in preference setting (key '" + string + "')");
                }
                for (Map<String, String> map : collection) {
                    LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(map);
                    if (linkedHashMap.keySet().contains(null)) {
                        throw new RuntimeException("Error: Null as map key in preference setting (key '" + string + "')");
                    }
                    if (linkedHashMap.values().contains(null)) {
                        throw new RuntimeException("Error: Null as map value in preference setting (key '" + string + "')");
                    }
                    arrayList.add(Collections.unmodifiableMap(linkedHashMap));
                }
                this.listOfStructsProperties.put(string, Collections.unmodifiableList(arrayList));
            }
            try {
                this.save();
            }
            catch (IOException iOException) {
                System.out.println(I18n.tr("Warning: failed to persist preferences to ''{0}''", this.getPreferenceFile().getAbsoluteFile()));
            }
        }
        this.firePreferenceChanged(string, new MapListSetting(list), new MapListSetting((List<Map<String, String>>)arrayList));
        return true;
    }

    public static boolean equalListOfStructs(Collection<Map<String, String>> collection, Collection<Map<String, String>> collection2) {
        if (collection == null) {
            return collection2 == null;
        }
        if (collection2 == null) {
            return false;
        }
        if (collection.size() != collection2.size()) {
            return false;
        }
        Iterator<Map<String, String>> iterator = collection.iterator();
        Iterator<Map<String, String>> iterator2 = collection2.iterator();
        while (iterator.hasNext()) {
            if (Preferences.equalMap(iterator.next(), iterator2.next())) continue;
            return false;
        }
        return true;
    }

    private static boolean equalMap(Map<String, String> map, Map<String, String> map2) {
        if (map == null) {
            return map2 == null;
        }
        if (map2 == null) {
            return false;
        }
        if (map.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (Utils.equal(entry.getValue(), map2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private synchronized void putListOfStructsDefault(String string, List<Map<String, String>> list) {
        this.listOfStructsDefaults.put(string, list);
    }

    public <T> List<T> getListOfStructs(String string, Class<T> clazz) {
        List<T> list = this.getListOfStructs(string, null, clazz);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public <T> List<T> getListOfStructs(String string, Collection<T> collection, Class<T> clazz) {
        Collection<Map<String, String>> collection2 = this.getListOfStructs(string, collection == null ? null : this.serializeListOfStructs(collection, clazz));
        if (collection2 == null) {
            return collection == null ? null : new ArrayList<T>(collection);
        }
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Map<String, String> map : collection2) {
            T t = this.deserializeStruct(map, clazz);
            arrayList.add(t);
        }
        return arrayList;
    }

    public <T> boolean putListOfStructs(String string, Collection<T> collection, Class<T> clazz) {
        return this.putListOfStructs(string, this.serializeListOfStructs(collection, clazz));
    }

    private <T> Collection<Map<String, String>> serializeListOfStructs(Collection<T> collection, Class<T> clazz) {
        if (collection == null) {
            return null;
        }
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        for (T t : collection) {
            if (t == null) continue;
            arrayList.add(this.serializeStruct(t, clazz));
        }
        return arrayList;
    }

    private <T> Map<String, String> serializeStruct(T t, Class<T> clazz) {
        T t2;
        try {
            t2 = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getAnnotation(pref.class) == null) continue;
            field.setAccessible(true);
            try {
                Object object = field.get(t);
                Object object2 = field.get(t2);
                if (object == null || field.getAnnotation(writeExplicitly.class) == null && Utils.equal(object, object2)) continue;
                linkedHashMap.put(field.getName().replace("_", "-"), object.toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException();
            }
        }
        return linkedHashMap;
    }

    private <T> T deserializeStruct(Map<String, String> map, Class<T> clazz) {
        T t = null;
        try {
            t = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException();
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Field field;
            Object object;
            block20: {
                object = null;
                try {
                    field = clazz.getDeclaredField(entry.getKey().replace("-", "_"));
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
                catch (SecurityException securityException) {
                    throw new RuntimeException();
                }
                if (field.getAnnotation(pref.class) == null) continue;
                field.setAccessible(true);
                if (field.getType() == Boolean.class || field.getType() == Boolean.TYPE) {
                    object = Boolean.parseBoolean(entry.getValue());
                } else {
                    if (field.getType() == Integer.class || field.getType() == Integer.TYPE) {
                        try {
                            object = Integer.parseInt(entry.getValue());
                            break block20;
                        }
                        catch (NumberFormatException numberFormatException) {
                            continue;
                        }
                    }
                    if (field.getType() == Double.class || field.getType() == Double.TYPE) {
                        try {
                            object = Double.parseDouble(entry.getValue());
                            break block20;
                        }
                        catch (NumberFormatException numberFormatException) {
                            continue;
                        }
                    }
                    if (field.getType() == String.class) {
                        object = entry.getValue();
                    } else {
                        throw new RuntimeException("unsupported preference primitive type");
                    }
                }
            }
            try {
                field.set(t, object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new AssertionError();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException();
            }
        }
        return t;
    }

    public boolean putSetting(final String string, Setting setting) {
        if (setting == null) {
            return false;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class PutVisitor
        implements SettingVisitor {
            public boolean changed;

            PutVisitor() {
            }

            @Override
            public void visit(StringSetting stringSetting) {
                this.changed = Preferences.this.put(string, (String)stringSetting.getValue());
            }

            @Override
            public void visit(ListSetting listSetting) {
                this.changed = Preferences.this.putCollection(string, (Collection)listSetting.getValue());
            }

            @Override
            public void visit(ListListSetting listListSetting) {
                boolean bl;
                this.changed = bl = Preferences.this.putArray(string, (Collection)listListSetting.getValue());
            }

            @Override
            public void visit(MapListSetting mapListSetting) {
                this.changed = Preferences.this.putListOfStructs(string, (Collection)mapListSetting.getValue());
            }
        }
        PutVisitor putVisitor = new PutVisitor();
        setting.visit(putVisitor);
        return putVisitor.changed;
    }

    public Map<String, Setting> getAllSettings() {
        TreeMap<String, Setting> treeMap = new TreeMap<String, Setting>();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            treeMap.put(entry.getKey(), new StringSetting(entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : this.collectionProperties.entrySet()) {
            treeMap.put(entry.getKey(), new ListSetting((List)entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : this.arrayProperties.entrySet()) {
            treeMap.put(entry.getKey(), new ListListSetting((List)entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : this.listOfStructsProperties.entrySet()) {
            treeMap.put(entry.getKey(), new MapListSetting((List)entry.getValue()));
        }
        return treeMap;
    }

    public Map<String, Setting> getAllDefaults() {
        TreeMap<String, Setting> treeMap = new TreeMap<String, Setting>();
        for (Map.Entry<String, String> entry : this.defaults.entrySet()) {
            treeMap.put(entry.getKey(), new StringSetting(entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : this.collectionDefaults.entrySet()) {
            treeMap.put(entry.getKey(), new ListSetting((List)entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : this.arrayDefaults.entrySet()) {
            treeMap.put(entry.getKey(), new ListListSetting((List)entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : this.listOfStructsDefaults.entrySet()) {
            treeMap.put(entry.getKey(), new MapListSetting((List)entry.getValue()));
        }
        return treeMap;
    }

    public void updateSystemProperties() {
        Properties properties = System.getProperties();
        properties.put("http.agent", Version.getInstance().getAgentString());
        System.setProperties(properties);
    }

    public Collection<String> getPluginSites() {
        return this.getCollection("pluginmanager.sites", Arrays.asList(DEFAULT_PLUGIN_SITE));
    }

    public void setPluginSites(Collection<String> collection) {
        this.putCollection("pluginmanager.sites", collection);
    }

    public void validateXML(Reader reader) throws Exception {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(new StreamSource(new MirroredInputStream("resource://data/preferences.xsd")));
        Validator validator = schema.newValidator();
        validator.validate(new StreamSource(reader));
    }

    public void fromXML(Reader reader) throws XMLStreamException {
        XMLStreamReader xMLStreamReader;
        this.parser = xMLStreamReader = XMLInputFactory.newInstance().createXMLStreamReader(reader);
        this.parse();
    }

    public void parse() throws XMLStreamException {
        int n = this.parser.getEventType();
        while (true) {
            if (n == 1) {
                this.parseRoot();
            } else if (n == 2) {
                return;
            }
            if (!this.parser.hasNext()) break;
            n = this.parser.next();
        }
        this.parser.close();
    }

    public void parseRoot() throws XMLStreamException {
        while (true) {
            int n;
            if ((n = this.parser.next()) == 1) {
                if (this.parser.getLocalName().equals("tag")) {
                    this.properties.put(this.parser.getAttributeValue(null, "key"), this.parser.getAttributeValue(null, "value"));
                    this.jumpToEnd();
                    continue;
                }
                if (this.parser.getLocalName().equals("list") || this.parser.getLocalName().equals("collection") || this.parser.getLocalName().equals("lists") || this.parser.getLocalName().equals("maps")) {
                    this.parseToplevelList();
                    continue;
                }
                this.throwException("Unexpected element: " + this.parser.getLocalName());
                continue;
            }
            if (n == 2) break;
        }
    }

    private void jumpToEnd() throws XMLStreamException {
        while (true) {
            int n;
            if ((n = this.parser.next()) == 1) {
                this.jumpToEnd();
                continue;
            }
            if (n == 2) break;
        }
    }

    protected void parseToplevelList() throws XMLStreamException {
        String string = this.parser.getAttributeValue(null, "key");
        String string2 = this.parser.getLocalName();
        ArrayList<String> arrayList = null;
        ArrayList<List<String>> arrayList2 = null;
        ArrayList<Map<String, String>> arrayList3 = null;
        while (true) {
            int n;
            if ((n = this.parser.next()) == 1) {
                if (this.parser.getLocalName().equals("entry")) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                    }
                    arrayList.add(this.parser.getAttributeValue(null, "value"));
                    this.jumpToEnd();
                    continue;
                }
                if (this.parser.getLocalName().equals("list")) {
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList<List<String>>();
                    }
                    arrayList2.add(this.parseInnerList());
                    continue;
                }
                if (this.parser.getLocalName().equals("map")) {
                    if (arrayList3 == null) {
                        arrayList3 = new ArrayList<Map<String, String>>();
                    }
                    arrayList3.add(this.parseMap());
                    continue;
                }
                this.throwException("Unexpected element: " + this.parser.getLocalName());
                continue;
            }
            if (n == 2) break;
        }
        if (arrayList != null) {
            this.collectionProperties.put(string, Collections.unmodifiableList(arrayList));
        } else if (arrayList2 != null) {
            this.arrayProperties.put(string, Collections.unmodifiableList(arrayList2));
        } else if (arrayList3 != null) {
            this.listOfStructsProperties.put(string, Collections.unmodifiableList(arrayList3));
        } else if (string2.equals("lists")) {
            this.arrayProperties.put(string, Collections.emptyList());
        } else if (string2.equals("maps")) {
            this.listOfStructsProperties.put(string, Collections.emptyList());
        } else {
            this.collectionProperties.put(string, Collections.emptyList());
        }
    }

    protected List<String> parseInnerList() throws XMLStreamException {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (true) {
            int n;
            if ((n = this.parser.next()) == 1) {
                if (this.parser.getLocalName().equals("entry")) {
                    arrayList.add(this.parser.getAttributeValue(null, "value"));
                    this.jumpToEnd();
                    continue;
                }
                this.throwException("Unexpected element: " + this.parser.getLocalName());
                continue;
            }
            if (n == 2) break;
        }
        return Collections.unmodifiableList(arrayList);
    }

    protected Map<String, String> parseMap() throws XMLStreamException {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        while (true) {
            int n;
            if ((n = this.parser.next()) == 1) {
                if (this.parser.getLocalName().equals("tag")) {
                    linkedHashMap.put(this.parser.getAttributeValue(null, "key"), this.parser.getAttributeValue(null, "value"));
                    this.jumpToEnd();
                    continue;
                }
                this.throwException("Unexpected element: " + this.parser.getLocalName());
                continue;
            }
            if (n == 2) break;
        }
        return Collections.unmodifiableMap(linkedHashMap);
    }

    protected void throwException(String string) {
        throw new RuntimeException(string + I18n.tr(" (at line {0}, column {1})", this.parser.getLocation().getLineNumber(), this.parser.getLocation().getColumnNumber()));
    }

    public String toXML(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<preferences xmlns=\"http://josm.openstreetmap.de/preferences-1.0\" version=\"" + Version.getInstance().getVersion() + "\">\n");
        SettingToXml settingToXml = new SettingToXml(stringBuilder, bl);
        TreeMap<String, AbstractSetting> treeMap = new TreeMap<String, AbstractSetting>();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            treeMap.put(entry.getKey(), new StringSetting(entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : this.collectionProperties.entrySet()) {
            treeMap.put(entry.getKey(), new ListSetting((List)entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : this.arrayProperties.entrySet()) {
            treeMap.put(entry.getKey(), new ListListSetting((List)entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : this.listOfStructsProperties.entrySet()) {
            treeMap.put(entry.getKey(), new MapListSetting((List)entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : treeMap.entrySet()) {
            settingToXml.setKey(entry.getKey());
            ((Setting)entry.getValue()).visit(settingToXml);
        }
        stringBuilder.append("</preferences>\n");
        return stringBuilder.toString();
    }

    public void removeObsolete() {
        String[] stringArray;
        for (String string : stringArray = new String[]{"edit.make-parallel-way-action.snap-threshold"}) {
            boolean bl = false;
            if (this.properties.containsKey(string)) {
                this.properties.remove(string);
                bl = true;
            }
            if (this.collectionProperties.containsKey(string)) {
                this.collectionProperties.remove(string);
                bl = true;
            }
            if (this.arrayProperties.containsKey(string)) {
                this.arrayProperties.remove(string);
                bl = true;
            }
            if (this.listOfStructsProperties.containsKey(string)) {
                this.listOfStructsProperties.remove(string);
                bl = true;
            }
            if (!bl) continue;
            System.out.println(I18n.tr("Preference setting {0} has been removed since it is no longer used.", string));
        }
    }

    private class SettingToXml
    implements SettingVisitor {
        private StringBuilder b;
        private boolean noPassword;
        private String key;

        public SettingToXml(StringBuilder stringBuilder, boolean bl) {
            this.b = stringBuilder;
            this.noPassword = bl;
        }

        public void setKey(String string) {
            this.key = string;
        }

        public void visit(StringSetting stringSetting) {
            if (this.noPassword && this.key.equals("osm-server.password")) {
                return;
            }
            String string = (String)stringSetting.getValue();
            String string2 = (String)Preferences.this.defaults.get(this.key);
            if (string2 == null || !string2.equals(string)) {
                if (string.contains("\u001e")) {
                    this.b.append("  <list key='");
                    this.b.append(XmlWriter.encode(this.key));
                    this.b.append("'>\n");
                    for (String string3 : string.split("\u001e", -1)) {
                        this.b.append("    <entry value='");
                        this.b.append(XmlWriter.encode(string3));
                        this.b.append("'/>\n");
                    }
                    this.b.append("  </list>\n");
                } else {
                    this.b.append("  <tag key='");
                    this.b.append(XmlWriter.encode(this.key));
                    this.b.append("' value='");
                    this.b.append(XmlWriter.encode((String)stringSetting.getValue()));
                    this.b.append("'/>\n");
                }
            }
        }

        public void visit(ListSetting listSetting) {
            this.b.append("  <list key='").append(XmlWriter.encode(this.key)).append("'>\n");
            for (String string : (List)listSetting.getValue()) {
                this.b.append("    <entry value='").append(XmlWriter.encode(string)).append("'/>\n");
            }
            this.b.append("  </list>\n");
        }

        public void visit(ListListSetting listListSetting) {
            this.b.append("  <lists key='").append(XmlWriter.encode(this.key)).append("'>\n");
            for (List list : (List)listListSetting.getValue()) {
                this.b.append("    <list>\n");
                for (String string : list) {
                    this.b.append("      <entry value='").append(XmlWriter.encode(string)).append("'/>\n");
                }
                this.b.append("    </list>\n");
            }
            this.b.append("  </lists>\n");
        }

        public void visit(MapListSetting mapListSetting) {
            this.b.append("  <maps key='").append(XmlWriter.encode(this.key)).append("'>\n");
            for (Map map : (List)mapListSetting.getValue()) {
                this.b.append("    <map>\n");
                for (Map.Entry entry : map.entrySet()) {
                    this.b.append("      <tag key='").append(XmlWriter.encode((String)entry.getKey())).append("' value='").append(XmlWriter.encode((String)entry.getValue())).append("'/>\n");
                }
                this.b.append("    </map>\n");
            }
            this.b.append("  </maps>\n");
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface writeExplicitly {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface pref {
    }

    public static interface ColorKey {
        public String getColorName();

        public String getSpecialName();

        public Color getDefault();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultPreferenceChangeEvent<T>
    implements PreferenceChangeEvent<T> {
        private final String key;
        private final Setting<T> oldValue;
        private final Setting<T> newValue;

        public DefaultPreferenceChangeEvent(String string, Setting<T> setting, Setting<T> setting2) {
            this.key = string;
            this.oldValue = setting;
            this.newValue = setting2;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Setting<T> getOldValue() {
            return this.oldValue;
        }

        @Override
        public Setting<T> getNewValue() {
            return this.newValue;
        }
    }

    public static interface PreferenceChangedListener {
        public void preferenceChanged(PreferenceChangeEvent var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PreferenceChangeEvent<T> {
        public String getKey();

        public Setting<T> getOldValue();

        public Setting<T> getNewValue();
    }

    public static interface SettingVisitor {
        public void visit(StringSetting var1);

        public void visit(ListSetting var1);

        public void visit(ListListSetting var1);

        public void visit(MapListSetting var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapListSetting
    extends AbstractSetting<List<Map<String, String>>> {
        public MapListSetting(List<Map<String, String>> list) {
            super(list);
        }

        @Override
        public void visit(SettingVisitor settingVisitor) {
            settingVisitor.visit(this);
        }

        public MapListSetting getNullInstance() {
            return new MapListSetting(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListListSetting
    extends AbstractSetting<List<List<String>>> {
        public ListListSetting(List<List<String>> list) {
            super(list);
        }

        @Override
        public void visit(SettingVisitor settingVisitor) {
            settingVisitor.visit(this);
        }

        public ListListSetting getNullInstance() {
            return new ListListSetting(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListSetting
    extends AbstractSetting<List<String>> {
        public ListSetting(List<String> list) {
            super(list);
        }

        @Override
        public void visit(SettingVisitor settingVisitor) {
            settingVisitor.visit(this);
        }

        public ListSetting getNullInstance() {
            return new ListSetting(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringSetting
    extends AbstractSetting<String> {
        public StringSetting(String string) {
            super(string);
        }

        @Override
        public void visit(SettingVisitor settingVisitor) {
            settingVisitor.visit(this);
        }

        public StringSetting getNullInstance() {
            return new StringSetting(null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractSetting<T>
    implements Setting<T> {
        private T value;

        public AbstractSetting(T t) {
            this.value = t;
        }

        @Override
        public T getValue() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Setting<T> {
        public T getValue();

        public void visit(SettingVisitor var1);

        public Setting<T> getNullInstance();
    }
}

