/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.paint.LineClip;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.mappaint.BoxTextElemStyle;
import org.openstreetmap.josm.gui.mappaint.MapImage;
import org.openstreetmap.josm.gui.mappaint.NodeElemStyle;
import org.openstreetmap.josm.gui.mappaint.TextElement;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapPainter {
    private final Graphics2D g;
    private final NavigatableComponent nc;
    private final boolean inactive;
    private final MapPaintSettings settings;
    private final Collection<WaySegment> highlightWaySegments;
    private final boolean useStrokes;
    private final boolean showNames;
    private final boolean showIcons;
    private final boolean isOutlineOnly;
    private final Color inactiveColor;
    private final Color selectedColor;
    private final Color relationSelectedColor;
    private final Color nodeColor;
    private final Color highlightColor;
    private final Color highlightColorTransparent;
    private final Color backgroundColor;
    private final Font orderFont;
    private final int virtualNodeSize;
    private final int virtualNodeSpace;
    private final int segmentNumberSpace;
    private final double circum;
    private final boolean leftHandTraffic;
    private static final double PHI = Math.toRadians(20.0);
    private static final double cosPHI = Math.cos(PHI);
    private static final double sinPHI = Math.sin(PHI);

    public MapPainter(MapPaintSettings mapPaintSettings, Graphics2D graphics2D, boolean bl, NavigatableComponent navigatableComponent, boolean bl2, double d, boolean bl3, Collection<WaySegment> collection) {
        this.settings = mapPaintSettings;
        this.g = graphics2D;
        this.inactive = bl;
        this.nc = navigatableComponent;
        this.highlightWaySegments = collection;
        this.useStrokes = (double)mapPaintSettings.getUseStrokesDistance() > d;
        this.showNames = (double)mapPaintSettings.getShowNamesDistance() > d;
        this.showIcons = (double)mapPaintSettings.getShowIconsDistance() > d;
        this.isOutlineOnly = mapPaintSettings.isOutlineOnly();
        this.inactiveColor = PaintColors.INACTIVE.get();
        this.selectedColor = PaintColors.SELECTED.get();
        this.relationSelectedColor = PaintColors.RELATIONSELECTED.get();
        this.nodeColor = PaintColors.NODE.get();
        this.highlightColor = PaintColors.HIGHLIGHT.get();
        this.highlightColorTransparent = new Color(this.highlightColor.getRed(), this.highlightColor.getGreen(), this.highlightColor.getBlue(), 100);
        this.backgroundColor = PaintColors.getBackgroundColor();
        this.orderFont = new Font(Main.pref.get("mappaint.font", "Helvetica"), 0, Main.pref.getInteger("mappaint.fontsize", 8));
        this.virtualNodeSize = bl2 ? Main.pref.getInteger("mappaint.node.virtual-size", 8) / 2 : 0;
        this.virtualNodeSpace = Main.pref.getInteger("mappaint.node.virtual-space", 70);
        this.segmentNumberSpace = Main.pref.getInteger("mappaint.segmentnumber.space", 40);
        this.circum = d;
        this.leftHandTraffic = bl3;
    }

    /*
     * WARNING - void declaration
     */
    public void drawWay(Way way, Color color, BasicStroke basicStroke, BasicStroke basicStroke2, Color color2, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Object object;
        Point point;
        Object object2;
        GeneralPath generalPath = new GeneralPath();
        GeneralPath generalPath2 = bl ? new GeneralPath() : null;
        GeneralPath generalPath3 = bl3 ? new GeneralPath() : null;
        GeneralPath generalPath4 = bl3 ? new GeneralPath() : null;
        Rectangle rectangle = this.g.getClipBounds();
        rectangle.grow(100, 100);
        double d = 0.0;
        Point point2 = null;
        boolean bl5 = true;
        List<Node> list = way.getNodes();
        if (list.size() < 2) {
            return;
        }
        if (!way.isHighlighted()) {
            object2 = null;
            for (WaySegment object3 : this.highlightWaySegments) {
                if (object3.way != way || object3.lowerIndex < n) continue;
                if (object2 == null) {
                    object2 = new GeneralPath();
                }
                point = this.nc.getPoint(object3.getFirstNode());
                object = this.nc.getPoint(object3.getSecondNode());
                ((Path2D.Float)object2).moveTo(point.x, point.y);
                ((Path2D.Float)object2).lineTo(((Point)object).x, ((Point)object).y);
            }
            this.drawPathHighlight((GeneralPath)object2, basicStroke);
        }
        object2 = new OffsetIterator(list, n);
        while (object2.hasNext()) {
            Point point3;
            Point point32 = (Point)object2.next();
            if (point2 != null && ((LineClip)(object = new LineClip(point3 = point2, point = point32, rectangle))).execute()) {
                double d2;
                double d3;
                void var23_26;
                double d4;
                if (!point3.equals(((LineClip)object).getP1())) {
                    Point point4 = ((LineClip)object).getP1();
                    generalPath.moveTo(point4.x, point4.y);
                } else if (bl5) {
                    bl5 = false;
                    generalPath.moveTo(point3.x, point3.y);
                }
                point = ((LineClip)object).getP2();
                generalPath.lineTo(point.x, point.y);
                if ((bl2 ? !object2.hasNext() : bl) && (d4 = var23_26.distance(point)) != 0.0) {
                    d3 = (10.0 + (double)basicStroke.getLineWidth()) / d4;
                    d2 = d3 * (double)(var23_26.x - point.x);
                    double d5 = d3 * (double)(var23_26.y - point.y);
                    generalPath2.moveTo((double)point.x + cosPHI * d2 - sinPHI * d5, (double)point.y + sinPHI * d2 + cosPHI * d5);
                    generalPath2.lineTo(point.x, point.y);
                    generalPath2.lineTo((double)point.x + cosPHI * d2 + sinPHI * d5, (double)point.y - sinPHI * d2 + cosPHI * d5);
                }
                if (bl3) {
                    d4 = var23_26.distance(point);
                    if (d4 != 0.0) {
                        d3 = (double)(point.x - var23_26.x) / d4;
                        d2 = (double)(point.y - var23_26.y) / d4;
                        for (double d6 = 60.0 - d % 60.0; d6 < d4; d6 += 60.0) {
                            for (Pair pair : Arrays.asList(new Pair<Float, GeneralPath>(Float.valueOf(3.0f), generalPath4), new Pair<Float, GeneralPath>(Float.valueOf(2.0f), generalPath3))) {
                                double d7 = (double)((float)(-(bl4 ? -1 : 1)) * ((Float)pair.a).floatValue()) * (1.0 + sinPHI) / (sinPHI * cosPHI);
                                double d8 = d3 * d7;
                                double d9 = d2 * d7;
                                double d10 = (double)var23_26.x + d3 * (d6 + (double)(bl4 ? -1 : 1) * ((double)((Float)pair.a).floatValue() / sinPHI));
                                double d11 = (double)var23_26.y + d2 * (d6 + (double)(bl4 ? -1 : 1) * ((double)((Float)pair.a).floatValue() / sinPHI));
                                ((GeneralPath)pair.b).moveTo(d10, d11);
                                ((GeneralPath)pair.b).lineTo(d10 + cosPHI * d8 - sinPHI * d9, d11 + sinPHI * d8 + cosPHI * d9);
                                ((GeneralPath)pair.b).lineTo(d10 + cosPHI * d8 + sinPHI * d9, d11 - sinPHI * d8 + cosPHI * d9);
                                ((GeneralPath)pair.b).lineTo(d10, d11);
                            }
                        }
                    }
                    d += d4;
                }
            }
            point2 = point32;
        }
        if (way.isHighlighted()) {
            this.drawPathHighlight(generalPath, basicStroke);
        }
        this.displaySegments(generalPath, generalPath2, generalPath3, generalPath4, color, basicStroke, basicStroke2, color2);
    }

    private void displaySegments(GeneralPath generalPath, GeneralPath generalPath2, GeneralPath generalPath3, GeneralPath generalPath4, Color color, BasicStroke basicStroke, BasicStroke basicStroke2, Color color2) {
        this.g.setColor(this.inactive ? this.inactiveColor : color);
        if (this.useStrokes) {
            this.g.setStroke(basicStroke);
        }
        this.g.draw(generalPath);
        if (!this.inactive && this.useStrokes && basicStroke2 != null) {
            this.g.setColor(color2);
            this.g.setStroke(basicStroke2);
            this.g.draw(generalPath);
        }
        if (generalPath2 != null) {
            this.g.setColor(this.inactive ? this.inactiveColor : color);
            this.g.setStroke(new BasicStroke(basicStroke.getLineWidth(), basicStroke.getEndCap(), 0, basicStroke.getMiterLimit()));
            this.g.draw(generalPath2);
        }
        if (generalPath3 != null) {
            this.g.setStroke(new BasicStroke(1.0f, basicStroke.getEndCap(), 0, basicStroke.getMiterLimit()));
            this.g.fill(generalPath4);
            this.g.setColor(this.inactive ? this.inactiveColor : this.backgroundColor);
            this.g.fill(generalPath3);
        }
        if (this.useStrokes) {
            this.g.setStroke(new BasicStroke());
        }
    }

    private void drawPathHighlight(GeneralPath generalPath, BasicStroke basicStroke) {
        if (generalPath == null) {
            return;
        }
        this.g.setColor(this.highlightColorTransparent);
        for (float f = basicStroke.getLineWidth() + 4.0f; f >= basicStroke.getLineWidth(); f -= 4.0f) {
            this.g.setStroke(new BasicStroke(f, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit()));
            this.g.draw(generalPath);
        }
    }

    private boolean isSegmentVisible(Point point, Point point2) {
        if (point.x < 0 && point2.x < 0) {
            return false;
        }
        if (point.y < 0 && point2.y < 0) {
            return false;
        }
        if (point.x > this.nc.getWidth() && point2.x > this.nc.getWidth()) {
            return false;
        }
        return point.y <= this.nc.getHeight() || point2.y <= this.nc.getHeight();
    }

    public void drawTextOnPath(Way way, TextElement textElement) {
        double d;
        double d2;
        double d3;
        double[] dArray;
        Cloneable cloneable;
        Object object;
        if (textElement == null) {
            return;
        }
        String string = textElement.getString(way);
        if (string == null || string.equals("")) {
            return;
        }
        Polygon polygon = new Polygon();
        Cloneable cloneable2 = null;
        Iterator<Node> iterator = way.getNodes().iterator();
        double d4 = 0.0;
        while (iterator.hasNext()) {
            object = iterator.next();
            cloneable = this.nc.getPoint((Node)object);
            polygon.addPoint(((Point)cloneable).x, ((Point)cloneable).y);
            if (cloneable2 != null) {
                long l = ((Point)cloneable).x - ((Point)cloneable2).x;
                long l2 = ((Point)cloneable).y - ((Point)cloneable2).y;
                d4 += Math.sqrt(l * l + l2 * l2);
            }
            cloneable2 = cloneable;
        }
        object = this.g.getFontMetrics(textElement.font);
        cloneable = ((FontMetrics)object).getStringBounds(string, this.g);
        if (((RectangularShape)cloneable).getWidth() > d4) {
            return;
        }
        double d5 = (d4 / 2.0 - ((RectangularShape)cloneable).getWidth() / 2.0) / d4;
        double d6 = (d4 / 2.0 + ((RectangularShape)cloneable).getWidth() / 2.0) / d4;
        double[] dArray2 = this.pointAt(d5, polygon, d4);
        if (dArray2[0] < (dArray = this.pointAt(d6, polygon, d4))[0] && dArray2[2] < 1.5707963267948966 && dArray2[2] > -1.5707963267948966) {
            d3 = 0.0;
            d2 = 1.0;
            d = d5;
        } else {
            d3 = Math.PI;
            d2 = -1.0;
            d = d6;
        }
        FontRenderContext fontRenderContext = this.g.getFontRenderContext();
        GlyphVector glyphVector = textElement.font.createGlyphVector(fontRenderContext, string);
        for (int i = 0; i < glyphVector.getNumGlyphs(); ++i) {
            Rectangle2D rectangle2D = glyphVector.getGlyphLogicalBounds(i).getBounds2D();
            double d7 = d + d2 * (rectangle2D.getX() + rectangle2D.getWidth() / 2.0) / d4;
            double[] dArray3 = this.pointAt(d7, polygon, d4);
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(dArray3[0] - rectangle2D.getX(), dArray3[1]);
            affineTransform.rotate(dArray3[2] + d3);
            double d8 = -rectangle2D.getY() - rectangle2D.getHeight() / 2.0 + (double)textElement.yOffset;
            affineTransform.translate(-rectangle2D.getWidth() / 2.0, d8);
            glyphVector.setGlyphTransform(i, affineTransform);
        }
        if (textElement.haloRadius != null) {
            Shape shape = glyphVector.getOutline();
            this.g.setStroke(new BasicStroke(2.0f * textElement.haloRadius.floatValue(), 0, 1));
            this.g.setColor(textElement.haloColor);
            this.g.draw(shape);
            this.g.setStroke(new BasicStroke());
            this.g.setColor(textElement.color);
            this.g.fill(shape);
        } else {
            this.g.setColor(textElement.color);
            this.g.drawGlyphVector(glyphVector, 0.0f, 0.0f);
        }
    }

    private double[] pointAt(double d, Polygon polygon, double d2) {
        double d3 = d * d2;
        double d4 = 0.0;
        for (int i = 1; i < polygon.npoints; ++i) {
            long l = polygon.xpoints[i] - polygon.xpoints[i - 1];
            long l2 = polygon.ypoints[i] - polygon.ypoints[i - 1];
            double d5 = Math.sqrt(l * l + l2 * l2);
            if (d3 > d4 + d5) {
                d4 += d5;
                continue;
            }
            return new double[]{(double)polygon.xpoints[i - 1] + (d3 - d4) / d5 * (double)l, (double)polygon.ypoints[i - 1] + (d3 - d4) / d5 * (double)l2, Math.atan2(l2, l)};
        }
        return null;
    }

    public void drawLinePattern(Way way, Image image) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        Point point = null;
        double d = 0.0;
        for (Node node : way.getNodes()) {
            Point point2 = this.nc.getPoint(node);
            if (point != null) {
                double d2 = point2.distance(point);
                double d3 = point2.x - point.x;
                double d4 = point2.y - point.y;
                double d5 = d == 0.0 ? 0.0 : (double)n - d % (double)n;
                AffineTransform affineTransform = this.g.getTransform();
                this.g.translate(point.x, point.y);
                this.g.rotate(Math.atan2(d4, d3));
                if (d5 > 0.0) {
                    this.g.drawImage(image, 0, 0, (int)d5, n2, n - (int)d5, 0, n, n2, null);
                }
                while (d5 < d2) {
                    if (d5 + (double)n > d2) {
                        this.g.drawImage(image, (int)d5, 0, (int)d2, n2, 0, 0, (int)d2 - (int)d5, n2, null);
                    } else {
                        this.g.drawImage(image, (int)d5, 0, this.nc);
                    }
                    d5 += (double)n;
                }
                this.g.setTransform(affineTransform);
                d += d2;
            }
            point = point2;
        }
    }

    public void drawNodeIcon(Node node, Image image, float f, boolean bl, boolean bl2) {
        Point point = this.nc.getPoint(node);
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (node.isHighlighted()) {
            this.drawPointHighlight(point, Math.max(n, n2));
        }
        if (f != 1.0f) {
            this.g.setComposite(AlphaComposite.getInstance(3, f));
        }
        this.g.drawImage(image, point.x - n / 2, point.y - n2 / 2, this.nc);
        this.g.setPaintMode();
        if (bl || bl2) {
            this.g.setColor(bl ? this.selectedColor : this.relationSelectedColor);
            this.g.drawRect(point.x - n / 2 - 2, point.y - n2 / 2 - 2, n + 4, n2 + 4);
        }
    }

    private Polygon buildPolygon(Point point, int n, int n2, double d) {
        Polygon polygon = new Polygon();
        for (int i = 0; i < n2; ++i) {
            double d2 = Math.PI * 2 / (double)n2 * (double)i - d;
            int n3 = (int)Math.round((double)point.x + (double)n * Math.cos(d2));
            int n4 = (int)Math.round((double)point.y + (double)n * Math.sin(d2));
            polygon.addPoint(n3, n4);
        }
        return polygon;
    }

    private Polygon buildPolygon(Point point, int n, int n2) {
        return this.buildPolygon(point, n, n2, 0.0);
    }

    public void drawNodeSymbol(Node node, NodeElemStyle.Symbol symbol, Color color, Color color2) {
        Point point = this.nc.getPoint(node);
        int n = symbol.size / 2;
        if (node.isHighlighted()) {
            this.drawPointHighlight(point, symbol.size);
        }
        if (color != null) {
            this.g.setColor(color);
            switch (symbol.symbol) {
                case SQUARE: {
                    this.g.fillRect(point.x - n, point.y - n, symbol.size, symbol.size);
                    break;
                }
                case CIRCLE: {
                    this.g.fillOval(point.x - n, point.y - n, symbol.size, symbol.size);
                    break;
                }
                case TRIANGLE: {
                    this.g.fillPolygon(this.buildPolygon(point, n, 3, 1.5707963267948966));
                    break;
                }
                case PENTAGON: {
                    this.g.fillPolygon(this.buildPolygon(point, n, 5, 1.5707963267948966));
                    break;
                }
                case HEXAGON: {
                    this.g.fillPolygon(this.buildPolygon(point, n, 6));
                    break;
                }
                case HEPTAGON: {
                    this.g.fillPolygon(this.buildPolygon(point, n, 7, 1.5707963267948966));
                    break;
                }
                case OCTAGON: {
                    this.g.fillPolygon(this.buildPolygon(point, n, 8, 0.39269908169872414));
                    break;
                }
                case NONAGON: {
                    this.g.fillPolygon(this.buildPolygon(point, n, 9, 1.5707963267948966));
                    break;
                }
                case DECAGON: {
                    this.g.fillPolygon(this.buildPolygon(point, n, 10));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        if (symbol.stroke != null) {
            this.g.setStroke(symbol.stroke);
            this.g.setColor(color2);
            switch (symbol.symbol) {
                case SQUARE: {
                    this.g.drawRect(point.x - n, point.y - n, symbol.size - 1, symbol.size - 1);
                    break;
                }
                case CIRCLE: {
                    this.g.drawOval(point.x - n, point.y - n, symbol.size - 1, symbol.size - 1);
                    break;
                }
                case TRIANGLE: {
                    this.g.drawPolygon(this.buildPolygon(point, n, 3, 1.5707963267948966));
                    break;
                }
                case PENTAGON: {
                    this.g.drawPolygon(this.buildPolygon(point, n, 5, 1.5707963267948966));
                    break;
                }
                case HEXAGON: {
                    this.g.drawPolygon(this.buildPolygon(point, n, 6));
                    break;
                }
                case HEPTAGON: {
                    this.g.drawPolygon(this.buildPolygon(point, n, 7, 1.5707963267948966));
                    break;
                }
                case OCTAGON: {
                    this.g.drawPolygon(this.buildPolygon(point, n, 8, 0.39269908169872414));
                    break;
                }
                case NONAGON: {
                    this.g.drawPolygon(this.buildPolygon(point, n, 9, 1.5707963267948966));
                    break;
                }
                case DECAGON: {
                    this.g.drawPolygon(this.buildPolygon(point, n, 10));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.g.setStroke(new BasicStroke());
        }
    }

    public void drawNode(Node node, Color color, int n, boolean bl) {
        if (n <= 0 && !node.isHighlighted()) {
            return;
        }
        Point point = this.nc.getPoint(node);
        if (node.isHighlighted()) {
            this.drawPointHighlight(point, n);
        }
        if (n > 1) {
            if (point.x < 0 || point.y < 0 || point.x > this.nc.getWidth() || point.y > this.nc.getHeight()) {
                return;
            }
            int n2 = n / 2;
            if (this.inactive || node.isDisabled()) {
                this.g.setColor(this.inactiveColor);
            } else {
                this.g.setColor(color);
            }
            if (bl) {
                this.g.fillRect(point.x - n2 - 1, point.y - n2 - 1, n + 1, n + 1);
            } else {
                this.g.drawRect(point.x - n2 - 1, point.y - n2 - 1, n, n);
            }
        }
    }

    private void drawPointHighlight(Point point, int n) {
        this.g.setColor(this.highlightColorTransparent);
        for (int i = n + 7; i >= n; i -= 4) {
            int n2 = (int)Math.floor(i / 2);
            this.g.fillRoundRect(point.x - n2, point.y - n2, i, i, n2, n2);
        }
    }

    public void drawBoxText(Node node, BoxTextElemStyle boxTextElemStyle) {
        Object object;
        FontRenderContext fontRenderContext;
        if (!this.isShowNames() || boxTextElemStyle == null) {
            return;
        }
        Point point = this.nc.getPoint(node);
        TextElement textElement = boxTextElemStyle.text;
        String string = textElement.labelCompositionStrategy.compose(node);
        if (string == null) {
            return;
        }
        Font font = this.g.getFont();
        this.g.setFont(textElement.font);
        int n = point.x + textElement.xOffset;
        int n2 = point.y + textElement.yOffset;
        if (boxTextElemStyle.hAlign == BoxTextElemStyle.HorizontalTextAlignment.RIGHT) {
            n += boxTextElemStyle.box.x + boxTextElemStyle.box.width + 2;
        } else {
            fontRenderContext = this.g.getFontRenderContext();
            object = textElement.font.getStringBounds(string, fontRenderContext);
            int n3 = (int)((RectangularShape)object).getWidth();
            if (boxTextElemStyle.hAlign == BoxTextElemStyle.HorizontalTextAlignment.CENTER) {
                n -= n3 / 2;
            } else if (boxTextElemStyle.hAlign == BoxTextElemStyle.HorizontalTextAlignment.LEFT) {
                n -= -boxTextElemStyle.box.x + 4 + n3;
            } else {
                throw new AssertionError();
            }
        }
        if (boxTextElemStyle.vAlign == BoxTextElemStyle.VerticalTextAlignment.BOTTOM) {
            n2 += boxTextElemStyle.box.y + boxTextElemStyle.box.height;
        } else {
            fontRenderContext = this.g.getFontRenderContext();
            object = textElement.font.getLineMetrics(string, fontRenderContext);
            if (boxTextElemStyle.vAlign == BoxTextElemStyle.VerticalTextAlignment.ABOVE) {
                n2 = (int)((float)n2 - ((float)(-boxTextElemStyle.box.y) + ((LineMetrics)object).getDescent()));
            } else if (boxTextElemStyle.vAlign == BoxTextElemStyle.VerticalTextAlignment.TOP) {
                n2 = (int)((float)n2 - ((float)(-boxTextElemStyle.box.y) - ((LineMetrics)object).getAscent()));
            } else if (boxTextElemStyle.vAlign == BoxTextElemStyle.VerticalTextAlignment.CENTER) {
                n2 = (int)((float)n2 + (((LineMetrics)object).getAscent() - ((LineMetrics)object).getDescent()) / 2.0f);
            } else if (boxTextElemStyle.vAlign == BoxTextElemStyle.VerticalTextAlignment.BELOW) {
                n2 = (int)((float)n2 + ((float)(boxTextElemStyle.box.y + boxTextElemStyle.box.height) + ((LineMetrics)object).getAscent() + 2.0f));
            } else {
                throw new AssertionError();
            }
        }
        if (this.inactive || node.isDisabled()) {
            this.g.setColor(this.inactiveColor);
        } else {
            this.g.setColor(textElement.color);
        }
        if (textElement.haloRadius != null) {
            this.g.setStroke(new BasicStroke(2.0f * textElement.haloRadius.floatValue(), 0, 1));
            this.g.setColor(textElement.haloColor);
            fontRenderContext = this.g.getFontRenderContext();
            object = textElement.font.createGlyphVector(fontRenderContext, string);
            Shape shape = ((GlyphVector)object).getOutline(n, n2);
            this.g.draw(shape);
            this.g.setStroke(new BasicStroke());
            this.g.setColor(textElement.color);
            this.g.fill(shape);
        } else {
            this.g.drawString(string, n, n2);
        }
        this.g.setFont(font);
    }

    private Path2D.Double getPath(Way way) {
        Path2D.Double double_ = new Path2D.Double();
        boolean bl = true;
        for (Node node : way.getNodes()) {
            EastNorth eastNorth = node.getEastNorth();
            if (bl) {
                double_.moveTo(((Point2D)eastNorth).getX(), ((Point2D)eastNorth).getY());
                bl = false;
                continue;
            }
            double_.lineTo(((Point2D)eastNorth).getX(), ((Point2D)eastNorth).getY());
        }
        return double_;
    }

    public void drawArea(Way way, Color color, MapImage<BufferedImage> mapImage, TextElement textElement) {
        this.drawArea(way, this.getPath(way), color, mapImage, textElement);
    }

    protected void drawArea(OsmPrimitive osmPrimitive, Path2D.Double double_, Color color, MapImage<BufferedImage> mapImage, TextElement textElement) {
        Serializable serializable;
        Object object;
        Shape shape = double_.createTransformedShape(this.nc.getAffineTransform());
        if (!this.isOutlineOnly) {
            if (mapImage == null) {
                this.g.setColor(color);
                this.g.fill(shape);
            } else {
                object = new TexturePaint((BufferedImage)mapImage.img, new Rectangle(0, 0, ((BufferedImage)mapImage.img).getWidth(null), ((BufferedImage)mapImage.img).getHeight(null)));
                this.g.setPaint((Paint)object);
                serializable = Utils.color_int2float(mapImage.alpha);
                if (((Float)serializable).floatValue() != 1.0f) {
                    this.g.setComposite(AlphaComposite.getInstance(3, ((Float)serializable).floatValue()));
                }
                this.g.fill(shape);
                this.g.setPaintMode();
            }
        }
        if (textElement != null && this.isShowNames()) {
            if (textElement.labelCompositionStrategy == null) {
                return;
            }
            object = textElement.labelCompositionStrategy.compose(osmPrimitive);
            if (object == null) {
                return;
            }
            serializable = shape.getBounds();
            FontMetrics fontMetrics = this.g.getFontMetrics(this.orderFont);
            Rectangle2D rectangle2D = fontMetrics.getStringBounds((String)object, this.g);
            Rectangle rectangle = new Rectangle(((Rectangle)serializable).x + (int)(((double)((Rectangle)serializable).width - rectangle2D.getWidth()) / 2.0), ((Rectangle)serializable).y + (int)(((double)((Rectangle)serializable).height - rectangle2D.getHeight()) / 2.0), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
            if ((double)((Rectangle)serializable).width >= rectangle2D.getWidth() && (double)((Rectangle)serializable).height >= rectangle2D.getHeight() && shape.contains(rectangle)) {
                this.g.setColor(textElement.color);
                Font font = this.g.getFont();
                this.g.setFont(textElement.font);
                this.g.drawString((String)object, (int)(rectangle.getMinX() - rectangle2D.getMinX()), (int)(rectangle.getMinY() - rectangle2D.getMinY()));
                this.g.setFont(font);
            }
        }
    }

    public void drawArea(Relation relation, Color color, MapImage<BufferedImage> mapImage, TextElement textElement) {
        Multipolygon multipolygon = MultipolygonCache.getInstance().get(this.nc, relation);
        if (!relation.isDisabled() && !multipolygon.getOuterWays().isEmpty()) {
            for (Multipolygon.PolyData polyData : multipolygon.getCombinedPolygons()) {
                Path2D.Double double_ = polyData.get();
                if (!this.isAreaVisible(double_)) continue;
                this.drawArea(relation, double_, polyData.selected ? this.settings.getRelationSelectedColor(color.getAlpha()) : color, mapImage, textElement);
            }
        }
    }

    private boolean isAreaVisible(Path2D.Double double_) {
        Rectangle2D rectangle2D = double_.getBounds2D();
        if (rectangle2D.isEmpty()) {
            return false;
        }
        Point2D point2D = this.nc.getPoint2D(new EastNorth(rectangle2D.getX(), rectangle2D.getY()));
        if (point2D.getX() > (double)this.nc.getWidth()) {
            return false;
        }
        if (point2D.getY() < 0.0) {
            return false;
        }
        point2D = this.nc.getPoint2D(new EastNorth(rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight()));
        if (point2D.getX() < 0.0) {
            return false;
        }
        return !(point2D.getY() > (double)this.nc.getHeight());
    }

    public void drawRestriction(Image image, Point point, double d, double d2, double d3, double d4, double d5, boolean bl) {
        Image image2 = ImageProvider.createRotatedImage(null, image, d5);
        Image image3 = new ImageIcon(image2.getScaledInstance(16, 16, 4)).getImage();
        int n = image3.getWidth(null);
        int n2 = image3.getHeight(null);
        this.g.drawImage(image3, (int)((double)point.x + d + d2) - n / 2, (int)((double)point.y + d3 + d4) - n2 / 2, this.nc);
        if (bl) {
            this.g.setColor(this.relationSelectedColor);
            this.g.drawRect((int)((double)point.x + d + d2) - n / 2 - 2, (int)((double)point.y + d3 + d4) - n2 / 2 - 2, n + 4, n2 + 4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void drawRestriction(Relation relation, MapImage<Image> mapImage) {
        void var7_13;
        Object object;
        Object object2;
        Object object3;
        Way way = null;
        OsmPrimitive osmPrimitive = null;
        Object object4 = null;
        for (RelationMember primitiveId2 : relation.getMembers()) {
            if (primitiveId2.getMember().isIncomplete()) {
                return;
            }
            if (primitiveId2.isWay()) {
                object3 = primitiveId2.getWay();
                if (((Way)object3).getNodesCount() < 2) continue;
                if ("from".equals(primitiveId2.getRole())) {
                    if (way != null) continue;
                    way = object3;
                    continue;
                }
                if ("to".equals(primitiveId2.getRole())) {
                    if (osmPrimitive != null) continue;
                    osmPrimitive = object3;
                    continue;
                }
                if (!"via".equals(primitiveId2.getRole()) || object4 != null) continue;
                object4 = object3;
                continue;
            }
            if (!primitiveId2.isNode()) continue;
            object3 = primitiveId2.getNode();
            if (!"via".equals(primitiveId2.getRole()) || object4 != null) continue;
            object4 = object3;
        }
        if (way == null || osmPrimitive == null || object4 == null) {
            return;
        }
        if (object4 instanceof Node) {
            object2 = (Node)object4;
            if (!way.isFirstLastNode((Node)object2)) {
                return;
            }
        } else {
            Way way2 = (Way)object4;
            object3 = way2.firstNode();
            object = way2.lastNode();
            Boolean bl = false;
            String string = way2.get("oneway");
            if (string != null) {
                if ("-1".equals(string)) {
                    bl = true;
                    Object object5 = object3;
                    object3 = object;
                    object = object5;
                } else {
                    bl = OsmUtils.getOsmBoolean(string);
                    if (bl == null) {
                        bl = false;
                    }
                }
            }
            if (way.isFirstLastNode((Node)object3)) {
                object2 = object3;
            } else if (!bl.booleanValue() && way.isFirstLastNode((Node)object)) {
                object2 = object;
            } else {
                return;
            }
        }
        Object var7_10 = null;
        if (way.firstNode() == object4) {
            Node node = way.getNode(1);
        } else {
            Node node = way.getNode(way.getNodesCount() - 2);
        }
        object3 = this.nc.getPoint((Node)var7_13);
        object = this.nc.getPoint((Node)object2);
        double d = 14.0;
        double d2 = ((Point)object3).x >= ((Point)object).x ? (double)(((Point)object3).x - ((Point)object).x) : (double)(((Point)object).x - ((Point)object3).x);
        double d3 = ((Point)object3).y >= ((Point)object).y ? (double)(((Point)object3).y - ((Point)object).y) : (double)(((Point)object).y - ((Point)object3).y);
        double d4 = d2 == 0.0 ? 1.5707963267948966 : Math.atan(d3 / d2);
        double d5 = Math.toDegrees(d4);
        double d6 = d * Math.cos(d4);
        double d7 = d * Math.sin(d4);
        if (((Point)object3).x < ((Point)object).x) {
            d6 = -d6;
        }
        if (((Point)object3).y < ((Point)object).y) {
            d7 = -d7;
        }
        double d8 = 10.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        if (((Point)object3).x >= ((Point)object).x && ((Point)object3).y >= ((Point)object).y) {
            if (!this.leftHandTraffic) {
                d9 = d8 * Math.cos(Math.toRadians(d5 - 90.0));
                d10 = d8 * Math.sin(Math.toRadians(d5 - 90.0));
            } else {
                d9 = d8 * Math.cos(Math.toRadians(d5 + 90.0));
                d10 = d8 * Math.sin(Math.toRadians(d5 + 90.0));
            }
            d11 = 270.0 + d5;
        }
        if (((Point)object3).x < ((Point)object).x && ((Point)object3).y >= ((Point)object).y) {
            if (!this.leftHandTraffic) {
                d9 = d8 * Math.sin(Math.toRadians(d5));
                d10 = d8 * Math.cos(Math.toRadians(d5));
            } else {
                d9 = d8 * Math.sin(Math.toRadians(d5 + 180.0));
                d10 = d8 * Math.cos(Math.toRadians(d5 + 180.0));
            }
            d11 = 90.0 - d5;
        }
        if (((Point)object3).x < ((Point)object).x && ((Point)object3).y < ((Point)object).y) {
            if (!this.leftHandTraffic) {
                d9 = d8 * Math.cos(Math.toRadians(d5 + 90.0));
                d10 = d8 * Math.sin(Math.toRadians(d5 + 90.0));
            } else {
                d9 = d8 * Math.cos(Math.toRadians(d5 - 90.0));
                d10 = d8 * Math.sin(Math.toRadians(d5 - 90.0));
            }
            d11 = 90.0 + d5;
        }
        if (((Point)object3).x >= ((Point)object).x && ((Point)object3).y < ((Point)object).y) {
            if (!this.leftHandTraffic) {
                d9 = d8 * Math.sin(Math.toRadians(d5 + 180.0));
                d10 = d8 * Math.cos(Math.toRadians(d5 + 180.0));
            } else {
                d9 = d8 * Math.sin(Math.toRadians(d5));
                d10 = d8 * Math.cos(Math.toRadians(d5));
            }
            d11 = 270.0 - d5;
        }
        this.drawRestriction(this.inactive || relation.isDisabled() ? mapImage.getDisabled() : mapImage.img, (Point)object, d6, d9, d7, d10, d11, relation.isSelected());
    }

    public void drawVirtualNodes(Collection<Way> collection, Collection<WaySegment> collection2) {
        if (this.virtualNodeSize == 0) {
            return;
        }
        GeneralPath generalPath = new GeneralPath();
        for (Way object : collection) {
            if (!object.isUsable() || object.isDisabled()) continue;
            this.visitVirtual(generalPath, object);
        }
        this.g.setColor(this.nodeColor);
        this.g.draw(generalPath);
        generalPath = new GeneralPath();
        for (WaySegment waySegment : collection2) {
            if (!waySegment.way.isUsable() || waySegment.way.isDisabled()) continue;
            this.visitVirtual(generalPath, waySegment.toWay());
        }
        this.g.setColor(this.highlightColor);
        this.g.draw(generalPath);
    }

    public void visitVirtual(GeneralPath generalPath, Way way) {
        Iterator<Node> iterator = way.getNodes().iterator();
        if (iterator.hasNext()) {
            Point point = this.nc.getPoint(iterator.next());
            while (iterator.hasNext()) {
                Point point2 = this.nc.getPoint(iterator.next());
                if (this.isSegmentVisible(point, point2) && MapPainter.isLargeSegment(point, point2, this.virtualNodeSpace)) {
                    int n = (point2.x + point.x) / 2;
                    int n2 = (point2.y + point.y) / 2;
                    generalPath.moveTo(n - this.virtualNodeSize, n2);
                    generalPath.lineTo(n + this.virtualNodeSize, n2);
                    generalPath.moveTo(n, n2 - this.virtualNodeSize);
                    generalPath.lineTo(n, n2 + this.virtualNodeSize);
                }
                point = point2;
            }
        }
    }

    private static boolean isLargeSegment(Point point, Point point2, int n) {
        int n2;
        int n3 = point.x - point2.x;
        if (n3 < 0) {
            n3 = -n3;
        }
        if ((n2 = point.y - point2.y) < 0) {
            n2 = -n2;
        }
        return n3 + n2 > n;
    }

    public void drawOrderNumber(Node node, Node node2, int n, Color color) {
        Point point = this.nc.getPoint(node);
        Point point2 = this.nc.getPoint(node2);
        this.drawOrderNumber(point, point2, n, color);
    }

    protected void drawOrderNumber(Point point, Point point2, int n, Color color) {
        if (this.isSegmentVisible(point, point2) && MapPainter.isLargeSegment(point, point2, this.segmentNumberSpace)) {
            String string = Integer.toString(n);
            int n2 = string.length();
            int n3 = (point.x + point2.x) / 2 - 4 * n2;
            int n4 = (point.y + point2.y) / 2 + 4;
            if (this.virtualNodeSize != 0 && MapPainter.isLargeSegment(point, point2, this.virtualNodeSpace)) {
                n4 = (point.y + point2.y) / 2 - this.virtualNodeSize - 3;
            }
            this.g.setColor(this.backgroundColor);
            this.g.fillRect(n3 - 1, n4 - 12, 8 * n2 + 1, 14);
            this.g.setColor(color);
            this.g.drawString(string, n3, n4);
        }
    }

    public boolean isShowNames() {
        return this.showNames;
    }

    public double getCircum() {
        return this.circum;
    }

    public boolean isShowIcons() {
        return this.showIcons;
    }

    public boolean isInactiveMode() {
        return this.inactive;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class OffsetIterator
    implements Iterator<Point> {
        private List<Node> nodes;
        private int offset;
        private int idx;
        private Point prev = null;
        private int x_prev0;
        private int y_prev0;

        public OffsetIterator(List<Node> list, int n) {
            this.nodes = list;
            this.offset = n;
            this.idx = 0;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.nodes.size();
        }

        @Override
        public Point next() {
            if (this.offset == 0) {
                return MapPainter.this.nc.getPoint(this.nodes.get(this.idx++));
            }
            Point point = MapPainter.this.nc.getPoint(this.nodes.get(this.idx));
            if (this.idx == this.nodes.size() - 1) {
                ++this.idx;
                return new Point(this.x_prev0 + point.x - this.prev.x, this.y_prev0 + point.y - this.prev.y);
            }
            Point point2 = MapPainter.this.nc.getPoint(this.nodes.get(this.idx + 1));
            int n = point2.x - point.x;
            int n2 = point2.y - point.y;
            double d = Math.sqrt(n * n + n2 * n2);
            if (d == 0.0) {
                d = 1.0;
            }
            int n3 = point.x + (int)Math.round((double)(this.offset * n2) / d);
            int n4 = point.y - (int)Math.round((double)(this.offset * n) / d);
            if (this.idx == 0) {
                ++this.idx;
                this.prev = point;
                this.x_prev0 = n3;
                this.y_prev0 = n4;
                return new Point(n3, n4);
            }
            int n5 = point.y - this.prev.y;
            int n6 = point.x - this.prev.x;
            int n7 = n * n5 - n6 * n2;
            if (n7 == 0) {
                ++this.idx;
                this.prev = point;
                this.x_prev0 = n3;
                this.y_prev0 = n4;
                return new Point(n3, n4);
            }
            int n8 = n * (n4 - this.y_prev0) - n2 * (n3 - this.x_prev0);
            int n9 = this.x_prev0 + Math.round((float)n8 * (float)n6 / (float)n7);
            int n10 = this.y_prev0 + Math.round((float)n8 * (float)n5 / (float)n7);
            ++this.idx;
            this.prev = point;
            this.x_prev0 = n3;
            this.y_prev0 = n4;
            return new Point(n9, n10);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

