/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.AbstractProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.datum.SevenParameterDatum;
import org.openstreetmap.josm.data.projection.proj.LambertConformalConic;
import org.openstreetmap.josm.tools.I18n;

public class BelgianLambert1972
extends AbstractProjection {
    public BelgianLambert1972() {
        this.ellps = Ellipsoid.hayford;
        this.datum = new SevenParameterDatum("Belgium Datum 72", null, Ellipsoid.hayford, -99.06, 53.32, -112.49, 0.419, -0.83, 1.885, -1.0);
        this.x_0 = 150000.013;
        this.y_0 = 5400088.438;
        this.lon_0 = BelgianLambert1972.convertDegreeMinuteSecond(4.0, 22.0, 2.952);
        double d = 90.0;
        double d2 = 49.0 + BelgianLambert1972.convertMinuteSecond(50.0, 0.00204);
        double d3 = 51.0 + BelgianLambert1972.convertMinuteSecond(10.0, 0.00204);
        this.proj = new LambertConformalConic();
        ((LambertConformalConic)this.proj).updateParameters2SP(this.ellps, d, d2, d3);
    }

    public String getCacheDirectoryName() {
        return "belgianLambert1972";
    }

    public Bounds getWorldBoundsLatLon() {
        return new Bounds(new LatLon(49.51, 2.54), new LatLon(51.5, 6.4));
    }

    public Integer getEpsgCode() {
        return 31370;
    }

    public String toString() {
        return I18n.tr("Belgian Lambert 1972", new Object[0]);
    }
}

