/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.gui.MapMover;
import org.openstreetmap.josm.gui.MapScaler;
import org.openstreetmap.josm.gui.MapSlider;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.PlayHeadMarker;
import org.openstreetmap.josm.tools.AudioPlayer;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapView
extends NavigatableComponent
implements PropertyChangeListener,
Preferences.PreferenceChangedListener {
    public boolean viewportFollowing = false;
    private static final CopyOnWriteArrayList<LayerChangeListener> layerChangeListeners = new CopyOnWriteArrayList();
    private static final CopyOnWriteArrayList<EditLayerChangeListener> editLayerChangeListeners = new CopyOnWriteArrayList();
    private final List<Layer> layers = new ArrayList<Layer>();
    public PlayHeadMarker playHeadMarker = null;
    private Layer activeLayer;
    private OsmDataLayer editLayer;
    public MouseEvent lastMEvent = new MouseEvent(this, 0, 0L, 0, 0, 0, 0, false);
    private LinkedList<MapViewPaintable> temporaryLayers = new LinkedList();
    private BufferedImage nonChangedLayersBuffer;
    private BufferedImage offscreenBuffer;
    private final List<Layer> nonChangedLayers = new ArrayList<Layer>();
    private Layer changedLayer;
    private int lastViewID;
    private boolean paintPreferencesChanged = true;
    private Rectangle lastClipBounds = new Rectangle();
    private boolean virtualNodesEnabled = false;
    private SelectionChangedListener repaintSelectionChangedListener = new SelectionChangedListener(){

        @Override
        public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
            MapView.this.repaint();
        }
    };

    public static void removeLayerChangeListener(LayerChangeListener layerChangeListener) {
        layerChangeListeners.remove(layerChangeListener);
    }

    public static void removeEditLayerChangeListener(EditLayerChangeListener editLayerChangeListener) {
        editLayerChangeListeners.remove(editLayerChangeListener);
    }

    public static void addLayerChangeListener(LayerChangeListener layerChangeListener) {
        if (layerChangeListener != null) {
            layerChangeListeners.addIfAbsent(layerChangeListener);
        }
    }

    public static void addEditLayerChangeListener(EditLayerChangeListener editLayerChangeListener, boolean bl) {
        MapView.addEditLayerChangeListener(editLayerChangeListener);
        if (bl && Main.map != null && Main.map.mapView != null && Main.map.mapView.getEditLayer() != null) {
            MapView.fireEditLayerChanged(null, Main.map.mapView.getEditLayer());
        }
    }

    public static void addEditLayerChangeListener(EditLayerChangeListener editLayerChangeListener) {
        if (editLayerChangeListener != null) {
            editLayerChangeListeners.addIfAbsent(editLayerChangeListener);
        }
    }

    protected static void fireActiveLayerChanged(Layer layer, Layer layer2) {
        for (LayerChangeListener layerChangeListener : layerChangeListeners) {
            layerChangeListener.activeLayerChange(layer, layer2);
        }
    }

    protected static void fireLayerAdded(Layer layer) {
        for (LayerChangeListener layerChangeListener : layerChangeListeners) {
            layerChangeListener.layerAdded(layer);
        }
    }

    protected static void fireLayerRemoved(Layer layer) {
        for (LayerChangeListener layerChangeListener : layerChangeListeners) {
            layerChangeListener.layerRemoved(layer);
        }
    }

    protected static void fireEditLayerChanged(OsmDataLayer osmDataLayer, OsmDataLayer osmDataLayer2) {
        for (EditLayerChangeListener editLayerChangeListener : editLayerChangeListeners) {
            editLayerChangeListener.editLayerChanged(osmDataLayer, osmDataLayer2);
        }
    }

    public MapView(final JPanel jPanel) {
        Main.pref.addPreferenceChangeListener(this);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                MapView.this.removeComponentListener(this);
                MapSlider mapSlider = new MapSlider(MapView.this);
                MapView.this.add(mapSlider);
                mapSlider.setBounds(3, 0, 114, 30);
                MapScaler mapScaler = new MapScaler(MapView.this);
                MapView.this.add(mapScaler);
                mapScaler.setLocation(10, 30);
                new MapMover(MapView.this, jPanel);
                OsmDataLayer osmDataLayer = MapView.this.getEditLayer();
                if (osmDataLayer != null) {
                    if (!MapView.this.zoomToDataSetBoundingBox(osmDataLayer.data)) {
                        AutoScaleAction.autoScale("data");
                    }
                } else {
                    AutoScaleAction.autoScale("layer");
                }
            }
        });
        DataSet.addSelectionListener(this.repaintSelectionChangedListener);
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent mouseEvent) {
                this.mouseMoved(mouseEvent);
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                MapView.this.lastMEvent = mouseEvent;
            }
        });
        MapView.addLayerChangeListener(MultipolygonCache.getInstance());
    }

    protected void addGpxLayer(GpxLayer gpxLayer) {
        if (this.layers.isEmpty()) {
            this.layers.add(gpxLayer);
            return;
        }
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            if (!(this.layers.get(i) instanceof OsmDataLayer)) continue;
            if (i == this.layers.size() - 1) {
                this.layers.add(gpxLayer);
            } else {
                this.layers.add(i + 1, gpxLayer);
            }
            return;
        }
        this.layers.add(0, gpxLayer);
    }

    public void addLayer(Layer layer) {
        if (layer instanceof MarkerLayer && this.playHeadMarker == null) {
            this.playHeadMarker = PlayHeadMarker.create();
        }
        if (layer instanceof GpxLayer) {
            this.addGpxLayer((GpxLayer)layer);
        } else if (layer.isBackgroundLayer() || this.layers.isEmpty()) {
            this.layers.add(layer);
        } else {
            this.layers.add(0, layer);
        }
        MapView.fireLayerAdded(layer);
        if (layer instanceof OsmDataLayer || this.activeLayer == null) {
            this.setActiveLayer(layer);
        }
        layer.addPropertyChangeListener(this);
        Main.addProjectionChangeListener(layer);
        AudioPlayer.reset();
        this.repaint();
    }

    @Override
    protected DataSet getCurrentDataSet() {
        if (this.editLayer != null) {
            return this.editLayer.data;
        }
        return null;
    }

    public boolean isActiveLayerDrawable() {
        return this.editLayer != null;
    }

    public boolean isActiveLayerVisible() {
        return this.isActiveLayerDrawable() && this.editLayer.isVisible();
    }

    protected Layer determineNextActiveLayer(List<Layer> list) {
        for (Layer layer : list) {
            if (!(layer instanceof OsmDataLayer)) continue;
            return layer;
        }
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public void removeLayer(Layer layer) {
        ArrayList<Layer> arrayList = new ArrayList<Layer>(this.layers);
        if (!arrayList.remove(layer)) {
            return;
        }
        this.setEditLayer(arrayList);
        if (layer == this.activeLayer) {
            this.setActiveLayer(this.determineNextActiveLayer(arrayList), false);
        }
        this.layers.remove(layer);
        Main.removeProjectionChangeListener(layer);
        MapView.fireLayerRemoved(layer);
        layer.removePropertyChangeListener(this);
        layer.destroy();
        AudioPlayer.reset();
        this.repaint();
    }

    public void setVirtualNodesEnabled(boolean bl) {
        if (this.virtualNodesEnabled != bl) {
            this.virtualNodesEnabled = bl;
            this.repaint();
        }
    }

    public boolean isVirtualNodesEnabled() {
        return this.virtualNodesEnabled;
    }

    public void moveLayer(Layer layer, int n) {
        int n2 = this.layers.indexOf(layer);
        if (n2 == -1) {
            throw new IllegalArgumentException(I18n.tr("Layer not in list.", new Object[0]));
        }
        if (n == n2) {
            return;
        }
        this.layers.remove(n2);
        if (n >= this.layers.size()) {
            this.layers.add(layer);
        } else {
            this.layers.add(n, layer);
        }
        this.setEditLayer(this.layers);
        AudioPlayer.reset();
        this.repaint();
    }

    public int getLayerPos(Layer layer) {
        int n = this.layers.indexOf(layer);
        if (n == -1) {
            throw new IllegalArgumentException(I18n.tr("Layer not in list.", new Object[0]));
        }
        return n;
    }

    protected List<Layer> getVisibleLayersInZOrder() {
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        for (Layer layer : this.layers) {
            if (!layer.isVisible()) continue;
            arrayList.add(layer);
        }
        Collections.sort(arrayList, new Comparator<Layer>(){

            @Override
            public int compare(Layer layer, Layer layer2) {
                if (layer instanceof OsmDataLayer && layer2 instanceof OsmDataLayer) {
                    if (layer == MapView.this.getActiveLayer()) {
                        return -1;
                    }
                    if (layer2 == MapView.this.getActiveLayer()) {
                        return 1;
                    }
                    return Integer.valueOf(MapView.this.layers.indexOf(layer)).compareTo(MapView.this.layers.indexOf(layer2));
                }
                return Integer.valueOf(MapView.this.layers.indexOf(layer)).compareTo(MapView.this.layers.indexOf(layer2));
            }
        });
        Collections.reverse(arrayList);
        return arrayList;
    }

    private void paintLayer(Layer layer, Graphics2D graphics2D, Bounds bounds) {
        if (layer.getOpacity() < 1.0) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, (float)layer.getOpacity()));
        }
        layer.paint(graphics2D, this, bounds);
        graphics2D.setPaintMode();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void paint(Graphics graphics) {
        double d;
        int n;
        int d2;
        Graphics2D bounds2;
        boolean bl;
        if (BugReportExceptionHandler.exceptionHandlingInProgress()) {
            return;
        }
        if (this.center == null) {
            return;
        }
        List<Layer> list = this.getVisibleLayersInZOrder();
        int n3 = 0;
        for (Layer object2 : list) {
            if (object2.isChanged() || object2 == this.changedLayer) break;
            ++n3;
        }
        boolean bl2 = bl = !this.paintPreferencesChanged && this.nonChangedLayers.size() <= n3 && this.lastViewID == this.getViewID() && this.lastClipBounds.contains(graphics.getClipBounds());
        if (bl) {
            void var5_8;
            boolean i = false;
            while (var5_8 < this.nonChangedLayers.size()) {
                if (list.get((int)var5_8) != this.nonChangedLayers.get((int)var5_8)) {
                    bl = false;
                    break;
                }
                ++var5_8;
            }
        }
        if (null == this.offscreenBuffer || this.offscreenBuffer.getWidth() != this.getWidth() || this.offscreenBuffer.getHeight() != this.getHeight()) {
            this.offscreenBuffer = new BufferedImage(this.getWidth(), this.getHeight(), 5);
        }
        Graphics2D graphics2D = this.offscreenBuffer.createGraphics();
        graphics2D.setClip(graphics.getClip());
        Bounds bounds = this.getLatLonBounds(graphics.getClipBounds());
        if (!bl || this.nonChangedLayersBuffer == null) {
            if (null == this.nonChangedLayersBuffer || this.nonChangedLayersBuffer.getWidth() != this.getWidth() || this.nonChangedLayersBuffer.getHeight() != this.getHeight()) {
                this.nonChangedLayersBuffer = new BufferedImage(this.getWidth(), this.getHeight(), 5);
            }
            bounds2 = this.nonChangedLayersBuffer.createGraphics();
            bounds2.setClip(graphics.getClip());
            bounds2.setColor(PaintColors.getBackgroundColor());
            bounds2.fillRect(0, 0, this.getWidth(), this.getHeight());
            for (d2 = 0; d2 < n3; ++d2) {
                this.paintLayer(list.get(d2), bounds2, bounds);
            }
        } else if (this.nonChangedLayers.size() != n3) {
            bounds2 = this.nonChangedLayersBuffer.createGraphics();
            bounds2.setClip(graphics.getClip());
            for (d2 = this.nonChangedLayers.size(); d2 < n3; ++d2) {
                this.paintLayer(list.get(d2), bounds2, bounds);
            }
        }
        this.nonChangedLayers.clear();
        this.changedLayer = null;
        for (n = 0; n < n3; ++n) {
            this.nonChangedLayers.add(list.get(n));
        }
        this.lastViewID = this.getViewID();
        this.paintPreferencesChanged = false;
        this.lastClipBounds = graphics.getClipBounds();
        graphics2D.drawImage((Image)this.nonChangedLayersBuffer, 0, 0, null);
        for (n = n3; n < list.size(); ++n) {
            this.paintLayer(list.get(n), graphics2D, bounds);
        }
        for (MapViewPaintable mapViewPaintable : this.temporaryLayers) {
            mapViewPaintable.paint(graphics2D, this, bounds);
        }
        graphics2D.setColor(Color.WHITE);
        Bounds bounds3 = this.getProjection().getWorldBoundsLatLon();
        double d3 = bounds3.getMin().lon();
        Point point = this.getPoint(bounds3.getMin());
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(point.x, point.y);
        double d4 = bounds3.getMax().lat();
        for (d = bounds3.getMin().lat(); d <= d4; d += 1.0) {
            point = this.getPoint(new LatLon(d >= d4 ? d4 : d, d3));
            generalPath.lineTo(point.x, point.y);
        }
        d = d4;
        d4 = bounds3.getMax().lon();
        while (d3 <= d4) {
            point = this.getPoint(new LatLon(d, d3 >= d4 ? d4 : d3));
            generalPath.lineTo(point.x, point.y);
            d3 += 1.0;
        }
        d3 = d4;
        d4 = bounds3.getMin().lat();
        while (d >= d4) {
            point = this.getPoint(new LatLon(d <= d4 ? d4 : d, d3));
            generalPath.lineTo(point.x, point.y);
            d -= 1.0;
        }
        d = d4;
        d4 = bounds3.getMin().lon();
        while (d3 >= d4) {
            point = this.getPoint(new LatLon(d, d3 <= d4 ? d4 : d3));
            generalPath.lineTo(point.x, point.y);
            d3 -= 1.0;
        }
        int n2 = this.getWidth();
        int n4 = this.getHeight();
        Area area = new Area(generalPath);
        Area area2 = new Area(new Rectangle(-1, -1, n2 + 2, n4 + 2));
        area.intersect(area2);
        graphics2D.draw(area);
        if (Main.map != null && Main.map.filterDialog != null) {
            Main.map.filterDialog.drawOSDText(graphics2D);
        }
        if (this.playHeadMarker != null) {
            this.playHeadMarker.paint(graphics2D, this);
        }
        graphics.drawImage(this.offscreenBuffer, 0, 0, null);
        super.paint(graphics);
    }

    public void recalculateCenterScale(BoundingXYVisitor boundingXYVisitor) {
        if (boundingXYVisitor == null) {
            boundingXYVisitor = new BoundingXYVisitor();
        }
        if (boundingXYVisitor.getBounds() == null) {
            boundingXYVisitor.visit(this.getProjection().getWorldBoundsLatLon());
        }
        if (!boundingXYVisitor.hasExtend()) {
            boundingXYVisitor.enlargeBoundingBox();
        }
        this.zoomTo(boundingXYVisitor.getBounds());
    }

    public Collection<Layer> getAllLayers() {
        return Collections.unmodifiableCollection(this.layers);
    }

    public List<Layer> getAllLayersAsList() {
        return Collections.unmodifiableList(this.layers);
    }

    public <T> List<T> getLayersOfType(Class<T> clazz) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Layer layer : this.getAllLayersAsList()) {
            if (!clazz.isInstance(layer)) continue;
            arrayList.add(clazz.cast(layer));
        }
        return arrayList;
    }

    public int getNumLayers() {
        return this.layers.size();
    }

    public boolean hasLayers() {
        return this.getNumLayers() > 0;
    }

    private void setEditLayer(List<Layer> list) {
        OsmDataLayer osmDataLayer = list.contains(this.editLayer) ? this.editLayer : null;
        OsmDataLayer osmDataLayer2 = this.editLayer;
        if (this.activeLayer != this.editLayer || !list.contains(this.editLayer)) {
            if (this.activeLayer instanceof OsmDataLayer && list.contains(this.activeLayer)) {
                osmDataLayer = (OsmDataLayer)this.activeLayer;
            } else {
                for (Layer layer : list) {
                    if (!(layer instanceof OsmDataLayer)) continue;
                    osmDataLayer = (OsmDataLayer)layer;
                    break;
                }
            }
        }
        if (osmDataLayer != this.editLayer) {
            if (osmDataLayer == null) {
                this.getCurrentDataSet().setSelected(new PrimitiveId[0]);
            }
            this.editLayer = osmDataLayer;
            MapView.fireEditLayerChanged(osmDataLayer2, osmDataLayer);
            this.refreshTitle();
        }
    }

    public void setActiveLayer(Layer layer) {
        this.setActiveLayer(layer, true);
    }

    private void setActiveLayer(Layer layer, boolean bl) {
        if (layer != null && !this.layers.contains(layer)) {
            throw new IllegalArgumentException(I18n.tr("Layer ''{0}'' must be in list of layers", layer.toString()));
        }
        if (layer == this.activeLayer) {
            return;
        }
        Layer layer2 = this.activeLayer;
        this.activeLayer = layer;
        if (bl) {
            this.setEditLayer(this.layers);
        }
        MapView.fireActiveLayerChanged(layer2, layer);
        Enumeration<AbstractButton> enumeration = Main.map.toolGroup.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = enumeration.nextElement();
            MapMode mapMode = (MapMode)abstractButton.getAction();
            boolean bl2 = mapMode.layerIsSupported(layer);
            abstractButton.setEnabled(bl2);
            if (bl2) {
                Main.registerActionShortcut(mapMode, mapMode.getShortcut());
                continue;
            }
            Main.unregisterActionShortcut(mapMode.getShortcut());
        }
        AudioPlayer.reset();
        this.repaint();
    }

    public Layer getActiveLayer() {
        return this.activeLayer;
    }

    public OsmDataLayer getEditLayer() {
        return this.editLayer;
    }

    public boolean hasLayer(Layer layer) {
        return this.layers.contains(layer);
    }

    public boolean zoomToDataSetBoundingBox(DataSet dataSet) {
        OsmDataLayer osmDataLayer = this.getEditLayer();
        if (osmDataLayer == null) {
            return false;
        }
        Collection<DataSource> collection = dataSet.dataSources;
        BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
        for (DataSource dataSource : collection) {
            boundingXYVisitor.visit(dataSource.bounds);
        }
        if (boundingXYVisitor.hasExtend()) {
            this.recalculateCenterScale(boundingXYVisitor);
            return true;
        }
        return false;
    }

    public boolean addTemporaryLayer(MapViewPaintable mapViewPaintable) {
        if (this.temporaryLayers.contains(mapViewPaintable)) {
            return false;
        }
        return this.temporaryLayers.add(mapViewPaintable);
    }

    public boolean removeTemporaryLayer(MapViewPaintable mapViewPaintable) {
        return this.temporaryLayers.remove(mapViewPaintable);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        OsmDataLayer osmDataLayer;
        if (propertyChangeEvent.getPropertyName().equals(Layer.VISIBLE_PROP)) {
            this.repaint();
        } else if (propertyChangeEvent.getPropertyName().equals(Layer.OPACITY_PROP)) {
            Layer layer = (Layer)propertyChangeEvent.getSource();
            if (layer.isVisible()) {
                this.changedLayer = layer;
                this.repaint();
            }
        } else if ((propertyChangeEvent.getPropertyName().equals(OsmDataLayer.REQUIRES_SAVE_TO_DISK_PROP) || propertyChangeEvent.getPropertyName().equals(OsmDataLayer.REQUIRES_UPLOAD_TO_SERVER_PROP)) && (osmDataLayer = (OsmDataLayer)propertyChangeEvent.getSource()) == this.getEditLayer()) {
            this.refreshTitle();
        }
    }

    protected void refreshTitle() {
        boolean bl;
        boolean bl2 = bl = this.editLayer != null && (this.editLayer.requiresSaveToFile() || this.editLayer.requiresUploadToServer());
        if (bl) {
            JOptionPane.getFrameForComponent(Main.parent).setTitle("* " + I18n.tr("Java OpenStreetMap Editor", new Object[0]));
        } else {
            JOptionPane.getFrameForComponent(Main.parent).setTitle(I18n.tr("Java OpenStreetMap Editor", new Object[0]));
        }
    }

    @Override
    public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
        this.paintPreferencesChanged = true;
    }

    public void destroy() {
        Main.pref.removePreferenceChangeListener(this);
        DataSet.removeSelectionListener(this.repaintSelectionChangedListener);
        MultipolygonCache.getInstance().clear(this);
    }

    public static interface EditLayerChangeListener {
        public void editLayerChanged(OsmDataLayer var1, OsmDataLayer var2);
    }

    public static interface LayerChangeListener {
        public void activeLayerChange(Layer var1, Layer var2);

        public void layerAdded(Layer var1);

        public void layerRemoved(Layer var1);
    }
}

