/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPainter;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.MapImage;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.TextElement;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AreaElemStyle
extends ElemStyle {
    public Color color;
    public MapImage<BufferedImage> fillImage;
    public TextElement text;

    protected AreaElemStyle(Cascade cascade, Color color, MapImage<BufferedImage> mapImage, TextElement textElement) {
        super(cascade, -1000.0f);
        CheckParameterUtil.ensureParameterNotNull(color);
        this.color = color;
        this.fillImage = mapImage;
        this.text = textElement;
    }

    public static AreaElemStyle create(Cascade cascade) {
        Object object;
        Object object2;
        MapImage<BufferedImage> mapImage = null;
        Color color = null;
        MapPaintStyles.IconReference iconReference = cascade.get("fill-image", null, MapPaintStyles.IconReference.class);
        if (iconReference != null) {
            object2 = MapPaintStyles.getIcon(iconReference, -1, -1);
            if (object2 != null) {
                if (!(((ImageIcon)object2).getImage() instanceof BufferedImage)) {
                    throw new RuntimeException();
                }
                mapImage = new MapImage<BufferedImage>(iconReference.iconName, iconReference.source);
                mapImage.img = (BufferedImage)((ImageIcon)object2).getImage();
                color = new Color(((BufferedImage)mapImage.img).getRGB(((BufferedImage)mapImage.img).getWidth() / 2, ((BufferedImage)mapImage.img).getHeight() / 2));
                mapImage.alpha = Math.min(255, Math.max(0, Main.pref.getInteger("mappaint.fill-image-alpha", 255)));
                object = Utils.color_float2int(cascade.get("fill-opacity", null, Float.TYPE));
                if (object != null) {
                    mapImage.alpha = (Integer)object;
                }
            }
        } else {
            color = cascade.get("fill-color", null, Color.class);
            if (color != null) {
                int n = Math.min(255, Math.max(0, Main.pref.getInteger("mappaint.fillalpha", 50)));
                object = Utils.color_float2int(cascade.get("fill-opacity", null, Float.TYPE));
                if (object != null) {
                    n = (Integer)object;
                }
                color = new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
            }
        }
        object2 = null;
        object = cascade.get("text-position", null, Keyword.class);
        if (object == null || Utils.equal(((Keyword)object).val, "center")) {
            object2 = TextElement.create(cascade, PaintColors.AREA_TEXT.get(), true);
        }
        if (color != null) {
            return new AreaElemStyle(cascade, color, mapImage, (TextElement)object2);
        }
        return null;
    }

    @Override
    public void paintPrimitive(OsmPrimitive osmPrimitive, MapPaintSettings mapPaintSettings, MapPainter mapPainter, boolean bl, boolean bl2) {
        if (osmPrimitive instanceof Way) {
            Color color = this.color;
            if (this.color != null && osmPrimitive.isSelected()) {
                color = mapPaintSettings.getSelectedColor(this.color.getAlpha());
            }
            mapPainter.drawArea((Way)osmPrimitive, color, this.fillImage, this.text);
        } else if (osmPrimitive instanceof Relation) {
            Color color = this.color;
            if (this.color != null && bl) {
                color = mapPaintSettings.getRelationSelectedColor(this.color.getAlpha());
            }
            mapPainter.drawArea((Relation)osmPrimitive, color, this.fillImage, this.text);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        AreaElemStyle areaElemStyle = (AreaElemStyle)object;
        if (!Utils.equal(this.fillImage, areaElemStyle.fillImage)) {
            return false;
        }
        if (!Utils.equal(this.color, areaElemStyle.color)) {
            return false;
        }
        return Utils.equal(this.text, areaElemStyle.text);
    }

    @Override
    public int hashCode() {
        int n = 3;
        n = 61 * n + this.color.hashCode();
        n = 61 * n + (this.fillImage != null ? this.fillImage.hashCode() : 0);
        n = 61 * n + (this.text != null ? this.text.hashCode() : 0);
        return n;
    }

    @Override
    public String toString() {
        return "AreaElemStyle{" + super.toString() + "color=" + Utils.toString(this.color) + " fillImage=[" + this.fillImage + "]}";
    }
}

