/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.advanced;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.advanced.AdvancedPreference;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.WindowGeometry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListEditor
extends ExtendedDialog {
    List<String> data;
    AdvancedPreference.PrefEntry entry;

    public ListEditor(PreferenceTabbedPane preferenceTabbedPane, AdvancedPreference.PrefEntry prefEntry, Preferences.ListSetting listSetting) {
        super(preferenceTabbedPane, I18n.tr("Change list setting", new Object[0]), new String[]{I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0])});
        this.entry = prefEntry;
        List list = (List)listSetting.getValue();
        this.data = list != null ? new ArrayList<String>(list) : new ArrayList<String>();
        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        this.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(preferenceTabbedPane, new Dimension(300, 350)));
        this.setContent(this.build(), false);
    }

    public List<String> getData() {
        return this.data;
    }

    protected JPanel build() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Key: {0}", this.entry.getKey())), GBC.eol().insets(0, 0, 5, 0));
        ListSettingTableModel listSettingTableModel = new ListSettingTableModel();
        JTable jTable = new JTable(listSettingTableModel);
        jTable.putClientProperty("terminateEditOnFocusLost", true);
        jTable.setTableHeader(null);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(new JTextField());
        defaultCellEditor.setClickCountToStart(1);
        jTable.setDefaultEditor(jTable.getColumnClass(0), defaultCellEditor);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jPanel.add((Component)jScrollPane, GBC.eol().insets(5, 10, 0, 0).fill());
        return jPanel;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ListSettingTableModel
    extends AbstractTableModel {
        ListSettingTableModel() {
        }

        public List<String> getData() {
            return ListEditor.this.data;
        }

        @Override
        public int getRowCount() {
            return ListEditor.this.data.size() + 1;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return ListEditor.this.data.size() == n ? "" : ListEditor.this.data.get(n);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            String string = (String)object;
            if (n == ListEditor.this.data.size()) {
                ListEditor.this.data.add(string);
                this.fireTableRowsInserted(n + 1, n + 1);
            } else {
                ListEditor.this.data.set(n, string);
            }
            this.fireTableCellUpdated(n, n2);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }
    }
}

