/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.shortcut;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefJPanel
extends JPanel {
    private AbstractTableModel model;
    private static int[] modifInts = new int[]{-1, 0, 64, 128, 512, 256, 192, 576, 320, 640, 384, 768, 704, 832};
    private static String[] modifList = new String[]{I18n.tr("disabled", new Object[0]), I18n.tr("no modifier", new Object[0]), KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, modifInts[2]).getModifiers()), KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, modifInts[3]).getModifiers()), KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, modifInts[4]).getModifiers()), KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, modifInts[5]).getModifiers()), KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, modifInts[6]).getModifiers()), KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, modifInts[7]).getModifiers()), KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, modifInts[8]).getModifiers()), KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, modifInts[9]).getModifiers()), KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, modifInts[10]).getModifiers()), KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, modifInts[11]).getModifiers()), KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, modifInts[12]).getModifiers()), KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, modifInts[13]).getModifiers())};
    private static String SHIFT = KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, 64).getModifiers());
    private static String CTRL = KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, 128).getModifiers());
    private static String ALT = KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, 512).getModifiers());
    private static String META = KeyEvent.getKeyModifiersText(KeyStroke.getKeyStroke(65, 256).getModifiers());
    private static Map<Integer, String> keyList = PrefJPanel.setKeyList();
    private JCheckBox cbAlt = new JCheckBox();
    private JCheckBox cbCtrl = new JCheckBox();
    private JCheckBox cbMeta = new JCheckBox();
    private JCheckBox cbShift = new JCheckBox();
    private JCheckBox cbDefault = new JCheckBox();
    private JCheckBox cbDisable = new JCheckBox();
    private JComboBox tfKey = new JComboBox();
    JTable shortcutTable = new JTable();
    private JTextField filterField = new JTextField();

    private static Map<Integer, String> setKeyList() {
        LinkedHashMap<Integer, String> linkedHashMap = new LinkedHashMap<Integer, String>();
        String string = Toolkit.getProperty("AWT.unknown", "Unknown");
        for (Field field : KeyEvent.class.getFields()) {
            if (!field.getName().startsWith("VK_")) continue;
            try {
                int n = field.getInt(null);
                String string2 = KeyEvent.getKeyText(n);
                if (string2 == null || string2.length() <= 0 || string2.contains(string)) continue;
                linkedHashMap.put(n, string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        linkedHashMap.put(-1, "");
        return linkedHashMap;
    }

    public PrefJPanel(AbstractTableModel abstractTableModel) {
        this.model = abstractTableModel;
        this.initComponents();
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        JPanel jPanel2 = new JPanel();
        CbAction cbAction = new CbAction(this);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.buildFilterPanel());
        jPanel.setLayout(new GridLayout());
        this.shortcutTable.setModel(this.model);
        this.shortcutTable.getSelectionModel().addListSelectionListener(new CbAction(this));
        this.shortcutTable.setFillsViewportHeight(true);
        this.shortcutTable.setSelectionMode(0);
        this.shortcutTable.setAutoCreateRowSorter(true);
        TableColumnModel tableColumnModel = this.shortcutTable.getColumnModel();
        tableColumnModel.getColumn(0).setCellRenderer(new ShortcutTableCellRenderer(true));
        tableColumnModel.getColumn(1).setCellRenderer(new ShortcutTableCellRenderer(false));
        jScrollPane.setViewportView(this.shortcutTable);
        jPanel.add(jScrollPane);
        this.add(jPanel);
        jPanel2.setLayout(new GridLayout(5, 2));
        this.cbDefault.setAction(cbAction);
        this.cbDefault.setText(I18n.tr("Use default", new Object[0]));
        this.cbShift.setAction(cbAction);
        this.cbShift.setText(SHIFT);
        this.cbDisable.setAction(cbAction);
        this.cbDisable.setText(I18n.tr("Disable", new Object[0]));
        this.cbCtrl.setAction(cbAction);
        this.cbCtrl.setText(CTRL);
        this.cbAlt.setAction(cbAction);
        this.cbAlt.setText(ALT);
        this.tfKey.setAction(cbAction);
        this.tfKey.setModel(new DefaultComboBoxModel<Object>(keyList.values().toArray()));
        this.cbMeta.setAction(cbAction);
        this.cbMeta.setText(META);
        jPanel2.add(this.cbDefault);
        jPanel2.add(new JLabel());
        jPanel2.add(this.cbShift);
        jPanel2.add(this.cbDisable);
        jPanel2.add(this.cbCtrl);
        jPanel2.add(new JLabel(I18n.tr("Key:", new Object[0]), 2));
        jPanel2.add(this.cbAlt);
        jPanel2.add(this.tfKey);
        jPanel2.add(this.cbMeta);
        jPanel2.add(new JLabel(I18n.tr("Attention: Use real keyboard keys only!", new Object[0])));
        cbAction.actionPerformed(null);
        this.add(jPanel2);
    }

    private JPanel buildFilterPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)new JLabel(I18n.tr("Search:", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.filterField, gridBagConstraints);
        this.filterField.setToolTipText(I18n.tr("Enter a search expression", new Object[0]));
        SelectAllOnFocusGainedDecorator.decorate(this.filterField);
        this.filterField.getDocument().addDocumentListener(new FilterFieldAdapter());
        jPanel.setMaximumSize(new Dimension(300, 10));
        return jPanel;
    }

    private void disableAllModifierCheckboxes() {
        this.cbDefault.setEnabled(false);
        this.cbDisable.setEnabled(false);
        this.cbShift.setEnabled(false);
        this.cbCtrl.setEnabled(false);
        this.cbAlt.setEnabled(false);
        this.cbMeta.setEnabled(false);
    }

    class FilterFieldAdapter
    implements DocumentListener {
        FilterFieldAdapter() {
        }

        public void filter() {
            String string = PrefJPanel.this.filterField.getText().trim();
            if (string.length() == 0) {
                string = null;
            }
            try {
                TableRowSorter tableRowSorter = (TableRowSorter)PrefJPanel.this.shortcutTable.getRowSorter();
                if (string == null) {
                    tableRowSorter.setRowFilter(null);
                } else {
                    ArrayList arrayList = new ArrayList();
                    for (String string2 : string.split("\\s+")) {
                        arrayList.add(RowFilter.regexFilter("(?i)" + string2, new int[0]));
                    }
                    tableRowSorter.setRowFilter(RowFilter.andFilter(arrayList));
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.filter();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.filter();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.filter();
        }
    }

    private class CbAction
    extends AbstractAction
    implements ListSelectionListener {
        private PrefJPanel panel;

        public CbAction(PrefJPanel prefJPanel2) {
            this.panel = prefJPanel2;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = this.panel.shortcutTable.getSelectionModel();
            if (!listSelectionModel.isSelectionEmpty()) {
                int n = this.panel.shortcutTable.convertRowIndexToModel(listSelectionModel.getMinSelectionIndex());
                Shortcut shortcut = (Shortcut)this.panel.model.getValueAt(n, -1);
                this.panel.cbDefault.setSelected(!shortcut.getAssignedUser());
                this.panel.cbDisable.setSelected(shortcut.getKeyStroke() == null);
                this.panel.cbShift.setSelected(shortcut.getAssignedModifier() != -1 && (shortcut.getAssignedModifier() & 0x40) != 0);
                this.panel.cbCtrl.setSelected(shortcut.getAssignedModifier() != -1 && (shortcut.getAssignedModifier() & 0x80) != 0);
                this.panel.cbAlt.setSelected(shortcut.getAssignedModifier() != -1 && (shortcut.getAssignedModifier() & 0x200) != 0);
                this.panel.cbMeta.setSelected(shortcut.getAssignedModifier() != -1 && (shortcut.getAssignedModifier() & 0x100) != 0);
                if (shortcut.getKeyStroke() != null) {
                    PrefJPanel.this.tfKey.setSelectedItem(keyList.get(shortcut.getKeyStroke().getKeyCode()));
                } else {
                    PrefJPanel.this.tfKey.setSelectedItem(keyList.get(-1));
                }
                if (!shortcut.isChangeable()) {
                    PrefJPanel.this.disableAllModifierCheckboxes();
                    this.panel.tfKey.setEnabled(false);
                } else {
                    this.panel.cbDefault.setEnabled(true);
                    this.actionPerformed(null);
                }
                PrefJPanel.this.model.fireTableRowsUpdated(n, n);
            } else {
                this.panel.disableAllModifierCheckboxes();
                this.panel.tfKey.setEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ListSelectionModel listSelectionModel = this.panel.shortcutTable.getSelectionModel();
            if (listSelectionModel != null && !listSelectionModel.isSelectionEmpty()) {
                if (actionEvent != null) {
                    int bl = this.panel.shortcutTable.convertRowIndexToModel(listSelectionModel.getMinSelectionIndex());
                    Shortcut shortcut = (Shortcut)this.panel.model.getValueAt(bl, -1);
                    if (this.panel.cbDisable.isSelected()) {
                        shortcut.setAssignedModifier(-1);
                    } else if (this.panel.tfKey.getSelectedItem().equals("")) {
                        shortcut.setAssignedModifier(3);
                    } else {
                        shortcut.setAssignedModifier((this.panel.cbShift.isSelected() ? 64 : 0) | (this.panel.cbCtrl.isSelected() ? 128 : 0) | (this.panel.cbAlt.isSelected() ? 512 : 0) | (this.panel.cbMeta.isSelected() ? 256 : 0));
                        for (Map.Entry entry : keyList.entrySet()) {
                            if (!((String)entry.getValue()).equals(this.panel.tfKey.getSelectedItem())) continue;
                            shortcut.setAssignedKey((Integer)entry.getKey());
                        }
                    }
                    shortcut.setAssignedUser(!this.panel.cbDefault.isSelected());
                    this.valueChanged(null);
                }
                boolean bl = !this.panel.cbDefault.isSelected();
                this.panel.cbDisable.setEnabled(bl);
                boolean bl2 = bl && !this.panel.cbDisable.isSelected();
                this.panel.cbShift.setEnabled(bl2);
                this.panel.cbCtrl.setEnabled(bl2);
                this.panel.cbAlt.setEnabled(bl2);
                this.panel.cbMeta.setEnabled(bl2);
                this.panel.tfKey.setEnabled(bl2);
            } else {
                this.panel.disableAllModifierCheckboxes();
                this.panel.tfKey.setEnabled(false);
            }
        }
    }

    private static class ShortcutTableCellRenderer
    extends DefaultTableCellRenderer {
        private boolean name;

        public ShortcutTableCellRenderer(boolean bl) {
            this.name = bl;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof Shortcut) {
                Shortcut shortcut = (Shortcut)object;
                JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, this.name ? shortcut.getLongText() : shortcut.getKeyText(), bl, bl2, n, n2);
                jLabel.setBackground(Main.pref.getUIColor("Table.background"));
                if (bl) {
                    jLabel.setForeground(Main.pref.getUIColor("Table.foreground"));
                }
                if (shortcut.getAssignedUser()) {
                    jLabel.setBackground(Main.pref.getColor(I18n.marktr("Shortcut Background: User"), new Color(200, 255, 200)));
                } else if (!shortcut.getAssignedDefault()) {
                    jLabel.setBackground(Main.pref.getColor(I18n.marktr("Shortcut Background: Modified"), new Color(255, 255, 200)));
                }
                return jLabel;
            }
            return null;
        }
    }
}

