/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;

public class ImportHandler
extends RequestHandler {
    public static final String command = "import";
    public static final String permissionKey = "remotecontrol.permission.import";
    public static final boolean permissionDefault = true;

    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException {
        try {
            DownloadOsmTask downloadOsmTask = new DownloadOsmTask();
            downloadOsmTask.loadUrl(false, (String)this.args.get("url"), null);
        }
        catch (Exception exception) {
            System.out.println("RemoteControl: Error parsing import remote control request:");
            exception.printStackTrace();
            throw new RequestHandler.RequestHandlerErrorException();
        }
    }

    public String[] getMandatoryParams() {
        return new String[]{"url"};
    }

    public String getPermissionMessage() {
        return I18n.tr("Remote Control has been asked to import data from the following URL:", new Object[0]) + "<br>" + this.request;
    }

    public PermissionPrefWithDefault getPermissionPref() {
        return new PermissionPrefWithDefault(permissionKey, true, "RemoteControl: import forbidden by preferences");
    }

    protected void parseArgs() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.request.indexOf(63) != -1) {
            String string = this.request.substring(this.request.indexOf(63) + 1);
            if (string.indexOf("url=") == 0) {
                hashMap.put("url", this.decodeURL(string.substring(4)));
            } else {
                String[] stringArray;
                int n = string.indexOf("&url=");
                if (n != -1) {
                    stringArray = string.substring(n + 1);
                    hashMap.put("url", this.decodeURL(string.substring(n + 5)));
                    string = string.substring(0, n);
                } else if (string.indexOf(35) != -1) {
                    string = string.substring(0, string.indexOf(35));
                }
                for (String string2 : stringArray = string.split("&", -1)) {
                    int n2 = string2.indexOf(61);
                    if (n2 == -1) continue;
                    hashMap.put(string2.substring(0, n2), string2.substring(n2 + 1));
                }
            }
        }
        this.args = hashMap;
    }

    private String decodeURL(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException();
        }
    }
}

