/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGUniverse;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.codec.binary.Base64;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageResource;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageProvider {
    protected Collection<String> dirs;
    protected String id;
    protected String subdir;
    protected String name;
    protected File archive;
    protected int width = -1;
    protected int height = -1;
    protected int maxWidth = -1;
    protected int maxHeight = -1;
    protected boolean optional;
    private static SVGUniverse svgUniverse;
    private static Map<String, ImageResource> cache;
    private static final Pattern dataUrlPattern;
    static final double DEGREE_90 = 1.5707963267948966;

    public ImageProvider(String string, String string2) {
        this.subdir = string;
        this.name = string2;
    }

    public ImageProvider(String string) {
        this.name = string;
    }

    public ImageProvider setDirs(Collection<String> collection) {
        this.dirs = collection;
        return this;
    }

    public ImageProvider setId(String string) {
        this.id = string;
        return this;
    }

    public ImageProvider setArchive(File file) {
        this.archive = file;
        return this;
    }

    public ImageProvider setSize(Dimension dimension) {
        this.width = dimension.width;
        this.height = dimension.height;
        return this;
    }

    public ImageProvider setWidth(int n) {
        this.width = n;
        return this;
    }

    public ImageProvider setHeight(int n) {
        this.height = n;
        return this;
    }

    public ImageProvider setMaxSize(Dimension dimension) {
        this.maxWidth = dimension.width;
        this.maxHeight = dimension.height;
        return this;
    }

    public ImageProvider setMaxWidth(int n) {
        this.maxWidth = n;
        return this;
    }

    public ImageProvider setMaxHeight(int n) {
        this.maxHeight = n;
        return this;
    }

    public ImageProvider setOptional(boolean bl) {
        this.optional = bl;
        return this;
    }

    public ImageIcon get() {
        return this.get(true);
    }

    public ImageIcon get(boolean bl) {
        return this.get(bl, null);
    }

    public ImageIcon get(Collection<ClassLoader> collection) {
        return this.get(true, collection);
    }

    public ImageIcon get(boolean bl, Collection<ClassLoader> collection) {
        ImageResource imageResource = this.getIfAvailableImpl(collection);
        if (imageResource == null) {
            if (!this.optional) {
                String string = this.name.indexOf(46) != -1 ? "" : ".???";
                throw new RuntimeException(I18n.tr("Fatal: failed to locate image ''{0}''. This is a serious configuration problem. JOSM will stop working.", this.name + string));
            }
            if (bl) {
                System.err.println(I18n.tr("Failed to locate image ''{0}''", this.name));
            }
            return null;
        }
        if (this.maxWidth != -1 || this.maxHeight != -1) {
            return imageResource.getImageIconBounded(new Dimension(this.maxWidth, this.maxHeight));
        }
        return imageResource.getImageIcon(new Dimension(this.width, this.height));
    }

    public static ImageIcon get(String string, String string2) {
        return new ImageProvider(string, string2).get();
    }

    public static ImageIcon get(String string) {
        return new ImageProvider(string).get();
    }

    public static ImageIcon getIfAvailable(String string) {
        return new ImageProvider(string).setOptional(true).get();
    }

    public static ImageIcon getIfAvailable(String string, String string2) {
        return new ImageProvider(string, string2).setOptional(true).get();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ImageResource getIfAvailableImpl(Collection<ClassLoader> collection) {
        Object[] objectArray;
        Object object;
        Object object2;
        Object object3;
        block31: {
            if (this.name == null) {
                return null;
            }
            try {
                if (!this.name.startsWith("data:") || !(object3 = dataUrlPattern.matcher(this.name)).matches()) break block31;
                object2 = object3.group(1);
                object = object3.group(2);
                String string = object3.group(3);
                byte[] byArray = objectArray = ";base64".equals(object) ? Base64.decodeBase64(string) : URLDecoder.decode(string, "utf-8").getBytes();
                if (object2 != null && object2.contains("image/svg+xml")) {
                    URI uRI = ImageProvider.getSvgUniverse().loadSVG(new StringReader(new String((byte[])objectArray)), this.name);
                    return new ImageResource(ImageProvider.getSvgUniverse().getDiagram(uRI));
                }
                {
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException.getMessage(), iOException);
                    }
                    try {
                        return new ImageResource(ImageIO.read(new ByteArrayInputStream((byte[])objectArray)));
                    }
                    catch (IOException iOException) {}
                    {
                    }
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
        }
        Object object4 = object3 = this.name.toLowerCase().endsWith(".svg") ? ImageType.SVG : ImageType.OTHER;
        if (this.name.startsWith("http://")) {
            object2 = this.name;
            object = cache.get(object2);
            if (object != null) {
                return object;
            }
            object = ImageProvider.getIfAvailableHttp((String)object2, (ImageType)((Object)object3));
            if (object != null) {
                cache.put((String)object2, (ImageResource)object);
            }
            return object;
        }
        if (this.name.startsWith("wiki://")) {
            object2 = cache.get(this.name);
            if (object2 != null) {
                return object2;
            }
            object2 = ImageProvider.getIfAvailableWiki(this.name, (ImageType)((Object)object3));
            if (object2 != null) {
                cache.put(this.name, (ImageResource)object2);
            }
            return object2;
        }
        if (this.subdir == null) {
            this.subdir = "";
        } else if (!this.subdir.equals("")) {
            this.subdir = this.subdir + "/";
        }
        object2 = this.name.indexOf(46) != -1 ? new String[]{""} : new String[]{".png", ".svg"};
        objectArray = new Integer[]{0, 1};
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = objectArray[n2].intValue();
            block12: for (String string : object2) {
                ImageResource imageResource;
                String string2;
                if (".svg".equals(string)) {
                    object3 = ImageType.SVG;
                } else if (".png".equals(string)) {
                    object3 = ImageType.OTHER;
                }
                String string3 = string2 = this.subdir + this.name + string;
                if (this.dirs != null && this.dirs.size() > 0) {
                    string3 = "id:" + this.id + ":" + string2;
                    if (this.archive != null) {
                        string3 = string3 + ":" + this.archive.getName();
                    }
                }
                if ((imageResource = cache.get(string3)) != null) {
                    return imageResource;
                }
                switch (n3) {
                    case 0: {
                        if (this.archive == null || (imageResource = ImageProvider.getIfAvailableZip(string2, this.archive, (ImageType)((Object)object3))) == null) continue block12;
                        cache.put(string3, imageResource);
                        return imageResource;
                    }
                    case 1: {
                        URL uRL = ImageProvider.getImageUrl(string2, this.dirs, collection);
                        if (uRL == null || (imageResource = ImageProvider.getIfAvailableLocalURL(uRL, (ImageType)((Object)object3))) == null) continue block12;
                        cache.put(string3, imageResource);
                        return imageResource;
                    }
                }
            }
            ++n2;
        }
        return null;
    }

    private static ImageResource getIfAvailableHttp(String string, ImageType imageType) {
        try {
            MirroredInputStream mirroredInputStream = new MirroredInputStream(string, new File(Main.pref.getCacheDirectory(), "images").getPath());
            switch (imageType) {
                case SVG: {
                    URI uRI = ImageProvider.getSvgUniverse().loadSVG(mirroredInputStream, mirroredInputStream.getFile().toURI().toURL().toString());
                    SVGDiagram sVGDiagram = ImageProvider.getSvgUniverse().getDiagram(uRI);
                    return sVGDiagram == null ? null : new ImageResource(sVGDiagram);
                }
                case OTHER: {
                    BufferedImage bufferedImage = null;
                    try {
                        bufferedImage = ImageIO.read(mirroredInputStream.getFile().toURI().toURL());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return bufferedImage == null ? null : new ImageResource(bufferedImage);
                }
            }
            throw new AssertionError();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static ImageResource getIfAvailableWiki(String string, ImageType imageType) {
        List<String> list = Arrays.asList("http://wiki.openstreetmap.org/w/images/", "http://upload.wikimedia.org/wikipedia/commons/", "http://wiki.openstreetmap.org/wiki/File:");
        Collection<String> collection = Main.pref.getCollection("image-provider.wiki.urls", list);
        String string2 = string.substring(string.lastIndexOf(47) + 1);
        ImageResource imageResource = null;
        for (String string3 : collection) {
            String string4;
            if (string3.endsWith(":")) {
                string4 = ImageProvider.getImgUrlFromWikiInfoPage(string3, string2);
                if (string4 == null) {
                    continue;
                }
            } else {
                String string5 = Utils.md5Hex(string2);
                string4 = string3 + string5.substring(0, 1) + "/" + string5.substring(0, 2) + "/" + string2;
            }
            if ((imageResource = ImageProvider.getIfAvailableHttp(string4, imageType)) == null) continue;
            break;
        }
        return imageResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ImageResource getIfAvailableZip(String string, File file, ImageType imageType) {
        ZipFile zipFile = null;
        try {
            int n;
            zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry(string);
            if (zipEntry == null) return null;
            int n2 = 0;
            byte[] byArray = new byte[n];
            InputStream inputStream = null;
            try {
                inputStream = zipFile.getInputStream(zipEntry);
                switch (imageType) {
                    case SVG: {
                        URI uRI = ImageProvider.getSvgUniverse().loadSVG(inputStream, string);
                        SVGDiagram sVGDiagram = ImageProvider.getSvgUniverse().getDiagram(uRI);
                        ImageResource imageResource = sVGDiagram == null ? null : new ImageResource(sVGDiagram);
                        return imageResource;
                    }
                    case OTHER: {
                        int n3;
                        for (n = (int)zipEntry.getSize(); n > 0; n2 += n3, n -= n3) {
                            n3 = inputStream.read(byArray, n2, n);
                        }
                        BufferedImage bufferedImage = null;
                        try {
                            bufferedImage = ImageIO.read(new ByteArrayInputStream(byArray));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        ImageResource imageResource = bufferedImage == null ? null : new ImageResource(bufferedImage);
                        return imageResource;
                    }
                }
                throw new AssertionError();
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception exception) {
            System.err.println(I18n.tr("Warning: failed to handle zip file ''{0}''. Exception was: {1}", file.getName(), exception.toString()));
            return null;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static ImageResource getIfAvailableLocalURL(URL uRL, ImageType imageType) {
        switch (imageType) {
            case SVG: {
                URI uRI = ImageProvider.getSvgUniverse().loadSVG(uRL);
                SVGDiagram sVGDiagram = ImageProvider.getSvgUniverse().getDiagram(uRI);
                return sVGDiagram == null ? null : new ImageResource(sVGDiagram);
            }
            case OTHER: {
                BufferedImage bufferedImage = null;
                try {
                    bufferedImage = ImageIO.read(uRL);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return bufferedImage == null ? null : new ImageResource(bufferedImage);
            }
        }
        throw new AssertionError();
    }

    private static URL getImageUrl(String string, String string2, Collection<ClassLoader> collection) {
        if (string != null && string.startsWith("resource://")) {
            String string3 = string.substring("resource://".length());
            ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>(PluginHandler.getResourceClassLoaders());
            if (collection != null) {
                arrayList.addAll(collection);
            }
            for (ClassLoader classLoader : arrayList) {
                URL uRL = classLoader.getResource(string3 + string2);
                if (uRL == null) continue;
                return uRL;
            }
        } else {
            try {
                File file = new File(string, string2);
                if (file.exists()) {
                    return file.toURI().toURL();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    private static URL getImageUrl(String string, Collection<String> collection, Collection<ClassLoader> collection2) {
        URL uRL = null;
        if (collection != null) {
            for (String object : collection) {
                try {
                    uRL = ImageProvider.getImageUrl(object, string, collection2);
                    if (uRL == null) continue;
                    return uRL;
                }
                catch (SecurityException securityException) {
                    System.out.println(I18n.tr("Warning: failed to access directory ''{0}'' for security reasons. Exception was: {1}", object, securityException.toString()));
                }
            }
        }
        String string2 = Main.pref.getPreferencesDir() + "images";
        try {
            uRL = ImageProvider.getImageUrl(string2, string, collection2);
            if (uRL != null) {
                return uRL;
            }
        }
        catch (SecurityException securityException) {
            System.out.println(I18n.tr("Warning: failed to access directory ''{0}'' for security reasons. Exception was: {1}", string2, securityException.toString()));
        }
        uRL = ImageProvider.getImageUrl(null, string, collection2);
        if (uRL != null) {
            return uRL;
        }
        uRL = ImageProvider.getImageUrl("resource://images/", string, collection2);
        if (uRL != null) {
            return uRL;
        }
        for (String string3 : Main.pref.getAllPossiblePreferenceDirs()) {
            uRL = ImageProvider.getImageUrl(string3 + "images", string, collection2);
            if (uRL != null) {
                return uRL;
            }
            uRL = ImageProvider.getImageUrl(string3, string, collection2);
            if (uRL == null) continue;
            return uRL;
        }
        return null;
    }

    private static String getImgUrlFromWikiInfoPage(String string, final String string2) {
        class SAXReturnException
        extends SAXException {
            private String result;

            public SAXReturnException(String string) {
                this.result = string;
            }

            public String getResult() {
                return this.result;
            }
        }
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(new DefaultHandler(){

                public void startElement(String string, String string22, String string3, Attributes attributes) throws SAXException {
                    String string4;
                    System.out.println();
                    if (string22.equalsIgnoreCase("img") && (string4 = attributes.getValue("src")).endsWith(string2)) {
                        throw new SAXReturnException(string4);
                    }
                }
            });
            xMLReader.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String string, String string2) {
                    return new InputSource(new ByteArrayInputStream(new byte[0]));
                }
            });
            xMLReader.parse(new InputSource(new MirroredInputStream(string + string2, new File(Main.pref.getPreferencesDir(), "images").toString())));
        }
        catch (SAXReturnException sAXReturnException) {
            return sAXReturnException.getResult();
        }
        catch (Exception exception) {
            System.out.println("INFO: parsing " + string + string2 + " failed:\n" + exception);
            return null;
        }
        System.out.println("INFO: parsing " + string + string2 + " failed: Unexpected content.");
        return null;
    }

    public static Cursor getCursor(String string, String string2) {
        ImageIcon imageIcon = ImageProvider.get("cursor", string);
        if (string2 != null) {
            imageIcon = ImageProvider.overlay((Icon)imageIcon, "cursor/modifier/" + string2, OverlayPosition.SOUTHEAST);
        }
        Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(imageIcon.getImage(), string.equals("crosshair") ? new Point(10, 10) : new Point(3, 2), "Cursor");
        return cursor;
    }

    public static ImageIcon overlay(Icon icon, String string, OverlayPosition overlayPosition) {
        return ImageProvider.overlay(icon, ImageProvider.get(string), overlayPosition);
    }

    public static ImageIcon overlay(Icon icon, Icon icon2, OverlayPosition overlayPosition) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        int n3 = icon2.getIconWidth();
        int n4 = icon2.getIconHeight();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(null, graphics2D, 0, 0);
        int n5 = 0;
        int n6 = 0;
        switch (overlayPosition) {
            case NORTHWEST: {
                n5 = 0;
                n6 = 0;
                break;
            }
            case NORTHEAST: {
                n5 = n - n3;
                n6 = 0;
                break;
            }
            case SOUTHWEST: {
                n5 = 0;
                n6 = n2 - n4;
                break;
            }
            case SOUTHEAST: {
                n5 = n - n3;
                n6 = n2 - n4;
            }
        }
        icon2.paintIcon(null, graphics2D, n5, n6);
        return new ImageIcon(bufferedImage);
    }

    public static Image createRotatedImage(Component component, Image image, double d) {
        int n;
        int n2;
        double d2 = d % 360.0;
        if (d != 0.0 && d2 == 0.0) {
            d2 = 360.0;
        }
        double d3 = d2 % 90.0;
        if (d2 != 0.0 && d3 == 0.0) {
            d3 = 90.0;
        }
        double d4 = Math.toRadians(d3);
        new ImageIcon(image);
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        if (d2 >= 0.0 && d2 <= 90.0 || d2 > 180.0 && d2 <= 270.0) {
            n2 = (int)((double)n3 * Math.sin(1.5707963267948966 - d4) + (double)n4 * Math.sin(d4));
            n = (int)((double)n3 * Math.sin(d4) + (double)n4 * Math.sin(1.5707963267948966 - d4));
        } else {
            n2 = (int)((double)n4 * Math.sin(1.5707963267948966 - d4) + (double)n3 * Math.sin(d4));
            n = (int)((double)n4 * Math.sin(d4) + (double)n3 * Math.sin(1.5707963267948966 - d4));
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n, 2);
        Graphics graphics = bufferedImage.getGraphics();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        int n5 = n3 / 2;
        int n6 = n4 / 2;
        graphics2D.translate(n2 / 2, n / 2);
        graphics2D.rotate(Math.toRadians(d2));
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.drawImage(image, -n5, -n6, component);
        graphics2D.dispose();
        new ImageIcon(bufferedImage);
        return bufferedImage;
    }

    public static ImageIcon get(OsmPrimitiveType osmPrimitiveType) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)osmPrimitiveType, "type");
        return ImageProvider.get("data", osmPrimitiveType.getAPIName());
    }

    public static BufferedImage createImageFromSvg(SVGDiagram sVGDiagram, Dimension dimension) {
        float f = sVGDiagram.getWidth();
        float f2 = sVGDiagram.getHeight();
        int n = Math.round(f);
        int n2 = Math.round(f2);
        Double d = null;
        Double d2 = null;
        if (dimension.width != -1) {
            n = dimension.width;
            d = (double)n / (double)f;
            if (dimension.height == -1) {
                d2 = d;
                n2 = (int)Math.round((double)f2 * d2);
            } else {
                n2 = dimension.height;
                d2 = (double)n2 / (double)f2;
            }
        } else if (dimension.height != -1) {
            n2 = dimension.height;
            d = d2 = Double.valueOf((double)n2 / (double)f2);
            n = (int)Math.round((double)f * d);
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setClip(0, 0, n, n2);
        if (d != null) {
            graphics2D.scale(d, d2);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            sVGDiagram.render(graphics2D);
        }
        catch (SVGException sVGException) {
            return null;
        }
        return bufferedImage;
    }

    private static SVGUniverse getSvgUniverse() {
        if (svgUniverse == null) {
            svgUniverse = new SVGUniverse();
        }
        return svgUniverse;
    }

    static {
        cache = new HashMap<String, ImageResource>();
        dataUrlPattern = Pattern.compile("^data:([a-zA-Z]+/[a-zA-Z+]+)?(;base64)?,(.+)$");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageType {
        SVG,
        OTHER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OverlayPosition {
        NORTHWEST,
        NORTHEAST,
        SOUTHWEST,
        SOUTHEAST;

    }
}

