/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.openstreetmap.gui.jmapviewer.FeatureAdapter;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.OpenFileAction;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadGpsTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.PrimitiveDeepCopy;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionChangeListener;
import org.openstreetmap.josm.data.validation.OsmValidator;
import org.openstreetmap.josm.gui.GettingStarted;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.io.SaveLayersDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.preferences.ToolbarPreferences;
import org.openstreetmap.josm.gui.preferences.imagery.ImageryPreference;
import org.openstreetmap.josm.gui.preferences.map.MapPaintPreference;
import org.openstreetmap.josm.gui.preferences.map.ProjectionPreference;
import org.openstreetmap.josm.gui.preferences.map.TaggingPresetPreference;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitorExecutor;
import org.openstreetmap.josm.gui.util.RedirectInputMap;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.PlatformHook;
import org.openstreetmap.josm.tools.PlatformHookOsx;
import org.openstreetmap.josm.tools.PlatformHookUnixoid;
import org.openstreetmap.josm.tools.PlatformHookWindows;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.WindowGeometry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Main {
    public static Component parent;
    public static Main main;
    public static final ExecutorService worker;
    public static Preferences pref;
    public static final PrimitiveDeepCopy pasteBuffer;
    public static Layer pasteSource;
    public static MapFrame map;
    public static boolean applet;
    public static ToolbarPreferences toolbar;
    public UndoRedoHandler undoRedo = new UndoRedoHandler();
    public static PleaseWaitProgressMonitor currentProgressMonitor;
    public MainMenu menu;
    public OsmValidator validator;
    private GettingStarted gettingStarted = new GettingStarted();
    public static int log_level;
    public static PlatformHook platform;
    public static boolean isOpenjdk;
    private static InitStatusListener initListener;
    protected static final JPanel contentPanePrivate;
    public static final JPanel panel;
    protected static WindowGeometry geometry;
    protected static int windowState;
    private final OsmDataLayer.CommandQueueListener redoUndoListener = new OsmDataLayer.CommandQueueListener(){

        public void commandChanged(int n, int n2) {
            Main.this.menu.undo.setEnabled(n > 0);
            Main.this.menu.redo.setEnabled(n2 > 0);
        }
    };
    private static Projection proj;
    private static final ArrayList<WeakReference<ProjectionChangeListener>> listeners;

    public static boolean isDisplayingMapView() {
        if (map == null) {
            return false;
        }
        return Main.map.mapView != null;
    }

    public static void warn(String string) {
        if (log_level < 1) {
            return;
        }
        System.out.println(string);
    }

    public static void info(String string) {
        if (log_level < 2) {
            return;
        }
        System.out.println(string);
    }

    public static void debug(String string) {
        if (log_level < 3) {
            return;
        }
        System.out.println(string);
    }

    public final void setMapFrame(MapFrame mapFrame) {
        MapFrame mapFrame2 = map;
        panel.setVisible(false);
        panel.removeAll();
        if (mapFrame != null) {
            mapFrame.fillPanel(panel);
        } else {
            mapFrame2.destroy();
            panel.add((Component)this.gettingStarted, "Center");
        }
        panel.setVisible(true);
        this.redoUndoListener.commandChanged(0, 0);
        map = mapFrame;
        PluginHandler.notifyMapFrameChanged(mapFrame2, mapFrame);
        if (mapFrame == null && currentProgressMonitor != null) {
            currentProgressMonitor.showForegroundDialog();
        }
    }

    public final void removeLayer(Layer layer) {
        if (map != null) {
            Main.map.mapView.removeLayer(layer);
            if (map != null && Main.map.mapView.getAllLayers().isEmpty()) {
                this.setMapFrame(null);
            }
        }
    }

    public static void setInitStatusListener(InitStatusListener initStatusListener) {
        initListener = initStatusListener;
    }

    public Main() {
        main = this;
        boolean bl = isOpenjdk = System.getProperty("java.vm.name").toUpperCase().indexOf("OPENJDK") != -1;
        if (initListener != null) {
            initListener.updateStatus(I18n.tr("Executing platform startup hook", new Object[0]));
        }
        platform.startupHook();
        if (initListener != null) {
            initListener.updateStatus(I18n.tr("Building main menu", new Object[0]));
        }
        contentPanePrivate.add((Component)panel, "Center");
        panel.add((Component)this.gettingStarted, "Center");
        this.menu = new MainMenu();
        this.undoRedo.addCommandQueueListener(this.redoUndoListener);
        contentPanePrivate.add((Component)Main.toolbar.control, "North");
        Main.registerActionShortcut(this.menu.help, Shortcut.registerShortcut("system:help", I18n.tr("Help", new Object[0]), 112, 5003));
        ArrayList<Callable<Void>> arrayList = new ArrayList<Callable<Void>>();
        arrayList.add(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (initListener != null) {
                    initListener.updateStatus(I18n.tr("Initializing OSM API", new Object[0]));
                }
                try {
                    OsmApi.getOsmApi().initialize(null, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
        arrayList.add(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (initListener != null) {
                    initListener.updateStatus(I18n.tr("Initializing presets", new Object[0]));
                }
                TaggingPresetPreference.initialize();
                if (initListener != null) {
                    initListener.updateStatus(I18n.tr("Initializing validator", new Object[0]));
                }
                Main.this.validator = new OsmValidator();
                MapView.addLayerChangeListener(Main.this.validator);
                return null;
            }
        });
        arrayList.add(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (initListener != null) {
                    initListener.updateStatus(I18n.tr("Initializing map styles", new Object[0]));
                }
                MapPaintPreference.initialize();
                return null;
            }
        });
        arrayList.add(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (initListener != null) {
                    initListener.updateStatus(I18n.tr("Loading imagery preferences", new Object[0]));
                }
                ImageryPreference.initialize();
                return null;
            }
        });
        try {
            Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()).invokeAll(arrayList);
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        FeatureAdapter.registerBrowserAdapter(new FeatureAdapter.BrowserAdapter(){

            public void openLink(String string) {
                OpenBrowser.displayUrl(string);
            }
        });
        FeatureAdapter.registerTranslationAdapter(I18n.getTranslationAdapter());
        if (initListener != null) {
            initListener.updateStatus(I18n.tr("Updating user interface", new Object[0]));
        }
        toolbar.refreshToolbarControl();
        Main.toolbar.control.updateUI();
        contentPanePrivate.updateUI();
    }

    public final void addLayer(Layer layer) {
        if (map == null) {
            MapFrame mapFrame = new MapFrame(contentPanePrivate);
            this.setMapFrame(mapFrame);
            mapFrame.selectMapMode((MapMode)mapFrame.getDefaultButtonAction(), layer);
            mapFrame.setVisible(true);
            mapFrame.initializeDialogsPane();
            layer.addPropertyChangeListener(LayerListDialog.getInstance().getModel());
        }
        Main.map.mapView.addLayer(layer);
    }

    public boolean hasEditLayer() {
        return this.getEditLayer() != null;
    }

    public OsmDataLayer getEditLayer() {
        if (map == null) {
            return null;
        }
        if (Main.map.mapView == null) {
            return null;
        }
        return Main.map.mapView.getEditLayer();
    }

    public DataSet getCurrentDataSet() {
        if (!this.hasEditLayer()) {
            return null;
        }
        return this.getEditLayer().data;
    }

    public Layer getActiveLayer() {
        if (map == null) {
            return null;
        }
        if (Main.map.mapView == null) {
            return null;
        }
        return Main.map.mapView.getActiveLayer();
    }

    public static void redirectToMainContentPane(JComponent jComponent) {
        RedirectInputMap.redirect(jComponent, contentPanePrivate);
    }

    public static void registerActionShortcut(Action action, Shortcut shortcut) {
        KeyStroke keyStroke = shortcut.getKeyStroke();
        if (keyStroke == null) {
            return;
        }
        InputMap inputMap = contentPanePrivate.getInputMap(2);
        Object object = inputMap.get(keyStroke);
        if (object != null && !object.equals(action)) {
            System.out.println(String.format("Keystroke %s is already assigned to %s, will be overridden by %s", keyStroke, object, action));
        }
        inputMap.put(keyStroke, action);
        contentPanePrivate.getActionMap().put(action, action);
    }

    public static void unregisterActionShortcut(Shortcut shortcut) {
        contentPanePrivate.getInputMap(2).remove(shortcut.getKeyStroke());
    }

    public static void unregisterActionShortcut(JosmAction josmAction) {
        Main.unregisterActionShortcut(josmAction, josmAction.getShortcut());
    }

    public static void unregisterActionShortcut(Action action, Shortcut shortcut) {
        contentPanePrivate.getInputMap(2).remove(shortcut.getKeyStroke());
        contentPanePrivate.getActionMap().remove(action);
    }

    public static void preConstructorInit(Map<String, Collection<String>> map) {
        ProjectionPreference.setProjection();
        try {
            String string = platform.getDefaultStyle();
            String string2 = pref.get("laf", string);
            try {
                UIManager.setLookAndFeel(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("Look and Feel not found: " + string2);
                pref.put("laf", string);
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                System.out.println("Look and Feel not supported: " + string2);
                pref.put("laf", string);
            }
            toolbar = new ToolbarPreferences();
            contentPanePrivate.updateUI();
            panel.updateUI();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        UIManager.put("OptionPane.okIcon", ImageProvider.get("ok"));
        UIManager.put("OptionPane.yesIcon", UIManager.get("OptionPane.okIcon"));
        UIManager.put("OptionPane.cancelIcon", ImageProvider.get("cancel"));
        UIManager.put("OptionPane.noIcon", UIManager.get("OptionPane.cancelIcon"));
        I18n.translateJavaInternalMessages();
        try {
            CoordinateFormat.setCoordinateFormat(CoordinateFormat.valueOf(pref.get("coordinates")));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            CoordinateFormat.setCoordinateFormat(CoordinateFormat.DECIMAL_DEGREES);
        }
        geometry = WindowGeometry.mainWindow("gui.geometry", map.containsKey("geometry") ? map.get("geometry").iterator().next() : null, !map.containsKey("no-maximize") && pref.getBoolean("gui.maximized", false));
    }

    public void postConstructorProcessCmdLine(Map<String, Collection<String>> map) {
        if (map.containsKey("download")) {
            Iterator<String> iterator = new ArrayList();
            for (String string : map.get("download")) {
                File file = null;
                switch (this.paramType(string)) {
                    case httpUrl: {
                        Main.downloadFromParamHttp(false, string);
                        break;
                    }
                    case bounds: {
                        Main.downloadFromParamBounds(false, string);
                        break;
                    }
                    case fileUrl: {
                        try {
                            file = new File(new URI(string));
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            JOptionPane.showMessageDialog(parent, I18n.tr("Ignoring malformed file URL: \"{0}\"", string), I18n.tr("Warning", new Object[0]), 2);
                        }
                        if (file == null) break;
                        iterator.add((String)((Object)file));
                        break;
                    }
                    case fileName: {
                        file = new File(string);
                        iterator.add((String)((Object)file));
                    }
                }
            }
            if (!iterator.isEmpty()) {
                OpenFileAction.openFiles(iterator, true);
            }
        }
        if (map.containsKey("downloadgps")) {
            for (String string : map.get("downloadgps")) {
                switch (this.paramType(string)) {
                    case httpUrl: {
                        Main.downloadFromParamHttp(true, string);
                        break;
                    }
                    case bounds: {
                        Main.downloadFromParamBounds(true, string);
                        break;
                    }
                    case fileUrl: 
                    case fileName: {
                        JOptionPane.showMessageDialog(parent, I18n.tr("Parameter \"downloadgps\" does not accept file names or file URLs", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                    }
                }
            }
        }
        if (map.containsKey("selection")) {
            for (String string : map.get("selection")) {
                SearchAction.search(string, SearchAction.SearchMode.add);
            }
        }
    }

    public static boolean saveUnsavedModifications() {
        if (map == null) {
            return true;
        }
        SaveLayersDialog saveLayersDialog = new SaveLayersDialog(parent);
        ArrayList<OsmDataLayer> arrayList = new ArrayList<OsmDataLayer>();
        for (OsmDataLayer osmDataLayer : Main.map.mapView.getLayersOfType(OsmDataLayer.class)) {
            if (!osmDataLayer.requiresSaveToFile() && !osmDataLayer.requiresUploadToServer() || !osmDataLayer.data.isModified()) continue;
            arrayList.add(osmDataLayer);
        }
        saveLayersDialog.prepareForSavingAndUpdatingLayersBeforeExit();
        if (!arrayList.isEmpty()) {
            saveLayersDialog.getModel().populate(arrayList);
            saveLayersDialog.setVisible(true);
            switch (saveLayersDialog.getUserAction()) {
                case CANCEL: {
                    return false;
                }
                case PROCEED: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public static boolean exitJosm(boolean bl) {
        if (Main.saveUnsavedModifications()) {
            geometry.remember("gui.geometry");
            if (map != null) {
                map.rememberToggleDialogWidth();
            }
            pref.put("gui.maximized", (windowState & 6) != 0);
            if (Main.isDisplayingMapView()) {
                ArrayList<Layer> arrayList = new ArrayList<Layer>(Main.map.mapView.getAllLayers());
                for (Layer layer : arrayList) {
                    Main.map.mapView.removeLayer(layer);
                }
            }
            if (bl) {
                System.exit(0);
                return true;
            }
            return true;
        }
        return false;
    }

    private DownloadParamType paramType(String string) {
        if (string.startsWith("http:")) {
            return DownloadParamType.httpUrl;
        }
        if (string.startsWith("file:")) {
            return DownloadParamType.fileUrl;
        }
        String string2 = "\\s*[0-9]+(\\.[0-9]+)?\\s*";
        if (string.matches(string2 + "(," + string2 + "){3}")) {
            return DownloadParamType.bounds;
        }
        return DownloadParamType.fileName;
    }

    private static void downloadFromParamHttp(boolean bl, String string) {
        Bounds bounds = OsmUrlToBounds.parse(string);
        if (bounds == null) {
            JOptionPane.showMessageDialog(parent, I18n.tr("Ignoring malformed URL: \"{0}\"", string), I18n.tr("Warning", new Object[0]), 2);
        } else {
            Main.downloadFromParamBounds(bl, bounds);
        }
    }

    private static void downloadFromParamBounds(boolean bl, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.countTokens() == 4) {
            Bounds bounds = new Bounds(new LatLon(Double.parseDouble(stringTokenizer.nextToken()), Double.parseDouble(stringTokenizer.nextToken())), new LatLon(Double.parseDouble(stringTokenizer.nextToken()), Double.parseDouble(stringTokenizer.nextToken())));
            Main.downloadFromParamBounds(bl, bounds);
        }
    }

    private static void downloadFromParamBounds(boolean bl, Bounds bounds) {
        AbstractDownloadTask abstractDownloadTask = bl ? new DownloadGpsTask() : new DownloadOsmTask();
        Future<?> future = abstractDownloadTask.download(true, bounds, null);
        worker.execute(new PostDownloadHandler((DownloadTask)abstractDownloadTask, future));
    }

    public static void determinePlatformHook() {
        String string = System.getProperty("os.name");
        if (string == null) {
            System.err.println("Your operating system has no name, so I'm guessing its some kind of *nix.");
            platform = new PlatformHookUnixoid();
        } else if (string.toLowerCase().startsWith("windows")) {
            platform = new PlatformHookWindows();
        } else if (string.equals("Linux") || string.equals("Solaris") || string.equals("SunOS") || string.equals("AIX") || string.equals("FreeBSD") || string.equals("NetBSD") || string.equals("OpenBSD")) {
            platform = new PlatformHookUnixoid();
        } else if (string.toLowerCase().startsWith("mac os x")) {
            platform = new PlatformHookOsx();
        } else {
            System.err.println("I don't know your operating system '" + string + "', so I'm guessing its some kind of *nix.");
            platform = new PlatformHookUnixoid();
        }
    }

    public static void addListener() {
        parent.addComponentListener(new WindowPositionSizeListener());
        ((JFrame)parent).addWindowStateListener(new WindowPositionSizeListener());
    }

    public static void checkJava6() {
        String string = System.getProperty("java.version");
        if (string != null) {
            if (string.startsWith("1.6") || string.startsWith("6") || string.startsWith("1.7") || string.startsWith("7")) {
                return;
            }
            if (string.startsWith("1.5") || string.startsWith("5")) {
                JLabel jLabel = new JLabel("<html>" + I18n.tr("<h2>JOSM requires Java version 6.</h2>Detected Java version: {0}.<br>You can <ul><li>update your Java (JRE) or</li><li>use an earlier (Java 5 compatible) version of JOSM.</li></ul>More Info:", string) + "</html>");
                JTextArea jTextArea = new JTextArea("http://josm.openstreetmap.de/wiki/Help/SystemRequirements");
                jTextArea.setEditable(false);
                jTextArea.setBackground(panel.getBackground());
                JPanel jPanel = new JPanel(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.weightx = 1.0;
                jPanel.add((Component)jLabel, gridBagConstraints);
                jPanel.add((Component)jTextArea, gridBagConstraints);
                String string2 = I18n.tr("Exit JOSM", new Object[0]);
                String string3 = I18n.tr("Continue, try anyway", new Object[0]);
                int n = JOptionPane.showOptionDialog(null, jPanel, I18n.tr("Error", new Object[0]), 0, 0, null, new String[]{string2, string3}, string2);
                if (n == 0) {
                    System.exit(0);
                }
                return;
            }
        }
        System.err.println("Error: Could not recognize Java Version: " + string);
    }

    public static Projection getProjection() {
        return proj;
    }

    public static void setProjection(Projection projection) {
        CheckParameterUtil.ensureParameterNotNull(projection);
        Projection projection2 = proj;
        proj = projection;
        Main.fireProjectionChanged(projection2, proj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void fireProjectionChanged(Projection projection, Projection projection2) {
        if (!(projection2 == null ^ projection == null)) {
            if (projection2 == null) return;
            if (projection == null) return;
            if (Utils.equal(projection2.toCode(), projection.toCode())) return;
        }
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            Iterator<WeakReference<ProjectionChangeListener>> iterator = listeners.iterator();
            while (iterator.hasNext()) {
                WeakReference<ProjectionChangeListener> weakReference = iterator.next();
                ProjectionChangeListener projectionChangeListener = (ProjectionChangeListener)weakReference.get();
                if (projectionChangeListener == null) {
                    iterator.remove();
                    continue;
                }
                projectionChangeListener.projectionChanged(projection, projection2);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (projection2 == null) return;
            if (map == null) return;
            if (Main.map.mapView == null) return;
            Bounds bounds = Main.map.mapView.getRealBounds();
            clazz = bounds;
            if (clazz == null) return;
            Main.map.mapView.zoomTo((Bounds)((Object)clazz));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addProjectionChangeListener(ProjectionChangeListener projectionChangeListener) {
        if (projectionChangeListener == null) {
            return;
        }
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            for (WeakReference<ProjectionChangeListener> weakReference : listeners) {
                if (weakReference.get() != projectionChangeListener) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            listeners.add(new WeakReference<ProjectionChangeListener>(projectionChangeListener));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeProjectionChangeListener(ProjectionChangeListener projectionChangeListener) {
        if (projectionChangeListener == null) {
            return;
        }
        Class<Main> clazz = Main.class;
        synchronized (Main.class) {
            Iterator<WeakReference<ProjectionChangeListener>> iterator = listeners.iterator();
            while (iterator.hasNext()) {
                WeakReference<ProjectionChangeListener> weakReference = iterator.next();
                if (weakReference.get() != null && weakReference.get() != projectionChangeListener) continue;
                iterator.remove();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        worker = new ProgressMonitorExecutor();
        pasteBuffer = new PrimitiveDeepCopy();
        applet = false;
        log_level = 2;
        initListener = null;
        contentPanePrivate = new JPanel(new BorderLayout());
        panel = new JPanel(new BorderLayout());
        windowState = 0;
        listeners = new ArrayList();
    }

    private static class WindowPositionSizeListener
    extends WindowAdapter
    implements ComponentListener {
        private WindowPositionSizeListener() {
        }

        public void windowStateChanged(WindowEvent windowEvent) {
            windowState = windowEvent.getNewState();
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
            this.handleComponentEvent(componentEvent);
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.handleComponentEvent(componentEvent);
        }

        public void componentShown(ComponentEvent componentEvent) {
        }

        private void handleComponentEvent(ComponentEvent componentEvent) {
            Component component = componentEvent.getComponent();
            if (component instanceof JFrame && component.isVisible() && windowState == 0) {
                geometry = new WindowGeometry((JFrame)component);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DownloadParamType {
        httpUrl,
        fileUrl,
        bounds,
        fileName;

    }

    public static interface InitStatusListener {
        public void updateStatus(String var1);
    }
}

