/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.AbstractProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.ProjectionSubPrefs;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.data.projection.datum.AbstractDatum;
import org.openstreetmap.josm.data.projection.datum.CentricDatum;
import org.openstreetmap.josm.data.projection.datum.Datum;
import org.openstreetmap.josm.data.projection.datum.SevenParameterDatum;
import org.openstreetmap.josm.data.projection.datum.ThreeParameterDatum;
import org.openstreetmap.josm.data.projection.proj.Proj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomProjection
extends AbstractProjection
implements ProjectionSubPrefs {
    private String pref = "";

    public void update(String string) {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String[] stringArray = string.trim().split("\\s+");
            for (int i = 0; i < stringArray.length; ++i) {
                String string2;
                String string3;
                String string4 = stringArray[i];
                if (string4.charAt(0) != '+') {
                    throw new ProjectionConfigurationException(I18n.tr("Parameter must begin with a ''+'' sign (found ''{0}'')", string4));
                }
                Matcher matcher = Pattern.compile("\\+([a-zA-Z0-9_]+)(=(.*))?").matcher(string4);
                if (matcher.matches()) {
                    string3 = matcher.group(1);
                    string2 = null;
                    if (matcher.groupCount() >= 3) {
                        string2 = matcher.group(3);
                    }
                } else {
                    throw new ProjectionConfigurationException(I18n.tr("Unexpected parameter format (''{0}'')", string4));
                }
                hashMap.put(string3, string2);
            }
            this.ellps = this.parseEllipsoid(hashMap);
            this.datum = this.parseDatum(hashMap, this.ellps);
            this.proj = this.parseProjection(hashMap, this.ellps);
            String string5 = (String)hashMap.get("x_0");
            if (string5 != null) {
                this.x_0 = this.parseDouble(string5, "x_0");
            }
            if ((string5 = (String)hashMap.get("y_0")) != null) {
                this.y_0 = this.parseDouble(string5, "y_0");
            }
            if ((string5 = (String)hashMap.get("lon_0")) != null) {
                this.lon_0 = this.parseAngle(string5, "lon_0");
            }
            if ((string5 = (String)hashMap.get("k_0")) != null) {
                this.k_0 = this.parseDouble(string5, "k_0");
            }
        }
        catch (ProjectionConfigurationException projectionConfigurationException) {
            System.err.println(projectionConfigurationException.toString());
        }
        this.pref = string;
    }

    public Ellipsoid parseEllipsoid(Map<String, String> map) throws ProjectionConfigurationException {
        String string = map.get("ellps");
        if (string != null) {
            Ellipsoid ellipsoid = Projections.getEllipsoid(string);
            if (ellipsoid == null) {
                throw new ProjectionConfigurationException(I18n.tr("Ellipsoid ''{0}'' not supported.", string));
            }
            return ellipsoid;
        }
        String string2 = map.get("a");
        if (string2 != null) {
            double d = this.parseDouble(string2, "a");
            if (map.get("es") != null) {
                double d2 = this.parseDouble(map, "es");
                return Ellipsoid.create_a_es(d, d2);
            }
            if (map.get("rf") != null) {
                double d3 = this.parseDouble(map, "rf");
                return Ellipsoid.create_a_rf(d, d3);
            }
            if (map.get("f") != null) {
                double d4 = this.parseDouble(map, "f");
                return Ellipsoid.create_a_f(d, d4);
            }
            if (map.get("b") != null) {
                double d5 = this.parseDouble(map, "b");
                return Ellipsoid.create_a_b(d, d5);
            }
        }
        if (map.containsKey("a") || map.containsKey("es") || map.containsKey("rf") || map.containsKey("f") || map.containsKey("b")) {
            throw new ProjectionConfigurationException(I18n.tr("Combination of ellipsoid parameters is not supported.", new Object[0]));
        }
        return Ellipsoid.WGS84;
    }

    public Datum parseDatum(Map<String, String> map, Ellipsoid ellipsoid) throws ProjectionConfigurationException {
        String string = map.get("towgs84");
        if (string != null) {
            return this.parseToWGS84(string, ellipsoid);
        }
        String string2 = map.get("datum");
        if (string2 != null) {
            Datum datum = Projections.getDatum(string2);
            if (datum == null) {
                throw new ProjectionConfigurationException(I18n.tr("Unkown datum identifier: ''{0}''", string2));
            }
            return datum;
        }
        return new CentricDatum(null, null, ellipsoid);
    }

    public Datum parseToWGS84(String string, Ellipsoid ellipsoid) throws ProjectionConfigurationException {
        int n;
        String[] stringArray = string.split(",");
        if (stringArray.length != 3 && stringArray.length != 7) {
            throw new ProjectionConfigurationException(I18n.tr("Unexpected number of arguments for parameter ''towgs84'' (must be 3 or 7)", new Object[0]));
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (n = 0; n < stringArray.length; ++n) {
            try {
                arrayList.add(Double.parseDouble(stringArray[n]));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProjectionConfigurationException(I18n.tr("Unable to parse value of parameter ''towgs84'' (''{0}'')", stringArray[n]));
            }
        }
        n = 1;
        for (int i = 3; i < arrayList.size(); ++i) {
            if ((Double)arrayList.get(i) == 0.0) continue;
            n = 0;
            break;
        }
        AbstractDatum abstractDatum = null;
        abstractDatum = n != 0 ? new ThreeParameterDatum(null, null, ellipsoid, (Double)arrayList.get(0), (Double)arrayList.get(1), (Double)arrayList.get(2)) : new SevenParameterDatum(null, null, ellipsoid, (Double)arrayList.get(0), (Double)arrayList.get(1), (Double)arrayList.get(2), (Double)arrayList.get(3), (Double)arrayList.get(4), (Double)arrayList.get(5), (Double)arrayList.get(6));
        return abstractDatum;
    }

    public Proj parseProjection(Map<String, String> map, Ellipsoid ellipsoid) throws ProjectionConfigurationException {
        String string = map.get("proj");
        if (string == null) {
            throw new ProjectionConfigurationException(I18n.tr("Projection required (+proj=*)", new Object[0]));
        }
        Proj proj = Projections.getProjection(string);
        if (proj == null) {
            throw new ProjectionConfigurationException(I18n.tr("Unkown projection identifier: ''{0}''", string));
        }
        ProjParameters projParameters = new ProjParameters();
        projParameters.ellps = ellipsoid;
        String string2 = map.get("lat_0");
        if (string2 != null) {
            projParameters.lat_0 = this.parseAngle(string2, "lat_0");
        }
        if ((string2 = map.get("lat_1")) != null) {
            projParameters.lat_1 = this.parseAngle(string2, "lat_1");
        }
        if ((string2 = map.get("lat_2")) != null) {
            projParameters.lat_2 = this.parseAngle(string2, "lat_2");
        }
        proj.initialize(projParameters);
        return proj;
    }

    public double parseDouble(Map<String, String> map, String string) throws ProjectionConfigurationException {
        String string2 = map.get(string);
        if (string2 == null && map.containsKey(string)) {
            throw new ProjectionConfigurationException(I18n.tr("Expected number argument for parameter ''{0}''", string));
        }
        return this.parseDouble(string2, string);
    }

    public double parseDouble(String string, String string2) throws ProjectionConfigurationException {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ProjectionConfigurationException(I18n.tr("Unable to parse value of ''{0}'' parameter ''{0}'' as number.", string2, string));
        }
    }

    public double parseAngle(String string, String string2) throws ProjectionConfigurationException {
        String string3 = string;
        double d = 0.0;
        boolean bl = false;
        Matcher matcher = Pattern.compile("^-").matcher(string3);
        if (matcher.find()) {
            bl = true;
            string3 = string3.substring(matcher.end());
        }
        boolean bl2 = false;
        matcher = Pattern.compile("^(\\d+(\\.\\d*)?)d").matcher(string3);
        if (matcher.find()) {
            string3 = string3.substring(matcher.end());
            d += Double.parseDouble(matcher.group(1));
            bl2 = true;
        }
        if ((matcher = Pattern.compile("^(\\d+(\\.\\d*)?)'").matcher(string3)).find()) {
            string3 = string3.substring(matcher.end());
            d += Double.parseDouble(matcher.group(1)) / 60.0;
            bl2 = true;
        }
        if ((matcher = Pattern.compile("^(\\d+(\\.\\d*)?)\"").matcher(string3)).find()) {
            string3 = string3.substring(matcher.end());
            d += Double.parseDouble(matcher.group(1)) / 3600.0;
            bl2 = true;
        }
        if (!bl2 && (matcher = Pattern.compile("^(\\d+(\\.\\d*)?)").matcher(string3)).find()) {
            string3 = string3.substring(matcher.end());
            d += Double.parseDouble(matcher.group(1));
        }
        if ((matcher = Pattern.compile("^(N|E)", 2).matcher(string3)).find()) {
            string3 = string3.substring(matcher.end());
        } else {
            matcher = Pattern.compile("^(S|W)", 2).matcher(string3);
            if (matcher.find()) {
                string3 = string3.substring(matcher.end());
                boolean bl3 = bl = !bl;
            }
        }
        if (bl) {
            d = -d;
        }
        if (!string3.isEmpty()) {
            throw new ProjectionConfigurationException(I18n.tr("Unable to parse value of ''{0}'' parameter ''{0}'' as coordinate value.", string2, string));
        }
        return d;
    }

    public void dump() {
        System.err.println("x_0=" + this.x_0);
        System.err.println("y_0=" + this.y_0);
        System.err.println("lon_0=" + this.lon_0);
        System.err.println("k_0=" + this.k_0);
        System.err.println("ellps=" + this.ellps);
        System.err.println("proj=" + this.proj);
        System.err.println("datum=" + this.datum);
    }

    @Override
    public Integer getEpsgCode() {
        return null;
    }

    @Override
    public String toCode() {
        return Utils.md5Hex(this.pref).substring(0, 10);
    }

    @Override
    public String getCacheDirectoryName() {
        return this.toCode();
    }

    @Override
    public Bounds getWorldBoundsLatLon() {
        return new Bounds(new LatLon(-85.05112877980659, -180.0), new LatLon(85.05112877980659, 180.0));
    }

    @Override
    public String toString() {
        return I18n.tr("Custom Projection (from PROJ.4 string)", new Object[0]);
    }

    @Override
    public void setupPreferencePanel(JPanel jPanel, ActionListener actionListener) {
        JTextField jTextField = new JTextField(this.pref, 50);
        jPanel.setLayout(new GridBagLayout());
        jPanel.add(jTextField);
    }

    @Override
    public Collection<String> getPreferences(JPanel jPanel) {
        Component component = jPanel.getComponent(0);
        if (!(component instanceof JTextField)) {
            return null;
        }
        String string = ((JTextField)component).getText();
        return Collections.singleton(string);
    }

    @Override
    public void setPreferences(Collection<String> collection) {
        this.update(collection.iterator().next());
    }

    @Override
    public String[] allCodes() {
        return new String[0];
    }

    @Override
    public Collection<String> getPreferencesFromCode(String string) {
        return null;
    }
}

