/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.advanced;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.CustomConfigurator;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.actionsupport.LogShowDialog;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.advanced.ListEditor;
import org.openstreetmap.josm.gui.preferences.advanced.ListListEditor;
import org.openstreetmap.josm.gui.preferences.advanced.MapListEditor;
import org.openstreetmap.josm.gui.preferences.advanced.StringEditor;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvancedPreference
extends DefaultTabPreferenceSetting {
    private AllSettingsTableModel model;
    protected List<PrefEntry> data;
    protected List<PrefEntry> displayData;
    protected JTextField txtFilter;

    private AdvancedPreference() {
        super("advanced", I18n.tr("Advanced Preferences", new Object[0]), I18n.tr("Setting Preference entries directly. Use with caution!", new Object[0]));
    }

    @Override
    public boolean isExpert() {
        return true;
    }

    @Override
    public void addGui(final PreferenceTabbedPane preferenceTabbedPane) {
        PreferenceTabbedPane.PreferencePanel preferencePanel = preferenceTabbedPane.createPreferenceTab(this);
        this.txtFilter = new JTextField();
        JLabel jLabel = new JLabel(I18n.tr("Search: ", new Object[0]));
        jLabel.setLabelFor(this.txtFilter);
        preferencePanel.add(jLabel);
        preferencePanel.add((Component)this.txtFilter, GBC.eol().fill(2));
        this.txtFilter.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.action();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.action();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.action();
            }

            private void action() {
                AdvancedPreference.this.applyFilter();
            }
        });
        this.readPreferences(Main.pref);
        this.model = new AllSettingsTableModel();
        this.applyFilter();
        final JTable jTable = new JTable(this.model);
        jTable.putClientProperty("terminateEditOnFocusLost", true);
        jTable.getColumnModel().getColumn(1).setCellRenderer(new SettingCellRenderer());
        jTable.getColumnModel().getColumn(1).setCellEditor(new SettingCellEditor());
        JScrollPane jScrollPane = new JScrollPane(jTable);
        preferencePanel.add((Component)jScrollPane, GBC.eol().fill(1));
        jScrollPane.setPreferredSize(new Dimension(400, 200));
        JButton jButton = new JButton(I18n.tr("Add", new Object[0]));
        preferencePanel.add(Box.createHorizontalGlue(), GBC.std().fill(2));
        preferencePanel.add((Component)jButton, GBC.std().insets(0, 5, 0, 0));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedPreference.this.addPreference(preferenceTabbedPane);
            }
        });
        JButton jButton2 = new JButton(I18n.tr("Edit", new Object[0]));
        preferencePanel.add((Component)jButton2, GBC.std().insets(5, 5, 5, 0));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedPreference.this.editPreference(preferenceTabbedPane, jTable);
            }
        });
        JButton jButton3 = new JButton(I18n.tr("Reset", new Object[0]));
        preferencePanel.add((Component)jButton3, GBC.std().insets(0, 5, 0, 0));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedPreference.this.resetPreference(preferenceTabbedPane, jTable);
            }
        });
        JButton jButton4 = new JButton(I18n.tr("Read from file", new Object[0]));
        preferencePanel.add((Component)jButton4, GBC.std().insets(5, 5, 0, 0));
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File[] fileArray = AdvancedPreference.this.askUserForCustomSettingsFiles(false, I18n.tr("Open JOSM customization file", new Object[0]));
                if (fileArray.length == 0) {
                    return;
                }
                Preferences preferences = CustomConfigurator.clonePreferences(Main.pref);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("<html>");
                for (File file : fileArray) {
                    CustomConfigurator.readXML(file, preferences);
                    stringBuilder.append(CustomConfigurator.getLog());
                }
                stringBuilder.append("</html>");
                String string = stringBuilder.toString().replace("\n", "<br/>");
                new LogShowDialog(I18n.tr("Import log", new Object[0]), I18n.tr("<html>Here is file import summary. <br/>You can reject preferences changes by pressing \"Cancel\" in preferences dialog <br/>To activate some changes JOSM restart may be needed.</html>", new Object[0]), string).showDialog();
                AdvancedPreference.this.readPreferences(preferences);
                Collections.sort(AdvancedPreference.this.data, new Comparator<PrefEntry>(){

                    @Override
                    public int compare(PrefEntry prefEntry, PrefEntry prefEntry2) {
                        if (prefEntry.changed && !prefEntry2.changed) {
                            return -1;
                        }
                        if (prefEntry2.changed && !prefEntry.changed) {
                            return 1;
                        }
                        if (!prefEntry.isDefault && prefEntry2.isDefault) {
                            return -1;
                        }
                        if (!prefEntry2.isDefault && prefEntry.isDefault) {
                            return 1;
                        }
                        return prefEntry.key.compareTo(prefEntry2.key);
                    }
                });
                AdvancedPreference.this.applyFilter();
                ((AllSettingsTableModel)jTable.getModel()).fireTableDataChanged();
            }
        });
        JButton jButton5 = new JButton(I18n.tr("Export selected items", new Object[0]));
        preferencePanel.add((Component)jButton5, GBC.std().insets(5, 5, 0, 0));
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList<String> arrayList = new ArrayList<String>();
                boolean bl = false;
                for (int n : jTable.getSelectedRows()) {
                    PrefEntry prefEntry = (PrefEntry)AdvancedPreference.this.model.getValueAt(n, -1);
                    if (prefEntry.isDefault()) continue;
                    if (!(prefEntry.getValue() instanceof Preferences.StringSetting)) {
                        bl = true;
                    }
                    arrayList.add(prefEntry.getKey());
                }
                if (arrayList.size() == 0) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select some preference keys not marked as default", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                    return;
                }
                File[] fileArray = AdvancedPreference.this.askUserForCustomSettingsFiles(true, I18n.tr("Export preferences keys to JOSM customization file", new Object[0]));
                if (fileArray.length == 0) {
                    return;
                }
                int n = 0;
                if (bl) {
                    n = JOptionPane.showOptionDialog(Main.parent, I18n.tr("What to with preference lists when this file is to be imported?", new Object[0]), I18n.tr("Question", new Object[0]), 1, 3, null, new String[]{"Append preferences from file to existing values", "Replace existing values"}, 0);
                }
                CustomConfigurator.exportPreferencesKeysToFile(fileArray[0].getAbsolutePath(), n == 0, arrayList);
            }
        });
        jTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    AdvancedPreference.this.editPreference(preferenceTabbedPane, jTable);
                }
            }
        });
    }

    private void readPreferences(Preferences preferences) {
        Map<String, Preferences.Setting> map;
        Map<String, Preferences.Setting> map2 = Main.pref.getAllSettings();
        Map<String, Preferences.Setting> map3 = preferences.getAllDefaults();
        map2.remove("osm-server.password");
        map3.remove("osm-server.password");
        if (preferences != Main.pref) {
            map = preferences.getAllSettings();
            Preferences.Setting setting = map2.get("plugins");
            if (setting != null) {
                map.put("plugins", setting);
            }
        } else {
            map = map2;
        }
        this.prepareData(map, map2, map3);
    }

    private File[] askUserForCustomSettingsFiles(boolean bl, String string) {
        int n;
        String string2 = Main.pref.get("customsettings.lastDirectory");
        if (string2.length() == 0) {
            string2 = ".";
        }
        JFileChooser jFileChooser = new JFileChooser(string2);
        jFileChooser.setDialogTitle(string);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".xml");
            }

            public String getDescription() {
                return I18n.tr("JOSM custom settings files (*.xml)", new Object[0]);
            }
        });
        jFileChooser.setMultiSelectionEnabled(!bl);
        int n2 = n = bl ? jFileChooser.showSaveDialog(Main.parent) : jFileChooser.showOpenDialog(Main.parent);
        if (n == 0) {
            File[] fileArray;
            if (!jFileChooser.getCurrentDirectory().getAbsolutePath().equals(string2)) {
                Main.pref.put("customsettings.lastDirectory", jFileChooser.getCurrentDirectory().getAbsolutePath());
            }
            if (jFileChooser.isMultiSelectionEnabled()) {
                fileArray = jFileChooser.getSelectedFiles();
            } else {
                File[] fileArray2 = new File[1];
                fileArray = fileArray2;
                fileArray2[0] = jFileChooser.getSelectedFile();
            }
            File[] fileArray3 = fileArray;
            if (fileArray3.length == 1 && !fileArray3[0].getName().contains(".")) {
                fileArray3[0] = new File(fileArray3[0].getAbsolutePath() + ".xml");
            }
            return fileArray3;
        }
        return new File[0];
    }

    private void prepareData(Map<String, Preferences.Setting> map, Map<String, Preferences.Setting> map2, Map<String, Preferences.Setting> map3) {
        Preferences.Setting setting;
        Object object;
        this.data = new ArrayList<PrefEntry>();
        for (Map.Entry<String, Preferences.Setting> entry : map.entrySet()) {
            object = entry.getValue();
            setting = map2.get(entry.getKey());
            Preferences.Setting setting2 = map3.get(entry.getKey());
            if (setting2 == null) {
                setting2 = object.getNullInstance();
            }
            PrefEntry prefEntry = new PrefEntry(entry.getKey(), (Preferences.Setting)object, setting2, false);
            if (!Preferences.isEqual(setting, (Preferences.Setting)object)) {
                prefEntry.markAsChanged();
            }
            this.data.add(prefEntry);
        }
        for (Map.Entry<String, Preferences.Setting> entry : map3.entrySet()) {
            if (map.containsKey(entry.getKey())) continue;
            object = new PrefEntry(entry.getKey(), entry.getValue(), entry.getValue(), true);
            setting = map2.get(entry.getKey());
            if (setting != null) {
                ((PrefEntry)object).markAsChanged();
            }
            this.data.add((PrefEntry)object);
        }
        Collections.sort(this.data);
        this.displayData = new ArrayList<PrefEntry>(this.data);
    }

    private void applyFilter() {
        this.displayData.clear();
        for (PrefEntry prefEntry : this.data) {
            String string = prefEntry.getKey();
            Preferences.Setting setting = prefEntry.getValue();
            String string2 = setting.getValue() == null ? "" : setting.getValue().toString();
            String[] stringArray = this.txtFilter.getText().split("\\s+");
            boolean bl = true;
            String string3 = string.toLowerCase();
            String string4 = string2.toLowerCase();
            for (String string5 : stringArray) {
                if (string3.contains(string5 = string5.toLowerCase()) || string4.contains(string5)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            this.displayData.add(prefEntry);
        }
        this.model.fireTableDataChanged();
    }

    @Override
    public boolean ok() {
        for (PrefEntry prefEntry : this.data) {
            if (!prefEntry.isChanged()) continue;
            Main.pref.putSetting(prefEntry.getKey(), prefEntry.getValue());
        }
        return false;
    }

    private void resetPreference(PreferenceTabbedPane preferenceTabbedPane, JTable jTable) {
        if (jTable.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(preferenceTabbedPane, I18n.tr("Please select the row to delete.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        for (int n : jTable.getSelectedRows()) {
            PrefEntry prefEntry = this.displayData.get(n);
            prefEntry.reset();
        }
        this.model.fireTableDataChanged();
    }

    private void addPreference(PreferenceTabbedPane preferenceTabbedPane) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Key", new Object[0])), GBC.std().insets(0, 0, 5, 0));
        JTextField jTextField = new JTextField("", 50);
        jPanel.add((Component)jTextField, GBC.eop().insets(5, 0, 0, 0).fill(2));
        jPanel.add((Component)new JLabel(I18n.tr("Select Setting Type:", new Object[0])), GBC.eol().insets(5, 15, 5, 0));
        JRadioButton jRadioButton = new JRadioButton(I18n.tr("Simple", new Object[0]));
        JRadioButton jRadioButton2 = new JRadioButton(I18n.tr("List", new Object[0]));
        JRadioButton jRadioButton3 = new JRadioButton(I18n.tr("List of lists", new Object[0]));
        JRadioButton jRadioButton4 = new JRadioButton(I18n.tr("List of maps", new Object[0]));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton4);
        jPanel.add((Component)jRadioButton, GBC.eol());
        jPanel.add((Component)jRadioButton2, GBC.eol());
        jPanel.add((Component)jRadioButton3, GBC.eol());
        jPanel.add((Component)jRadioButton4, GBC.eol());
        jRadioButton.setSelected(true);
        ExtendedDialog extendedDialog = new ExtendedDialog(preferenceTabbedPane, I18n.tr("Add setting", new Object[0]), new String[]{I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0])});
        extendedDialog.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        extendedDialog.setContent(jPanel);
        extendedDialog.showDialog();
        PrefEntry prefEntry = null;
        boolean bl = false;
        if (extendedDialog.getValue() == 1) {
            if (jRadioButton.isSelected()) {
                Preferences.StringSetting stringSetting = new Preferences.StringSetting(null);
                prefEntry = new PrefEntry(jTextField.getText(), stringSetting, stringSetting, false);
                StringEditor stringEditor = new StringEditor(preferenceTabbedPane, prefEntry, stringSetting);
                stringEditor.showDialog();
                if (stringEditor.getValue() == 1) {
                    String string = stringEditor.getData();
                    if (!Utils.equal(stringSetting.getValue(), string)) {
                        prefEntry.setValue(new Preferences.StringSetting(string));
                        bl = true;
                    }
                }
            } else if (jRadioButton2.isSelected()) {
                Preferences.ListSetting listSetting = new Preferences.ListSetting(null);
                prefEntry = new PrefEntry(jTextField.getText(), listSetting, listSetting, false);
                ListEditor listEditor = new ListEditor(preferenceTabbedPane, prefEntry, listSetting);
                listEditor.showDialog();
                if (listEditor.getValue() == 1) {
                    List<String> list = listEditor.getData();
                    if (!Preferences.equalCollection((Collection)listSetting.getValue(), list)) {
                        prefEntry.setValue(new Preferences.ListSetting(list));
                        bl = true;
                    }
                }
            } else if (jRadioButton3.isSelected()) {
                Preferences.ListListSetting listListSetting = new Preferences.ListListSetting(null);
                prefEntry = new PrefEntry(jTextField.getText(), listListSetting, listListSetting, false);
                ListListEditor listListEditor = new ListListEditor(preferenceTabbedPane, prefEntry, listListSetting);
                listListEditor.showDialog();
                if (listListEditor.getValue() == 1) {
                    List<List<String>> list = listListEditor.getData();
                    if (!Preferences.equalArray((Collection)listListSetting.getValue(), list)) {
                        prefEntry.setValue(new Preferences.ListListSetting(list));
                        bl = true;
                    }
                }
            } else if (jRadioButton4.isSelected()) {
                Preferences.MapListSetting mapListSetting = new Preferences.MapListSetting(null);
                prefEntry = new PrefEntry(jTextField.getText(), mapListSetting, mapListSetting, false);
                MapListEditor mapListEditor = new MapListEditor(preferenceTabbedPane, prefEntry, mapListSetting);
                mapListEditor.showDialog();
                if (mapListEditor.getValue() == 1) {
                    List<Map<String, String>> list = mapListEditor.getData();
                    if (!Preferences.equalListOfStructs((Collection)mapListSetting.getValue(), list)) {
                        prefEntry.setValue(new Preferences.MapListSetting(list));
                        bl = true;
                    }
                }
            }
            if (bl) {
                this.data.add(prefEntry);
                Collections.sort(this.data);
                this.applyFilter();
            }
        }
    }

    private void editPreference(PreferenceTabbedPane preferenceTabbedPane, JTable jTable) {
        if (jTable.getSelectedRowCount() != 1) {
            JOptionPane.showMessageDialog(preferenceTabbedPane, I18n.tr("Please select the row to edit.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        PrefEntry prefEntry = (PrefEntry)this.model.getValueAt(jTable.getSelectedRow(), 1);
        Preferences.Setting setting = prefEntry.getValue();
        if (setting instanceof Preferences.StringSetting) {
            jTable.editCellAt(jTable.getSelectedRow(), 1);
            Component component = jTable.getEditorComponent();
            if (component != null) {
                component.requestFocus();
            }
        } else if (setting instanceof Preferences.ListSetting) {
            Preferences.ListSetting listSetting = (Preferences.ListSetting)setting;
            ListEditor listEditor = new ListEditor(preferenceTabbedPane, prefEntry, listSetting);
            listEditor.showDialog();
            if (listEditor.getValue() == 1) {
                List<String> list = listEditor.getData();
                if (!Preferences.equalCollection((Collection)listSetting.getValue(), list)) {
                    prefEntry.setValue(new Preferences.ListSetting(list));
                    this.applyFilter();
                }
            }
        } else if (setting instanceof Preferences.ListListSetting) {
            ListListEditor listListEditor = new ListListEditor(preferenceTabbedPane, prefEntry, (Preferences.ListListSetting)setting);
            listListEditor.showDialog();
            if (listListEditor.getValue() == 1) {
                List<List<String>> list = listListEditor.getData();
                if (!Preferences.equalArray((Collection)setting.getValue(), list)) {
                    prefEntry.setValue(new Preferences.ListListSetting(list));
                    this.applyFilter();
                }
            }
        } else if (setting instanceof Preferences.MapListSetting) {
            Preferences.MapListSetting mapListSetting = (Preferences.MapListSetting)setting;
            MapListEditor mapListEditor = new MapListEditor(preferenceTabbedPane, prefEntry, mapListSetting);
            mapListEditor.showDialog();
            if (mapListEditor.getValue() == 1) {
                List<Map<String, String>> list = mapListEditor.getData();
                if (!Preferences.equalListOfStructs((Collection)mapListSetting.getValue(), list)) {
                    prefEntry.setValue(new Preferences.MapListSetting(list));
                    this.applyFilter();
                }
            }
        }
    }

    private static class SettingCellEditor
    extends DefaultCellEditor {
        public SettingCellEditor() {
            super(new JTextField());
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            PrefEntry prefEntry = (PrefEntry)object;
            Preferences.StringSetting stringSetting = (Preferences.StringSetting)prefEntry.getValue();
            String string = stringSetting.getValue() == null ? "" : (String)stringSetting.getValue();
            return super.getTableCellEditorComponent(jTable, string, bl, n, n2);
        }
    }

    private static class SettingCellRenderer
    extends DefaultTableCellRenderer {
        private Color backgroundColor = Main.pref.getUIColor("Table.background");
        private Color changedColor = Main.pref.getColor(I18n.marktr("Advanced Background: Changed"), new Color(200, 255, 200));
        private Color foregroundColor = Main.pref.getUIColor("Table.foreground");
        private Color nonDefaultColor = Main.pref.getColor(I18n.marktr("Advanced Background: NonDefalut"), new Color(255, 255, 200));

        private SettingCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return this;
            }
            PrefEntry prefEntry = (PrefEntry)object;
            Preferences.Setting setting = prefEntry.getValue();
            Object t = setting.getValue();
            String string = t != null ? t.toString() : "<html><i>&lt;" + I18n.tr("unset", new Object[0]) + "&gt;</i></html>";
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            jLabel.setBackground(this.backgroundColor);
            if (bl) {
                jLabel.setForeground(this.foregroundColor);
            }
            if (prefEntry.isChanged()) {
                jLabel.setBackground(this.changedColor);
            } else if (!prefEntry.isDefault()) {
                jLabel.setBackground(this.nonDefaultColor);
            }
            if (!prefEntry.isDefault()) {
                jLabel.setFont(jLabel.getFont().deriveFont(1));
            }
            if ((t = prefEntry.getDefaultValue().getValue()) != null) {
                if (prefEntry.isDefault()) {
                    jLabel.setToolTipText(I18n.tr("Current value is default.", new Object[0]));
                } else {
                    jLabel.setToolTipText(I18n.tr("Default value is ''{0}''.", t));
                }
            } else {
                jLabel.setToolTipText(I18n.tr("Default value currently unknown (setting has not been used yet).", new Object[0]));
            }
            return jLabel;
        }
    }

    class AllSettingsTableModel
    extends DefaultTableModel {
        public AllSettingsTableModel() {
            this.setColumnIdentifiers(new String[]{I18n.tr("Key", new Object[0]), I18n.tr("Value", new Object[0])});
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1 && AdvancedPreference.this.displayData.get(n).getValue() instanceof Preferences.StringSetting;
        }

        public int getRowCount() {
            return AdvancedPreference.this.displayData.size();
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return AdvancedPreference.this.displayData.get(n).getKey();
            }
            return AdvancedPreference.this.displayData.get(n);
        }

        public void setValueAt(Object object, int n, int n2) {
            String string = (String)object;
            PrefEntry prefEntry = AdvancedPreference.this.displayData.get(n);
            if (!string.equals(prefEntry.getValue().getValue())) {
                prefEntry.setValue(new Preferences.StringSetting(string));
                this.fireTableCellUpdated(n, n2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PrefEntry
    implements Comparable<PrefEntry> {
        private String key;
        private Preferences.Setting value;
        private Preferences.Setting defaultValue;
        private boolean isDefault;
        private boolean changed;

        public PrefEntry(String string, Preferences.Setting setting, Preferences.Setting setting2, boolean bl) {
            CheckParameterUtil.ensureParameterNotNull(string);
            CheckParameterUtil.ensureParameterNotNull(setting);
            CheckParameterUtil.ensureParameterNotNull(setting2);
            this.key = string;
            this.value = setting;
            this.defaultValue = setting2;
            this.isDefault = bl;
        }

        public String getKey() {
            return this.key;
        }

        public Preferences.Setting getValue() {
            return this.value;
        }

        public Preferences.Setting getDefaultValue() {
            return this.defaultValue;
        }

        public void setValue(Preferences.Setting setting) {
            this.value = setting;
            this.changed = true;
            this.isDefault = false;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public boolean isChanged() {
            return this.changed;
        }

        private void markAsChanged() {
            this.changed = true;
        }

        public void reset() {
            this.value = this.defaultValue;
            this.changed = true;
            this.isDefault = true;
        }

        @Override
        public int compareTo(PrefEntry prefEntry) {
            return this.key.compareTo(prefEntry.key);
        }

        public String toString() {
            return this.value.toString();
        }
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new AdvancedPreference();
        }
    }
}

