/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.ac;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.tagging.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionItemPritority;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionListItem;
import org.openstreetmap.josm.tools.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCompletionManager
implements DataSetListener {
    protected boolean dirty;
    protected DataSet ds;
    protected MultiMap<String, String> tagCache;
    protected static final MultiMap<String, String> presetTagCache = new MultiMap();
    protected Set<String> roleCache;
    protected static final Set<String> presetRoleCache = new HashSet<String>();

    public AutoCompletionManager(DataSet dataSet) {
        this.ds = dataSet;
        this.dirty = true;
    }

    protected MultiMap<String, String> getTagCache() {
        if (this.dirty) {
            this.rebuild();
            this.dirty = false;
        }
        return this.tagCache;
    }

    protected Set<String> getRoleCache() {
        if (this.dirty) {
            this.rebuild();
            this.dirty = false;
        }
        return this.roleCache;
    }

    protected void rebuild() {
        this.tagCache = new MultiMap();
        this.roleCache = new HashSet<String>();
        this.cachePrimitives(this.ds.allNonDeletedCompletePrimitives());
    }

    protected void cachePrimitives(Collection<? extends OsmPrimitive> collection) {
        for (OsmPrimitive osmPrimitive : collection) {
            this.cachePrimitiveTags(osmPrimitive);
            if (!(osmPrimitive instanceof Relation)) continue;
            this.cacheRelationMemberRoles((Relation)osmPrimitive);
        }
    }

    protected void cachePrimitiveTags(OsmPrimitive osmPrimitive) {
        for (String string : osmPrimitive.keySet()) {
            String string2 = osmPrimitive.get(string);
            this.tagCache.put(string, string2);
        }
    }

    protected void cacheRelationMemberRoles(Relation relation) {
        for (RelationMember relationMember : relation.getMembers()) {
            if (!relationMember.hasRole()) continue;
            this.roleCache.add(relationMember.getRole());
        }
    }

    public static void cachePresets(Collection<TaggingPreset> collection) {
        for (TaggingPreset taggingPreset : collection) {
            for (TaggingPreset.Item item : taggingPreset.data) {
                TaggingPreset.Item item2;
                if (item instanceof TaggingPreset.Check) {
                    item2 = (TaggingPreset.Check)item;
                    if (item2.key == null) continue;
                    presetTagCache.put(item2.key, "no");
                    presetTagCache.put(item2.key, "yes");
                    continue;
                }
                if (item instanceof TaggingPreset.Combo) {
                    item2 = (TaggingPreset.Combo)item;
                    if (((TaggingPreset.Combo)item2).key == null || ((TaggingPreset.Combo)item2).values == null) continue;
                    for (String string : ((TaggingPreset.Combo)item2).values.split(",")) {
                        presetTagCache.put(((TaggingPreset.Combo)item2).key, string);
                    }
                    continue;
                }
                if (item instanceof TaggingPreset.Key) {
                    item2 = (TaggingPreset.Key)item;
                    if (((TaggingPreset.Key)item2).key == null || ((TaggingPreset.Key)item2).value == null) continue;
                    presetTagCache.put(((TaggingPreset.Key)item2).key, ((TaggingPreset.Key)item2).value);
                    continue;
                }
                if (item instanceof TaggingPreset.Text) {
                    item2 = (TaggingPreset.Text)item;
                    if (((TaggingPreset.Text)item2).key == null) continue;
                    presetTagCache.putVoid(((TaggingPreset.Text)item2).key);
                    if (((TaggingPreset.Text)item2).default_ == null || ((TaggingPreset.Text)item2).default_.equals("")) continue;
                    presetTagCache.put(((TaggingPreset.Text)item2).key, ((TaggingPreset.Text)item2).default_);
                    continue;
                }
                if (!(item instanceof TaggingPreset.Roles)) continue;
                item2 = (TaggingPreset.Roles)item;
                for (TaggingPreset.Role role : ((TaggingPreset.Roles)item2).roles) {
                    if (role.key == null) continue;
                    presetRoleCache.add(role.key);
                }
            }
        }
    }

    protected List<String> getDataKeys() {
        return new ArrayList<String>(this.getTagCache().keySet());
    }

    protected List<String> getPresetKeys() {
        return new ArrayList<String>(presetTagCache.keySet());
    }

    protected List<String> getDataValues(String string) {
        return new ArrayList<String>(this.getTagCache().getValues(string));
    }

    protected static List<String> getPresetValues(String string) {
        return new ArrayList<String>(presetTagCache.getValues(string));
    }

    public List<String> getMemberRoles() {
        return new ArrayList<String>(this.getRoleCache());
    }

    public void populateWithMemberRoles(AutoCompletionList autoCompletionList) {
        autoCompletionList.add(presetRoleCache, AutoCompletionItemPritority.IS_IN_STANDARD);
        autoCompletionList.add(this.getRoleCache(), AutoCompletionItemPritority.IS_IN_DATASET);
    }

    public void populateWithKeys(AutoCompletionList autoCompletionList) {
        autoCompletionList.add(this.getPresetKeys(), AutoCompletionItemPritority.IS_IN_STANDARD);
        autoCompletionList.add(this.getDataKeys(), AutoCompletionItemPritority.IS_IN_DATASET);
    }

    public void populateWithTagValues(AutoCompletionList autoCompletionList, String string) {
        this.populateWithTagValues(autoCompletionList, Arrays.asList(string));
    }

    public void populateWithTagValues(AutoCompletionList autoCompletionList, List<String> list) {
        for (String string : list) {
            autoCompletionList.add(AutoCompletionManager.getPresetValues(string), AutoCompletionItemPritority.IS_IN_STANDARD);
            autoCompletionList.add(this.getDataValues(string), AutoCompletionItemPritority.IS_IN_DATASET);
        }
    }

    public List<AutoCompletionListItem> getKeys() {
        AutoCompletionList autoCompletionList = new AutoCompletionList();
        this.populateWithKeys(autoCompletionList);
        return autoCompletionList.getList();
    }

    public List<AutoCompletionListItem> getValues(String string) {
        return this.getValues(Arrays.asList(string));
    }

    public List<AutoCompletionListItem> getValues(List<String> list) {
        AutoCompletionList autoCompletionList = new AutoCompletionList();
        this.populateWithTagValues(autoCompletionList, list);
        return autoCompletionList.getList();
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent primitivesAddedEvent) {
        if (this.dirty) {
            return;
        }
        this.cachePrimitives(primitivesAddedEvent.getPrimitives());
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent primitivesRemovedEvent) {
        this.dirty = true;
    }

    @Override
    public void tagsChanged(TagsChangedEvent tagsChangedEvent) {
        if (this.dirty) {
            return;
        }
        Map<String, String> map = tagsChangedEvent.getPrimitive().getKeys();
        Map<String, String> map2 = tagsChangedEvent.getOriginalKeys();
        if (!map.keySet().containsAll(map2.keySet())) {
            this.dirty = true;
        } else {
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                if (entry.getValue().equals(map.get(entry.getKey()))) continue;
                this.dirty = true;
                return;
            }
            this.cachePrimitives(Collections.singleton(tagsChangedEvent.getPrimitive()));
        }
    }

    @Override
    public void nodeMoved(NodeMovedEvent nodeMovedEvent) {
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent wayNodesChangedEvent) {
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent relationMembersChangedEvent) {
        this.dirty = true;
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
    }

    @Override
    public void dataChanged(DataChangedEvent dataChangedEvent) {
        this.dirty = true;
    }
}

