/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.util.Random;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;

public class ScanexTileSource
extends AbstractTMSTileSource {
    private static String API_KEY = "4018C5A9AECAD8868ED5DEB2E41D09F7";
    private ScanexLayer Layer = ScanexLayer.IRS;
    private static double RADIUS_E = 6378137.0;
    private static double EQUATOR = 4.007501668557849E7;
    private static double E = 0.0818191908426;
    private double cached_lat = 0.0;

    public ScanexTileSource(String string) {
        super("Scanex " + string, "http://maps.kosmosnimki.ru");
        for (ScanexLayer scanexLayer : ScanexLayer.values()) {
            if (!string.equalsIgnoreCase(scanexLayer.getName())) continue;
            this.Layer = scanexLayer;
            break;
        }
    }

    public int getMaxZoom() {
        return 14;
    }

    public String getExtension() {
        return "jpeg";
    }

    public String getTilePath(int n, int n2, int n3) {
        int n4 = (int)Math.pow(2.0, n - 1);
        n3 = n4 - n3 - 1;
        return this.Layer.getUri() + "&apikey=" + API_KEY + "&x=" + (n2 -= n4) + "&y=" + n3 + "&z=" + n;
    }

    public TileSource.TileUpdate getTileUpdate() {
        return TileSource.TileUpdate.IfNoneMatch;
    }

    public double latToTileY(double d, int n) {
        double d2 = Math.tan(0.7853981633974483 * (1.0 + d / 90.0));
        double d3 = Math.pow(Math.tan(0.7853981633974483 + Math.asin(E * Math.sin(Math.toRadians(d))) / 2.0), E);
        return (EQUATOR / 2.0 - RADIUS_E * Math.log(d2 / d3)) * Math.pow(2.0, n) / EQUATOR;
    }

    public double lonToTileX(double d, int n) {
        return (RADIUS_E * d * Math.PI / (90.0 * EQUATOR) + 1.0) * Math.pow(2.0, n - 1);
    }

    public double tileYToLat(int n, int n2) {
        double d;
        Random random = new Random();
        double d2 = this.cached_lat;
        do {
            d = d2;
            if (!((d2 -= Math.toDegrees(this.NextTerm(Math.toRadians(d2), n, n2))) > 85.05112877980659) && !(d2 < -85.05112877980659)) continue;
            d2 = -85.05112877980659 + (double)random.nextInt(170);
        } while (Math.abs(d - d2) > 1.0E-6);
        this.cached_lat = d2;
        return d2;
    }

    private double NextTerm(double d, double d2, int n) {
        double d3 = Math.sin(d);
        double d4 = Math.cos(d);
        n = (int)Math.pow(2.0, n - 1);
        double d5 = Math.exp((1.0 - d2 / (double)n) * Math.PI);
        double d6 = Math.tan(0.7853981633974483 + d / 2.0) - d5 * Math.pow(Math.tan(0.7853981633974483 + Math.asin(E * d3) / 2.0), E);
        double d7 = 1.0 / (1.0 - d3) - d5 * E * d4 / ((1.0 - E * d3) * Math.sqrt(1.0 - E * E * d3 * d3));
        return d6 / d7;
    }

    public double tileXToLon(int n, int n2) {
        return ((double)n / Math.pow(2.0, n2 - 1) - 1.0) * (90.0 * EQUATOR) / RADIUS_E / Math.PI;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ScanexLayer {
        IRS("irs", "/TileSender.ashx?ModeKey=tile&MapName=F7B8CF651682420FA1749D894C8AD0F6&LayerName=BAC78D764F0443BD9AF93E7A998C9F5B"),
        SPOT("spot", "/TileSender.ashx?ModeKey=tile&MapName=F7B8CF651682420FA1749D894C8AD0F6&LayerName=F51CE95441284AF6B2FC319B609C7DEC");

        private String name;
        private String uri;

        private ScanexLayer(String string2, String string3) {
            this.name = string2;
            this.uri = string3;
        }

        public String getName() {
            return this.name;
        }

        public String getUri() {
            return this.uri;
        }
    }
}

