/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.ChangesetDataSet;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Changeset
implements Tagged {
    public static final int MAX_COMMENT_LENGTH = 255;
    private int id;
    private User user;
    private Date createdAt;
    private Date closedAt;
    private boolean open;
    private LatLon min;
    private LatLon max;
    private Map<String, String> tags;
    private boolean incomplete;
    private ChangesetDataSet content = null;

    public Changeset() {
        this.id = 0;
        this.tags = new HashMap<String, String>();
    }

    public Changeset(int n) {
        this.id = n;
        this.incomplete = n > 0;
        this.tags = new HashMap<String, String>();
    }

    public Changeset(Changeset changeset) {
        if (changeset == null) {
            this.id = 0;
            this.tags = new HashMap<String, String>();
        } else if (changeset.isIncomplete()) {
            this.setId(changeset.getId());
            this.incomplete = true;
            this.tags = new HashMap<String, String>();
        } else {
            this.id = changeset.id;
            this.mergeFrom(changeset);
            this.incomplete = false;
        }
    }

    public void visit(Visitor visitor) {
        visitor.visit(this);
    }

    public int compareTo(Changeset changeset) {
        return Integer.valueOf(this.getId()).compareTo(changeset.getId());
    }

    public String getName() {
        return "changeset " + this.getId();
    }

    public String getDisplayName(NameFormatter nameFormatter) {
        return nameFormatter.format(this);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date date) {
        this.createdAt = date;
    }

    public Date getClosedAt() {
        return this.closedAt;
    }

    public void setClosedAt(Date date) {
        this.closedAt = date;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean bl) {
        this.open = bl;
    }

    public LatLon getMin() {
        return this.min;
    }

    public void setMin(LatLon latLon) {
        this.min = latLon;
    }

    public LatLon getMax() {
        return this.max;
    }

    public Bounds getBounds() {
        if (this.min != null && this.max != null) {
            return new Bounds(this.min, this.max);
        }
        return null;
    }

    public void setMax(LatLon latLon) {
        this.max = latLon;
    }

    @Override
    public Map<String, String> getKeys() {
        return this.tags;
    }

    @Override
    public void setKeys(Map<String, String> map) {
        this.tags = map;
    }

    public boolean isIncomplete() {
        return this.incomplete;
    }

    public void setIncomplete(boolean bl) {
        this.incomplete = bl;
    }

    @Override
    public void put(String string, String string2) {
        this.tags.put(string, string2);
    }

    @Override
    public String get(String string) {
        return this.tags.get(string);
    }

    @Override
    public void remove(String string) {
        this.tags.remove(string);
    }

    @Override
    public void removeAll() {
        this.tags.clear();
    }

    public boolean hasEqualSemanticAttributes(Changeset changeset) {
        if (changeset == null) {
            return false;
        }
        if (this.closedAt == null ? changeset.closedAt != null : !this.closedAt.equals(changeset.closedAt)) {
            return false;
        }
        if (this.createdAt == null ? changeset.createdAt != null : !this.createdAt.equals(changeset.createdAt)) {
            return false;
        }
        if (this.id != changeset.id) {
            return false;
        }
        if (this.max == null ? changeset.max != null : !this.max.equals(changeset.max)) {
            return false;
        }
        if (this.min == null ? changeset.min != null : !this.min.equals(changeset.min)) {
            return false;
        }
        if (this.open != changeset.open) {
            return false;
        }
        if (this.tags == null ? changeset.tags != null : !((Object)this.tags).equals(changeset.tags)) {
            return false;
        }
        return !(this.user == null ? changeset.user != null : !this.user.equals(changeset.user));
    }

    public int hashCode() {
        if (this.id > 0) {
            return this.id;
        }
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Changeset changeset = (Changeset)object;
        if (this.id > 0 && changeset.id == this.id) {
            return true;
        }
        return this == object;
    }

    @Override
    public boolean hasKeys() {
        return !this.tags.keySet().isEmpty();
    }

    @Override
    public Collection<String> keySet() {
        return this.tags.keySet();
    }

    public boolean isNew() {
        return this.id <= 0;
    }

    public void mergeFrom(Changeset changeset) {
        if (changeset == null) {
            return;
        }
        if (this.id != changeset.id) {
            return;
        }
        this.user = changeset.user;
        this.createdAt = changeset.createdAt;
        this.closedAt = changeset.closedAt;
        this.open = changeset.open;
        this.min = changeset.min;
        this.max = changeset.max;
        this.tags = new HashMap<String, String>(changeset.tags);
        this.incomplete = changeset.incomplete;
        this.content = changeset.content;
    }

    public boolean hasContent() {
        return this.content != null;
    }

    public ChangesetDataSet getContent() {
        return this.content;
    }

    public void setContent(ChangesetDataSet changesetDataSet) {
        this.content = changesetDataSet;
    }
}

