/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.AbstractProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.datum.GRS80Datum;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.data.projection.proj.TransverseMercator;
import org.openstreetmap.josm.tools.I18n;

public class TransverseMercatorLV
extends AbstractProjection {
    public TransverseMercatorLV() {
        this.ellps = Ellipsoid.GRS80;
        this.proj = new TransverseMercator();
        try {
            this.proj.initialize(new ProjParameters(){
                {
                    this.ellps = TransverseMercatorLV.this.ellps;
                }
            });
        }
        catch (ProjectionConfigurationException projectionConfigurationException) {
            throw new RuntimeException(projectionConfigurationException);
        }
        this.datum = GRS80Datum.INSTANCE;
        this.lon_0 = 24.0;
        this.x_0 = 500000.0;
        this.y_0 = -6000000.0;
        this.k_0 = 0.9996;
    }

    public String toString() {
        return I18n.tr("LKS-92 (Latvia TM)", new Object[0]);
    }

    public Integer getEpsgCode() {
        return 3059;
    }

    public int hashCode() {
        return this.toCode().hashCode();
    }

    public String getCacheDirectoryName() {
        return "epsg" + this.getEpsgCode();
    }

    public Bounds getWorldBoundsLatLon() {
        return new Bounds(new LatLon(-90.0, -180.0), new LatLon(90.0, 180.0));
    }
}

