/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginListParseException;
import org.openstreetmap.josm.plugins.PluginListParser;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadRemotePluginInformationTask
extends PleaseWaitRunnable {
    private Collection<String> sites;
    private boolean canceled;
    private HttpURLConnection connection;
    private List<PluginInformation> availablePlugins;

    protected void init(Collection<String> collection) {
        this.sites = collection;
        if (collection == null) {
            this.sites = Collections.emptySet();
        }
        this.availablePlugins = new LinkedList<PluginInformation>();
    }

    public ReadRemotePluginInformationTask(Collection<String> collection) {
        super(I18n.tr("Download plugin list...", new Object[0]), false);
        this.init(collection);
    }

    public ReadRemotePluginInformationTask(ProgressMonitor progressMonitor, Collection<String> collection) {
        super(I18n.tr("Download plugin list...", new Object[0]), progressMonitor == null ? NullProgressMonitor.INSTANCE : progressMonitor, false);
        this.init(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        ReadRemotePluginInformationTask readRemotePluginInformationTask = this;
        synchronized (readRemotePluginInformationTask) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    @Override
    protected void finish() {
    }

    protected File createSiteCacheFile(File file, String string, CacheType cacheType) {
        String string2;
        try {
            string = string.replaceAll("%<(.*)>", "");
            URL uRL = new URL(string);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("site-");
            stringBuilder.append(uRL.getHost()).append("-");
            if (uRL.getPort() != -1) {
                stringBuilder.append(uRL.getPort()).append("-");
            }
            String string3 = uRL.getPath();
            for (int i = 0; i < string3.length(); ++i) {
                char c = string3.charAt(i);
                if (Character.isLetterOrDigit(c)) {
                    stringBuilder.append(c);
                    continue;
                }
                stringBuilder.append("_");
            }
            switch (cacheType) {
                case PLUGIN_LIST: {
                    stringBuilder.append(".txt");
                    break;
                }
                case ICON_LIST: {
                    stringBuilder.append("-icons.zip");
                }
            }
            string2 = stringBuilder.toString();
        }
        catch (MalformedURLException malformedURLException) {
            string2 = "site-unknown.txt";
        }
        return new File(file, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected String downloadPluginList(String string, ProgressMonitor progressMonitor) {
        ReadRemotePluginInformationTask readRemotePluginInformationTask;
        String string2;
        BufferedReader bufferedReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string3 = Utils.join(",", Main.pref.getCollection("plugins"));
            String string4 = string.replaceAll("%<(.*)>", "");
            string = string3 != null && string3.length() != 0 ? string.replaceAll("%<(.*)>", "$1" + string3) : string4;
            progressMonitor.beginTask("");
            progressMonitor.indeterminateSubTask(I18n.tr("Downloading plugin list from ''{0}''", string4));
            URL uRL = new URL(string);
            Object object = this;
            synchronized (object) {
                this.connection = (HttpURLConnection)uRL.openConnection();
                this.connection.setRequestProperty("Cache-Control", "no-cache");
                this.connection.setRequestProperty("User-Agent", Version.getInstance().getAgentString());
                this.connection.setRequestProperty("Host", uRL.getHost());
                this.connection.setRequestProperty("Accept-Charset", "utf-8");
            }
            bufferedReader = new BufferedReader(new InputStreamReader(this.connection.getInputStream(), "UTF-8"));
            while ((object = bufferedReader.readLine()) != null) {
                stringBuilder.append((String)object).append("\n");
            }
            string2 = stringBuilder.toString();
            readRemotePluginInformationTask = this;
        }
        catch (MalformedURLException malformedURLException) {
            block33: {
                if (!this.canceled) break block33;
                String string5 = null;
                return string5;
            }
            malformedURLException.printStackTrace();
            String string6 = null;
            return string6;
        }
        catch (IOException iOException) {
            block34: {
                if (!this.canceled) break block34;
                String string7 = null;
                return string7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            iOException.printStackTrace();
            String string8 = null;
            return string8;
        }
        finally {
            ReadRemotePluginInformationTask readRemotePluginInformationTask2 = this;
            synchronized (readRemotePluginInformationTask2) {
                if (this.connection != null) {
                    this.connection.disconnect();
                }
                this.connection = null;
            }
            Utils.close(bufferedReader);
            progressMonitor.finishTask();
        }
        synchronized (readRemotePluginInformationTask) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
            this.connection = null;
        }
        Utils.close(bufferedReader);
        progressMonitor.finishTask();
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    protected void downloadPluginIcons(String string, File file, ProgressMonitor progressMonitor) {
        Iterator<PluginInformation> iterator;
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            string = string.replaceAll("%<(.*)>", "");
            progressMonitor.beginTask("");
            progressMonitor.indeterminateSubTask(I18n.tr("Downloading plugin list from ''{0}''", string));
            iterator = new URL(string);
            Object object = this;
            synchronized (object) {
                this.connection = (HttpURLConnection)((URL)((Object)iterator)).openConnection();
                this.connection.setRequestProperty("Cache-Control", "no-cache");
                this.connection.setRequestProperty("User-Agent", Version.getInstance().getAgentString());
                this.connection.setRequestProperty("Host", ((URL)((Object)iterator)).getHost());
            }
            inputStream = this.connection.getInputStream();
            fileOutputStream = new FileOutputStream(file);
            object = new byte[8192];
            int n = inputStream.read((byte[])object);
            while (n != -1) {
                ((OutputStream)fileOutputStream).write((byte[])object, 0, n);
                n = inputStream.read((byte[])object);
            }
            ((OutputStream)fileOutputStream).close();
            inputStream.close();
            iterator = this;
        }
        catch (MalformedURLException malformedURLException) {
            block34: {
                if (!this.canceled) break block34;
                return;
            }
            malformedURLException.printStackTrace();
            return;
        }
        catch (IOException iOException) {
            block35: {
                if (!this.canceled) break block35;
                return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            iOException.printStackTrace();
            return;
        }
        finally {
            ReadRemotePluginInformationTask readRemotePluginInformationTask = this;
            synchronized (readRemotePluginInformationTask) {
                if (this.connection != null) {
                    this.connection.disconnect();
                }
                this.connection = null;
            }
            Utils.close(inputStream);
            progressMonitor.finishTask();
        }
        synchronized (iterator) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
            this.connection = null;
        }
        Utils.close(inputStream);
        progressMonitor.finishTask();
        for (Object object : this.availablePlugins) {
            if (((PluginInformation)object).icon != null || ((PluginInformation)object).iconPath == null) continue;
            ((PluginInformation)object).icon = new ImageProvider(((PluginInformation)object).name + ".jar/" + ((PluginInformation)object).iconPath).setArchive(file).setMaxWidth(24).setMaxHeight(24).setOptional(true).get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cachePluginList(String string, String string2) {
        PrintWriter printWriter = null;
        try {
            File file = Main.pref.getPluginsDirectory();
            if (!file.exists() && !file.mkdirs()) {
                System.err.println(I18n.tr("Warning: failed to create plugin directory ''{0}''. Cannot cache plugin list from plugin site ''{1}''.", file.toString(), string));
            }
            File file2 = this.createSiteCacheFile(file, string, CacheType.PLUGIN_LIST);
            this.getProgressMonitor().subTask(I18n.tr("Writing plugin list to local cache ''{0}''", file2.toString()));
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "utf-8"));
            printWriter.write(string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (printWriter != null) {
                printWriter.flush();
                printWriter.close();
            }
        }
    }

    protected List<PluginInformation> filterDeprecatedPlugins(List<PluginInformation> list) {
        ArrayList<PluginInformation> arrayList = new ArrayList<PluginInformation>(list.size());
        HashSet<String> hashSet = new HashSet<String>();
        for (PluginHandler.DeprecatedPlugin object : PluginHandler.DEPRECATED_PLUGINS) {
            hashSet.add(object.name);
        }
        for (PluginInformation pluginInformation : list) {
            if (hashSet.contains(pluginInformation.name)) continue;
            arrayList.add(pluginInformation);
        }
        return arrayList;
    }

    protected void parsePluginListDocument(String string, String string2) {
        try {
            this.getProgressMonitor().subTask(I18n.tr("Parsing plugin list from site ''{0}''", string));
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes("UTF-8"));
            List<PluginInformation> list = new PluginListParser().parse(byteArrayInputStream);
            this.availablePlugins.addAll(this.filterDeprecatedPlugins(list));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println(I18n.tr("Failed to parse plugin list document from site ''{0}''. Skipping site. Exception was: {1}", string, unsupportedEncodingException.toString()));
            unsupportedEncodingException.printStackTrace();
        }
        catch (PluginListParseException pluginListParseException) {
            System.err.println(I18n.tr("Failed to parse plugin list document from site ''{0}''. Skipping site. Exception was: {1}", string, pluginListParseException.toString()));
            pluginListParseException.printStackTrace();
        }
    }

    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        Object object;
        if (this.sites == null) {
            return;
        }
        this.getProgressMonitor().setTicksCount(this.sites.size() * 3);
        File file = Main.pref.getPluginsDirectory();
        LinkedList<File> linkedList = new LinkedList<File>();
        for (String object2 : PluginInformation.getPluginLocations()) {
            object = new File(object2).listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.matches("^([0-9]+-)?site.*\\.txt$") || string.matches("^([0-9]+-)?site.*-icons\\.zip$");
                }
            });
            if (object == null || ((File[])object).length <= 0) continue;
            linkedList.addAll(Arrays.asList(object));
        }
        for (String string : this.sites) {
            object = string.replaceAll("%<(.*)>", "");
            this.getProgressMonitor().subTask(I18n.tr("Processing plugin list from site ''{0}''", object));
            String string2 = this.downloadPluginList(string, this.getProgressMonitor().createSubTaskMonitor(0, false));
            if (this.canceled) {
                return;
            }
            linkedList.remove(this.createSiteCacheFile(file, string, CacheType.PLUGIN_LIST));
            linkedList.remove(this.createSiteCacheFile(file, string, CacheType.ICON_LIST));
            if (string2 != null) {
                this.getProgressMonitor().worked(1);
                this.cachePluginList(string, string2);
                if (this.canceled) {
                    return;
                }
                this.getProgressMonitor().worked(1);
                this.parsePluginListDocument(string, string2);
                if (this.canceled) {
                    return;
                }
                this.getProgressMonitor().worked(1);
                if (this.canceled) {
                    return;
                }
            }
            this.downloadPluginIcons(string + "-icons.zip", this.createSiteCacheFile(file, string, CacheType.ICON_LIST), this.getProgressMonitor().createSubTaskMonitor(0, false));
        }
        for (File file2 : linkedList) {
            file2.delete();
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public List<PluginInformation> getAvailabePlugins() {
        return this.availablePlugins;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum CacheType {
        PLUGIN_LIST,
        ICON_LIST;

    }
}

