/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.io.session.SessionLayerExporter;
import org.openstreetmap.josm.io.session.SessionWriter;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.WindowGeometry;

public class SessionSaveAsAction
extends JosmAction {
    private List<Layer> layers;
    private Map<Layer, SessionLayerExporter> exporters;
    private MultiMap<Layer, Layer> dependencies;
    private boolean zipRequired;

    public SessionSaveAsAction() {
        super(I18n.tr("Save Session As...", new Object[0]), "save_as", I18n.tr("Save the current session to a new file.", new Object[0]), null, true, "save_as-session", true);
        this.putValue("help", HelpUtil.ht("/Action/SessionSaveAs"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2;
        if (!this.isEnabled()) {
            return;
        }
        SessionSaveAsDialog sessionSaveAsDialog = new SessionSaveAsDialog();
        sessionSaveAsDialog.showDialog();
        if (sessionSaveAsDialog.getValue() != 2) {
            return;
        }
        this.zipRequired = false;
        Object object3 = this.layers.iterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            object = this.exporters.get(object2);
            if (!object.requiresZip()) continue;
            this.zipRequired = true;
            break;
        }
        if (((String)(object3 = Main.pref.get("lastDirectory"))).equals("")) {
            object3 = ".";
        }
        object2 = new JFileChooser(new File((String)object3));
        ((JFileChooser)object2).setDialogTitle(I18n.tr("Save session", new Object[0]));
        ((JFileChooser)object2).setFileSelectionMode(0);
        object = new ExtensionFileFilter("joz", "joz", I18n.tr("Session file (archive) (*.joz)", new Object[0]));
        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter("jos", "jos", I18n.tr("Session file (*.jos)", new Object[0]));
        if (this.zipRequired) {
            ((JFileChooser)object2).addChoosableFileFilter((FileFilter)object);
        } else {
            ((JFileChooser)object2).addChoosableFileFilter(extensionFileFilter);
            ((JFileChooser)object2).addChoosableFileFilter((FileFilter)object);
            ((JFileChooser)object2).setFileFilter(extensionFileFilter);
        }
        int n = ((JFileChooser)object2).showSaveDialog(Main.parent);
        if (n != 0) {
            return;
        }
        if (!((JFileChooser)object2).getCurrentDirectory().getAbsolutePath().equals(object3)) {
            Main.pref.put("lastDirectory", ((JFileChooser)object2).getCurrentDirectory().getAbsolutePath());
        }
        File file = ((JFileChooser)object2).getSelectedFile();
        String string = file.getName();
        FileFilter fileFilter = ((JFileChooser)object2).getFileFilter();
        boolean bl = this.zipRequired ? true : (fileFilter == object ? true : (fileFilter == extensionFileFilter ? false : string.toLowerCase().endsWith(".joz")));
        if (string.indexOf(46) == -1) {
            file = new File(file.getPath() + (bl ? ".joz" : ".jos"));
        }
        if (!SaveActionBase.confirmOverwrite(file)) {
            return;
        }
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        for (Layer layer : this.layers) {
            if (this.exporters.get(layer) == null || !this.exporters.get(layer).shallExport()) continue;
            arrayList.add(layer);
        }
        SessionWriter sessionWriter = new SessionWriter(arrayList, this.exporters, this.dependencies, bl);
        try {
            sessionWriter.write(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, I18n.tr("<html>Could not save session file ''{0}''.<br>Error is:<br>{1}</html>", file.getName(), iOException.getMessage()), I18n.tr("IO Error", new Object[0]), 0, null);
        }
    }

    public class SessionSaveAsDialog
    extends ExtendedDialog {
        public SessionSaveAsDialog() {
            super(Main.parent, I18n.tr("Save Session", new Object[0]), new String[]{I18n.tr("Cancel", new Object[0]), I18n.tr("Save As", new Object[0])});
            this.initialize();
            this.setButtonIcons(new String[]{"cancel", "save_as"});
            this.setDefaultButton(2);
            this.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(350, 450)));
            this.setContent(this.build(), false);
        }

        public void initialize() {
            SessionSaveAsAction.this.layers = new ArrayList<Layer>(Main.map.mapView.getAllLayersAsList());
            SessionSaveAsAction.this.exporters = new HashMap();
            SessionSaveAsAction.this.dependencies = new MultiMap();
            HashSet<Object> hashSet = new HashSet<Object>();
            for (Object object : SessionSaveAsAction.this.layers) {
                Object object2 = SessionWriter.getSessionLayerExporter((Layer)object);
                if (object2 != null) {
                    SessionSaveAsAction.this.exporters.put(object, object2);
                    Collection<Layer> collection = object2.getDependencies();
                    if (collection != null) {
                        SessionSaveAsAction.this.dependencies.putAll(object, collection);
                        continue;
                    }
                    SessionSaveAsAction.this.dependencies.putVoid(object);
                    continue;
                }
                hashSet.add(object);
                SessionSaveAsAction.this.exporters.put(object, null);
            }
            int n = 0;
            block1: while (n != hashSet.size()) {
                n = hashSet.size();
                for (Object object2 : SessionSaveAsAction.this.layers) {
                    if (hashSet.contains(object2)) continue;
                    for (Layer layer : SessionSaveAsAction.this.dependencies.get(object2)) {
                        if (!hashSet.contains(layer)) continue;
                        hashSet.add(object2);
                        SessionSaveAsAction.this.exporters.put(object2, null);
                        break block1;
                    }
                }
            }
        }

        public Component build() {
            Object object2;
            JPanel jPanel = new JPanel(new GridBagLayout());
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            for (Object object2 : SessionSaveAsAction.this.layers) {
                Component component;
                JPanel jPanel3 = new JPanel(new GridBagLayout());
                jPanel3.setBorder(BorderFactory.createEtchedBorder(0));
                SessionLayerExporter sessionLayerExporter = (SessionLayerExporter)SessionSaveAsAction.this.exporters.get(object2);
                if (sessionLayerExporter == null) {
                    if (!SessionSaveAsAction.this.exporters.containsKey(object2)) {
                        throw new AssertionError();
                    }
                    component = this.getDisabledExportPanel((Layer)object2);
                } else {
                    component = sessionLayerExporter.getExportPanel();
                }
                jPanel3.add(component, GBC.std().fill(2));
                jPanel2.add((Component)jPanel3, GBC.eol().fill(2).insets(2, 2, 4, 2));
            }
            jPanel2.add(GBC.glue(0, 1), GBC.eol().fill(3));
            JScrollPane jScrollPane = new JScrollPane(jPanel2);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            jPanel.add((Component)jScrollPane, GBC.eol().fill());
            object2 = new JTabbedPane();
            ((JTabbedPane)object2).addTab(I18n.tr("Layers", new Object[0]), jPanel);
            return object2;
        }

        protected Component getDisabledExportPanel(Layer layer) {
            JPanel jPanel = new JPanel(new GridBagLayout());
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setEnabled(false);
            JLabel jLabel = new JLabel(layer.getName(), layer.getIcon(), 2);
            jLabel.setToolTipText(I18n.tr("No exporter for this layer", new Object[0]));
            jLabel.setEnabled(false);
            jPanel.add((Component)jCheckBox, GBC.std());
            jPanel.add((Component)jLabel, GBC.std());
            jPanel.add(GBC.glue(1, 0), GBC.std().fill(2));
            return jPanel;
        }
    }
}

