/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressTaskId;
import org.openstreetmap.josm.gui.progress.ProgressTaskIds;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadGpsTask
extends AbstractDownloadTask {
    private DownloadTask downloadTask;
    private static final String PATTERN_TRACE_ID = "http://.*openstreetmap.org/trace/\\p{Digit}+/data";
    private static final String PATTERN_TRACKPOINTS_BBOX = "http://.*/api/0.6/trackpoints\\?bbox=.*,.*,.*,.*";
    private static final String PATTERN_EXTERNAL_GPX_SCRIPT = "http://.*exportgpx.*";
    private static final String PATTERN_EXTERNAL_GPX_FILE = "http://.*/(.*\\.gpx)";
    protected String newLayerName = null;

    @Override
    public Future<?> download(boolean bl, Bounds bounds, ProgressMonitor progressMonitor) {
        this.downloadTask = new DownloadTask(bl, new BoundingBoxDownloader(bounds), progressMonitor);
        return Main.worker.submit(this.downloadTask);
    }

    @Override
    public Future<?> loadUrl(boolean bl, String string, ProgressMonitor progressMonitor) {
        if (string != null && (string.matches(PATTERN_TRACE_ID) || string.matches(PATTERN_EXTERNAL_GPX_SCRIPT) || string.matches(PATTERN_EXTERNAL_GPX_FILE))) {
            this.downloadTask = new DownloadTask(bl, new OsmServerLocationReader(string), progressMonitor);
            Matcher matcher = Pattern.compile(PATTERN_EXTERNAL_GPX_FILE).matcher(string);
            this.newLayerName = matcher.matches() ? matcher.group(1) : null;
            return Main.worker.submit(this.downloadTask);
        }
        if (string != null && string.matches(PATTERN_TRACKPOINTS_BBOX)) {
            String[] stringArray = string.split("\\?|=|&");
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals("bbox") || i >= stringArray.length - 1) continue;
                return this.download(bl, new Bounds(stringArray[i + 1], ",", Bounds.ParseMethod.LEFT_BOTTOM_RIGHT_TOP), progressMonitor);
            }
        }
        return null;
    }

    @Override
    public boolean acceptsUrl(String string) {
        return string != null && (string.matches(PATTERN_TRACE_ID) || string.matches(PATTERN_TRACKPOINTS_BBOX) || string.matches(PATTERN_EXTERNAL_GPX_SCRIPT) || string.matches(PATTERN_EXTERNAL_GPX_FILE));
    }

    @Override
    public void cancel() {
        if (this.downloadTask != null) {
            this.downloadTask.cancel();
        }
    }

    class DownloadTask
    extends PleaseWaitRunnable {
        private OsmServerReader reader;
        private GpxData rawData;
        private final boolean newLayer;

        public DownloadTask(boolean bl, OsmServerReader osmServerReader, ProgressMonitor progressMonitor) {
            super(I18n.tr("Downloading GPS data", new Object[0]));
            this.reader = osmServerReader;
            this.newLayer = bl;
        }

        public void realRun() throws IOException, SAXException, OsmTransferException {
            try {
                if (DownloadGpsTask.this.isCanceled()) {
                    return;
                }
                this.rawData = this.reader.parseRawGps(this.progressMonitor.createSubTaskMonitor(-1, false));
            }
            catch (Exception exception) {
                if (DownloadGpsTask.this.isCanceled()) {
                    return;
                }
                if (exception instanceof OsmTransferException) {
                    DownloadGpsTask.this.rememberException(exception);
                }
                DownloadGpsTask.this.rememberException(new OsmTransferException(exception));
            }
        }

        protected void finish() {
            if (DownloadGpsTask.this.isCanceled() || DownloadGpsTask.this.isFailed()) {
                return;
            }
            if (this.rawData == null) {
                return;
            }
            String string = DownloadGpsTask.this.newLayerName != null ? DownloadGpsTask.this.newLayerName : I18n.tr("Downloaded GPX Data", new Object[0]);
            GpxLayer gpxLayer = new GpxLayer(this.rawData, string);
            Layer layer = this.findMergeLayer();
            if (this.newLayer || layer == null) {
                Main.main.addLayer(gpxLayer);
            } else {
                layer.mergeFrom(gpxLayer);
                Main.map.repaint();
            }
        }

        private Layer findMergeLayer() {
            boolean bl = Main.pref.getBoolean("download.gps.mergeWithLocal", false);
            if (!Main.isDisplayingMapView()) {
                return null;
            }
            Layer layer = Main.map.mapView.getActiveLayer();
            if (layer != null && layer instanceof GpxLayer && (bl || ((GpxLayer)layer).data.fromServer)) {
                return layer;
            }
            for (Layer layer2 : Main.map.mapView.getAllLayers()) {
                if (!(layer2 instanceof GpxLayer) || !bl && !((GpxLayer)layer2).data.fromServer) continue;
                return layer2;
            }
            return null;
        }

        protected void cancel() {
            DownloadGpsTask.this.setCanceled(true);
            if (this.reader != null) {
                this.reader.cancel();
            }
        }

        public ProgressTaskId canRunInBackground() {
            return ProgressTaskIds.DOWNLOAD_GPS;
        }
    }
}

