/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.AbstractProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.datum.NTV2Datum;
import org.openstreetmap.josm.data.projection.datum.NTV2GridShiftFileWrapper;
import org.openstreetmap.josm.data.projection.proj.LambertConformalConic;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;

public class Lambert
extends AbstractProjection {
    private static final double[] lat_0s = new double[]{49.5, 46.8, 44.1, 42.165};
    private static final double[] lat_1s = new double[]{Lambert.convertDegreeMinuteSecond(48.0, 35.0, 54.682), Lambert.convertDegreeMinuteSecond(45.0, 53.0, 56.108), Lambert.convertDegreeMinuteSecond(43.0, 11.0, 57.449), Lambert.convertDegreeMinuteSecond(41.0, 33.0, 37.396)};
    private static final double[] lat_2s = new double[]{Lambert.convertDegreeMinuteSecond(50.0, 23.0, 45.282), Lambert.convertDegreeMinuteSecond(47.0, 41.0, 45.652), Lambert.convertDegreeMinuteSecond(44.0, 59.0, 45.938), Lambert.convertDegreeMinuteSecond(42.0, 46.0, 3.588)};
    private static final double[] x_0s = new double[]{600000.0, 600000.0, 600000.0, 234.358};
    private static final double[] y_0s = new double[]{200000.0, 200000.0, 200000.0, 185861.369};
    public static final double cMaxLatZone1Radian = Math.toRadians(51.300000000000004);
    public static final double cMinLatZone1Radian = Math.toRadians(41.49);
    public static final double[][] zoneLimitsDegree = new double[][]{{Math.toDegrees(cMaxLatZone1Radian), 48.15}, {48.15, 45.45}, {45.45, 42.300000000000004}, {42.767667, Math.toDegrees(cMinLatZone1Radian)}};
    public static final double cMinLonZonesRadian = Math.toRadians(-4.416666666666665);
    public static final double cMaxLonZonesRadian = Math.toRadians(9.18);
    public static final double cMaxOverlappingZonesDegree = 1.5;
    public static final int DEFAULT_ZONE = 0;
    private int layoutZone;

    public Lambert() {
        this(0);
    }

    public Lambert(final int n) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException();
        }
        this.layoutZone = n;
        this.ellps = Ellipsoid.clarkeIGN;
        this.datum = new NTV2Datum("ntf_rgf93Grid", null, this.ellps, NTV2GridShiftFileWrapper.ntf_rgf93);
        this.x_0 = x_0s[n];
        this.y_0 = y_0s[n];
        this.lon_0 = 2.337229166666667;
        if (this.proj == null) {
            this.proj = new LambertConformalConic();
        }
        this.proj = new LambertConformalConic();
        try {
            this.proj.initialize(new ProjParameters(){
                {
                    this.ellps = Lambert.this.ellps;
                    this.lat_0 = lat_0s[n];
                    this.lat_1 = lat_1s[n];
                    this.lat_2 = lat_2s[n];
                }
            });
        }
        catch (ProjectionConfigurationException projectionConfigurationException) {
            throw new RuntimeException(projectionConfigurationException);
        }
    }

    public String toString() {
        return I18n.tr("Lambert 4 Zones (France)", new Object[0]);
    }

    public Integer getEpsgCode() {
        return 27561 + this.layoutZone;
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() + this.layoutZone;
    }

    public String getCacheDirectoryName() {
        return "lambert";
    }

    public Bounds getWorldBoundsLatLon() {
        Bounds bounds = new Bounds(new LatLon(Math.max(zoneLimitsDegree[this.layoutZone][1] - 1.5, Math.toDegrees(cMinLatZone1Radian)), Math.toDegrees(cMinLonZonesRadian)), new LatLon(Math.min(zoneLimitsDegree[this.layoutZone][0] + 1.5, Math.toDegrees(cMaxLatZone1Radian)), Math.toDegrees(cMaxLonZonesRadian)), false);
        return bounds;
    }

    public int getLayoutZone() {
        return this.layoutZone;
    }
}

