/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.tools.I18n;

public class ChangesetCacheTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public ChangesetCacheTableCellRenderer() {
        this.setOpaque(true);
    }

    protected void reset() {
        this.setBackground(UIManager.getColor("Table.background"));
        this.setForeground(UIManager.getColor("Table.foreground"));
        this.setFont(UIManager.getFont("Table.font"));
        this.setToolTipText("");
    }

    protected void renderColors(boolean bl) {
        if (bl) {
            this.setBackground(UIManager.getColor("Table.selectionBackground"));
            this.setForeground(UIManager.getColor("Table.selectionForeground"));
        } else {
            this.setBackground(UIManager.getColor("Table.background"));
            this.setForeground(UIManager.getColor("Table.foreground"));
        }
    }

    protected void renderId(Changeset changeset) {
        this.setText(Integer.toString(changeset.getId()));
        this.setToolTipText("");
    }

    protected void renderUploadComment(Changeset changeset) {
        String string = changeset.get("comment");
        if (string == null || string.trim().equals("")) {
            this.setText(I18n.trc("changeset.upload-comment", "empty"));
            this.setFont(UIManager.getFont("Table.font").deriveFont(2));
        } else {
            this.setText(string);
            this.setToolTipText(string);
            this.setFont(UIManager.getFont("Table.font"));
        }
    }

    protected void renderOpen(Changeset changeset) {
        if (changeset.isOpen()) {
            this.setText(I18n.trc("changeset.state", "Open"));
        } else {
            this.setText(I18n.trc("changeset.state", "Closed"));
        }
        this.setToolTipText("");
    }

    protected void renderUser(Changeset changeset) {
        User user = changeset.getUser();
        if (user == null || user.getName().trim().equals("")) {
            this.setFont(UIManager.getFont("Table.font").deriveFont(2));
            this.setText(I18n.tr("anonymous", new Object[0]));
        } else {
            this.setFont(UIManager.getFont("Table.font"));
            this.setText(user.getName());
            this.setToolTipText(user.getName());
        }
    }

    protected void renderDate(Date date) {
        if (date == null) {
            this.setText("");
        } else {
            this.setText(new SimpleDateFormat().format(date));
        }
        this.setToolTipText("");
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object == null) {
            return this;
        }
        this.reset();
        this.renderColors(bl);
        Changeset changeset = (Changeset)object;
        switch (n2) {
            case 0: {
                this.renderId(changeset);
                break;
            }
            case 1: {
                this.renderUploadComment(changeset);
                break;
            }
            case 2: {
                this.renderOpen(changeset);
                break;
            }
            case 3: {
                this.renderUser(changeset);
                break;
            }
            case 4: {
                this.renderDate(changeset.getCreatedAt());
                break;
            }
            case 5: {
                this.renderDate(changeset.getClosedAt());
            }
        }
        return this;
    }
}

