/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.gui.io.SaveLayerInfo;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

class ActionFlagsTableCell
extends JPanel
implements TableCellRenderer,
TableCellEditor {
    protected JCheckBox[] checkBoxes = new JCheckBox[2];
    private CopyOnWriteArrayList<CellEditorListener> listeners;
    private ActionListener al = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            ActionFlagsTableCell.this.fireEditingStopped();
        }
    };

    public ActionFlagsTableCell() {
        this.listeners = new CopyOnWriteArrayList();
        this.setLayout(new GridBagLayout());
        this.checkBoxes[0] = new JCheckBox(I18n.tr("Upload", new Object[0]));
        this.checkBoxes[1] = new JCheckBox(I18n.tr("Save", new Object[0]));
        ActionMap actionMap = this.getActionMap();
        for (int i = 0; i < this.checkBoxes.length; ++i) {
            final JCheckBox jCheckBox = this.checkBoxes[i];
            this.add((Component)jCheckBox, GBC.eol().fill(2));
            jCheckBox.setPreferredSize(new Dimension(jCheckBox.getPreferredSize().width, 19));
            jCheckBox.addActionListener(this.al);
            actionMap.put(jCheckBox.getText(), new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    jCheckBox.setSelected(!jCheckBox.isSelected());
                    ActionFlagsTableCell.this.fireEditingStopped();
                }
            });
        }
        this.setToolTipText(I18n.tr("<html>Select which actions to perform for this layer, if you click the leftmost button.<br/>Check \"upload\" to upload the changes to the OSM server.<br/>Check \"Save\" to save the layer to the file specified on the left.</html>", new Object[0]));
    }

    protected void updateCheckboxes(Object object) {
        boolean[] blArray = object instanceof SaveLayerInfo ? new boolean[]{((SaveLayerInfo)object).isDoUploadToServer(), ((SaveLayerInfo)object).isDoSaveToFile()} : (boolean[])object;
        this.checkBoxes[0].setSelected(blArray[0]);
        this.checkBoxes[1].setSelected(blArray[1]);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.updateCheckboxes(object);
        return this;
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        if (cellEditorListener != null) {
            this.listeners.addIfAbsent(cellEditorListener);
        }
    }

    protected void fireEditingCanceled() {
        for (CellEditorListener cellEditorListener : this.listeners) {
            cellEditorListener.editingCanceled(new ChangeEvent(this));
        }
    }

    protected void fireEditingStopped() {
        for (CellEditorListener cellEditorListener : this.listeners) {
            cellEditorListener.editingStopped(new ChangeEvent(this));
        }
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public Object getCellEditorValue() {
        boolean[] blArray = new boolean[]{this.checkBoxes[0].isSelected(), this.checkBoxes[1].isSelected()};
        return blArray;
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.listeners.remove(cellEditorListener);
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.updateCheckboxes(object);
        return this;
    }
}

