/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.imagery;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.imagery.GeorefImage;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.WMSLayer;
import org.openstreetmap.josm.io.imagery.WMSRequest;

public abstract class Grabber
implements Runnable {
    protected final MapView mv;
    protected final WMSLayer layer;
    private final boolean localOnly;
    protected ProjectionBounds b;
    protected volatile boolean canceled;

    Grabber(MapView mapView, WMSLayer wMSLayer, boolean bl) {
        this.mv = mapView;
        this.layer = wMSLayer;
        this.localOnly = bl;
    }

    abstract void fetch(WMSRequest var1, int var2) throws Exception;

    int width() {
        return this.layer.getBaseImageWidth();
    }

    int height() {
        return this.layer.getBaseImageHeight();
    }

    public void run() {
        while (!this.canceled) {
            WMSRequest wMSRequest = this.layer.getRequest(this.localOnly);
            if (wMSRequest == null) {
                return;
            }
            this.b = this.layer.getBounds(wMSRequest);
            if (wMSRequest.isPrecacheOnly()) {
                if (!this.layer.cache.hasExactMatch(Main.getProjection(), wMSRequest.getPixelPerDegree(), this.b.minEast, this.b.minNorth)) {
                    this.attempt(wMSRequest);
                }
            } else if (!this.loadFromCache(wMSRequest)) {
                this.attempt(wMSRequest);
            }
            this.layer.finishRequest(wMSRequest);
        }
        return;
    }

    protected void attempt(WMSRequest wMSRequest) {
        int n = 5;
        for (int i = 1; i <= n; ++i) {
            if (this.canceled) {
                return;
            }
            try {
                if (!wMSRequest.isPrecacheOnly() && !this.layer.requestIsVisible(wMSRequest)) {
                    return;
                }
                this.fetch(wMSRequest, i);
                break;
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(Grabber.random(1000, 2000));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (i != n) continue;
                exception.printStackTrace();
                wMSRequest.finish(GeorefImage.State.FAILED, null);
                continue;
            }
        }
    }

    public static int random(int n, int n2) {
        return (int)(Math.random() * (double)(n2 + 1 - n)) + n;
    }

    public abstract boolean loadFromCache(WMSRequest var1);

    public void cancel() {
        this.canceled = true;
    }
}

