/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.template_engine;

import java.util.Arrays;
import java.util.List;
import org.openstreetmap.josm.tools.template_engine.ParseError;

public class Tokenizer {
    private final List<Character> specialCharaters = Arrays.asList(Character.valueOf('$'), Character.valueOf('?'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('|'), Character.valueOf('\''), Character.valueOf('!'));
    private final String template;
    private int c;
    private int index;
    private Token currentToken;
    private StringBuilder text = new StringBuilder();

    public Tokenizer(String string) {
        this.template = string;
        this.getChar();
    }

    private void getChar() {
        this.c = this.index >= this.template.length() ? -1 : (int)this.template.charAt(this.index++);
    }

    public Token nextToken() throws ParseError {
        if (this.currentToken != null) {
            Token token = this.currentToken;
            this.currentToken = null;
            return token;
        }
        int n = this.index;
        this.text.setLength(0);
        switch (this.c) {
            case -1: {
                return new Token(TokenType.EOF, n);
            }
            case 123: {
                this.getChar();
                return new Token(TokenType.VARIABLE_START, n);
            }
            case 63: {
                this.getChar();
                if (this.c == 123) {
                    this.getChar();
                    return new Token(TokenType.CONDITION_START, n);
                }
                throw ParseError.unexpectedChar('{', (char)this.c, n);
            }
            case 33: {
                this.getChar();
                if (this.c == 123) {
                    this.getChar();
                    return new Token(TokenType.CONTEXT_SWITCH_START, n);
                }
                throw ParseError.unexpectedChar('{', (char)this.c, n);
            }
            case 125: {
                this.getChar();
                return new Token(TokenType.END, n);
            }
            case 124: {
                this.getChar();
                return new Token(TokenType.PIPE, n);
            }
            case 39: {
                this.getChar();
                return new Token(TokenType.APOSTROPHE, n);
            }
        }
        while (this.c != -1 && !this.specialCharaters.contains(Character.valueOf((char)this.c))) {
            if (this.c == 92) {
                this.getChar();
                if (this.c == 110) {
                    this.c = 10;
                }
            }
            this.text.append((char)this.c);
            this.getChar();
        }
        return new Token(TokenType.TEXT, n, this.text.toString());
    }

    public Token lookAhead() throws ParseError {
        if (this.currentToken == null) {
            this.currentToken = this.nextToken();
        }
        return this.currentToken;
    }

    public Token skip(char c) {
        this.currentToken = null;
        int n = this.index;
        StringBuilder stringBuilder = new StringBuilder();
        while (this.c != c && this.c != -1) {
            if (this.c == 92) {
                this.getChar();
            }
            stringBuilder.append((char)this.c);
            this.getChar();
        }
        return new Token(TokenType.TEXT, n, stringBuilder.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TokenType {
        CONDITION_START,
        VARIABLE_START,
        CONTEXT_SWITCH_START,
        END,
        PIPE,
        APOSTROPHE,
        TEXT,
        EOF;

    }

    public static class Token {
        private final TokenType type;
        private final int position;
        private final String text;

        public Token(TokenType tokenType, int n) {
            this(tokenType, n, null);
        }

        public Token(TokenType tokenType, int n, String string) {
            this.type = tokenType;
            this.position = n;
            this.text = string;
        }

        public TokenType getType() {
            return this.type;
        }

        public int getPosition() {
            return this.position;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return (Object)((Object)this.type) + (this.text != null ? " " + this.text : "");
        }
    }
}

