/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.Font;
import com.kitfox.svg.FontFace;
import com.kitfox.svg.MissingGlyph;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGLoaderHelper;
import com.kitfox.svg.ShapeElement;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class Tspan
extends ShapeElement {
    float[] x = null;
    float[] y = null;
    float[] dx = null;
    float[] dy = null;
    float[] rotate = null;
    private String text = "";
    float cursorX;
    float cursorY;

    public float getCursorX() {
        return this.cursorX;
    }

    public float getCursorY() {
        return this.cursorY;
    }

    public void setCursorX(float f) {
        this.cursorX = f;
    }

    public void setCursorY(float f) {
        this.cursorY = f;
    }

    public void loaderAddText(SVGLoaderHelper sVGLoaderHelper, String string) {
        this.text = this.text + string;
    }

    protected void build() throws SVGException {
        super.build();
        StyleAttribute styleAttribute = new StyleAttribute();
        if (this.getPres(styleAttribute.setName("x"))) {
            this.x = styleAttribute.getFloatList();
        }
        if (this.getPres(styleAttribute.setName("y"))) {
            this.y = styleAttribute.getFloatList();
        }
        if (this.getPres(styleAttribute.setName("dx"))) {
            this.dx = styleAttribute.getFloatList();
        }
        if (this.getPres(styleAttribute.setName("dy"))) {
            this.dy = styleAttribute.getFloatList();
        }
        if (this.getPres(styleAttribute.setName("rotate"))) {
            this.rotate = styleAttribute.getFloatList();
            for (int i = 0; i < this.rotate.length; ++i) {
                this.rotate[i] = (float)Math.toRadians(this.rotate[i]);
            }
        }
    }

    public void addShape(GeneralPath generalPath) throws SVGException {
        Font font;
        if (this.x != null) {
            this.cursorX = this.x[0];
            this.cursorY = this.y[0];
        } else if (this.dx != null) {
            this.cursorX += this.dx[0];
            this.cursorY += this.dy[0];
        }
        StyleAttribute styleAttribute = new StyleAttribute();
        String string = null;
        if (this.getStyle(styleAttribute.setName("font-family"))) {
            string = styleAttribute.getStringValue();
        }
        float f = 12.0f;
        if (this.getStyle(styleAttribute.setName("font-size"))) {
            f = styleAttribute.getFloatValueWithUnits();
        }
        if ((font = this.diagram.getUniverse().getFont(string)) == null) {
            this.addShapeSysFont(generalPath, font, string, f);
            return;
        }
        FontFace fontFace = font.getFontFace();
        int n = fontFace.getAscent();
        float f2 = f / (float)n;
        AffineTransform affineTransform = new AffineTransform();
        this.strokeWidthScalar = 1.0f / f2;
        int n2 = 1;
        for (int i = 0; i < this.text.length(); ++i) {
            String string2;
            MissingGlyph missingGlyph;
            Shape shape;
            affineTransform.setToIdentity();
            affineTransform.setToTranslation(this.cursorX, this.cursorY);
            affineTransform.scale(f2, f2);
            if (this.rotate != null) {
                affineTransform.rotate(this.rotate[n2]);
            }
            if ((shape = (missingGlyph = font.getGlyph(string2 = this.text.substring(i, i + 1))).getPath()) != null) {
                shape = affineTransform.createTransformedShape(shape);
                generalPath.append(shape, false);
            }
            if (this.x != null && n2 < this.x.length) {
                this.cursorX = this.x[n2];
                this.cursorY = this.y[n2++];
            } else if (this.dx != null && n2 < this.dx.length) {
                this.cursorX += this.dx[n2];
                this.cursorY += this.dy[n2++];
            }
            this.cursorX += f2 * (float)missingGlyph.getHorizAdvX();
        }
        this.strokeWidthScalar = 1.0f;
    }

    private void addShapeSysFont(GeneralPath generalPath, Font font, String string, float f) {
        java.awt.Font font2 = new java.awt.Font(string, 0, (int)f);
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        GlyphVector glyphVector = font2.createGlyphVector(fontRenderContext, this.text);
        AffineTransform affineTransform = new AffineTransform();
        int n = 1;
        for (int i = 0; i < this.text.length(); ++i) {
            affineTransform.setToIdentity();
            affineTransform.setToTranslation(this.cursorX, this.cursorY);
            if (this.rotate != null) {
                affineTransform.rotate(this.rotate[Math.min(i, this.rotate.length - 1)]);
            }
            String string2 = this.text.substring(i, i + 1);
            Shape shape = glyphVector.getGlyphOutline(i);
            GlyphMetrics glyphMetrics = glyphVector.getGlyphMetrics(i);
            shape = affineTransform.createTransformedShape(shape);
            generalPath.append(shape, false);
            if (this.x != null && n < this.x.length) {
                this.cursorX = this.x[n];
                this.cursorY = this.y[n++];
                continue;
            }
            if (this.dx == null || n >= this.dx.length) continue;
            this.cursorX += this.dx[n];
            this.cursorY += this.dy[n++];
        }
    }

    public void render(Graphics2D graphics2D) throws SVGException {
        Font font;
        if (this.x != null) {
            this.cursorX = this.x[0];
            this.cursorY = this.y[0];
        } else if (this.dx != null) {
            this.cursorX += this.dx[0];
            this.cursorY += this.dy[0];
        }
        StyleAttribute styleAttribute = new StyleAttribute();
        String string = null;
        if (this.getPres(styleAttribute.setName("font-family"))) {
            string = styleAttribute.getStringValue();
        }
        float f = 12.0f;
        if (this.getPres(styleAttribute.setName("font-size"))) {
            f = styleAttribute.getFloatValueWithUnits();
        }
        if ((font = this.diagram.getUniverse().getFont(string)) == null) {
            System.err.println("Could not load font");
            java.awt.Font font2 = new java.awt.Font(string, 0, (int)f);
            this.renderSysFont(graphics2D, font2);
            return;
        }
        FontFace fontFace = font.getFontFace();
        int n = fontFace.getAscent();
        float f2 = f / (float)n;
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = new AffineTransform();
        this.strokeWidthScalar = 1.0f / f2;
        int n2 = 1;
        for (int i = 0; i < this.text.length(); ++i) {
            affineTransform2.setToTranslation(this.cursorX, this.cursorY);
            affineTransform2.scale(f2, f2);
            graphics2D.transform(affineTransform2);
            String string2 = this.text.substring(i, i + 1);
            MissingGlyph missingGlyph = font.getGlyph(string2);
            Shape shape = missingGlyph.getPath();
            if (shape != null) {
                this.renderShape(graphics2D, shape);
            } else {
                missingGlyph.render(graphics2D);
            }
            if (this.x != null && n2 < this.x.length) {
                this.cursorX = this.x[n2];
                this.cursorY = this.y[n2++];
            } else if (this.dx != null && n2 < this.dx.length) {
                this.cursorX += this.dx[n2];
                this.cursorY += this.dy[n2++];
            }
            this.cursorX += f2 * (float)missingGlyph.getHorizAdvX();
            graphics2D.setTransform(affineTransform);
        }
        this.strokeWidthScalar = 1.0f;
    }

    protected void renderSysFont(Graphics2D graphics2D, java.awt.Font font) throws SVGException {
        boolean bl = true;
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Shape shape = font.createGlyphVector(fontRenderContext, this.text).getOutline(this.cursorX, this.cursorY);
        this.renderShape(graphics2D, shape);
        Rectangle2D rectangle2D = font.getStringBounds(this.text, fontRenderContext);
        this.cursorX += (float)rectangle2D.getWidth();
    }

    public Shape getShape() {
        return null;
    }

    public Rectangle2D getBoundingBox() {
        return null;
    }

    public boolean updateTime(double d) throws SVGException {
        return false;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }
}

