/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.MergeNodesAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Hash;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Storage;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicateNode
extends Test {
    protected static final int DUPLICATE_NODE = 1;
    protected static final int DUPLICATE_NODE_MIXED = 2;
    protected static final int DUPLICATE_NODE_OTHER = 3;
    protected static final int DUPLICATE_NODE_UNCLOSED = 4;
    protected static final int DUPLICATE_NODE_BUILDING = 10;
    protected static final int DUPLICATE_NODE_BOUNDARY = 11;
    protected static final int DUPLICATE_NODE_HIGHWAY = 12;
    protected static final int DUPLICATE_NODE_LANDUSE = 13;
    protected static final int DUPLICATE_NODE_NATURAL = 14;
    protected static final int DUPLICATE_NODE_POWER = 15;
    protected static final int DUPLICATE_NODE_RAILWAY = 16;
    protected static final int DUPLICATE_NODE_WATERWAY = 17;
    Storage<Object> potentialDuplicates;

    public DuplicateNode() {
        super(I18n.tr("Duplicated nodes", new Object[0]), I18n.tr("This test checks that there are no nodes at the very same location.", new Object[0]));
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.potentialDuplicates = new Storage<Object>(new NodeHash());
    }

    @Override
    public void endTest() {
        for (Object object : this.potentialDuplicates) {
            if (object instanceof Node) continue;
            List list = (List)object;
            this.errors.addAll(this.buildTestErrors(this, list));
        }
        super.endTest();
        this.potentialDuplicates = null;
    }

    public List<TestError> buildTestErrors(Test test, List<Node> list) {
        ArrayList<TestError> arrayList = new ArrayList<TestError>();
        MultiMap<Object, Node> multiMap = new MultiMap<Object, Node>();
        for (Node stringArray2 : list) {
            multiMap.put(stringArray2.getKeys(), stringArray2);
        }
        HashMap hashMap = new HashMap();
        String[] stringArray = new String[]{"none", "highway", "railway", "waterway", "boundary", "power", "natural", "landuse", "building"};
        Object object = multiMap.keySet().iterator();
        while (object.hasNext()) {
            Object object2;
            Map map = (Map)object.next();
            if (multiMap.get(map).size() <= 1) continue;
            boolean bl = false;
            for (String string : stringArray) {
                hashMap.put(string, false);
            }
            for (OsmPrimitive osmPrimitive : multiMap.get(map)) {
                if (osmPrimitive.getType() != OsmPrimitiveType.NODE) continue;
                Node string = (Node)osmPrimitive;
                List<OsmPrimitive> list2 = string.getReferrers();
                for (OsmPrimitive osmPrimitive2 : list2) {
                    if (osmPrimitive2.getType() != OsmPrimitiveType.WAY) continue;
                    boolean bl2 = false;
                    Way way = (Way)osmPrimitive2;
                    bl = bl || way.isClosed();
                    Map<String, String> map2 = way.getKeys();
                    for (String string2 : hashMap.keySet()) {
                        if (!map2.containsKey(string2)) continue;
                        hashMap.put(string2, true);
                        bl2 = true;
                    }
                    if (bl2) continue;
                    hashMap.put("none", true);
                }
            }
            int n = 0;
            for (String string : hashMap.keySet()) {
                if (!((Boolean)hashMap.get(string)).booleanValue()) continue;
                ++n;
            }
            if (!bl) {
                object2 = I18n.marktr("Duplicate nodes in two un-closed ways");
                arrayList.add(new TestError(test, Severity.WARNING, I18n.tr("Duplicated nodes", new Object[0]), I18n.tr((String)object2, new Object[0]), (String)object2, 4, multiMap.get(map)));
            } else if (n > 1) {
                object2 = I18n.marktr("Mixed type duplicated nodes");
                arrayList.add(new TestError(test, Severity.WARNING, I18n.tr("Duplicated nodes", new Object[0]), I18n.tr((String)object2, new Object[0]), (String)object2, 2, multiMap.get(map)));
            } else if (((Boolean)hashMap.get("highway")).booleanValue()) {
                object2 = I18n.marktr("Highway duplicated nodes");
                arrayList.add(new TestError(test, Severity.ERROR, I18n.tr("Duplicated nodes", new Object[0]), I18n.tr((String)object2, new Object[0]), (String)object2, 12, multiMap.get(map)));
            } else if (((Boolean)hashMap.get("railway")).booleanValue()) {
                object2 = I18n.marktr("Railway duplicated nodes");
                arrayList.add(new TestError(test, Severity.ERROR, I18n.tr("Duplicated nodes", new Object[0]), I18n.tr((String)object2, new Object[0]), (String)object2, 16, multiMap.get(map)));
            } else if (((Boolean)hashMap.get("waterway")).booleanValue()) {
                object2 = I18n.marktr("Waterway duplicated nodes");
                arrayList.add(new TestError(test, Severity.ERROR, I18n.tr("Duplicated nodes", new Object[0]), I18n.tr((String)object2, new Object[0]), (String)object2, 17, multiMap.get(map)));
            } else if (((Boolean)hashMap.get("boundary")).booleanValue()) {
                object2 = I18n.marktr("Boundary duplicated nodes");
                arrayList.add(new TestError(test, Severity.ERROR, I18n.tr("Duplicated nodes", new Object[0]), I18n.tr((String)object2, new Object[0]), (String)object2, 11, multiMap.get(map)));
            } else if (((Boolean)hashMap.get("power")).booleanValue()) {
                object2 = I18n.marktr("Power duplicated nodes");
                arrayList.add(new TestError(test, Severity.ERROR, I18n.tr("Duplicated nodes", new Object[0]), I18n.tr((String)object2, new Object[0]), (String)object2, 15, multiMap.get(map)));
            } else if (((Boolean)hashMap.get("natural")).booleanValue()) {
                object2 = I18n.marktr("Natural duplicated nodes");
                arrayList.add(new TestError(test, Severity.ERROR, I18n.tr("Duplicated nodes", new Object[0]), I18n.tr((String)object2, new Object[0]), (String)object2, 14, multiMap.get(map)));
            } else if (((Boolean)hashMap.get("building")).booleanValue()) {
                object2 = I18n.marktr("Building duplicated nodes");
                arrayList.add(new TestError(test, Severity.ERROR, I18n.tr("Duplicated nodes", new Object[0]), I18n.tr((String)object2, new Object[0]), (String)object2, 10, multiMap.get(map)));
            } else if (((Boolean)hashMap.get("landuse")).booleanValue()) {
                object2 = I18n.marktr("Landuse duplicated nodes");
                arrayList.add(new TestError(test, Severity.ERROR, I18n.tr("Duplicated nodes", new Object[0]), I18n.tr((String)object2, new Object[0]), (String)object2, 13, multiMap.get(map)));
            } else {
                object2 = I18n.marktr("Other duplicated nodes");
                arrayList.add(new TestError(test, Severity.WARNING, I18n.tr("Duplicated nodes", new Object[0]), I18n.tr((String)object2, new Object[0]), (String)object2, 3, multiMap.get(map)));
            }
            object.remove();
        }
        if (!multiMap.isEmpty()) {
            object = new ArrayList();
            for (LinkedHashSet linkedHashSet : multiMap.values()) {
                object.addAll(linkedHashSet);
            }
            if (object.size() > 1) {
                arrayList.add(new TestError(test, Severity.WARNING, I18n.tr("Nodes at same position", new Object[0]), 1, (Collection<? extends OsmPrimitive>)object));
            }
        }
        return arrayList;
    }

    @Override
    public void visit(Node node) {
        if (node.isUsable()) {
            if (this.potentialDuplicates.get(node) == null) {
                this.potentialDuplicates.put(node);
            } else if (this.potentialDuplicates.get(node) instanceof Node) {
                Node node2 = (Node)this.potentialDuplicates.get(node);
                ArrayList<Node> arrayList = new ArrayList<Node>(2);
                arrayList.add(node2);
                arrayList.add(node);
                this.potentialDuplicates.put(arrayList);
            } else if (this.potentialDuplicates.get(node) instanceof List) {
                List list = (List)this.potentialDuplicates.get(node);
                list.add(node);
            }
        }
    }

    @Override
    public Command fixError(TestError testError) {
        if (!this.isFixable(testError)) {
            return null;
        }
        LinkedList<OsmPrimitive> linkedList = new LinkedList<OsmPrimitive>(testError.getPrimitives());
        LinkedHashSet<Node> linkedHashSet = new LinkedHashSet<Node>(OsmPrimitive.getFilteredList(linkedList, Node.class));
        Object object = linkedHashSet.iterator();
        while (object.hasNext()) {
            if (!((Node)object.next()).isDeleted()) continue;
            object.remove();
        }
        if (linkedHashSet.size() >= 2) {
            object = null;
            for (Node node : linkedHashSet) {
                if (node.isNew()) continue;
                object = node;
                break;
            }
            if (object == null) {
                object = (Node)linkedHashSet.iterator().next();
            }
            if (DeleteCommand.checkAndConfirmOutlyingDelete(Main.main.getCurrentDataSet().getDataSourceArea(), linkedHashSet, Collections.singleton(object))) {
                return MergeNodesAction.mergeNodes(Main.main.getEditLayer(), linkedHashSet, (Node)object);
            }
        }
        return null;
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (!(testError.getTester() instanceof DuplicateNode)) {
            return false;
        }
        if (testError.getCode() == 1) {
            return false;
        }
        return testError.getCode() != 4;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeHash
    implements Hash<Object, Object> {
        double precision = Main.pref.getDouble("validator.duplicatenodes.precision", 0.0);

        private NodeHash() {
        }

        private LatLon RoundCoord(Node node) {
            return new LatLon((double)Math.round(node.getCoor().lat() / this.precision) * this.precision, (double)Math.round(node.getCoor().lon() / this.precision) * this.precision);
        }

        private LatLon getLatLon(Object object) {
            if (object instanceof Node) {
                if (this.precision == 0.0) {
                    return ((Node)object).getCoor().getRoundedToOsmPrecision();
                }
                return this.RoundCoord((Node)object);
            }
            if (object instanceof List) {
                if (this.precision == 0.0) {
                    return ((Node)((List)object).get(0)).getCoor().getRoundedToOsmPrecision();
                }
                return this.RoundCoord((Node)((List)object).get(0));
            }
            throw new AssertionError();
        }

        @Override
        public boolean equals(Object object, Object object2) {
            return this.getLatLon(object).equals(this.getLatLon(object2));
        }

        @Override
        public int getHashCode(Object object) {
            return this.getLatLon(object).hashCode();
        }
    }
}

