/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.Collections;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;

public class WronglyOrderedWays
extends Test {
    protected static final int WRONGLY_ORDERED_COAST = 1001;
    protected static final int WRONGLY_ORDERED_LAND = 1003;

    public WronglyOrderedWays() {
        super(I18n.tr("Wrongly Ordered Ways", new Object[0]), I18n.tr("This test checks the direction of water, land and coastline ways.", new Object[0]));
    }

    public void visit(Way way) {
        if (!way.isUsable() || !way.isClosed()) {
            return;
        }
        String string = way.get("natural");
        if (string == null) {
            return;
        }
        if ("coastline".equals(string) && Geometry.isClockwise(way)) {
            this.reportError(way, I18n.tr("Reversed coastline: land not on left side", new Object[0]), 1001);
        } else if ("land".equals(string) && Geometry.isClockwise(way)) {
            this.reportError(way, I18n.tr("Reversed land: land not on left side", new Object[0]), 1003);
        } else {
            return;
        }
    }

    private void reportError(Way way, String string, int n) {
        this.errors.add(new TestError((Test)this, Severity.WARNING, string, n, Collections.singletonList(way)));
    }
}

