/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.gui.HideableButton;
import org.openstreetmap.josm.gui.ShowHideButtonListener;
import org.openstreetmap.josm.tools.Destroyable;

public class IconToggleButton
extends JToggleButton
implements HideableButton,
PropertyChangeListener,
Destroyable,
ExpertToggleAction.ExpertModeChangeListener {
    public boolean groupbutton;
    private ShowHideButtonListener listener;
    private boolean hideIfDisabled = false;
    private boolean isExpert;

    public IconToggleButton(Action action) {
        this(action, false);
    }

    public IconToggleButton(Action action, boolean bl) {
        super(action);
        this.isExpert = bl;
        this.setText(null);
        Object object = action.getValue("ShortDescription");
        if (object != null) {
            this.setToolTipText(object.toString());
        }
        action.addPropertyChangeListener(this);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                IconToggleButton.this.groupbutton = mouseEvent.getX() > IconToggleButton.this.getWidth() / 2 && mouseEvent.getY() > IconToggleButton.this.getHeight() / 2;
            }
        });
        ExpertToggleAction.addExpertModeChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("active")) {
            this.setSelected((Boolean)propertyChangeEvent.getNewValue());
            this.requestFocusInWindow();
        } else if (propertyChangeEvent.getPropertyName().equals("selected")) {
            this.setSelected((Boolean)propertyChangeEvent.getNewValue());
        }
    }

    public void destroy() {
        Action action = this.getAction();
        if (action instanceof Destroyable) {
            ((Destroyable)((Object)action)).destroy();
        }
        if (action != null) {
            action.removePropertyChangeListener(this);
        }
    }

    String getPreferenceKey() {
        String string = (String)this.getSafeActionValue("toolbar");
        if (string == null && this.getAction() != null) {
            string = this.getAction().getClass().getName();
        }
        return "sidetoolbar.hidden." + string;
    }

    public void expertChanged(boolean bl) {
        this.applyButtonHiddenPreferences();
    }

    public void applyButtonHiddenPreferences() {
        boolean bl = Main.pref.getBoolean("sidetoolbar.hideDisabledButtons", false);
        if (!this.isEnabled() && (this.hideIfDisabled || bl)) {
            this.setVisible(false);
        } else {
            boolean bl2 = false;
            String string = Main.pref.get(this.getPreferenceKey(), null);
            if (string == null) {
                if (this.isExpert && !ExpertToggleAction.isExpert()) {
                    bl2 = true;
                }
            } else {
                bl2 = Boolean.parseBoolean(string);
            }
            this.setVisible(!bl2);
        }
    }

    public void setButtonHidden(boolean bl) {
        this.setVisible(!bl);
        if (this.listener != null) {
            if (!bl) {
                this.listener.buttonShown();
            } else {
                this.listener.buttonHidden();
            }
        }
        if (bl && this.isExpert && !ExpertToggleAction.isExpert() || !bl && this.isExpert && ExpertToggleAction.isExpert()) {
            Main.pref.put(this.getPreferenceKey(), null);
        } else {
            Main.pref.put(this.getPreferenceKey(), bl);
        }
    }

    public void setAutoHideDisabledButton(boolean bl) {
        this.hideIfDisabled = bl;
        if (bl && !this.isEnabled()) {
            this.setVisible(false);
        }
    }

    public void showButton() {
        this.setButtonHidden(false);
    }

    public void hideButton() {
        this.setButtonHidden(true);
    }

    public String getActionName() {
        return (String)this.getSafeActionValue("Name");
    }

    public Icon getIcon() {
        return (Icon)this.getSafeActionValue("SmallIcon");
    }

    public boolean isButtonVisible() {
        return this.isVisible();
    }

    public void setShowHideButtonListener(ShowHideButtonListener showHideButtonListener) {
        this.listener = showHideButtonListener;
    }

    protected final Object getSafeActionValue(String string) {
        return this.getAction() != null ? this.getAction().getValue(string) : null;
    }
}

