/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.actionsupport;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.UrlLabel;

public class AlignImageryPanel
extends JPanel {
    private static final String PREF = "imagery.offsetnagging";

    public AlignImageryPanel(boolean bl) {
        Font font = this.getFont().deriveFont(0, 14.0f);
        JLabel jLabel = new JLabel(I18n.tr("Aerial imagery might be misaligned. Please check its offset using GPS tracks!", new Object[0]));
        UrlLabel urlLabel = new UrlLabel(I18n.tr("http://wiki.openstreetmap.org/wiki/Using_Imagery", new Object[0]), I18n.tr("Details...", new Object[0]));
        jLabel.setFont(font);
        urlLabel.setFont(font);
        JButton jButton = new JButton(ImageProvider.get("misc", "black_x"));
        jButton.setContentAreaFilled(false);
        jButton.setRolloverEnabled(true);
        jButton.setBorderPainted(false);
        jButton.setToolTipText(I18n.tr("Hide this message and never show it again", new Object[0]));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Main.map != null) {
                    Main.map.removeTopPanel(AlignImageryPanel.class);
                    Main.pref.put(AlignImageryPanel.PREF, false);
                }
            }
        });
        this.setLayout(new GridBagLayout());
        if (!bl) {
            this.add((Component)jLabel, GBC.std(1, 1).fill());
            this.add((Component)urlLabel, GBC.std(1, 2).fill());
            this.add((Component)jButton, GBC.std(2, 1).span(1, 2).anchor(13));
        } else {
            this.add((Component)jLabel, GBC.std(1, 1).fill());
            this.add((Component)urlLabel, GBC.std(2, 1).fill());
            this.add((Component)jButton, GBC.std(3, 1).anchor(13));
        }
        this.setBorder(new CompoundBorder(new EtchedBorder(1), new EmptyBorder(12, 12, 12, 12)));
        this.setBackground(new Color(224, 236, 249));
    }

    public static void addNagPanelIfNeeded() {
        if (Main.map != null && !Main.pref.getBoolean("expert") && Main.pref.getBoolean(PREF, true) && Main.map.getTopPanel(AlignImageryPanel.class) == null) {
            double d = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
            AlignImageryPanel alignImageryPanel = new AlignImageryPanel(d > 1300.0);
            Main.map.addTopPanel(alignImageryPanel);
        }
    }
}

