/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.projection;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.preferences.CollectionProperty;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.data.projection.BelgianLambert1972;
import org.openstreetmap.josm.data.projection.BelgianLambert2008;
import org.openstreetmap.josm.data.projection.Epsg3008;
import org.openstreetmap.josm.data.projection.Epsg4326;
import org.openstreetmap.josm.data.projection.Lambert93;
import org.openstreetmap.josm.data.projection.LambertEST;
import org.openstreetmap.josm.data.projection.Mercator;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.TransverseMercatorLV;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.projection.Alias;
import org.openstreetmap.josm.gui.preferences.projection.CustomProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.GaussKruegerProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.LambertCC9ZonesProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.LambertProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.PuwgProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.SingleProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.SubPrefsOptions;
import org.openstreetmap.josm.gui.preferences.projection.SwissGridProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.UTMProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.UTM_France_DOM_ProjectionChoice;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectionPreference
implements SubPreferenceSetting {
    private static List<ProjectionChoice> projectionChoices = new ArrayList<ProjectionChoice>();
    private static Map<String, ProjectionChoice> projectionChoicesById = new HashMap<String, ProjectionChoice>();
    private static Map<String, String> aliasNormalizer = new HashMap<String, String>();
    public static ProjectionChoice mercator = new SingleProjectionChoice("core:mercator", new Mercator());
    private static final StringProperty PROP_PROJECTION;
    private static final StringProperty PROP_COORDINATES;
    private static final CollectionProperty PROP_SUB_PROJECTION;
    public static final StringProperty PROP_SYSTEM_OF_MEASUREMENT;
    private static final String[] unitsValues;
    private static final String[] unitsValuesTr;
    private JComboBox projectionCombo = new JComboBox<Object>(projectionChoices.toArray());
    private JComboBox coordinatesCombo = new JComboBox<CoordinateFormat>(CoordinateFormat.values());
    private JComboBox unitsCombo = new JComboBox<String>(unitsValuesTr);
    private JPanel projSubPrefPanel;
    private JPanel projSubPrefPanelWrapper = new JPanel(new GridBagLayout());
    private JLabel projectionCodeLabel;
    private Component projectionCodeGlue;
    private JLabel projectionCode = new JLabel();
    private JLabel bounds = new JLabel();
    private JPanel projPanel = new JPanel(new GridBagLayout());
    private static GBC projSubPrefPanelGBC;

    public static void registerProjectionChoice(ProjectionChoice projectionChoice) {
        projectionChoices.add(projectionChoice);
        projectionChoicesById.put(projectionChoice.getId(), projectionChoice);
        aliasNormalizer.put(projectionChoice.getId(), projectionChoice.getId());
        if (projectionChoice instanceof Alias) {
            String string = ((Alias)((Object)projectionChoice)).getAlias();
            projectionChoicesById.put(string, projectionChoice);
            aliasNormalizer.put(string, projectionChoice.getId());
        }
    }

    public static void registerProjectionChoice(String string, Projection projection) {
        ProjectionPreference.registerProjectionChoice(new SingleProjectionChoice(string, projection));
    }

    public static List<ProjectionChoice> getProjectionChoices() {
        return Collections.unmodifiableList(projectionChoices);
    }

    @Override
    public void addGui(PreferenceTabbedPane preferenceTabbedPane) {
        int n;
        ProjectionChoice projectionChoice = this.setupProjectionCombo();
        for (n = 0; n < this.coordinatesCombo.getItemCount(); ++n) {
            if (!((CoordinateFormat)((Object)this.coordinatesCombo.getItemAt(n))).name().equals(PROP_COORDINATES.get())) continue;
            this.coordinatesCombo.setSelectedIndex(n);
            break;
        }
        for (n = 0; n < unitsValues.length; ++n) {
            if (!unitsValues[n].equals(PROP_SYSTEM_OF_MEASUREMENT.get())) continue;
            this.unitsCombo.setSelectedIndex(n);
            break;
        }
        this.projPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.projPanel.setLayout(new GridBagLayout());
        this.projPanel.add((Component)new JLabel(I18n.tr("Projection method", new Object[0])), GBC.std().insets(5, 5, 0, 5));
        this.projPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.projPanel.add((Component)this.projectionCombo, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projectionCodeLabel = new JLabel(I18n.tr("Projection code", new Object[0]));
        this.projPanel.add((Component)this.projectionCodeLabel, GBC.std().insets(25, 5, 0, 5));
        this.projectionCodeGlue = GBC.glue(5, 0);
        this.projPanel.add(this.projectionCodeGlue, GBC.std().fill(2));
        this.projPanel.add((Component)this.projectionCode, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add((Component)new JLabel(I18n.tr("Bounds", new Object[0])), GBC.std().insets(25, 5, 0, 5));
        this.projPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.projPanel.add((Component)this.bounds, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add((Component)this.projSubPrefPanelWrapper, GBC.eol().fill(2).insets(20, 5, 5, 5));
        this.projPanel.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 10));
        this.projPanel.add((Component)new JLabel(I18n.tr("Display coordinates as", new Object[0])), GBC.std().insets(5, 5, 0, 5));
        this.projPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.projPanel.add((Component)this.coordinatesCombo, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add((Component)new JLabel(I18n.tr("System of measurement", new Object[0])), GBC.std().insets(5, 5, 0, 5));
        this.projPanel.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.projPanel.add((Component)this.unitsCombo, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add(GBC.glue(1, 1), GBC.std().fill(2).weight(1.0, 1.0));
        JScrollPane jScrollPane = new JScrollPane(this.projPanel);
        preferenceTabbedPane.getMapPreference().mapcontent.addTab(I18n.tr("Map Projection", new Object[0]), jScrollPane);
        this.selectedProjectionChanged(projectionChoice);
    }

    private void updateMeta(ProjectionChoice projectionChoice) {
        projectionChoice.setPreferences(projectionChoice.getPreferences(this.projSubPrefPanel));
        Projection projection = projectionChoice.getProjection();
        this.projectionCode.setText(projection.toCode());
        Bounds bounds = projection.getWorldBoundsLatLon();
        CoordinateFormat coordinateFormat = CoordinateFormat.getDefaultFormat();
        this.bounds.setText(bounds.getMin().lonToString(coordinateFormat) + ", " + bounds.getMin().latToString(coordinateFormat) + " : " + bounds.getMax().lonToString(coordinateFormat) + ", " + bounds.getMax().latToString(coordinateFormat));
        boolean bl = true;
        if (projectionChoice instanceof SubPrefsOptions) {
            bl = ((SubPrefsOptions)((Object)projectionChoice)).showProjectionCode();
        }
        this.projectionCodeLabel.setVisible(bl);
        this.projectionCodeGlue.setVisible(bl);
        this.projectionCode.setVisible(bl);
    }

    @Override
    public boolean ok() {
        ProjectionChoice projectionChoice = (ProjectionChoice)this.projectionCombo.getSelectedItem();
        String string = projectionChoice.getId();
        Collection<String> collection = projectionChoice.getPreferences(this.projSubPrefPanel);
        ProjectionPreference.setProjection(string, collection);
        if (PROP_COORDINATES.put(((CoordinateFormat)((Object)this.coordinatesCombo.getSelectedItem())).name())) {
            CoordinateFormat.setCoordinateFormat((CoordinateFormat)((Object)this.coordinatesCombo.getSelectedItem()));
        }
        int n = this.unitsCombo.getSelectedIndex();
        PROP_SYSTEM_OF_MEASUREMENT.put(unitsValues[n]);
        return false;
    }

    public static void setProjection() {
        ProjectionPreference.setProjection(PROP_PROJECTION.get(), PROP_SUB_PROJECTION.get());
    }

    public static void setProjection(String string, Collection<String> collection) {
        ProjectionChoice projectionChoice = projectionChoicesById.get(string);
        if (projectionChoice == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("The projection {0} could not be activated. Using Mercator", string), I18n.tr("Error", new Object[0]), 0);
            collection = null;
            projectionChoice = mercator;
        }
        string = projectionChoice.getId();
        PROP_PROJECTION.put(string);
        PROP_SUB_PROJECTION.put(collection);
        Main.pref.putCollection("projection.sub." + string, collection);
        projectionChoice.setPreferences(collection);
        Projection projection = projectionChoice.getProjection();
        Main.setProjection(projection);
    }

    private void selectedProjectionChanged(final ProjectionChoice projectionChoice) {
        int n = this.projPanel.getComponentCount();
        if (n < 1) {
            return;
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectionPreference.this.updateMeta(projectionChoice);
            }
        };
        this.projSubPrefPanelWrapper.removeAll();
        this.projSubPrefPanel = projectionChoice.getPreferencePanel(actionListener);
        this.projSubPrefPanelWrapper.add((Component)this.projSubPrefPanel, projSubPrefPanelGBC);
        this.projPanel.revalidate();
        this.projSubPrefPanel.repaint();
        this.updateMeta(projectionChoice);
    }

    private ProjectionChoice setupProjectionCombo() {
        ProjectionChoice projectionChoice = null;
        for (int i = 0; i < this.projectionCombo.getItemCount(); ++i) {
            ProjectionChoice projectionChoice2 = (ProjectionChoice)this.projectionCombo.getItemAt(i);
            projectionChoice2.setPreferences(this.getSubprojectionPreference(projectionChoice2));
            if (!projectionChoice2.getId().equals(aliasNormalizer.get(PROP_PROJECTION.get()))) continue;
            this.projectionCombo.setSelectedIndex(i);
            this.selectedProjectionChanged(projectionChoice2);
            projectionChoice = projectionChoice2;
        }
        if (projectionChoice == null) {
            throw new RuntimeException("Couldn't find the current projection in the list of available projections!");
        }
        this.projectionCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProjectionChoice projectionChoice = (ProjectionChoice)ProjectionPreference.this.projectionCombo.getSelectedItem();
                ProjectionPreference.this.selectedProjectionChanged(projectionChoice);
            }
        });
        return projectionChoice;
    }

    private Collection<String> getSubprojectionPreference(ProjectionChoice projectionChoice) {
        Collection<String> collection = Main.pref.getCollection("projection.sub." + projectionChoice.getId(), null);
        if (collection != null) {
            return collection;
        }
        if (projectionChoice instanceof Alias) {
            String string = ((Alias)((Object)projectionChoice)).getAlias();
            String string2 = string.substring(string.lastIndexOf(".") + 1);
            return Main.pref.getCollection("projection.sub." + string2, null);
        }
        return null;
    }

    @Override
    public boolean isExpert() {
        return false;
    }

    @Override
    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane preferenceTabbedPane) {
        return preferenceTabbedPane.getMapPreference();
    }

    static {
        ProjectionPreference.registerProjectionChoice("core:wgs84", new Epsg4326());
        ProjectionPreference.registerProjectionChoice(mercator);
        ProjectionPreference.registerProjectionChoice(new UTMProjectionChoice());
        ProjectionPreference.registerProjectionChoice("core:belambert1972", new BelgianLambert1972());
        ProjectionPreference.registerProjectionChoice("core:belambert2008", new BelgianLambert2008());
        ProjectionPreference.registerProjectionChoice(new SwissGridProjectionChoice());
        ProjectionPreference.registerProjectionChoice(new GaussKruegerProjectionChoice());
        ProjectionPreference.registerProjectionChoice("core:lambertest", new LambertEST());
        ProjectionPreference.registerProjectionChoice(new LambertProjectionChoice());
        ProjectionPreference.registerProjectionChoice("core:lambert93", new Lambert93());
        ProjectionPreference.registerProjectionChoice(new LambertCC9ZonesProjectionChoice());
        ProjectionPreference.registerProjectionChoice(new UTM_France_DOM_ProjectionChoice());
        ProjectionPreference.registerProjectionChoice("core:tmerclv", new TransverseMercatorLV());
        ProjectionPreference.registerProjectionChoice(new PuwgProjectionChoice());
        ProjectionPreference.registerProjectionChoice("core:sweref99", new Epsg3008());
        ProjectionPreference.registerProjectionChoice(new CustomProjectionChoice());
        PROP_PROJECTION = new StringProperty("projection", mercator.getId());
        PROP_COORDINATES = new StringProperty("coordinates", null);
        PROP_SUB_PROJECTION = new CollectionProperty("projection.sub", null);
        PROP_SYSTEM_OF_MEASUREMENT = new StringProperty("system_of_measurement", "Metric");
        unitsValues = new ArrayList<String>(NavigatableComponent.SYSTEMS_OF_MEASUREMENT.keySet()).toArray(new String[0]);
        unitsValuesTr = new String[unitsValues.length];
        for (int i = 0; i < unitsValues.length; ++i) {
            ProjectionPreference.unitsValuesTr[i] = I18n.tr(unitsValues[i], new Object[0]);
        }
        projSubPrefPanelGBC = GBC.std().fill(1).weight(1.0, 1.0);
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new ProjectionPreference();
        }
    }
}

