/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.io.FileExporter;
import org.openstreetmap.josm.io.GpxWriter;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class GpxExporter
extends FileExporter {
    private static final String warningGpl = "<html><font color='red' size='-2'>" + I18n.tr("Note: GPL is not compatible with the OSM license. Do not upload GPL licensed tracks.", new Object[0]) + "</html>";

    public GpxExporter() {
        super(new ExtensionFileFilter("gpx,gpx.gz", "gpx", I18n.tr("GPX Files", new Object[0]) + " (*.gpx *.gpx.gz)"));
    }

    public boolean acceptFile(File file, Layer layer) {
        if (!(layer instanceof OsmDataLayer) && !(layer instanceof GpxLayer)) {
            return false;
        }
        return super.acceptFile(file, layer);
    }

    public void exportData(File file, Layer layer) throws IOException {
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        if (!(layer instanceof OsmDataLayer) && !(layer instanceof GpxLayer)) {
            throw new IllegalArgumentException(MessageFormat.format("Expected instance of OsmDataLayer or GpxLayer. Got ''{0}''.", layer.getClass().getName()));
        }
        CheckParameterUtil.ensureParameterNotNull(file, "file");
        String string = file.getPath();
        if (string.indexOf(46) == -1) {
            string = string + ".gpx";
            file = new File(string);
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("GPS track description", new Object[0])), GBC.eol());
        JTextArea jTextArea = new JTextArea(3, 40);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jPanel.add((Component)new JScrollPane(jTextArea), GBC.eop().fill(1));
        JCheckBox jCheckBox = new JCheckBox(I18n.tr("Add author information", new Object[0]), Main.pref.getBoolean("lastAddAuthor", true));
        jCheckBox.setSelected(true);
        jPanel.add((Component)jCheckBox, GBC.eol());
        JLabel jLabel = new JLabel(I18n.tr("Real name", new Object[0]));
        jPanel.add((Component)jLabel, GBC.std().insets(10, 0, 5, 0));
        JTextField jTextField = new JTextField(Main.pref.get("lastAuthorName"));
        jPanel.add((Component)jTextField, GBC.eol().fill(2));
        JLabel jLabel2 = new JLabel(I18n.tr("E-Mail", new Object[0]));
        jPanel.add((Component)jLabel2, GBC.std().insets(10, 0, 5, 0));
        String string2 = CredentialsManager.getInstance().getUsername();
        JTextField jTextField2 = new JTextField(string2 == null ? "" : string2);
        jPanel.add((Component)jTextField2, GBC.eol().fill(2));
        JLabel jLabel3 = new JLabel(I18n.tr("Copyright (URL)", new Object[0]));
        jPanel.add((Component)jLabel3, GBC.std().insets(10, 0, 5, 0));
        JTextField jTextField3 = new JTextField();
        jPanel.add((Component)jTextField3, GBC.std().fill(2));
        JButton jButton = new JButton(I18n.tr("Predefined", new Object[0]));
        jPanel.add((Component)jButton, GBC.eol().insets(5, 0, 0, 0));
        JLabel jLabel4 = new JLabel(I18n.tr("Copyright year", new Object[0]));
        jPanel.add((Component)jLabel4, GBC.std().insets(10, 0, 5, 5));
        JTextField jTextField4 = new JTextField("");
        jPanel.add((Component)jTextField4, GBC.eol().fill(2));
        JLabel jLabel5 = new JLabel("<html><font size='-2'>&nbsp;</html");
        jPanel.add((Component)jLabel5, GBC.eol().fill(2).insets(15, 0, 0, 0));
        GpxExporter.addDependencies(jCheckBox, jTextField, jTextField2, jTextField3, jButton, jTextField4, jLabel, jLabel2, jLabel3, jLabel4, jLabel5);
        if (!jTextField2.getText().contains("@")) {
            jTextField.setText(jTextField2.getText());
            jTextField2.setText("");
        }
        jPanel.add((Component)new JLabel(I18n.tr("Keywords", new Object[0])), GBC.eol());
        JTextField jTextField5 = new JTextField();
        jPanel.add((Component)jTextField5, GBC.eop().fill(2));
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Export options", new Object[0]), new String[]{I18n.tr("Export and Save", new Object[0]), I18n.tr("Cancel", new Object[0])});
        extendedDialog.setButtonIcons(new String[]{"exportgpx.png", "cancel.png"});
        extendedDialog.setContent(jPanel);
        extendedDialog.showDialog();
        if (extendedDialog.getValue() != 1) {
            return;
        }
        Main.pref.put("lastAddAuthor", jCheckBox.isSelected());
        if (jTextField.getText().length() != 0) {
            Main.pref.put("lastAuthorName", jTextField.getText());
        }
        if (jTextField3.getText().length() != 0) {
            Main.pref.put("lastCopyright", jTextField3.getText());
        }
        GpxData gpxData = layer instanceof OsmDataLayer ? ((OsmDataLayer)layer).toGpxData() : (layer instanceof GpxLayer ? ((GpxLayer)layer).data : OsmDataLayer.toGpxData(this.getCurrentDataSet(), file));
        if (jCheckBox.isSelected()) {
            if (jTextField.getText().length() > 0) {
                gpxData.attr.put("meta.author.name", jTextField.getText());
                gpxData.attr.put("meta.copyright.author", jTextField.getText());
            }
            if (jTextField2.getText().length() > 0) {
                gpxData.attr.put("meta.author.email", jTextField2.getText());
            }
            if (jTextField3.getText().length() > 0) {
                gpxData.attr.put("meta.copyright.license", jTextField3.getText());
            }
            if (jTextField4.getText().length() > 0) {
                gpxData.attr.put("meta.copyright.year", jTextField4.getText());
            }
        }
        if (jTextArea.getText().length() > 0) {
            gpxData.attr.put("meta.desc", jTextArea.getText());
        }
        if (jTextField5.getText().length() > 0) {
            gpxData.attr.put("meta.keywords", jTextField5.getText());
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            new GpxWriter(fileOutputStream).write(gpxData);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error while exporting {0}:\n{1}", string, iOException.getMessage()), I18n.tr("Error", new Object[0]), 0);
        }
    }

    private static void enableCopyright(JTextField jTextField, JButton jButton, JTextField jTextField2, JLabel jLabel, JLabel jLabel2, JLabel jLabel3, boolean bl) {
        jTextField.setEnabled(bl);
        jButton.setEnabled(bl);
        jTextField2.setEnabled(bl);
        jLabel.setEnabled(bl);
        jLabel2.setEnabled(bl);
        jLabel3.setText(bl ? warningGpl : "<html><font size='-2'>&nbsp;</html");
        if (bl && jTextField2.getText().length() == 0) {
            jTextField2.setText(bl ? Integer.toString(Calendar.getInstance().get(1)) : "");
        } else if (!bl) {
            jTextField2.setText("");
        }
        if (bl && jTextField.getText().length() == 0) {
            jTextField.setText(bl ? Main.pref.get("lastCopyright", "http://creativecommons.org/licenses/by-sa/2.5") : "");
            jTextField.setCaretPosition(0);
        } else if (!bl) {
            jTextField.setText("");
        }
    }

    private static void addDependencies(final JCheckBox jCheckBox, final JTextField jTextField, final JTextField jTextField2, final JTextField jTextField3, final JButton jButton, final JTextField jTextField4, final JLabel jLabel, final JLabel jLabel2, final JLabel jLabel3, final JLabel jLabel4, final JLabel jLabel5) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = jCheckBox.isSelected();
                jTextField.setEnabled(bl);
                jTextField2.setEnabled(bl);
                jLabel.setEnabled(bl);
                jLabel2.setEnabled(bl);
                jTextField.setText(bl ? Main.pref.get("lastAuthorName") : "");
                String string = CredentialsManager.getInstance().getUsername();
                jTextField2.setText(bl ? (string == null ? "" : string) : "");
                boolean bl2 = jTextField.getText().length() != 0;
                GpxExporter.enableCopyright(jTextField3, jButton, jTextField4, jLabel3, jLabel4, jLabel5, bl && bl2);
            }
        };
        jCheckBox.addActionListener(actionListener);
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                boolean bl = jTextField.getText().length() != 0 && jCheckBox.isSelected();
                GpxExporter.enableCopyright(jTextField3, jButton, jTextField4, jLabel3, jLabel4, jLabel5, bl);
            }
        };
        jTextField.addKeyListener(keyAdapter);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray = new String[]{"Creative Commons By-SA", "Open Database License (ODbL)", "public domain", "GNU Lesser Public License (LGPL)", "BSD License (MIT/X11)"};
                JList<String> jList = new JList<String>(stringArray);
                jList.setVisibleRowCount(stringArray.length);
                jList.setSelectionMode(2);
                int n = JOptionPane.showConfirmDialog(Main.parent, new JScrollPane(jList), I18n.tr("Choose a predefined license", new Object[0]), 2, 3);
                if (n != 0 || jList.getSelectedIndex() == -1) {
                    return;
                }
                String[] stringArray2 = new String[]{"http://creativecommons.org/licenses/by-sa/2.5", "http://opendatacommons.org/licenses/odbl/1.0", "public domain", "http://www.gnu.org/copyleft/lesser.html", "http://www.opensource.org/licenses/bsd-license.php"};
                String string = "";
                for (int n2 : jList.getSelectedIndices()) {
                    if (n2 == 2) {
                        string = "public domain";
                        break;
                    }
                    string = string + (string.length() == 0 ? stringArray2[n2] : ", " + stringArray2[n2]);
                }
                jTextField3.setText(string);
                jTextField3.setCaretPosition(0);
            }
        });
        actionListener.actionPerformed(null);
        keyAdapter.keyReleased(null);
    }

    private DataSet getCurrentDataSet() {
        return Main.main.getCurrentDataSet();
    }
}

