/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.jpeg;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.MetadataReader;
import com.drew.metadata.jpeg.JpegComponent;
import com.drew.metadata.jpeg.JpegDirectory;
import java.io.File;
import java.io.InputStream;

public class JpegReader
implements MetadataReader {
    private final byte[] _data;

    public JpegReader(File file) throws JpegProcessingException {
        this(new JpegSegmentReader(file).readSegment((byte)-64));
    }

    public JpegReader(InputStream inputStream) throws JpegProcessingException {
        this(new JpegSegmentReader(inputStream).readSegment((byte)-19));
    }

    public JpegReader(byte[] byArray) {
        this._data = byArray;
    }

    public Metadata extract() {
        return this.extract(new Metadata());
    }

    public Metadata extract(Metadata metadata) {
        if (this._data == null) {
            return metadata;
        }
        JpegDirectory jpegDirectory = (JpegDirectory)metadata.getDirectory(JpegDirectory.class);
        try {
            int n = this.get16Bits(0);
            jpegDirectory.setInt(0, n);
            int n2 = this.get32Bits(1);
            jpegDirectory.setInt(1, n2);
            int n3 = this.get32Bits(3);
            jpegDirectory.setInt(3, n3);
            int n4 = this.get16Bits(5);
            jpegDirectory.setInt(5, n4);
            int n5 = 6;
            for (int i = 0; i < n4; ++i) {
                int n6 = this.get16Bits(n5++);
                int n7 = this.get16Bits(n5++);
                int n8 = this.get16Bits(n5++);
                JpegComponent jpegComponent = new JpegComponent(n6, n7, n8);
                jpegDirectory.setObject(6 + i, jpegComponent);
            }
        }
        catch (MetadataException metadataException) {
            jpegDirectory.addError("MetadataException: " + metadataException);
        }
        return metadata;
    }

    private int get32Bits(int n) throws MetadataException {
        if (n + 1 >= this._data.length) {
            throw new MetadataException("Attempt to read bytes from outside Jpeg segment data buffer");
        }
        return (this._data[n] & 0xFF) << 8 | this._data[n + 1] & 0xFF;
    }

    private int get16Bits(int n) throws MetadataException {
        if (n >= this._data.length) {
            throw new MetadataException("Attempt to read bytes from outside Jpeg segment data buffer");
        }
        return this._data[n] & 0xFF;
    }
}

