/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.RenderableElement;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGElementException;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGLoaderHelper;
import com.kitfox.svg.ShapeElement;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;

public class Group
extends ShapeElement {
    Rectangle2D boundingBox;
    Shape cachedShape;
    final Rectangle clipBounds = new Rectangle();

    public void loaderAddChild(SVGLoaderHelper sVGLoaderHelper, SVGElement sVGElement) throws SVGElementException {
        super.loaderAddChild(sVGLoaderHelper, sVGElement);
    }

    protected boolean outsideClip(Graphics2D graphics2D) throws SVGException {
        graphics2D.getClipBounds(this.clipBounds);
        Rectangle2D rectangle2D = this.getBoundingBox();
        return !rectangle2D.intersects(this.clipBounds);
    }

    void pick(Point2D point2D, boolean bl, List list) throws SVGException {
        Point2D.Double double_ = new Point2D.Double(point2D.getX(), point2D.getY());
        if (this.xform != null) {
            try {
                this.xform.inverseTransform(point2D, double_);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new SVGException(noninvertibleTransformException);
            }
        }
        for (SVGElement sVGElement : this.children) {
            if (!(sVGElement instanceof RenderableElement)) continue;
            RenderableElement renderableElement = (RenderableElement)sVGElement;
            renderableElement.pick(double_, bl, list);
        }
    }

    void pick(Rectangle2D rectangle2D, AffineTransform affineTransform, boolean bl, List list) throws SVGException {
        if (this.xform != null) {
            affineTransform = new AffineTransform(affineTransform);
            affineTransform.concatenate(this.xform);
        }
        for (SVGElement sVGElement : this.children) {
            if (!(sVGElement instanceof RenderableElement)) continue;
            RenderableElement renderableElement = (RenderableElement)sVGElement;
            renderableElement.pick(rectangle2D, affineTransform, bl, list);
        }
    }

    public void render(Graphics2D graphics2D) throws SVGException {
        StyleAttribute styleAttribute = new StyleAttribute();
        if (this.getStyle(styleAttribute.setName("visibility")) && !styleAttribute.getStringValue().equals("visible")) {
            return;
        }
        boolean bl = this.diagram.ignoringClipHeuristic();
        if (!bl && this.outsideClip(graphics2D)) {
            return;
        }
        this.beginLayer(graphics2D);
        Iterator iterator = this.children.iterator();
        try {
            graphics2D.getClipBounds(this.clipBounds);
        }
        catch (Exception exception) {
            bl = true;
        }
        while (iterator.hasNext()) {
            SVGElement sVGElement = (SVGElement)iterator.next();
            if (!(sVGElement instanceof RenderableElement)) continue;
            RenderableElement renderableElement = (RenderableElement)sVGElement;
            if (!(sVGElement instanceof Group) && !bl && !renderableElement.getBoundingBox().intersects(this.clipBounds)) continue;
            renderableElement.render(graphics2D);
        }
        this.finishLayer(graphics2D);
    }

    public Shape getShape() {
        if (this.cachedShape == null) {
            this.calcShape();
        }
        return this.cachedShape;
    }

    public void calcShape() {
        Area area = new Area();
        for (SVGElement sVGElement : this.children) {
            ShapeElement shapeElement;
            Shape shape;
            if (!(sVGElement instanceof ShapeElement) || (shape = (shapeElement = (ShapeElement)sVGElement).getShape()) == null) continue;
            area.add(new Area(shape));
        }
        this.cachedShape = this.shapeToParent(area);
    }

    public Rectangle2D getBoundingBox() throws SVGException {
        if (this.boundingBox == null) {
            this.calcBoundingBox();
        }
        return this.boundingBox;
    }

    public void calcBoundingBox() throws SVGException {
        Rectangle2D rectangle2D = null;
        for (SVGElement sVGElement : this.children) {
            RenderableElement renderableElement;
            Rectangle2D rectangle2D2;
            if (!(sVGElement instanceof RenderableElement) || (rectangle2D2 = (renderableElement = (RenderableElement)sVGElement).getBoundingBox()) == null) continue;
            if (rectangle2D == null) {
                rectangle2D = rectangle2D2;
                continue;
            }
            rectangle2D = ((Rectangle2D)rectangle2D).createUnion(rectangle2D2);
        }
        if (rectangle2D == null) {
            rectangle2D = new Rectangle2D.Float();
        }
        this.boundingBox = this.boundsToParent(rectangle2D);
    }

    public boolean updateTime(double d) throws SVGException {
        boolean bl = super.updateTime(d);
        for (SVGElement sVGElement : this.children) {
            boolean bl2 = sVGElement.updateTime(d);
            boolean bl3 = bl = bl || bl2;
            if (sVGElement instanceof ShapeElement) {
                this.cachedShape = null;
            }
            if (!(sVGElement instanceof RenderableElement)) continue;
            this.boundingBox = null;
        }
        return bl;
    }
}

