/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.corrector.ReverseWayTagCorrector;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReverseWayAction
extends JosmAction {
    public ReverseWayAction() {
        super(I18n.tr("Reverse Ways", new Object[0]), "wayflip", I18n.tr("Reverse the direction of all selected ways.", new Object[0]), Shortcut.registerShortcut("tools:reverse", I18n.tr("Tool: {0}", I18n.tr("Reverse Ways", new Object[0])), 82, 5003), true);
        this.putValue("help", HelpUtil.ht("/Action/ReverseWays"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (ReverseWayAction.getCurrentDataSet() == null) {
            return;
        }
        Collection<Way> collection = ReverseWayAction.getCurrentDataSet().getSelectedWays();
        if (collection.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least one way.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
            return;
        }
        boolean bl = false;
        LinkedList<Command> linkedList = new LinkedList<Command>();
        for (Way way : collection) {
            ReverseWayResult reverseWayResult;
            try {
                reverseWayResult = ReverseWayAction.reverseWay(way);
            }
            catch (UserCancelException userCancelException) {
                return;
            }
            linkedList.addAll(reverseWayResult.getCommands());
            bl |= !reverseWayResult.getTagCorrectionCommands().isEmpty();
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Reverse ways", new Object[0]), linkedList));
        if (bl) {
            ReverseWayAction.getCurrentDataSet().fireSelectionChanged();
        }
        Main.map.repaint();
    }

    public static ReverseWayResult reverseWay(Way way) throws UserCancelException {
        Way way2 = new Way(way);
        List<Node> list = way2.getNodes();
        Collections.reverse(list);
        way2.setNodes(list);
        Collection<Command> collection = Collections.emptyList();
        if (Main.pref.getBoolean("tag-correction.reverse-way", true)) {
            collection = new ReverseWayTagCorrector().execute(way, way2);
        }
        return new ReverseWayResult(way2, collection, new ChangeCommand(way, way2));
    }

    protected int getNumWaysInSelection() {
        if (ReverseWayAction.getCurrentDataSet() == null) {
            return 0;
        }
        int n = 0;
        for (OsmPrimitive osmPrimitive : ReverseWayAction.getCurrentDataSet().getSelected()) {
            if (!(osmPrimitive instanceof Way)) continue;
            ++n;
        }
        return n;
    }

    @Override
    protected void updateEnabledState() {
        if (ReverseWayAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(ReverseWayAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(Utils.exists(collection, OsmPrimitive.wayPredicate));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReverseWayResult {
        private Way newWay;
        private Collection<Command> tagCorrectionCommands;
        private Command reverseCommand;

        public ReverseWayResult(Way way, Collection<Command> collection, Command command) {
            this.newWay = way;
            this.tagCorrectionCommands = collection;
            this.reverseCommand = command;
        }

        public Way getNewWay() {
            return this.newWay;
        }

        public Collection<Command> getCommands() {
            ArrayList<Command> arrayList = new ArrayList<Command>();
            arrayList.addAll(this.tagCorrectionCommands);
            arrayList.add(this.reverseCommand);
            return arrayList;
        }

        public Command getAsSequenceCommand() {
            return new SequenceCommand(I18n.tr("Reverse way", new Object[0]), this.getCommands());
        }

        public Command getReverseCommand() {
            return this.reverseCommand;
        }

        public Collection<Command> getTagCorrectionCommands() {
            return this.tagCorrectionCommands;
        }
    }
}

